# 2段階成長法による多結晶シリコン薄膜の作製：表面反応制御による構造制御と物性

## 1. はじめに

皆様、こんにちは。ただいまご紹介に与りました、東京工業大学 総合理工学研究科の博士課程学生、神谷と申します。本日は、「2段階成長法による多結晶シリコン薄膜の作製：表面反応制御による構造制御と物性」と題しまして、我々の研究成果をご発表させていただきます。

まず、本発表の概要をご説明いたします。はじめに、研究の背景と、私たちが提案する2段階成長法についてご説明します。次に、本研究の目的、および実験装置・条件について述べた後、具体的な実験結果と考察に入ります。実験結果としては、主にエリプソメトリーを用いた界面構造のその場観察結果、そして種結晶の構造が最終的な薄膜に与える影響についてご報告いたします。最後に、本研究で得られた知見をまとめ、今後の展望について述べたいと存じます。

## 2. 背景

### 2.1 SiF4原料PE-CVD法による多結晶シリコン薄膜作製技術

我々のグループでは、これまでシリコン源として一般的なSiH4ガスではなく、SiF4ガスを用いたマイクロ波プラズマエンハンスドCVD法（PE-CVD法）によって、多結晶シリコン薄膜を作製する研究を進めてまいりました。このSiF4原料を用いる手法には、いくつかの優れた特長があります。第一に、400℃以下の比較的低温で、高い結晶性を有する多結晶シリコン薄膜の作製が可能である点です。第二に、約10 Å/sという高い成長速度を実現できる点も大きなメリットです。そして第三に、得られた薄膜が高い配向性、具体的には(022)配向を示すという特徴があります。このような優れた特性は、特に太陽電池のような縦型デバイス、例えばアモルファスシリコン太陽電池のボトムセルや薄膜トランジスタのチャネル層といった応用において、優れた特性を示すものと期待されます。

### 2.2 低温プロセスにおける課題

しかしながら、廉価なガラス基板やプラスチックフィルムなどのフレキシブル基板を用いる場合、あるいはデバイス界面での不純物拡散を抑制するために成長温度をさらに下げたい場合、新たな問題が生じます。それは、製膜直後にアモルファス相が生成しやすく、これが薄膜の特性を劣化させるという課題です。

この問題に対しては、過去に我々が報告してきたLayer-By-Layer（LBL）法が有効です。LBL法では、数10 Åの堆積毎に原子状水素処理を繰り返すことで、アモルファス相の生成を抑制し、結晶性の高い薄膜を得ることができます。しかしながら、LBL法はその特性上、実効成長速度が低下してしまうため、大規模な実用化、例えば太陽電池の量産プロセスにおいては不向きであると考えられます。

このような背景から、実効成長速度を維持しつつ、低温で高品質な多結晶シリコン薄膜を製膜可能な手法が求められていました。この課題を解決するために、我々は「2段階成長法」を提案してきました。

## 3. 2段階成長法

### 3.1 提案する2段階成長法

私たちが提案する2段階成長法は、その名の通り、2つの異なる成長プロセスを組み合わせることで、上記の課題を克服しようとするものです。

まず、第一段階として「種結晶プロセス」を行います。このプロセスでは、約380℃という比較的高温の条件で、LBL法を用いて高品質な種結晶層を、厚さ数10ナノメートル程度作製します。この種結晶は高い配向性と結晶性を有します。

次に、この種結晶の上に、第二段階として「成長プロセス」を行います。ここでは、実効成長速度を稼げる連続製膜法を用い、多結晶シリコンをエピタキシャルライクに成長させます。この成長プロセスでは、なるべく基板温度を下げ、200〜350℃の低温で製膜を行うことを目指します。

### 3.2 界面構造の重要性

この2段階成長法において重要な点は、種結晶プロセスと成長プロセス間の界面構造が連続的かつ滑らかであることです。もし、基板温度を変えることによって、この種結晶と成長薄膜の界面構造が不連続に変化してしまうと、薄膜全体の特性が劣化する懸念があります。

実際に、昨年、宮本らが報告した先行研究では、この界面における問題が浮き彫りになりました。彼らは、種結晶を作製した後、一度大気開放して別のチャンバーで成長プロセスを行いました。その結果、成長プロセス開始時にエリプソメータで測定した<ε2>（イプシロン2）トラジェクトリーに、図に示すような大きなディップが観察されました。このディップは、大気開放による表面コンタミネーション、すなわち表面の汚染や酸化膜の生成に起因するものと考えられます。残念ながら、このような不連続な界面を持つ薄膜からは、満足のいく太陽電池特性を得ることはできませんでした。

このように、2段階成長法において、種結晶と成長薄膜間の界面を連続的かつ高品質に保つことは、最終的なデバイス特性を向上させる上で不可欠であると私たちは考えております。

## 4. 目的

以上の背景を踏まえ、本研究では以下の二点を主な目的といたしました。

1.  いかにして連続的かつ滑らかな種結晶－成長薄膜界面を得られるか、分光エリプソメトリーを用いたその場観察によって詳細に調べること。
2.  最終的な薄膜の構造に、種結晶の構造がどのような影響を与えるかを検討すること。

これらの検討を通じて、低温かつ高速で高品質な多結晶シリコン薄膜の作製技術の確立を目指します。

## 5. 実験装置

本研究で用いた実験装置は、我々が独自に開発したマイクロ波プラズマエンハンスドCVD装置です。その特徴について簡単にご説明いたします。

原料ガスとしてはSiF4を、希釈ガスとしてはH2とArを用いています。H2とArガスは、SiF4とは別のステンレスチューブ内を通ってマイクロ波プラズマで励起されます。その後、励起されたH2とArプラズマは、SiF4ガスと混合され、SiF4を分解することで薄膜形成に関与します。

LBL法の堆積プロセスと水素処理プロセスは、SiF4ガスの間欠導入によって精密に制御しています。具体的には、SiF4を導入している間は堆積プロセス、SiF4を止めてH2/Arプラズマのみを導入している間は原子状水素処理プロセスとなります。

さらに、この装置にはその場観察（in-situ）が可能な分光エリプソメータが備え付けられており、製膜過程における薄膜の構造変化をリアルタイムで詳細に解析することが可能です。これにより、界面構造の形成過程を直接観察することができます。

## 6. 実験条件

典型的な製膜条件をこちらに示します。マイクロ波出力は200W、反応圧は400mTorrとしました。LBL法を用いる種結晶過程では、堆積時間と水素処理時間をそれぞれ10秒と設定しました。

種結晶プロセスでは、基板温度を380℃と一定に保ちました。一方、その上に成長させる成長プロセスでは、基板温度を220℃から380℃まで広範囲に振って実験を行いました。また、この際、主に種結晶プロセスと成長プロセスそれぞれのSiF4/H2流量比を重要なパラメータとして制御し、薄膜の構造変化を調べました。

得られた薄膜の構造評価には、製膜中のその場観察には分光エリプソメータを用い、最終的な薄膜の結晶構造は、粉末X線回折（XRD）を用いて評価いたしました。分光エリプソメトリーでは、特に4.15eVにおける擬誘電関数<ε2>の製膜時間変化を観察し、薄膜の表面構造や結晶性の変化を評価しました。

## 7. 実験結果と考察

### 7.1 界面構造のその場観察：ガス流量制御による改善

#### 7.1.1 種結晶プロセスと成長プロセスで同じガス流量の場合

まず、種結晶を作製した後、大気開放せずに、同じチャンバー内でそのまま成長プロセスを行った際のエリプソメータで測定した擬誘電関数<ε2>の成長過程における変化を示します。このグラフの点線より左側が種結晶の製膜過程、点線より右側が成長プロセスの製膜過程を示しています。

エリプソメトリーにおける<ε2>の値は、薄膜の表面構造に非常に敏感であり、その減少は、薄膜の結晶性低下、あるいは表面ラフネスの増大を意味します。

ご覧の通り、大気開放を行わなかったため、先行研究の宮本らが報告したような大きな<ε2>のディップは観察されません。これは、表面コンタミネーションを抑制できたことを示唆しており、界面の連続性への第一歩と言えます。

しかしながら、成長温度を350℃に下げただけでも、図に示しますように、界面で<ε2>が急激に低下することがわかります。これは、350℃という温度では、種結晶と比べて成長薄膜の結晶性が大きく低下している、あるいは表面ラフネスが増大していることを示しており、界面で急激な構造変化が起こっていることが示唆されます。この結果から、単に大気開放を避けるだけでは、低温での連続的な高品質界面の形成は困難であることが分かりました。

#### 7.1.2 種結晶プロセスにおいてSiF4流量を増大させた場合

次に、温度低下による影響を補うため、種結晶プロセスと成長プロセスでガス流量を変えて、界面がどのように変化するかを調べてみました。具体的には、成長プロセスに比べて種結晶プロセスでのSiF4流量を相対的に多くすることで、種結晶の結晶性を高めることを試みました。

その結果、基板温度350℃においても、界面で<ε2>が比較的連続的に変化しており、界面構造が改善されていることが分かります。これは、種結晶の条件を調整することで、低温成長における結晶性低下を緩和できる可能性を示唆しています。ただし、この場合でも、さらに低温の320℃では、依然として大きな<ε2>低下が起こってしまいます。このことから、単に種結晶側のSiF4流量を増やすだけでは、さらなる低温化には限界があることが分かります。

#### 7.1.3 成長プロセスにおけるH2流量も制御した場合

そこで、さらなる低温化と界面構造の改善を目指し、今度は成長プロセスにおけるH2流量も制御し、種結晶プロセスと成長プロセスでのSiF4/H2流量比をさらに大きく変えて調べてみました。H2流量を増やすことは、プラズマ中の原子状水素濃度を高め、表面における結合の組み換えやアモルファス相のエッチング効果を促進し、結晶成長を助けると考えられます。

その結果、図に示しますように、280℃程度でも界面の構造が滑らかにつながり、また、その後の成長を続けても大きな<ε2>低下が起こらなくなります。これは非常に重要な知見です。

この結果から、まず種結晶を、SiF4/H2流量比が比較的小さく（つまりH2が少ない条件で）作製し、その後、成長プロセスではSiF4/H2流量比を大きく（つまりH2を多く）して成長を行うことで、基板温度を下げても連続的な界面を保ったまま2段階成長が可能になることが分かりました。このSiF4/H2流量比の制御が、低温での高品質なエピタキシャルライク成長を実現する鍵であると考えられます。

### 7.2 2段階成長法における種結晶の構造の影響

次に、2段階成長法において、種結晶が成長薄膜にどのような影響を与えるかを調べてみました。

#### 7.2.1 <ε2>変化の種結晶依存性

こちらは、種結晶の作製条件だけを変え、全く同じ条件で成長プロセスをおこなった際の<ε2>変化を示しています。比較しているのは、SiF4/H2流量比を小さくした（H2を少なくした）ことで、右図の<ε2>が小さく、アモルファス相が多い種結晶と、左図の比較的結晶性の高い種結晶です。

高温（例えば350℃や380℃）で成長させた場合、これら2つのケースで成長プロセス中の<ε2>変化に大きな差異は見られません。これは、高温であれば、種結晶の初期状態の影響が緩和され、薄膜全体としての結晶性が比較的保たれることを示唆しています。

しかし、成長温度が280℃以下になると、アモルファスリッチな種結晶の上に成長させた膜（右図）では、成長プロセス中の<ε2>低下が顕著に大きくなっていることがわかります。これは、低温では種結晶の結晶性が、その後の成長薄膜の結晶性に直接的に影響を与えることを示唆しています。

#### 7.2.2 最終薄膜構造の種結晶依存性

さらに、得られた最終的な薄膜の構造を、分光エリプソメトリー（SE）とX線回折（XRD）で詳しく調べた結果を、種結晶の条件を変えた2つの薄膜で比較しました。

SEスペクトル、特に<ε2>スペクトルを見ますと、両者の薄膜がはっきりと異なっていることがわかります。特に、アモルファスリッチな種結晶の上に280℃以下で成長させた膜では、結晶相に対応するピークがほとんどなくなっています。

また、XRDの結果を見ても、アモルファスリッチな種結晶の上に280℃以下で成長させた膜では、多結晶シリコンに特徴的な回折ピークがほとんど消失しており、アモルファス相が主体であることが示唆されます。

これらの結果から、種結晶がアモルファスリッチである場合、その上に成長させた膜の構造も種結晶の構造を強く反映し、アモルファスリッチになることが明らかになりました。このことは、2段階成長法において、初期の種結晶の品質が、その後の低温でのエピタキシャルライク成長に極めて重要な影響を与えることを明確に示しています。

## 8. まとめ

本日の発表のまとめです。

-   我々は、2段階成長法において、種結晶プロセスと成長プロセスそれぞれのガス流量、特にSiF4/H2流量比を適切に制御することにより、低温領域においても連続的かつ滑らかな界面を実現できることを、エリプソメトリーその場観察によって明らかにしました。これにより、デバイス界面の品質向上が期待されます。
-   また、種結晶の構造、特にその結晶性が、最終的に形成される多結晶シリコン薄膜の構造に大きく影響を与えることが分かりました。高品質な種結晶の形成が、その後の低温でのエピタキシャルライク成長を可能にする上で不可欠であると結論付けられます。

これらの知見は、低温・高速製膜による高性能な多結晶シリコン薄膜、特に太陽電池や薄膜トランジスタといったデバイス応用への道を開くものと期待されます。

以上で私の発表を終わります。ご清聴ありがとうございました。ご質問等がございましたら、何なりとお申し付けください。