# スライド 1　二段階成長法による多結晶シリコン薄膜の作製

## テキスト
二段階成長法による多結晶シリコン薄膜の作製－表面反応制御による構造制御と物性－
（東工大・総理工）
○神谷利夫、中畑浩一、三井田淳、　　盧和敬、C.M.Fortmann、清水勇

概要
　　・背景
　　・2段階成長法
　　・実験結果
　　　　界面構造（エリプソメータ）
　　　　種結晶の影響
　　・まとめ

Substrate
Seed crystal
poly-Si grain
Substrate

<!-- 補足：本日は、私、東京工業大学の神谷が、2段階成長法を用いた多結晶シリコン薄膜作製に関する研究成果を発表いたします。特に、表面反応の精密制御がいかに薄膜の構造と物性を決定づけるかについて、詳しくご説明します。-->

---

# スライド 2　背景

## テキスト
SiF4原料を用いたPE-CVD法による多結晶シリコン薄膜の作製
・低温で高結晶性多結晶シリコン
・~10Å/sの高速製膜
・高配向性	(022)

ガラス基板上への製膜
　製膜初期のアモルファス層の低減が必要
　・Layer-By-Layer法（実効成長速度が低下）
　・2段階成長法（本研究で提案する解決策）

背景

<!-- 補足：SiF4原料PECVDの優位性と、低温製膜におけるアモルファス層生成という課題についてご説明いたします。LBL法は有効ですが、実用化には課題があるため、本研究では2段階成長法を提案しています。-->

---

# スライド 3　2段階成長法

## テキスト
2段階成長法

成長プロセス
Substrate
エピタキシャルライク成長
低温製膜 (200~350C)
速い成膜速度
poly-Si

BA

種結晶プロセス
Substrate
Seeds crystal
~100nm
高配向性
高結晶性
高温製膜 Ts (> 360C)
Layer-By-Layer法

<!-- 補足：2段階成長法は、高品質な種結晶をまず形成し、その上に低温で高速にエピタキシャルライク成長させることで、両者の利点を組み合わせる手法です。界面の連続性が極めて重要になります。-->

---

# スライド 4　先行研究の課題：界面構造の不連続性

## テキスト
<!-- スライドタイトルを修正しました。「宮本さんデータ」というテキストから、先行研究の課題を示すスライドと判断しました。 -->

0
5
10
15
20
0
2000
4000
6000
8000
on P-doped poly-Si
SiF4 50 sccm
SiF4 40 sccm
SiF4 30 sccm
<e2>
Time (sec)

## 図
![スライド4の図1](images\slide4_image1.png)
![スライド4の図2](images\slide4_image2.png)
![スライド4の図3](images\slide4_image3.png)
![スライド4の図4](images\slide4_image4.png)
![スライド4の図5](images\slide4_image5.png)
![スライド4の図6](images\slide4_image6.png)
![スライド4の図7](images\slide4_image7.png)
![スライド4の図8](images\slide4_image8.png)
![スライド4の図9](images\slide4_image9.png)
![スライド4の図10](images\slide4_image10.png)
![スライド4の図11](images\slide4_image11.png)
![スライド4の図12](images\slide4_image12.png)
![スライド4の図13](images\slide4_image13.png)
![スライド4の図14](images\slide4_image14.png)
![スライド4の図15](images\slide4_image15.x-wmf)
![スライド4の図16](images\slide4_image16.x-wmf)

<!-- 補足：これは宮本らの先行研究データです。大気開放後に成長プロセスを行うと、エリプソメトリーの<ε2>に大きなディップが見られます。これは表面コンタミネーションによる界面の不連続性を示唆しており、太陽電池特性も不良でした。この問題の解決が本研究の出発点です。-->

---

# スライド 5　目 的

## テキスト
目 的
2段階成長法の種結晶と成長多結晶薄膜のエピタキシャルライク界面を実現する
2段階成長法における種結晶の結晶性の影響について検討する

<!-- 補足：本研究では、この界面を連続的かつ高品質に形成する手法を確立すること、そして種結晶の質が最終薄膜に与える影響を明らかにすることを目的とします。-->

---

# スライド 6　実験装置

## テキスト
実験装置
Modulator
Susceptor
MBP
Auto VaccumControler
Ar/H2
SiF4
Shutter
in-situ SpectroscopicEllipsometer
Substrate
Light source
Controlled bySequenser
Layer-By-Layer 法
H2
SiF4
Process time
Gas flow
0
Deposition
Atomic HydrogenTreatment
結晶性促進
Detector
Microwave
Magnet

<!-- 補足：本研究で用いたマイクロ波プラズマCVD装置です。SiF4を原料とし、H2/ArプラズマでSiF4を分解します。LBL法制御、そしてその場観察可能な分光エリプソメータが搭載されている点が特徴です。-->

---

# スライド 7　実験方法

## テキスト
実験方法
分光エリプソメータ(SE)
粉末X線回折(XRD)
構造評価

典型的な製膜条件
製膜過程の観察:   エリプソメータ（4.15eVにおける<e2> ）

## 図
![スライド7の図1](images\slide7_image1.x-emf)
![スライド7の図2](images\slide7_image2.x-emf)

<!-- 補足：エリプソメトリーは特に4.15eVにおける<ε2>を用いて製膜中の表面構造変化をリアルタイムで追跡しました。これにより、界面での微細な構造変化を捉えることができます。-->

---

# スライド 8　成長プロセスにおける<e2>の製膜時間変化

## テキスト
成長プロセスにおける<e2>の製膜時間変化
(SiF4/H2 : 種結晶プロセスと成長プロセスで同じ)
(Seed:50/5/30, 380C - poly-Si:50/5/30)

## 図
![スライド8の図1](images\slide8_image1.x-emf)

<!-- 補足：種結晶プロセスと成長プロセスでSiF4/H2流量比を同じにした場合の結果です。大気開放なしでも、350℃以下では<ε2>の急激な低下が見られ、界面での構造変化が起こっていることが示唆されます。これは、低温での結晶性低下や表面ラフネス増大を意味します。-->

---

# スライド 9　成長プロセスにおける<e2>の製膜時間変化

## テキスト
成長プロセスにおける<e2>の製膜時間変化
(SiF4/H2 : 種結晶プロセスでのSiF4流量を増大)
(Seed:50/5/60, 380C - poly-Si:50/5/30)

## 図
![スライド9の図1](images\slide9_image1.x-wmf)

<!-- 補足：次に、種結晶プロセスのSiF4流量を増やし、SiF4/H2流量比を相対的に小さくすることで、種結晶の結晶性を高めました。350℃では界面の連続性が改善されましたが、320℃では依然として<ε2>の低下が見られます。-->

---

# スライド 10　成長プロセスにおける<e2>の製膜時間変化

## テキスト
成長プロセスにおける<e2>の製膜時間変化
(SiF4/H2 : さらに成長プロセスでのH2流量を増大)
(Seed:60/5/60, 380C - poly-Si:60/10/30)

## 図
![スライド10の図1](images\slide10_image1.x-wmf)

<!-- 補足：H2流量も制御し、種結晶プロセスと成長プロセスでSiF4/H2流量比をさらに変えました。その結果、280℃という低温でも界面が滑らかにつながり、成長中も高い<ε2>を維持できることが分かりました。これは、SiF4/H2流量比の制御が低温での連続界面形成に有効であることを示しています。-->

---

# スライド 11　2段階成長法で作製した薄膜の構造に与える種結晶の影響

## テキスト
2段階成長法で作製した薄膜の構造に与える種結晶の影響

## 図
![スライド11の図1](images\slide11_image1.x-wmf)

<!-- 補足：ここからは、種結晶の構造がその後の成長薄膜にどのような影響を与えるかについてご説明します。-->

---

# スライド 12　成長プロセスにおける<e2>変化の種結晶依存性

## テキスト
成長プロセスにおける<e2>変化の種結晶依存性
Seed: 60/5/60
Seed: 60/10/60
(poly-Si: 60/10/60)

## 図
![スライド12の図1](images\slide12_image1.x-wmf)
![スライド12の図2](images\slide12_image2.x-wmf)

<!-- 補足：種結晶の作製条件を変え、アモルファスリッチな種結晶（右図）と結晶性の高い種結晶（左図）を用意しました。高温成長では大きな差は見られませんが、280℃以下ではアモルファスリッチな種結晶の上に成長した膜で<ε2>の低下が顕著でした。-->

---

# スライド 13　2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響

## テキスト
2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響
Seed: 60/5/60
Seed: 60/10/60
Diffraction intensity / counts
<e2>
(poly-Si: 60/10/60)

## 図
![スライド13の図1](images\slide13_image1.x-wmf)
![スライド13の図2](images\slide13_image2.x-wmf)
![スライド13の図3](images\slide13_image3.x-wmf)
![スライド13の図4](images\slide13_image4.x-wmf)

<!-- 補足：得られた薄膜のSEスペクトルとXRDパターンを比較しました。アモルファスリッチな種結晶の上に低温で成長させた膜では、結晶相のピークがほとんど見られず、種結晶の構造が成長薄膜に直接的に影響を与えることが確認されました。-->

---

# スライド 14　まとめ

## テキスト
まとめ
・    種結晶プロセスと成長プロセスにおいて、ガス流量を制御することにより界面構造を改善できた
・  種結晶の構造が最終的な薄膜の構造に大きく影響していることがわかった

<!-- 補足：まとめです。ガス流量制御による連続的な界面形成と、種結晶の構造が最終薄膜の構造に与える影響を明らかにしました。これらの知見は、低温・高速製膜による高性能な多結晶シリコン薄膜作製に貢献すると期待されます。ご清聴ありがとうございました。-->