# 成果報告書：2段階成長法による多結晶シリコン薄膜の作製－表面反応制御による構造制御と物性－

## 1. はじめに

本報告書では、応用物理学会にて発表いたしました「2段階成長法による多結晶シリコン薄膜の作製－表面反応制御による構造制御と物性－」の研究成果について詳細を述べさせていただきます。本研究は、次世代太陽電池などのデバイス応用を念頭に置いた、低温・高速での高品質な多結晶シリコン薄膜作製技術の確立を目指したものです。

## 2. 背景

我々の研究グループでは、これまでシリコン源としてSiH4ガスではなく、SiF4ガスを用いるマイクロ波プラズマCVD（PE-CVD）法に着目し、その優位性を報告してまいりました。SiF4ガスを原料とすることで、400℃以下の比較的低温でありながら、高い結晶性を持つ多結晶シリコン薄膜を作製することが可能です。加えて、この製膜法は10 Å/sという高い成長速度を実現できるという特長も持ち合わせております。得られる薄膜は、(022)配向を主とする高い配向性を示し、特に薄膜太陽電池のような縦型デバイスにおける優れた特性が期待されます。

しかしながら、廉価なガラス基板などの異種基板上に製膜する際には、製膜初期にアモルファス相が生成しやすく、これがデバイス特性の劣化を引き起こすという課題がありました。この問題に対する一つの解決策として、我々はLayer-By-Layer（LBL）法を適用してきました。LBL法では、数10 Åのシリコン層を堆積するごとに原子状水素処理を繰り返すことで、アモルファス層の生成を抑制し、結晶性の向上を図ることができます。原子状水素は表面のダングリングボンドを終端し、表面の移動度を高めることで結晶成長を促進すると考えられます。

しかしながら、LBL法は堆積と水素処理を交互に行うため、実効的な成長速度が低下するという問題があり、実際の産業応用においては生産性の点で不向きであると考えられます。また、ガラスやプラスチックフィルムなどの基板を用いる場合や、デバイス界面における拡散を抑制するためには、可能な限り成長温度を下げる必要があります。

これらの課題を解決するため、本研究では「2段階成長法」を提案し、その最適化を進めてまいりました。

## 3. 2段階成長法

2段階成長法は、高品質な種結晶層と、その上に高速で成長させる多結晶シリコン層の2つのプロセスから構成されます。

1.  **種結晶プロセス**:
    まず、比較的高温である約380℃において、LBL法を用いることで高品質な多結晶シリコンの種結晶層（厚さ約100 nm）を作製します。この層は、高い配向性と結晶性を有します。
2.  **成長プロセス**:
    種結晶層の上に、実効成長速度を高く保てる連続製膜法を用いて、多結晶シリコンをエピタキシャルライクに成長させます。ここでいうエピタキシャルライク成長とは、下地の種結晶の結晶学的配向性を引き継ぎながら、多結晶層が成長することを指します。この成長プロセスでは、低温での製膜（200℃～350℃）を目指します。

成長プロセスにおいては、なるべく基板温度を下げたいという要求がありますが、種結晶層と成長薄膜層の界面において、基板温度の変化によって構造が不連続に変化してしまうと、薄膜全体の特性が劣化する懸念があります。特に、界面にアモルファス層が形成されたり、結晶性の乱れが生じたりすることは、キャリア輸送を阻害し、デバイス性能に悪影響を及ぼします。

## 4. 従来の研究における課題

昨年、宮本らが報告した成長プロセスのin-situエリプソメトリー観察結果には、界面における重大な課題が示唆されていました。種結晶を作製した後、一度チャンバーを大気開放し、別のチャンバーで成長プロセスを行った場合、成長プロセス開始時に分光エリプソメーターで測定した擬誘電関数虚部 $ \langle\varepsilon_2\rangle $ のトラジェクトリーに大きなディップ（急激な低下）が観察されました。

このディップは、大気開放による表面コンタミネーション（汚染）が原因であると考えられます。表面コンタミネーションは、界面に不純物層を形成し、その後の成長を阻害するため、結果として満足のいく太陽電池特性（例えば、開放電圧、短絡電流、フィルファクターの低下）を得ることができませんでした。この過去のデータは、2段階成長法における界面の品質が、最終的なデバイス特性を決定する上で極めて重要であることを示しています。

\[ スライド4の図に相当するデータを示すグラフ群の概念図。エリプソメトリーのトラジェクトリーやIV特性曲線など。図の具体的な内容は提示されていないため、概念的な説明とします。]
- ![宮本らのエリプソメトリーデータ](images\slide4_image1.png)
- ![太陽電池IV特性](images\slide4_image2.png)
- ... (画像リンクはスライドに合わせてすべて含めます)
- ![スライド4の図1](images\slide4_image1.png)
- ![スライド4の図2](images\slide4_image2.png)
- ![スライド4の図3](images\slide4_image3.png)
- ![スライド4の図4](images\slide4_image4.png)
- ![スライド4の図5](images\slide4_image5.png)
- ![スライド4の図6](images\slide4_image6.png)
- ![スライド4の図7](images\slide4_image7.png)
- ![スライド4の図8](images\slide4_image8.png)
- ![スライド4の図9](images\slide4_image9.png)
- ![スライド4の図10](images\slide4_image10.png)
- ![スライド4の図11](images\slide4_image11.png)
- ![スライド4の図12](images\slide4_image12.png)
- ![スライド4の図13](images\slide4_image13.png)
- ![スライド4の図14](images\slide4_image14.png)
- ![スライド4の図15](images\slide4_image15.x-wmf)
- ![スライド4の図16](images\slide4_image16.x-wmf)

## 5. 目的

本研究の目的は、以下の2点に集約されます。

1.  **連続的かつ滑らかな種結晶－成長薄膜界面の実現**:
    分光エリプソメトリーその場観察（in-situ Spectroscopic Ellipsometry）を用いて、2段階成長における種結晶と成長薄膜の界面構造をリアルタイムでモニタリングし、いかにして連続的で高品質な界面を得られるかを明らかにすること。特に、成長プロセスへの移行時に基板温度を変化させる際の界面変化の抑制を目指します。
2.  **種結晶構造の影響評価**:
    最終的に得られる薄膜の構造が、種結晶の構造（結晶性、配向性など）によってどのように影響されるかについて検討すること。これにより、高品質な薄膜を得るための最適な種結晶作製条件を探索します。

## 6. 実験装置

本研究で用いた製膜装置は、マイクロ波プラズマエンハンスドCVD（MWPE-CVD）装置です。

\[装置構成図の概念図]
- ![実験装置図](images\slide6_image1.png)

装置の主な構成と特徴は以下の通りです。

*   **原料ガス**: SiF4ガスをシリコン源として使用します。
*   **希釈ガス**: H2とArガスを使用します。
*   **ガス供給経路**: H2とArガスはSiF4ガスとは別のステンレスチューブ内を通し、マイクロ波プラズマによって励起されます。その後、励起されたH2/ArプラズマとSiF4ガスを混合することで、SiF4が効率的に分解され、シリコン薄膜の成長が促進されます。
*   **LBL法制御**: LBL法における堆積プロセスと原子状水素処理プロセスは、SiF4ガスの間欠導入によって精密に制御されます。SiF4を導入している間は堆積が起こり、SiF4を止めてH2/Arプラズマのみを供給している間に水素処理が行われます。
*   **その場観察**: 装置にはその場観察が可能な分光エリプソメーターが備え付けられています。これにより、製膜中の薄膜の成長挙動や表面構造の変化をリアルタイムでモニタリングすることができます。

## 7. 実験条件

典型的な製膜条件を以下に示します。

*   **マイクロ波出力**: 200 W
*   **反応圧**: 400 mTorr
*   **LBL法プロセス時間**: 種結晶過程におけるLBL法の堆積時間および水素処理時間はそれぞれ10秒としました。
*   **基板温度**:
    *   種結晶プロセス: 380℃
    *   成長プロセス: 220℃〜380℃の範囲で変化させました。
*   **主要パラメータ**: 各プロセスにおけるSiF4/H2流量比を主要なパラメータとして変化させ、界面構造への影響を評価しました。

得られた薄膜の構造評価には、主に分光エリプソメーター（SE）と粉末X線回折（XRD）を用いました。分光エリプソメーターでは、特に4.15 eVにおける擬誘電関数虚部 $\langle\varepsilon_2\rangle$ の変化をリアルタイムで追跡し、薄膜の結晶性や表面ラフネスの情報を得ました。$\langle\varepsilon_2\rangle$ は、バルクの結晶性シリコンで明確なピークを示すことから、その値の減少は結晶性の低下や表面ラフネスの増大を示唆します。XRDは薄膜の結晶構造や配向性を評価するために用いられました。

\[製膜条件の表やSE, XRD装置の図の概念図]
- ![実験条件表](images\slide7_image1.x-emf)
- ![SEとXRD装置の概念図](images\slide7_image2.x-emf)

## 8. 実験結果1：成長プロセスにおける擬誘電関数虚部 $\langle\varepsilon_2\rangle$ の製膜時間変化 (SiF4/H2流量比を固定した場合)

まず、種結晶作製後にチャンバーを大気開放せずに、同一チャンバー内で基板温度のみを変化させて成長プロセスを行った際のエリプソメーターによる擬誘電関数虚部 $\langle\varepsilon_2\rangle$ の製膜時間変化を観察しました。

\[グラフ: 種結晶作製後、成長プロセスでの $\langle\varepsilon_2\rangle$ 変化]
- ![成長プロセスにおける<e2>の製膜時間変化 (SiF4/H2同じ)](images\slide8_image1.x-emf)

グラフにおいて、左側は種結晶の $\langle\varepsilon_2\rangle$ を示し、この点から成長プロセスが開始されています。先に宮本らのデータで観察されたような、成長プロセス開始時の大きなディップは観察されませんでした。これは、大気開放を行わないことで、表面のコンタミネーションが抑制されたためと考えられます。

しかしながら、成長温度を380℃から350℃に下げただけでも、成長プロセス開始直後に $\langle\varepsilon_2\rangle$ が急激に低下する現象が観察されました。この $\langle\varepsilon_2\rangle$ の低下は、種結晶と成長薄膜の界面において、結晶性が低下したり、表面ラフネスが増大したりする急激な構造変化が起こっていることを強く示唆しています。これは、SiF4/H2流量比が同じであるため、低温でSiラジカルの表面移動度が低下し、結晶成長が困難になった結果と考えられます。

## 9. 実験結果2：成長プロセスにおける擬誘電関数虚部 $\langle\varepsilon_2\rangle$ の製膜時間変化 (種結晶プロセスでSiF4流量を増大させた場合)

次に、温度低下による結晶性劣化の影響を補うため、種結晶プロセスと成長プロセスでガス流量、特にSiF4/H2流量比を変えることで、界面構造の変化を詳細に調べました。

まず、種結晶プロセスに比べて成長プロセスにおけるSiF4流量を少なく設定してみました。これは、SiF4流量を減らすことで、シリコンの堆積速度を抑制し、原子状水素による表面エッチング効果を相対的に高めることで、低温下での結晶成長を促進させる狙いがあります。

\[グラフ: 種結晶プロセスでSiF4流量増大、成長プロセスでSiF4流量減の場合の $\langle\varepsilon_2\rangle$ 変化]
- ![成長プロセスにおける<e2>の製膜時間変化 (SiF4/H2: 種結晶SiF4増大)](images\slide9_image1.x-wmf)

その結果、基板温度を350℃に下げた場合においても、界面での $\langle\varepsilon_2\rangle$ の変化がより連続的になり、界面構造が改善されていることが分かります。これは、成長プロセスにおけるSiF4/H2比を相対的に小さくすることで、低温下でも結晶性を維持しやすい成長条件が実現できたことを示唆しています。ただし、この条件においても、基板温度をさらに低く、例えば320℃まで下げると、依然として大きな $\langle\varepsilon_2\rangle$ の低下が観察されました。これは、さらに低温ではSiF4流量を減らすだけでは不十分であり、より積極的な表面制御が必要であることを示しています。

## 10. 実験結果3：成長プロセスにおける擬誘電関数虚部 $\langle\varepsilon_2\rangle$ の製膜時間変化 (H2流量も制御した場合)

さらに低温での界面構造改善を目指し、今度は成長プロセスにおけるH2流量を増加させ、種結晶プロセスと成長プロセスにおけるSiF4/H2流量比をさらに大きく変化させて（成長プロセスでSiF4/H2比をさらに小さくして）実験を行いました。H2流量の増加は、プラズマ中の原子状水素濃度を高め、表面におけるエッチング・再配列効果を強化することで、低温下での結晶成長を促進する効果が期待されます。

\[グラフ: 成長プロセスでH2流量増の場合の $\langle\varepsilon_2\rangle$ 変化]
- ![成長プロセスにおける<e2>の製膜時間変化 (SiF4/H2: 成長プロセスH2増大)](images\slide10_image1.x-wmf)

その結果、驚くべきことに約280℃という低い温度においても、界面の構造が滑らかに連続していることが確認されました。また、成長を継続しても大きな $\langle\varepsilon_2\rangle$ の低下が起こらず、安定して高品質な薄膜が成長していることが示されました。

この結果は、まず種結晶をSiF4/H2流量比が比較的大きな（すなわち、SiF4濃度が高く高速堆積寄りの）条件で作製し、その後の成長プロセスにおいてはSiF4/H2流量比を大きく下げる（すなわち、H2濃度を高くし、原子状水素によるエッチング・再配列効果を強める）という制御を行うことで、基板温度を下げても連続的な界面を保ったまま2段階成長が可能になることを明確に示しています。この制御により、低温下でも表面のSi原子の移動度が高まり、結晶性の良い成長が持続されると考えられます。

## 11. 実験結果4：種結晶の異なる場合の擬誘電関数虚部 $\langle\varepsilon_2\rangle$ の比較

次に、2段階成長法において、種結晶の構造がその上に成長させる薄膜にどのような影響を与えるかを調べました。種結晶の作製条件のみを変え、その後の成長プロセスは全く同じ条件で行った際のエリプソメーターによる $\langle\varepsilon_2\rangle$ 変化を比較しました。

\[グラフ: 種結晶の異なる場合の $\langle\varepsilon_2\rangle$ 変化]
- ![成長プロセスにおける<e2>変化の種結晶依存性](images\slide12_image1.x-wmf)
- ![成長プロセスにおける<e2>変化の種結晶依存性 (詳細)](images\slide12_image2.x-wmf)

右図に示すように、一方の種結晶では $\langle\varepsilon_2\rangle$ が小さく、これはアモルファス相が多い、あるいは結晶性が低い種結晶であることを示しています。もう一方の種結晶は $\langle\varepsilon_2\rangle$ が高く、結晶性の良い種結晶です。

高温（例えば350℃以上）で成長させた場合には、この2つの異なる種結晶を用いたケースで、成長プロセス中の $\langle\varepsilon_2\rangle$ に大きな差異は見られませんでした。これは、高温であれば表面のSi原子の移動度が十分に高く、種結晶の初期状態の影響を「乗り越えて」結晶成長が促進されるためと考えられます。

しかしながら、成長温度を280℃以下に下げると、 $\langle\varepsilon_2\rangle$ が小さい（アモルファスリッチな）種結晶の上に成長させた薄膜では、成長プロセス中の $\langle\varepsilon_2\rangle$ の低下が著しく大きくなることが分かりました。これは、低温では種結晶の結晶性の悪さが成長過程に直接影響し、薄膜の結晶性も悪化することを示唆しています。

## 12. 実験結果5：種結晶の異なる場合のSEおよびXRDの比較

最後に、種結晶の作製条件を変えて2段階成長法で作製した最終的な薄膜の構造を、分光エリプソメーター（SE）と粉末X線回折（XRD）を用いて評価しました。

\[グラフ: 種結晶の異なる場合のSEとXRDデータ]
- ![2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響 (SE)](images\slide13_image1.x-wmf)
- ![2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響 (XRD)](images\slide13_image2.x-wmf)
- ![2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響 (XRD詳細)](images\slide13_image3.x-wmf)
- ![2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響 (XRD詳細2)](images\slide13_image4.x-wmf)

SEおよびXRDの結果は、両者で得られた薄膜の構造がはっきりと異なっていることを示していました。特に、280℃以下で成長させた膜において、アモルファスリッチな種結晶を用いた場合では、XRDの結晶ピーク（例えばSi(111), Si(220)など）がほとんど観察されなくなりました。これは、薄膜がアモルファス相を多く含むことを意味します。

このように、種結晶がアモルファスリッチである場合、その上に成長させた膜の構造も、種結晶の構造を強く反映してアモルファスリッチになることが明らかになりました。このことは、高品質な多結晶シリコン薄膜を低温で得るためには、単に界面を滑らかに接続するだけでなく、**種結晶自身の結晶性を高めることが極めて重要である**という結論を裏付けています。種結晶の高品質化が、その後の低温成長を成功させるための鍵となることが示されました。

## 13. まとめ

本研究により得られた主要な知見は以下の通りです。

1.  **界面構造の改善**:
    種結晶プロセスと成長プロセスにおいて、SiF4/H2流量比を適切に制御することにより、連続的かつ滑らかな種結晶－成長薄膜界面を実現できることが分かりました。特に、種結晶作製後に成長プロセスへ移行する際にSiF4/H2流量比を下げる（H2濃度を相対的に高める）ことで、約280℃という低温でも高品質な界面を維持できることが実証されました。

2.  **種結晶構造の影響**:
    種結晶の構造が、最終的に得られる多結晶シリコン薄膜の構造に大きく影響することが明らかになりました。アモルファスリッチな種結晶の上に低温で成長させた場合、薄膜もアモルファスリッチになり、結晶性が著しく低下します。これは、低温でのエピタキシャルライク成長において、種結晶の結晶性が品質を決定する上で非常に重要であることを示しています。

これらの成果は、低温プロセスが要求される次世代の薄膜太陽電池やTFTなどの半導体デバイスの製造において、高品質な多結晶シリコン薄膜を効率的に作製するための基盤技術となるものです。今後、この技術をさらに発展させ、デバイス応用における実証を進めていく所存です。