# 応用物理学会発表スライド

---

# スライド 1：二段階成長法による 多結晶シリコン薄膜の作製

## テキスト
### 二段階成長法による多結晶シリコン薄膜の作製
**－表面反応制御による構造制御と物性－**

東工大・総理工
○神谷利夫、中畑浩一、三井田淳、盧和敬、C.M.Fortmann、清水勇

### 発表概要
*   背景
*   2段階成長法
*   実験結果
    *   界面構造（エリプソメータその場観察）
    *   種結晶の影響
*   まとめ

Substrate
Seed crystal
poly-Si grain
Substrate

---

# スライド 2：背景

## テキスト
### SiF4原料を用いたPE-CVD法による多結晶シリコン薄膜の作製
*   低温で高結晶性多結晶シリコン薄膜
*   ~10 Å/s の高速製膜
*   高い配向性：典型的には (022) 配向

### ガラス基板上への製膜における課題
*   製膜初期のアモルファス層の低減が必要
    *   Layer-By-Layer (LBL) 法による解決策
        *   堆積毎の原子状水素処理で結晶性向上
        *   しかし、実効成長速度低下が課題
    *   **2段階成長法** の提案

---

# スライド 3：2段階成長法

## テキスト
### 2段階成長法 の概念図
**成長プロセス**
Substrate
エピタキシャルライク成長
低温製膜 (200~350℃)
速い成膜速度
poly-Si

**種結晶プロセス**
Substrate
Seeds crystal (~100nm)
高配向性・高結晶性
高温製膜 ($T_s$ > 360℃)
Layer-By-Layer法

*   **課題**: 低温成長プロセスへの移行時の界面構造変化を抑制する必要がある

---

# スライド 4：界面構造の課題と過去のデータ

## テキスト
### 過去の研究における界面構造の課題 (宮本ら)
*   種結晶作製後、大気開放し別チャンバーで成長プロセスを行うと、成長開始時にエリプソメータ $ \langle\varepsilon_2\rangle $ トラジェクトリーに大きなディップを観察。
*   原因：大気開放による表面コンタミネーション。
*   結果：太陽電池特性の劣化。
*   対策：2段階成長における界面改善が不可欠。

## 図
![エリプソメトリーのトラジェクトリー](images\slide4_image1.png)
![太陽電池特性の劣化を示すデータ](images\slide4_image2.png)
![スライド4の図3](images\slide4_image3.png)
![スライド4の図4](images\slide4_image4.png)
![スライド4の図5](images\slide4_image5.png)
![スライド4の図6](images\slide4_image6.png)
![スライド4の図7](images\slide4_image7.png)
![スライド4の図8](images\slide4_image8.png)
![スライド4の図9](images\slide4_image9.png)
![スライド4の図10](images\slide4_image10.png)
![スライド4の図11](images\slide4_image11.png)
![スライド4の図12](images\slide4_image12.png)
![スライド4の図13](images\slide4_image13.png)
![スライド4の図14](images\slide4_image14.png)
![スライド4の図15](images\slide4_image15.x-wmf)
![スライド4の図16](images\slide4_image16.x-wmf)

---

# スライド 5：目 的

## テキスト
### 研究の目的
1.  **2段階成長法における種結晶と成長多結晶薄膜のエピタキシャルライク界面を実現する。**
    *   分光エリプソメトリーその場観察を用いて界面構造を詳細に解析。
2.  **2段階成長法における種結晶の結晶性の影響について検討する。**
    *   最終薄膜構造への種結晶構造の影響を評価。

---

# スライド 6：実験装置

## テキスト
### マイクロ波プラズマCVD装置 (MWPE-CVD)
*   原料ガス：SiF4
*   希釈ガス：H2, Ar
*   ガス混合：H2/Arをマイクロ波プラズマで励起後、SiF4と混合・分解。
*   LBL法制御：SiF4ガス間欠導入による堆積と原子状水素処理。
*   その場観察：in-situ 分光エリプソメータを搭載。

## 図
![実験装置の概略図](images\slide6_image1.png)

---

# スライド 7：実験条件

## テキスト
### 典型的な製膜条件
*   マイクロ波出力：200 W
*   反応圧：400 mTorr
*   LBL過程 (種結晶プロセス)：堆積時間 10秒、水素処理時間 10秒
*   基板温度：
    *   種結晶プロセス：380℃
    *   成長プロセス：220℃～380℃ (可変)
*   主なパラメータ：各過程でのSiF4/H2流量比

### 構造評価
*   分光エリプソメーター (SE)：製膜過程の観察 (4.15 eVにおける擬誘電関数虚部 $ \langle\varepsilon_2\rangle $ )
*   粉末X線回折 (XRD)：最終薄膜の結晶構造、配向性

## 図
![製膜条件の表](images\slide7_image1.x-emf)
![分光エリプソメーターとX線回折の概念図](images\slide7_image2.x-emf)

---

# スライド 8：成長プロセスにおける $ \langle\varepsilon_2\rangle $ の製膜時間変化 (SiF4/H2流量比が同じ場合)

## テキスト
### 種結晶プロセスと成長プロセスでガス流量比を同じにした場合
*   種結晶作製後、大気開放せずに成長プロセスを開始。
    *   大気開放によるディップは観察されず。
*   しかし、成長温度を380℃から350℃に下げただけで、 $ \langle\varepsilon_2\rangle $ が急激に低下。
    *   界面で急激な構造変化 (結晶性低下、表面ラフネス増大) が発生していることを示唆。

## 図
![SiF4/H2比が同じ場合の<e2>製膜時間変化](images\slide8_image1.x-emf)

---

# スライド 9：成長プロセスにおける $ \langle\varepsilon_2\rangle $ の製膜時間変化 (種結晶プロセスにおいてSiF4流量を増やす)

## テキスト
### 温度低下効果を補うためのガス流量制御
*   種結晶プロセスに比べ、成長プロセスでのSiF4流量を少なく設定。
    *   SiF4/H2流量比を相対的に低下。
*   結果：基板温度350℃においても、界面で $ \langle\varepsilon_2\rangle $ が連続的に変化し、界面構造が改善。
*   ただし、320℃では依然として大きな $ \langle\varepsilon_2\rangle $ 低下が発生。

## 図
![種結晶SiF4流量増、成長SiF4流量減の場合の<e2>製膜時間変化](images\slide9_image1.x-wmf)

---

# スライド 10：成長プロセスにおける $ \langle\varepsilon_2\rangle $ の製膜時間変化 (H2流量も制御)

## テキスト
### 成長プロセスにおけるH2流量を増大 (SiF4/H2比をさらに大きく変化)
*   種結晶作製後、成長プロセスでH2流量を増大し、SiF4/H2流量比を大幅に低下。
*   結果：
    *   約280℃でも界面の構造が滑らかにつながる。
    *   成長を続けても大きな $ \langle\varepsilon_2\rangle $ 低下が起こらず、安定した成長が可能。
*   **結論：種結晶をSiF4/H2流量比が大きい条件で作製後、成長プロセスでSiF4/H2流量比を下げれば、低温でも連続的な界面を保った2段階成長が可能。**

## 図
![成長プロセスH2流量増の場合の<e2>製膜時間変化](images\slide10_image1.x-wmf)

---

# スライド 11：2段階成長法で作製した薄膜の構造に与える種結晶の影響

## テキスト
### 種結晶の作製条件が異なる場合の検討
*   種結晶の作製条件のみを変え、全く同じ条件で成長プロセスを実行。
*   目標：種結晶の構造が成長薄膜に与える影響を評価。

## 図
![種結晶の違いの概念図](images\slide11_image1.x-wmf)

---

# スライド 12：成長プロセスにおける $ \langle\varepsilon_2\rangle $ 変化の種結晶依存性

## テキスト
### 異なる種結晶を用いた場合の $ \langle\varepsilon_2\rangle $ 変化
*   右図の種結晶は $ \langle\varepsilon_2\rangle $ が小さく、アモルファス相が多い種結晶。
*   高温成長 (350℃以上) では、両者で大きな差異は見られない。
*   しかし、**280℃以下では $ \langle\varepsilon_2\rangle $ が小さい種結晶の場合、成長プロセス中の $ \langle\varepsilon_2\rangle $ 低下が著しく大きい。**

## 図
![種結晶の異なる場合の<e2>比較グラフ](images\slide12_image1.x-wmf)
![種結晶の異なる場合の<e2>比較グラフ (詳細)](images\slide12_image2.x-wmf)

---

# スライド 13：2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響 (SE, XRD比較)

## テキスト
### 最終薄膜の構造評価 (SE, XRD)
*   SEとXRDの結果は、薄膜構造が種結晶に強く依存することを示す。
*   特に、**280℃以下で成長させた膜において、アモルファスリッチな種結晶の場合、XRDの結晶ピークがほとんど消失。**
*   **結論：種結晶がアモルファスリッチである場合、その上に成長させた膜の構造も種結晶の構造を反映し、アモルファスリッチになる。**

## 図
![種結晶の異なる場合のSEデータ](images\slide13_image1.x-wmf)
![種結晶の異なる場合のXRDデータ](images\slide13_image2.x-wmf)
![種結晶の異なる場合のXRDデータ (詳細1)](images\slide13_image3.x-wmf)
![種結晶の異なる場合のXRDデータ (詳細2)](images\slide13_image4.x-wmf)

---

# スライド 14：まとめ

## テキスト
### まとめ
*   種結晶プロセスと成長プロセスにおいて、ガス流量 (SiF4/H2流量比) を制御することにより、連続的・滑らかな界面を実現できました。
    *   特に、成長プロセスでSiF4/H2流量比を下げることで、低温 (約280℃) での界面品質を維持。
*   種結晶の構造が、最終的な多結晶シリコン薄膜の構造に大きく影響していることがわかりました。
    *   低温成長においては、種結晶の結晶性が重要。

---