# スライド 1　チュートリアル: 講義録画・録音ファイルと生成AIから教科書を作ろう

## テキスト

チュートリアル: 講義録画・録音ファイルと生成AIから教科書を作ろう東京科学大学 総合研究院　元素戦略MDX研究センター　/ フロンティア材料研究所神谷利夫本チュートリアルには、Microsoft365 Copilot / Chat GPT5 / Gemini 2.5等 を使用した結果が含まれています

---

# スライド 2　講義の内容

## テキスト

著作権、生成AIを利用する上での注意教科書の作成:何もない状態で生成AIが教科書を作成　Markdown書式　pandoc: https://pandoc.org/資料を入力して生成AIで作成・Zoom音声 => 文字起こしテキスト・講義資料 (PowerPoint, PDF etc) => テキスト (Markdown) 化pythonプログラムから生成AIを呼び出して利用その他の応用講義の内容

---

# スライド 3　教科書作成プログラムWeb

## テキスト

教科書作成プログラムWebhttp://d2mate.mdxes.iir.isct.ac.jp/D2MatE/textbook/textbook.html

## 図

![スライド3の図1](images\slide3_image1.png)


---

# スライド 4　ハルシネーションの少ない自製AI: NotebookLM

## テキスト

ハルシネーションの少ない自製AI: NotebookLMhttp://d2mate.mdxes.iir.isct.ac.jp/D2MatE/D2MatE_programs.html?page=notebooklm

## 図

![スライド4の図1](images\slide4_image1.png)


---

# スライド 5　公開NotebookLM (gmailアカウントの認証が必要です)

## テキスト

公開NotebookLM (gmailアカウントの認証が必要です)http://d2mate.mdxes.iir.isct.ac.jp/D2MatE/D2MatE_programs.html?page=notebooklmこちらで著作権やAI等に関する質問ができます統計力学(C) 講義用Notebook

## 図

![スライド5の図1](images\slide5_image1.png)


---

# スライド 6　教科書の作成: 生成AIだけで生成

## テキスト

教科書の作成: 生成AIだけで生成

---

# スライド 7　神谷の環境

## テキスト

神谷の環境OS: Windows 11ターミナルアプリ: cmd.exeテキストエディタ: 　Microsoft Visual Studio Code (VSC)　Markdown Preview Enhanced拡張機能生成AI　Office365+Copilot、ChatGPT5Instantも使いました　プログラムを使う場合はGemini 2.5Flashを主に使います生成AIプログラミング・pytyon 3.13 および各種ライブラリ・Google API

---

# スライド 8　python関係のインストール

## テキスト

python関係のインストールPythonのインストール: https://www.python.org/ から python (3.10以上推奨) をインストールライブラリのインストール・必要なライブラリを一括インストール: 　> pip install -r requirements.txt・transcribe_simple.pyを使う場合: FFｍpegをインストール:    > winget install --id=Gyan.FFmpeg -e(一括インストールすれば不要)個別インストール：> python -m pip install --upgrade pip> pip install wheel update.py (プログラムファイルのダウンロード)に必要:> pip install requests bs4to_audio.py (動画ファイルを音声ファイルに変換) に必要:> pip install pydubtranscribe_simple.py (OpenAI whisper local版を使った読み起こしプログラム) に必要:> pip install git+https://github.com/openai/whisper.gitFFmpegをインストール> winget install --id=Gyan.FFmpeg –ebin フォルダのパスを環境変数 PATH に追加pptx2md.py (PowerPointファイルをMarkdownに変換) に必要:> pip install python-pptxmake_textbook.py (教科書作成支援プログラム) に必要:> pip install google-generativeai openai python-dotenv

---

# スライド 9　プログラムの入手方法

## テキスト

プログラムの入手方法http://d2mate.mdxes.iir.isct.ac.jp/D2MatE/textbook/textbook_programs.htmlから個別にダウンロードしたりコピペできます。まとめて入手する場合は以下の手順(i) pythonと、shutil, requests ライブラリをインストール   > pip install shutil requests(ii) http://d2mate.mdxes.iir.isct.ac.jp/download/tkProg/tkProg_textbook　から、update.py と update_textbook.bat を適当なフォルダーに　ダウンロード(iii) update_textbook.batを実行。　　tkprog_textbook/ai, tkprog_textbook/cnverter, tkprog_textbook/multimedia　フォルダに、プログラム及びプログラムの説明を書いたMarkdownファイル .mdが保存されます。注: メインテナンスの都合上、教科書作成に関係のないプログラムも入っていますが、ご容赦ください

---

# スライド 10　pythonで生成AIを使う場合 (make_textbook5.py)

## テキスト

pythonで生成AIを使う場合 (make_textbook5.py)　プログラムから生成AIを使う場合は、それぞれのAPI (Application Program Interface) を使う必要があります。　本チュートリアルでは主にGoogle Gemini 2.5Flashを使います。Gemini APIへのサブスクリプションをしなくても、無料枠を試せます。https://ai.google.dev/gemini-api/docs/pricing?hl=jaGoogle AI Studio (https://ai.google.dev/aistudio?hl=ja) からGoogle API Key を取得する環境変数 GOOGLE_API_KEY にGoogle API Keyを設定する

---

# スライド 11　配布ファイル: distribution-textbook.zip

## テキスト

配布ファイル: distribution-textbook.zipdistribution-textbook.zipを展開Root directory　pptx2md.bat, make_textbook.batのひな型1_生成AIだけで作成　Office365 MS-Word、Gemini WebUIを使った例3_vector_analysis　make_textbook5.pyを使って作成した「ベクトル解析」教科書4_crystallography　講義スライドの図を入れ込んだ「結晶学」教科書の最終版5_other_applications　その他の応用例download　プログラム

---

# スライド 12　方法1-1: 

## テキスト

方法1-1: Office365 MS-Word + Copilotを使う

---

# スライド 13　Office365のMS-Wordでは、Copilotで出力できる

## テキスト

Office365のMS-Wordでは、Copilotで出力できるプロンプト:統計力学概論の講義の教科書を作ってください。以下の要件を満たしてください。条件:# 聴講者は材料工学科 学部2年生# 100分の授業# 数式を含める# 学生が興味を持ちそうな話などを入れる講義内容# 統計力学と熱力学の関係# 統計力学の考え方# 統計分布関数# 応用

---

# スライド 14　方法1-2: 

## テキスト

方法1-2: 生成AI WebUI で作るWebUIの出力を選択してMS-Wordに張り付けるMarkdownテキストで出力させて pandoc でMS-Wordファイルに変換

---

# スライド 15　Gemini 2.5 Flashを選んだ理由

## テキスト

Gemini 2.5 Flashを選んだ理由教科書作成に関する生成AIの比較 (http://d2mate.mdxes.iir.isct.ac.jp/D2MatE/textbook/textbook_comparison.html) にまとめているように、Gemini 2.5 Flashに比べると、Chat GPTは短く要約してしまい、教科書としては情報が不足しました。

---

# スライド 16　教科書作成の流れ

## テキスト

教科書作成の流れ 生成AIにプロンプトを入れて 教科書の Markdown テキストを入手 Markdownファイルを MS-Wordに変換する

---

# スライド 17　Markdown (拡張子 .md)

## テキスト

Markdown (拡張子 .md)プレーンテキストで書ける簡単な記法で数式を含む構造化された文書を作成可能Web・GitHub・教育資料などで広く利用他フォーマットへの変換が簡単# 見出し1（章）## 見出し2（節）### 見出し3（項）箇条書き- 項目A- 項目B  - サブ項目B-1数式 (LaTeX)$$\sqrt{3x-1} + (1+x)^2$$

---

# スライド 18　VSCode + Markdown 拡張機能

## テキスト

VSCode + Markdown 拡張機能

## 図

![スライド18の図1](images\slide18_image1.png)


---

# スライド 19　Markdown 拡張機能

## テキスト

Markdown 拡張機能

## 図

![スライド19の図1](images\slide19_image1.png)

![スライド19の図2](images\slide19_image2.png)


---

# スライド 20　Markdown 拡張機能

## テキスト

Markdown 拡張機能

## 図

![スライド20の図1](images\slide20_image1.png)

![スライド20の図2](images\slide20_image2.png)


---

# スライド 21　Markdown → Office変換ツールの特徴と導入ハードル

## テキスト

Markdown → Office変換ツールの特徴と導入ハードルツール名特徴導入ハードル備考Marphttps://marp.app/#get-started- Markdownでスライド作成- PowerPointやPDFに出力可能若干高い(Node.jsの導入が必要）- npmでCLI導入- VS Code拡張あり未使用のため評価できませんMarkItDown- Word/PPT/PDF → Markdown変換- 逆方向も可能Python使い    ：低い非Python使い：高い- Webアプリあり- 端末実行にはPythonスクリプト作成が必要- 生成AIでスクリプト作成可能Pandochttps://pandoc.org/- 多形式に対応- 相互変換が豊富- PPT → Markdownは未対応低い- 実行ファイルをDLするだけで使える- Windows / macOS / Linux対応本講義で使う

---

# スライド 22　pandocの使用方法

## テキスト

pandocの使用方法基本:> pandoc 入力ファイル名 -o 出力ファイル名　ファイル名の拡張子を自動判別して変換しますオプション:--template=テンプレート名　独自のテンプレートを使って、HTMLやPDFの見た目を整える--toc　目次を自動生成--standalone（略記：-s）　HTMLやPDFを単独で表示可能な完全なドキュメントとして出力--pdf-engine=lualatex（PDF出力時）　LaTeXエンジンを指定して、日本語フォントやコードブロックの整形が可能。--mathjax　HTMLへの変換の際、MathJaxを使う--include-in-header=header.html　HTMLへの変換では<head>が含まれないので、headerファイルを指定して追加--css slide.css　HTMLへの変換でCSSファイルの内容を追加

---

# スライド 23　pandoc.py

## テキスト

pandoc.pypandoc単体でも使用は簡単ですが、pandoc.pyは以下の機能があります・ 出力ファイル名を自動生成・ templateファイルを、実行ディレクトリ => pandoc.py ディレクトリの順で検索・ HTMLへ変換する際、     <head>~</head>を追加して完全なHTMLファイルにする使用方法:pandoc.exeのパスを指定して変換> python pandoc.py --pandoc_path g:\pandoc --convert docx --infile ionput.md テンプレートを指定して変換> python pandoc.py --convert docx --template template.docx --infile ionput.md テンプレートを生成して終了（docx 用テンプレートの作成）> python pandoc.py --make_template docx --template template.docxHTML へ変換（MathML、CSSファイル指定など）> python pandoc.py --convert html --infile infile.md --mathml> python pandoc.py --convert html --infile input.md --css custom_style.css

---

# スライド 24　Web UI生成AIで教科書を作る: 失敗例

## テキスト

Web UI生成AIで教科書を作る: 失敗例プロンプト:統計力学概論の講義の教科書を作ってください。以下の要件を満たしてください。条件:# 聴講者は材料工学科 学部2年生# 100分の授業# 数式を含める# 学生が興味を持ちそうな話などを入れる# Markdown形式でコピペできる形で出力する講義内容# 統計力学と熱力学の関係# 統計力学の考え方# 統計分布関数# 応用

---

# スライド 25　Web UI生成AIで教科書を作る: Markdown出力の問題

## テキスト

Web UI生成AIで教科書を作る: Markdown出力の問題Gemini 2.5Flashでは、「Markdown形式でコピペできる形で出力する」 の指令を入れても、Markdown出力がWebに変換されて出力されてしまった注: 生成AIのWebUIは、出力をMarkdownで作成し、　  WebブラウザがJavascritpでHTML+CSSに整形して出力します。　　そのため、Markdownで出力させると、　　その部分もHTMLに変換されてしまうことがあります2025/9/21現在、Gemini WebUI でMarkdownテキストを得るには、以下のプロンプトを使ってください# 出力形式は、Markdownの書式がそのまま見えるように、コードブロック形式（```markdown ... ```）で出力してください

---

# スライド 26　Web UI生成AIで教科書を作る: Markdownで出力できる例

## テキスト

Web UI生成AIで教科書を作る: Markdownで出力できる例プロンプト:統計力学概論の講義の教科書を作ってください。以下の要件を満たしてください。条件:# 聴講者は材料工学科 学部2年生＃ 100分の授業# 数式を含める# 学生が興味を持ちそうな話などを入れる# 出力形式は、Markdownの書式がそのまま見えるように、コードブロック形式（```markdown ... ```）で出力してください。講義内容# 統計力学と熱力学の関係# 統計力学の考え方# 統計分布関数# 応用

---

# スライド 27　それぞれの特徴

## テキスト

それぞれの特徴Office365+Copilot (AIモデルはOpenAI GPT5ベース、Microsoft社が独自学習)ファイル: 統計力学と熱力学ーOffice365_Copilot.docx2438 words書式の設定にメリハリがある数式はLaTeXソースコードのままGemini 2.5Flash: WebUIからWordに張り付けファイル: 統計力学入門-gemini_paste.docx2203 wordsGemini WebUIからコピペしたので、書式が最小限数式はLaTeXソースコードのままか不完全Gemini 2.5Flash: WebUIでMarkdownで出力、pandocでWordファイルに変換ファイル: 統計力学入門-gemini_markdown.docx1682 words書式が反映される数式はLaTeXソースを数式エディタに変換

---

# スライド 28　改めて注意: 著作権など

## テキスト

改めて注意: 著作権など間違い (ハルシネーション) のチェックは必ず行う必要がありますここで説明したような方法では、人間の創作的な関与が少ないので、著作権が認められない可能性が高い。　・人間が創作性を含めるようなプロンプトを使った場合、　　 著作権が認められる可能性があります　・ この後のやり方では、教員の創作物を使い、         生成AIを利用して教科書を作成していきます。　　 教師の創作性の関与の度合いにもよりますが、　　 教師の著作権が認められる可能性が高くなります生成AIが自動生成したものをそのまま教育に使う是非は検討してください

---

# スライド 29　教科書の作成: 

## テキスト

教科書の作成: 講義音声・資料の利用

---

# スライド 30　教科書作成フローとプログラム

## テキスト

教科書作成フローとプログラム録画・録音ファイル講義スライドPPTXTEXTMarkdown文字起こし　whisperpptx2md.pyMarkdown:　　・教科書　　・スライド生成AI　Gemini 2.5　・教科書 MS-Word　・スライド MS-PowerPointpandoc特徴・プロンプトで多言語出力・role、プロンプトでレベル調整・数式、説明、コラムなどを補完　　入力PowerPointの数式も反映 (ppt2md.py必須)

---

# スライド 31　音声ファイルから文字起こしファイルを作る方法

## テキスト

音声ファイルから文字起こしファイルを作る方法デスクトップアプリOffice365 Microsoft Word　トランスクリプト機能Zoom　リアルタイム処理可能　 (文字起こし=>文字起こしを保存、あるいはクラウド録画＋音声文字起こしを有効)WebサービスNotta: https://www.notta.ai/OpenAI Whisper: https://openai.com/ja-JP/index/whisper/　バッチ処理型　無料Google Speech-to-Text: https://cloud.google.com/speech-to-text　話者分離機能、自動句読点挿入あり、　ストリーミング対応でリアルタイム処理可能　月60分まで無料

---

# スライド 32　transcribe_simple.py (OpenAI whisper local版)

## テキスト

transcribe_simple.py (OpenAI whisper local版)デスクトップで音声ファイル (mp4/m4a/mp3/wav など) から文字起こしテキストファイルを作成Python + 関連ライブラリ (whisper, ffmpeg, torchなど) が必要・ NVIDIAのGPUを搭載しているPCでは、GPUを使って高速化できる。　 しかし、CUDA/GPU機能を使う場合はインストールのハードルが高いAIモデルは初回実行時にPCにダウンロードされます。使い方> python transcribe_simple.py --model small --lang ja --input input.mp3・modelには tiny, base, small, medium, largeが選べるが、　GPUが無い場合はbaseかsmallが無難 (今回は生成AIで修正するので十分な精度がでる)・langを指定しない場合は自動判別するが、指定したほうが無難いずれにしても、自力で文字起こしをするのはハードルが高いので、Webサービスを使うことを薦めます

---

# スライド 33　方法2-1: 

## テキスト

方法2-1: 生成AI WebUI に講義情報を入力して作る2段階プロンプトを使うと楽に入力できる講義音声から文字起こししたテキストを学習させる教科書の要件をプロンプトで入力し、Markdownテキストで出力させて pandoc でMS-Wordファイルに変換

---

# スライド 34　Web UI生成AIで文字起こしテキストから教科書を作る

## テキスト

Web UI生成AIで文字起こしテキストから教科書を作るプロンプト: 2段階に分けて入力Step1 プロンプト:以下は、統計力学の講義の文字起こしテキストです。学習してください。＊＊ ここに文字起こしテキストをコピペ ＊＊Step2 プロンプト:あなたは大学で統計力学を研究している教授です。文字起こしテキストをもとに、統計力学概論の講義の教科書を作ってください。以下の要件を満たしてください。条件:# 聴講者は材料工学科 学部2年生# 100分の授業# 数式を含める# 学生が興味を持ちそうな話などを入れる# 出力形式は、Markdownの書式がそのまま見えるように、コードブロック形式（```markdown ... ```）で出力してください。

---

# スライド 35　音声データを使った場合の特徴

## テキスト

音声データを使った場合の特徴作成手順 (Gemini 2.5Flash): WebUIで音声の文字起こしファイルを入力Markdownで出力pandocでWordファイルに変換文字起こしファイル	: 20231010統計力学_gemini_transcribe.txt出力Markdownファイル	: 20231010統計力学_gemini_transcribe.md変換したWordファイル	: 20231010統計力学_gemini_transcribe.docx2977 words, 6 page書式が反映される音声に無い数式も挿入される数式は数式エディタに変換

---

# スライド 36　スライドファイルの利用

## テキスト

スライドファイルの利用音声ファイルを２段階プロンプトで入力したように、ppt2md.pyをつかってPowerPointの講義スライドをMarkdown化し、３段階プロンプトで教科書を生成することができます。音声の文字起こしテキストを学習させるスライドPowerPointファイルをMarkdownに変換スライドのMarkdownテキストを学習させるプロンプトで教科書の要件、出力形式を指定してMarkdownテキストを出力MarkdownテキストをpandocでWordファイルに変換

---

# スライド 37　教科書の作成:

## テキスト

教科書の作成:プログラムで生成AI に講義情報を入力して作るmake_textbook5.pyを使用

---

# スライド 38　教科書作成フローとプログラム

## テキスト

教科書作成フローとプログラム録画・録音ファイル講義スライドPPTXTEXTMarkdown文字起こし　whisperpptx2md.pyMarkdown:・教科書・スライド生成AI　Gemini 2.5・教科書 MS-Word・スライド MS-PowerPointpandoc特徴・プロンプトで多言語出力・role、プロンプトでレベル調整・数式、説明、コラムなどを補完　　入力PowerPointの数式も反映 (ppt2md.py必須)

---

# スライド 39　使用する講義資料

## テキスト

使用する講義資料いろいろな比較をするため、http://d2mate.mdxes.iir.isct.ac.jp/D2MatE/D2MatE_programs.html?page=tutorialで公開している	第11回　「結晶学 (逆格子と共変・反変テンソル)」の録画と講義スライドを使い、教科書を作ってみます入力ファイル:・文字起こしファイル:	チュートリアル-結晶学03-逆格子と共変・反変テンソル.txt・講義スライドファイル:	チュートリアル-結晶学03-逆格子と共変・反変テンソル.pptx

---

# スライド 40　ベクトル解析講義に関するファイル

## テキスト

ベクトル解析講義に関するファイル入力ファイル:　講義音声の文字起こしファイル:	チュートリアル-結晶学03-逆格子と共変・反変テンソル.txt出力ファイル:　Markdownファイル:	チュートリアル-結晶学03-逆格子と共変・反変テンソル.md　MarkdownファイルをMS-Wordに変換したファイル:	チュートリアル-結晶学03-逆格子と共変・反変テンソル.docx青地の２つのファイルを使って教科書を生成

---

# スライド 41　文字起こしテキストの比較

## テキスト

文字起こしテキストの比較transcribe_simple.py (OpenAI Whisper local版ライブラリ)model = smallmodel = largeだってここでは逆講師について 復習した後 共編半篇テンソルという概念について 学び逆講師と 実講師の関係にどのように関わってくるかについて説明をしていきます 最初に逆講師についての復習をするです 逆講師はここに書かれているように定義されていますこの結果として 実講師の基本ベクトルA ijと 逆講師の基本ベクトルAスターiは互いに企画直行化していますさて ここでは逆行詞について復習した後 共変 反変転送という概念について学び逆行詞と実行詞の関係にどのように関わってくるかについて説明をしていきます最初に逆行詞についての復習です逆行詞はここに書かれているように定義されていますこの結果として 実行詞の基本ベクトルAijと逆行詞の基本ベクトルAiは 互いに規格直行化しています日本語に同音異義語が多いので、誤変換は仕方ないSmall でも large でも、音声がクリアであれば大差ない　ヘッドセットや高品質のマイクを使う生成AIで、”物理学の専門家“などの role を与えると、専門用語を優先して修正してくれる

---

# スライド 42　方法3-1: 

## テキスト

方法3-1: 講義音声の文字起こしファイルだけを入力した場合

---

# スライド 43　pptx2md.py を使用

## テキスト

pptx2md.py を使用PowerPoint => MD変換プログラムの問題点:　以下の機能が十分でない・ .pptxファイルをスライドごとに明示して出力する・数式、表、図ファイル、図ファイルへのリンクのすべてを出力するpptx2md.py: 完ぺきではないが、以下の機能に対応・ .pptxファイルをスライドタイトルごとに分離して出力する・ テキスト、表、数式、図ファイル、図ファイルへのリンクを出力する　　ただし、数式および数式のあるスライドのテキストの抽出は不完全です　　図ファイルはimagesディレクトリに保存されます使用方法:> python pptx2md.py -i input.pptx -o output.md

---

# スライド 44　pptx2md.bat

## テキスト

pptx2md.bat@echo offrem pythonスクリプトのパスを設定set script_pptx2md=d:\git\tkProg\tkprog_COE\converter\pptx2md.pyset script_pandoc=d:\git\tkProg\tkprog_COE\converter\pandoc.pyrem スライドPowerPointファイル名の拡張子を除いた部分set prefix=チュートリアル-結晶学03-逆格子と共変・反変テンソルrem スライドPowerPointファイルからMarkdownファイルを作成set cmd_pptx2md=python %script_pptx2md% -i %prefix%.pptx -o %prefix%.mdecho.echo Run [%cmd_pptx2md%]%cmd_pptx2md%rem どのようなMarkdownファイルを作成されたか、MS-Wordファイルに変換して確認set cmd_pandoc=python %script_pandoc% --convert docx --infile %prefix%.md echo.echo Run [%cmd_pandoc%]%cmd_pandoc%

---

# スライド 45　make_textbook5.py

## テキスト

make_textbook5.py入力: 文字起こしファイル、講義資料（スライド）のテキストファイル生成AI APIを選んで教科書を作成make_textbook5.ini でプロンプト全体を指定できる--role, --fieldで、教科書作成者の職業と専門分野を指定できる使い方> python make_textbook5.py -i transcribe.txt -im  slide.md -t output_text.md -s output_slide.md -a gemini --lang ja --field “材料工学” --role “日本の大学教授”  transcribe.txt	: 文字起こしテキストファイル  slide.md	: 講義資料（スライド）Markdownファイル  output_text.md	: 出力教科書Markdownファイル  output_slide.md : 出力スライドMarkdownファイル  -a gemini	: Gemini 2.5 Flashを使う  --lang ja	: 日本語で出力 (enの場合、米国英語で出力)  --field 材料工学: roleの専門分野  --role		: 日本の大学教授: role

---

# スライド 46　make_textbook5.bat の設定

## テキスト

make_textbook5.bat の設定make_textbook5.py と pandoc処理のバッチファイル設定項目:rem pythonスクリプトのパスset script_textbook=..\..\download\tkprog_textbook\ai\make_textbook5.pyset script_pandoc=..\..\download\tkprog_textbook\converter\pandoc.pyrem 入力文字起こしファイルのファイル名から拡張子を除いた部分set transcribe_prefix=チュートリアル-結晶学03-逆格子と共変・反変テンソルrem 入力スライドファイルのMarkdownファイル名set slide_path=チュートリアル-結晶学03-逆格子と共変・反変テンソル.mdset field=材料科学set role=日本の大学院教授set lang=ja		# jpではないことに注意

---

# スライド 47　標準 make_textbook5.ini

## テキスト

標準 make_textbook5.ini{role},{field},{language}は、起動時引数のrole, field, langで置換されます:実行ディレクトリ => make_textbook5.py ディレクトリの順で検索されますPROMPT_TEMPLATE_JA = """あなたは{field}を専門とする{role}です。これから「文字起こしテキスト」と、オプションで「講義スライド」のテキストを提供します。これらの情報を統合し、音声認識による誤字・誤変換を修正した上で、次の要件に従って、{language}の{field}の講義として論理的かつ正確な内容になるように全面的に修正・校正してください。**[全体要件]**- **内容の順番は維持する**- **数式を含む法則、定義などは、なるべくその導出の説明を加える**- **LaTeXのブロック数式は、１行ごとに$$~$$で区切る**- **入力Markdownテキストに図等へのリンクがある場合、生成するMarkdownファイルに必ずリンクを入れる**- **学生の学習に役立つ内容を補足する**- **学生が興味をもつ、関連する歴史、エピソードなどを追加する**- **講義で言及されている数式や、関連する重要な数式を積極的に`LaTeX`形式で記述する。**その上で、次の2種類のMarkdownファイルを生成してください。**[要件]**1.  **教科書用ファイル**: 講義内容を、教科書の章のように詳細かつ体系的に{language}で記述する。    - **見出し、箇条書き、太字などを適切に使い、可読性を高める。**    - **専門用語は正確に記述し、必要に応じて簡単な解説を加える。**    - **丁寧語（です・ます調）で記述する。**2.  **スライド用ファイル**: 上記の教科書用ファイルに対応したプレゼンテーションスライドの形式で作成する。    - **各スライドは要点をまとめた箇条書きを中心とする。**    - **スライドの区切りとして 空行＋`---`＋空行 を使用する。****[出力形式]**生成する2つのファイルの内容は、以下のカスタム区切り文字で明確に分けて出力してください。-- 略 --"""PROMPT_TEMPLATE_EN = $PROMPT_TEMPLATE_JA      <= 日本語テンプレートを英語テンプレートにコピー。別に設定する場合は “””~””” で代入

---

# スライド 48　音声文字起こしファイルだけで教科書作成 (smallモデル)

## テキスト

音声文字起こしファイルだけで教科書作成 (smallモデル)ディレクトリ: 3_vector_analysis\1_small-audio_only入力文字起こしファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.txt出力教科書Markdownファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.md変換してできたMS-Wordファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.docxmake_textbook.batの設定:rem pythonスクリプトのパスset script_textbook=..\..\download\tkprog_textbook\ai\make_textbook5.pyset script_pandoc=..\..\download\tkprog_textbook\converter\pandoc.pyrem 入力文字起こしファイルのファイル名から拡張子を除いた部分set transcribe_prefix=チュートリアル-結晶学03-逆格子と共変・反変テンソルrem 入力スライドファイルのMarkdownファイル名set slide_path=set field=材料科学set role=日本の大学院教授set lang=ja		# jpではないことに注意

---

# スライド 49　標準 make_textbook5.ini

## テキスト

標準 make_textbook5.iniPROMPT_TEMPLATE_JA = """あなたは{field}を専門とする{role}です。これから「文字起こしテキスト」と、オプションで「講義スライド」のテキストを提供します。これらの情報を統合し、音声認識による誤字・誤変換を修正した上で、次の要件に従って、{language}の{field}の講義として論理的かつ正確な内容になるように全面的に修正・校正してください。**[全体要件]**- **内容の順番は維持する**- **数式を含む法則、定義などは、なるべくその導出の説明を加える**- **LaTeXのブロック数式は、１行ごとに$$~$$で区切る**- **入力Markdownテキストに図等へのリンクがある場合、生成するMarkdownファイルに必ずリンクを入れる**- **学生の学習に役立つ内容を補足する**- **学生が興味をもつ、関連する歴史、エピソードなどを追加する**- **講義で言及されている数式や、関連する重要な数式を積極的に`LaTeX`形式で記述する。**(以下略)

---

# スライド 50　pandocでエラーが出るCase 1

## テキスト

pandocでエラーが出るCase 1Case 1: ‘---’ の前後に空行が無い⚡️ 実行中: g:\pandoc チュートリアル-結晶学03-逆格子と共変・反変テンソル_textbook.md -o チュートリアル-結晶学03-逆格子と共変・反変テンソル_textbook.docx --reference-doc D:\doc1.current\doc.講義\00チュートリアルコース\20250924生成AI-教科書作成\distribution-textbook\download\tkprog_textbook\converter\template_text.docx -t docx❌ Pandoc実行エラー (終了コード: 64)--- stderr ---Error parsing YAML metadata at "チュートリアル-結晶学03-逆格子と共変・反変テンソル_textbook.md" (line 128, column 1):YAML parse exception at line 1, column 1,while scanning an alias:did not find expected alphabetic or numeric character原因:　pandocでは、Markdownテキストに ---改行 ~ --- を見つけると、その中をYAMLと仮定して解析します。YAML書式に従っていないと、上記のYAML parse exception がでます対策:　--- を検索し、---行を削除するか、前後に空行を入れ、pandocだけ実行しなおしてください

---

# スライド 51　pandocでエラーが出るCase 2

## テキスト

pandocでエラーが出るCase 2Case 1: 図ファイルが見つからない⚡️ 実行中: g:\pandoc _slide.md -o _slide.pptx --reference-doc D:\doc1.current\doc.講義\00チュートリアルコース\20250924生成AI-教科書作成\distribution-textbook\download\tkprog_textbook\converter\template_slide.pptx -t pptx❌ Pandoc実行エラー (終了コード: 99)--- stderr ---File images\slide5_image1.png not found in resource path原因:　Markdownファイルに図ファイルへのリンクがある場合に、生成AIが存在しない図ファイルへリンクを張ってしまい、図ファイルの実体が見つからない対策:　ファイル名で検索して削除し、pandocだけ実行しなおしてください

---

# スライド 52　pandocだけ再実行する簡単な方法

## テキスト

pandocだけ再実行する簡単な方法make_textbook.batで、生成AI実行コマンドをコメントアウトするrem ======================================================rem 生成AIで教科書とスライドのMarkdownファイルを作成rem ======================================================set cmd=python %script_textbook% -i “%transcribe_path%” -im  “%slide_path%” -t “%output_text_path%” -s “%output_slide_path%” -a gemini --lang %lang% --field %field% --role %role%echo.echo Run [%cmd%]:%cmd%↑ Windowsバッチファイルでは、行頭に rem か、: を入れるとコメント扱いになりますpandocを直接呼び出す> pandoc input.md –o output.docx   (あるいはoutput.pptx)

---

# スライド 53　文字起こしテキストと教科書の比較

## テキスト

文字起こしテキストと教科書の比較model = small教科書だってここでは逆講師について 復習した後 共編半篇テンソルという概念について 学び逆講師と 実講師の関係にどのように関わってくるかについて説明をしていきます 最初に逆講師についての復習をするです 逆講師はここに書かれているように定義されていますこの結果として 実講師の基本ベクトルA ijと 逆講師の基本ベクトルAスターiは互いに企画直行化しています本講義では、結晶学と物性物理学において極めて重要な概念である「逆格子」について復習し、さらにそれを深く理解するための数学的ツールである「共変・反変テンソル」の概念について学びます。これらの概念は、X線回折などの回折現象の理解、固体中の電子の運動を記述するバンド理論、そして材料の異方的な物性を記述する上で不可欠です。直交性: 逆格子ベクトル a_i^* は、自身と同じ添字の付いた実格子ベクトル a_i とは平行な成分を持たず、残りの2つの実格子ベクトルが張る平面に垂直です。例えば、a_1^* は a_2 と a_3 の両方に直交します。長さの反比例関係:生成AIに専門家のroleを設定することで、smallモデルであっても文字起こしの誤字・誤変換は、かなりの部分修正される記号表記や怪しい表現も修正 (a*i･aj = δij を規格直交化と表現していた)

---

# スライド 54　数式の誤りも修正された

## テキスト

数式の誤りも修正された誤:　散乱振幅:    　　生成AIが修正　散乱振幅:    　　　散乱振幅:

## 数式

$$ 𝑆(𝐤)= 𝜌(𝐫)exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ =\sum_{𝑛_{1},𝑛_{2},𝑛_{3}}^{}𝜌_{u.c.}(𝑛_{1}a_{1}+𝑛_{2}a_{2}+𝑛_{3}a_{𝟑})exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ 𝑆(𝐤)= 𝜌(𝐫)exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ =\sum_{𝑛_{1},𝑛_{2},𝑛_{3}}^{}𝜌_{u.c.}(𝒓-(𝑛_{1}a_{1}+𝑛_{2}a_{2}+𝑛_{3}a_{𝟑}))exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ =\sum_{𝑛_{1},𝑛_{2},𝑛_{3}}^{}𝜌_{u.c.}(𝒓+𝑛_{1}a_{1}+𝑛_{2}a_{2}+𝑛_{3}a_{𝟑})exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

## 図

![スライド54の図1](images\slide54_image1.png)


---

# スライド 55　音声文字起こしファイルだけで教科書作成 (largeモデル)

## テキスト

音声文字起こしファイルだけで教科書作成 (largeモデル)ディレクトリ: 3_vector_analysis\2_large-audio_only入力文字起こしファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.txt出力教科書Markdownファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.md変換してできたMS-Wordファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.docxmake_textbook.batの設定:rem pythonスクリプトのパスset script_textbook=..\..\download\tkprog_textbook\ai\make_textbook5.pyset script_pandoc=..\..\download\tkprog_textbook\converter\pandoc.pyrem 入力文字起こしファイルのファイル名から拡張子を除いた部分set transcribe_prefix=チュートリアル-結晶学03-逆格子と共変・反変テンソルrem 入力スライドファイルのMarkdownファイル名set slide_path=set field=材料科学set role=日本の大学院教授set lang=ja		# jpではないことに注意

---

# スライド 56　音声文字起こしとスライドファイルで教科書作成 (日本語)

## テキスト

音声文字起こしとスライドファイルで教科書作成 (日本語)ディレクトリ: 3_vector_analysis\3_large-audio_slide入力文字起こしファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.txt入力スライドファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.md出力教科書Markdownファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.md変換してできたMS-Wordファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.docxmake_textbook.batの設定:rem 入力文字起こしファイルのファイル名から拡張子を除いた部分set transcribe_prefix=チュートリアル-結晶学03-逆格子と共変・反変テンソルrem 入力スライドファイルのMarkdownファイル名set slide_path=チュートリアル-結晶学03-逆格子と共変・反変テンソル.mdset field=材料科学set role=日本の大学院教授set lang=ja		# jpではないことに注意

---

# スライド 57　生成AIの出力Wordファイルで修正が必要だった点

## テキスト

生成AIの出力Wordファイルで修正が必要だった点ディレクトリ: 3_large-audio_slide生成AIが出力したMarkdownをpandoc –tocで目次付きでWordに変換:　チュートリアル-結晶学03-逆格子と共変・反変テンソル_textbook_toc.docx神谷が修正:　チュートリアル-結晶学03-逆格子と共変・反変テンソル_textbook_toc-V2.docx誤字や誤った説明など (論理的な関係の理解に難点？)ほとんどない実格子と逆格子の計量テンソルが逆行列の関係にあることが証明されていないことを無視している前提か、導出された結論かがあやふやになっている箇所がある生成AIが勝手に追加した点 (正しい改善) (黄色背景)「学習目標」では、教科書全体を要約して目標を追加しているδijの補足説明などを追加生成AIが勝手に変更した点 (正しいが、神谷の意図に合わない) (黄色背景)変換行列 T の要素を tij ではなく Tijと書き変えている2.12の表を作り変えた

---

# スライド 58　スライドファイルだけで教科書作成 (日本語)

## テキスト

スライドファイルだけで教科書作成 (日本語)ディレクトリ: 3_vector_analysis\4_large-slide_only入力スライドファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.md出力教科書Markdownファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.md変換してできたMS-Wordファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.docxmake_textbook.batの設定:rem 入力文字起こしファイルのファイル名から拡張子を除いた部分set transcribe_prefix=rem 入力スライドファイルのMarkdownファイル名set slide_path=チュートリアル-結晶学03-逆格子と共変・反変テンソル.mdset transcribe_path=set field=材料科学set role=日本の大学院教授set lang=ja		# jpではないことに注意

---

# スライド 59　生成AIで構成を改善: 音声ファイル (英語)

## テキスト

生成AIで構成を改善: 音声ファイル (英語)ディレクトリ: 3_vector_analysis\6_large-audio_only_en入力文字起こしファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.txt出力教科書Markdownファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.md変換してできたMS-Wordファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.docxmake_textbook.batの設定:rem 入力文字起こしファイルのファイル名から拡張子を除いた部分set transcribe_prefix=チュートリアル-結晶学03-逆格子と共変・反変テンソルrem 入力スライドファイルのMarkdownファイル名set slide_path=set field=材料科学set role=米国の大学院教授set lang=en

---

# スライド 60　生成AIの注意

## テキスト

生成AIの注意 同じ入力情報、同じプロンプトを使っても、 出力の再現性は保証されません 出力を繰り返すと、 毎回違った構成・内容・表現になる 英語版を生成しても、日本語版の英訳には ならない

---

# スライド 61　音声文字＋スライドファイルで全面的に再構成 (日本語)

## テキスト

音声文字＋スライドファイルで全面的に再構成 (日本語)ディレクトリ: 3_vector_analysis\5_large-reconstruct入力文字起こしファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.txt入力スライドファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル.md出力教科書Markdownファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.md変換してできたMS-Wordファイル	: チュートリアル-結晶学03-逆格子と共変・反変テンソル_text.docxmake_textbook.batの設定:rem 入力文字起こしファイルのファイル名から拡張子を除いた部分set transcribe_prefix=チュートリアル-結晶学03-逆格子と共変・反変テンソルrem 入力スライドファイルのMarkdownファイル名set slide_path=チュートリアル-結晶学03-逆格子と共変・反変テンソル.mdset field=材料科学set role=日本の大学院教授set lang=ja		# jpではないことに注意

---

# スライド 62　音声文字＋スライドファイルで全面的に再構成 (日本語)

## テキスト

音声文字＋スライドファイルで全面的に再構成 (日本語)プロンプト make_textbook5.iniPROMPT_TEMPLATE_JA = """あなたは{field}を専門とする{role}です。これから「文字起こしテキスト」と、オプションで「講義スライド」のテキストを提供します。これらの情報を統合し、音声認識による誤字・誤変換を修正した上で、次の要件に従って、{language}の{field}の講義として論理的かつ正確な内容になるように全面的に修正・校正してください。**[全体要件]**- **数学的な厳密性ではなく、物理理論として理論展開が論理的で理解しやすくなるように再構成する**- **数式を含む法則、定義などは、なるべくその導出の説明を加える**- **LaTeXのブロック数式は、１行ごとに$$~$$で区切る**- **入力Markdownテキストに図等へのリンクがある場合、生成するMarkdownファイルに必ずリンクを入れる**(以下略)

---

# スライド 63　pandocに--tocオプションを与えて目次を作成して比較

## テキスト

pandocに--tocオプションを与えて目次を作成して比較音声とスライドに従って教科書作成全体的な修正、再構成を指令序論	1学習目標	11. 逆格子（Reciprocal Lattice）の基礎	1(略)2. 共変ベクトルと反変ベクトル	12.1 座標変換におけるベクトルのふるまい	12.2 計量テンソル (Metric Tensor)	12.3 実格子から逆格子への変換行列	12.4 共変ベクトルと反変ベクトルの内積は不変量（スカラー）になる	12.5 添え字の約束とアインシュタインの縮約記法 12.6 方程式の共変性	2.7 未知のベクトル・テンソル成分の共変・反変の判断	12.8 計量テンソルによる共変成分と反変成分の変換2.9 微分による共変・反変の変換	12.10 物性テンソルへの応用	12.11 実践的な課題とデカルト座標系	12.12 共変・反変成分の一般的な規則のまとめ	12.13 共変座標と反変座標の幾何学的解釈	1序論	21. 逆格子	21.1 逆格子の定義と物理的意義	21.2 逆格子の幾何学的理解	31.3 逆格子のBravais格子と消滅則	51.4 実格子と逆格子のBravais格子関係	62. 共変ベクトルと反変ベクトル	72.1 ベクトルの変換則と共変・反変の定義	72.2 計量テンソル	92.3 逆格子変換と計量テンソル	102.4 内積の不変性と添え字規則	112.5 物性テンソルと共変性	132.6 共変座標と反変座標	17まとめ	18参考文献・関連プログラム	18歴史的背景・エピソード	18

---

# スライド 64　pandocに --toc オプションを与えて目次を作成して比較

## テキスト

pandocに --toc オプションを与えて目次を作成して比較章立てが簡潔になった (実際には項の中で見出しで分けられている)参考文献、エピソードが最後にまとめられた数式の導出が簡潔になった　説明も数式も書き換わっている。でも、「  こそが、逆格子の計量テンソル  」の証明が先にくるように再構成してほしかったが、それではできていない 一般座標系（実格子）から一般座標系（逆格子）への変換　実格子の基本ベクトル  を逆格子の基本ベクトル  に変換する行列はどのような形になるでしょうか。 逆格子の定義  を用いると、この変換行列の関係を導き出すことができます。(略)					これを行列の形で書くと、			ここで  は単位行列、 は実格子の計量テンソル行列です。したがって、変換行列  は実格子の計量テンソル行列の逆行列に等しいことがわかります。この  こそが、逆格子の計量テンソル  に他なりません。

## 数式

$$ 𝐺^{-1} $$

$$ 𝑔^{𝑖𝑗} $$

$$ 𝐚_{𝑖} $$

$$ 𝐚^{∗𝑗} $$

$$ 𝐚^{∗𝑖}\cdot𝐚_{𝑗}=𝛿_{𝑖𝑗} $$

$$ 𝛿_{𝑖𝑘}=\sum_{𝑗}^{​}𝑚_{𝑖𝑗}𝑔_{𝑗𝑘} $$

$$ 𝐼=𝑀𝐺 $$

$$ 𝐼 $$

$$ 𝐺 $$

$$ 𝑀 $$

$$ 𝑀=𝐺^{-1} $$

$$ 𝐺^{-1} $$

$$ 𝑔^{𝑖𝑗} $$

$$ 𝑚_{𝑖𝑗}=𝑔^{𝑖𝑗} $$

## 図

![スライド64の図1](images\slide64_image1.png)

![スライド64の図2](images\slide64_image2.png)


---

# スライド 65　仕上げ

## テキスト

仕上げMake_textbook5.pyで作成したWordファイルの内容を修正しながら、講義スライドファイルの図を貼り付けます。ここでは、図が多い 「チュートリアル-結晶学01-基本格子とブラべ格子」を使いました（チュートリアルWebから入手可能）ディレクトリ: 4_crystallographyスライドファイル	: チュートリアル-結晶学01-基本格子とブラべ格子.pptx変換してできたMS-Wordファイル	:チュートリアル-結晶学01-基本格子とブラべ格子_text.docx最終版MS-Wordファイル	　:チュートリアル-結晶学01-基本格子とブラべ格子_text-V3.docx

---

# スライド 66　その他の応用

## テキスト

その他の応用学会発表の発表原稿やスライドからいろいろな書類を作る「プロンプト次第」でなんでも生成できる

---

# スライド 67　スライドを作り、発表原稿を生成 (日本語)

## テキスト

スライドを作り、発表原稿を生成 (日本語)make_textbook5.ini:PROMPT_TEMPLATE_JA = """あなたは材料科学を専門とする日本人の博士課程学生です。これから、応用物理学会で発表予定の「スライド」のテキストを提供します。これから、次の要件に従って、日本語で発表原稿と発表スライド校正案のMarkdownファイルを作ってください。**[全体要件]**- **発表言語は日本語**- **発表時間は12分**- **聴講者はこの分野の専門家**- **話し言葉は学生らしく丁寧に**- **スライドでは説明が十分でない場合は補足する****[出力形式]**生成する2つのファイルの内容は、以下のカスタム区切り文字で明確に分けて出力してください。[TEXTBOOK_START]（ここに発表原稿ファイルの内容を記述）[TEXTBOOK_END][SLIDES_START]（ここに発表スライド校正案ファイルの内容を記述）[SLIDES_END]"""PROMPT_TEMPLATE_EN = $PROMPT_TEMPLATE_JA

---

# スライド 68　スライドを作り、発表原稿を生成 (英語)

## テキスト

スライドを作り、発表原稿を生成 (英語)make_textbook5.ini:PROMPT_TEMPLATE_JA = """あなたは材料科学を専門とする日本人の博士課程学生です。これから、米国Materiasl Research Societyで発表予定の「スライド」の日本語原案のテキストを提供します。これから、次の要件に従って、米国英語で発表原稿と発表スライド校正案のMarkdownファイルを作ってください。**[全体要件]**- **スライドのテキストを英語に翻訳**- **発表言語は英語**- **発表時間は12分**- **聴講者はこの分野の専門家**- **話し言葉は学生らしく丁寧に**- **スライドでは説明が十分でない場合は補足する****[出力形式]**生成する2つのファイルの内容は、以下のカスタム区切り文字で明確に分けて出力してください。[TEXTBOOK_START]（ここに発表原稿ファイルの内容を記述）[TEXTBOOK_END][SLIDES_START]（ここに発表スライド校正案ファイルの内容を記述）[SLIDES_END]"""PROMPT_TEMPLATE_EN = $PROMPT_TEMPLATE_JA

---

# スライド 69　推奨: 発表原稿とスライドを作り、発表原稿を生成 (日本語)

## テキスト

推奨: 発表原稿とスライドを作り、発表原稿を生成 (日本語)make_textbook5.ini:PROMPT_TEMPLATE_JA = """あなたは材料科学を専門とする日本人の博士課程学生です。これから、応用物理学会で発表予定の「スライド」のテキストを提供します。これから、次の要件に従って、日本語で発表原稿と発表スライド校正案のMarkdownファイルを作ってください。**[全体要件]**- **発表言語は日本語**- **発表時間は12分**- **聴講者はこの分野の専門家**- **話し言葉は学生らしく丁寧に**- **スライドでは説明が十分でない場合は補足する****[出力形式]**生成する2つのファイルの内容は、以下のカスタム区切り文字で明確に分けて出力してください。[TEXTBOOK_START]（ここに発表原稿ファイルの内容を記述）[TEXTBOOK_END][SLIDES_START]（ここに発表スライド校正案ファイルの内容を記述）[SLIDES_END]"""PROMPT_TEMPLATE_EN = $PROMPT_TEMPLATE_JA

---

# スライド 70　推奨: 発表原稿とスライドを作り、発表原稿を生成 (英語)

## テキスト

推奨: 発表原稿とスライドを作り、発表原稿を生成 (英語)make_textbook5.ini:PROMPT_TEMPLATE_JA = """あなたは材料科学を専門とする日本人の博士課程学生です。これから、米国Materiasl Research Societyで発表予定の「スライド」の日本語原案のテキストを提供します。これから、次の要件に従って、米国英語で発表原稿と発表スライド校正案のMarkdownファイルを作ってください。**[全体要件]**- **スライドのテキストを英語に翻訳**- **発表言語は英語**- **発表時間は12分**- **聴講者はこの分野の専門家**- **話し言葉は学生らしく丁寧に**- **スライドでは説明が十分でない場合は補足する****[出力形式]**生成する2つのファイルの内容は、以下のカスタム区切り文字で明確に分けて出力してください。[TEXTBOOK_START]（ここに発表原稿ファイルの内容を記述）[TEXTBOOK_END][SLIDES_START]（ここに発表スライド校正案ファイルの内容を記述）[SLIDES_END]"""PROMPT_TEMPLATE_EN = $PROMPT_TEMPLATE_JA

---

# スライド 71　発表原稿とスライドから成果報告書を作る

## テキスト

発表原稿とスライドから成果報告書を作るmake_textbook5.ini:PROMPT_TEMPLATE_JA = """あなたは半導体工学を専門とする日本の大学教授です。これから、応用物理学会で発表した「発表原稿」と「発表スライド」のテキストを提供します。次の要件に従って、この研究の成果報告書と成果報告会発表スライドのMarkdownを作ってください。**[全体要件]**- **言語は日本語**- **ですます調で丁寧に**- **発表スライドファイルの数式、図リンクをすべて成果報告書と成果報告会発表スライドに入れる**- **説明が十分でない場合は補足する****[出力形式]**生成する2つのファイルの内容は、以下のカスタム区切り文字で明確に分けて出力してください。[TEXTBOOK_START]（ここに成果報告書ファイルの内容を記述）[TEXTBOOK_END][SLIDES_START]（ここに成果報告会発表スライドファイルの内容を記述）[SLIDES_END]"""PROMPT_TEMPLATE_EN = $PROMPT_TEMPLATE_JA

---

# スライド 72　発表原稿とスライドからYoutube対談原稿を生成する

## テキスト

発表原稿とスライドからYoutube対談原稿を生成するmake_textbook5.ini:PROMPT_TEMPLATE_JA = """あなたは、対談形式の動画を配信しているYoutuberです。これから、応用物理学会で発表予定の「スライド」のテキストを提供します。次の要件に従って、日本語で対談形式の原稿とスライド校正案のMarkdownファイルを作ってください。**[全体要件]**- **言語は日本語**- **時間は12分**- **聴講者は科学技術に詳しくない一般人**- **話し言葉は気さくな感じで**- **スライドでは説明が十分でない場合は補足する****[出力形式]**生成する2つのファイルの内容は、以下のカスタム区切り文字で明確に分けて出力してください。[TEXTBOOK_START]（ここに対談形式の原稿ファイルの内容を記述）[TEXTBOOK_END][SLIDES_START]（ここにスライド校正案ファイルの内容を記述）[SLIDES_END]"""PROMPT_TEMPLATE_EN = $PROMPT_TEMPLATE_JA

---

# スライド 73　対談原稿: VOICEVOXなどで再生可能

## テキスト

対談原稿: VOICEVOXなどで再生可能書式を合わせなおせばVOICEVOX (https://voicevox.hiroshiba.jp/) などで再生可能5_other_applications\Youtube対談\voicevox_script.txt:四国めたん（ノーマル）,皆さん、こんにちは。東京工業大学の神谷です。本日はよろしくお願いいたします。ずんだもん（ノーマル）,神谷先生、ありがとうございます！早速ですが、先生の研究内容を、今日はお客様にバッチリ伝えたいと思います！それでは、最初のスライドからいきましょう！ずんだもん（ノーマル）,はい、最初のスライドはタイトルですね。「二段階成長法による多結晶シリコン薄膜の作製」というタイトルですが、神谷先生、そもそも「多結晶シリコン薄膜」って、どんなものなんですか？四国めたん（ノーマル）,はい。「多結晶シリコン薄膜」というのは、その名の通り、小さなシリコンの粒がたくさん集まってできた薄い膜のことです。

---

# スライド 74　GUIプログラム: まだ正式公開ではありません

## テキスト

GUIプログラム: まだ正式公開ではありませんインストール> cd [zipを展開したディレクトリ]> update_textbook.bat launcher> pip install -r requirements_launcher.txt> python setup.py起動> launcher

## 図

![スライド74の図1](images\slide74_image1.png)

![スライド74の図2](images\slide74_image2.png)

![スライド74の図3](images\slide74_image3.png)

![スライド74の図4](images\slide74_image4.png)


---

# スライド 75　まとめ

## テキスト

生成AIの活用は、プロンプト次第Roleを与えることで、誤字だけでなく、論理・数式・専門用語も修正　=> 修正された結果が間違っていることもあるので注意効果的に使うには、入力情報をテキストで準備する原則、出力もテキストに限定されるので、Markdownを活用ほとんどの処理は、Webサービスと pandoc だけで完結できる　・PowerPointをMarkdown化するには不十分？　　　pptx2md.py の利用を推奨プログラムを利用したほうが便利make_textbook5.py, pandoc.py, transcribe_simple.pypptx2md.bat, make_textbook.bat を配布しましたまとめ

---

