# スライド 1　チュートリアル: 講義録画・録音ファイルと生成AIから 教科書を作ろう

## テキスト

今日のテーマは、AIを使って講義の録画や録音、資料から、サクッと教科書を作っちゃおう！というお話です。東京科学大学の神谷利夫先生の研究をご紹介しますね。

この技術には、最新のAIツール (Microsoft365 Copilot / Chat GPT5 / Gemini 2.5等) が使われているんですって！

---

# スライド 2　AIでできること、そして使う上での注意点

## テキスト

AIで教科書を作るって、どんなことができるんでしょう？大きく分けて３つのことができます。

1.  何もないところからAIに教科書を作ってもらう。
2.  皆さんの講義資料（録音やPowerPoint）を入力して、AIに教科書を作ってもらう。
3.  AIを使う上での大切な注意点（著作権や間違いがないかチェックすること）も忘れずに！

今日は特に2番の「持ってる資料を活かす方法」と、3番の「注意点」を中心に、皆さんの身近な話題としてお伝えします！

---

# スライド 3　教科書作成プログラムWebサイト (誰でも試せるよ！)

## テキスト

特別なソフトを入れなくても、インターネットのWebサイトで手軽に教科書作りを体験できます！

神谷先生の研究室が公開しているサイトで、色々なプログラムやツールが試せます。

## 図

![スライド3の図1](images\slide3_image1.png)

---

# スライド 4　ハルシネーションの少ない自製AI: NotebookLM (試してみよう！)

## テキスト

AIがもっともらしいデタラメ（ハルシネーション）を出す心配が少ない、ちょっと特別なAIサービス「NotebookLM」もWebサイトから試せます。

## 図

![スライド4の図1](images\slide4_image1.png)

---

# スライド 5　公開NotebookLM (質問してみよう！)

## テキスト

Gmailアカウントがあれば誰でも利用可能！著作権やAIに関する質問ができる、統計力学の講義用Notebookも公開されています。AIに直接疑問をぶつけてみましょう！

## 図

![スライド5の図1](images\slide5_image1.png)

---

# スライド 6　教科書の作成: AIにお願いするだけで生成！

## テキスト

まずは一番簡単な方法から！AIにプロンプト（お願いの文章）を入力するだけで、あっという間に教科書が作れます。

---

# スライド 12　AIだけで作る方法1: Office365 MS-Word + Copilot

## テキスト

Microsoft Office365のWordを使っているなら、「Copilot（コパイロット）」というAI機能を使うのが一番手軽です。

---

# スライド 13　AIへのお願いの仕方（プロンプトの例）

## テキスト

WordのCopilotに、以下のような「プロンプト（AIへのお願いの文章）」を入力するだけ！

**プロンプト:**
統計力学概論の講義の教科書を作ってください。以下の要件を満たしてください。

**条件:**
*   聴講者は材料工学科 学部2年生
*   100分の授業
*   数式を含める
*   学生が興味を持ちそうな話などを入れる

**講義内容:**
*   統計力学と熱力学の関係
*   統計力学の考え方
*   統計分布関数
*   応用

---

# スライド 14　AIだけで作る方法2: Webサイトの生成AIを使う

## テキスト

WordにCopilotがない場合でも、GeminiやChat GPTといったWebサイトの生成AIを使えば、同様に教科書が作成できます。

AIの出力を直接Wordに貼り付けることもできますし、「Markdown」というシンプルなテキスト形式で出力させて、専用ツールでWordファイルに変換することも可能です。

---

# スライド 15　AIツールの選び方 (Gemini 2.5 Flashがおすすめな理由)

## テキスト

様々な生成AIを比較した結果、教科書作成には「Gemini 2.5 Flash」がおすすめです。

Chat GPTは短く要約しがちで情報が不足することがありましたが、Gemini 2.5 Flashはより詳細な内容を生成してくれます。

---

# スライド 16　AIで教科書を作る流れ (とってもシンプル！)

## テキスト

AIに教科書を作成してもらう手順は、以下のシンプルな2ステップです。

1.  生成AIにプロンプト（お願いの文章）を入れて、教科書のMarkdownテキストを入手。
2.  入手したMarkdownファイルをMS-Wordに変換する。

---

# スライド 24　AIにうまく伝わらなかった失敗例

## テキスト

AIとの対話にはコツが必要です。

**失敗したプロンプトの例:**
「統計力学概論の講義の教科書を作ってください。(中略) Markdown形式でコピペできる形で出力する」

この指令でも、AIがMarkdownをWeb表示に変換して出力してしまうことがありました。

---

# スライド 25　AIへのお願いの仕方 (プロンプトのコツ)

## テキスト

AIに意図を正確に伝えるための「プロンプトのコツ」です。

AIのWebUIは、出力をHTML+CSSに整形して表示します。そのため、Markdownで出力させたい場合でも、その部分がHTMLに変換されてしまうことがあります。

**【AIにMarkdownテキストを正確に出力させるためのプロンプト】**
「出力形式は、Markdownの書式がそのまま見えるように、コードブロック形式（```markdown ... ```）で出力してください」

---

# スライド 26　プロンプトを工夫した成功例

## テキスト

プロンプトを工夫すれば、AIは指示通りに動いてくれます。

**プロンプトの例:**
統計力学概論の講義の教科書を作ってください。以下の要件を満たしてください。
**条件:**
*   聴講者は材料工学科 学部2年生
*   100分の授業
*   数式を含める
*   学生が興味を持ちそうな話などを入れる
*   **出力形式は、Markdownの書式がそのまま見えるように、コードブロック形式（```markdown ... ```）で出力してください。**
**講義内容:**
*   統計力学と熱力学の関係
*   統計力学の考え方
*   統計分布関数
*   応用

このように具体的に指定することで、AIは期待通りのMarkdownテキストを生成します。

---

# スライド 28　大事な注意点: 著作権とハルシネーション (AIの「うそ」に気を付けて！)

## テキスト

生成AIを活用する上で、特に注意すべき点を再確認しましょう。

*   **間違い (ハルシネーション) のチェックは必ず行う必要があります。**
    AIはもっともらしいデタラメを生成することがあります。内容の正確性は、人間が確認することが必須です。

*   **著作権について:**
    *   AIが自動生成したものをそのまま使用する場合、人間の創作的関与が少ないため、著作権が認められない可能性が高いです。
    *   人間がアイデアや表現を盛り込むなど、創作性を含めるプロンプトを使った場合、著作権が認められる可能性があります。
    *   既存の講義資料など、教師の創作物をAIで教科書化する場合、教師の著作権が認められる可能性が高くなります。

*   **AI生成物の教育利用について:**
    生成AIが自動生成したものをそのまま教育に使うことの是非は、常に検討が必要です。

---

# スライド 29　教科書の作成: 講義の音声や資料をAIに読ませる！

## テキスト

もっとハイクオリティな教科書を作るには、先生たちが普段使っている講義の「音声データ」や「PowerPointのスライド」をAIに活用させるのが効果的です。

---

# スライド 30　講義資料から教科書を作る流れ

## テキスト

講義資料から教科書を作成する全体像です。

録画・録音ファイル
↓ （文字起こしツール）
文字起こしテキスト

講義スライドPPTX
↓ （変換ツール）
スライドのMarkdownテキスト

これらのテキストデータを生成AIに入力することで、教科書とスライドのMarkdownテキストが生成されます。

最終的に、これらのMarkdownファイルをPandocなどのツールで、MS-WordやMS-PowerPoint形式に変換します。
AIはプロンプト次第で、多言語出力、レベル調整、数式・説明・コラムの補完なども可能です。

---

# スライド 31　音声ファイルから文字を起こす方法 (便利なWebサービス)

## テキスト

講義の音声ファイルから文字起こしをするには、様々な便利なツールがあります。

*   **デスクトップアプリ:**
    *   Office365 Microsoft Word（トランスクリプト機能）
    *   Zoom（リアルタイム処理、クラウド録画＋音声文字起こし）

*   **Webサービス:**
    *   Notta: https://www.notta.ai/
    *   OpenAI Whisper: https://openai.com/ja-JP/index/whisper/（バッチ処理型、無料）
    *   Google Speech-to-Text: https://cloud.google.com/speech-to-text（話者分離、自動句読点、リアルタイム処理可能、月60分まで無料）

これらのサービスを使えば、手軽に音声からテキストを作成できます。

---

# スライド 33　講義音声の文字起こしをAIに入力！

## テキスト

文字起こししたテキストは、Webサイトの生成AIに直接入力して教科書を作成できます。長いテキストの場合、AIに情報を整理してもらうために「2段階プロンプト」を使うのが効果的です。

---

# スライド 34　2段階プロンプトでAIに賢くお願い！

## テキスト

AIに講義の文字起こしテキストから教科書を作成してもらうためのプロンプト例です。

**Step1 プロンプト:**
「以下は、統計力学の講義の文字起こしテキストです。学習してください。」
（ここに文字起こしテキストをコピペ）

**Step2 プロンプト:**
「あなたは大学で統計力学を研究している教授です。文字起こしテキストをもとに、統計力学概論の講義の教科書を作ってください。以下の要件を満たしてください。
**条件:**
*   聴講者は材料工学科 学部2年生
*   100分の授業
*   数式を含める
*   学生が興味を持ちそうな話などを入れる
*   出力形式は、Markdownの書式がそのまま見えるように、コードブロック形式（```markdown ... ```）で出力してください。」

---

# スライド 35　音声データを使った教科書の特徴

## テキスト

講義の音声データから作成した教科書には、次のような特徴があります。

*   **書式が反映される:** AIがテキストを読み込み、見出しや箇条書きなど、読みやすい書式に整えてくれます。
*   **音声に無い数式も挿入される:** 講義中には口頭で説明されたり、板書された数式も、AIが内容を理解して適切な箇所に挿入してくれることがあります。
*   **数式は数式エディタに変換:** 挿入された数式は、Wordの数式エディタなどで編集できるきれいな形式で出力されます。

---

# スライド 41　AIによる文字起こしテキストの修正例 (専門家AIはすごい！)

## テキスト

AIは、文字起こしで生じた誤字・誤変換を、専門知識に基づいて修正してくれます。

**元の文字起こしテキストの例:**
「だってここでは逆講師について 復習した後 共編半篇テンソルという概念について 学び逆講師と 実講師の関係にどのように関わってくるかについて説明をしていきます...」

**AIが修正した教科書テキストの例:**
「さて、ここでは逆格子について復習した後、共変反変テンソルという概念について学び、逆格子と実格子の関係にどのように関わってくるかについて説明をしていきます...」

*   **専門用語の修正:** 「逆講師」を「逆格子」、「共編半篇テンソル」を「共変反変テンソル」など、文脈に合わせて正しく修正します。
*   **記号表記や怪しい表現の修正:** AIに「物理学の専門家」などの役割（role）を与えることで、専門用語を優先して修正してくれます。

---

# スライド 53　AIが教科書の記述を改善！ (例: 専門用語の修正)

## テキスト

AIは、文字起こしテキストの専門用語や表現を、より正確で分かりやすい教科書表現に改善してくれます。

**文字起こしテキスト（例）:**
「...規格直交化しています」

**AIが改善した教科書（例）:**
「本講義では、結晶学と物性物理学において極めて重要な概念である「逆格子」について復習し、さらにそれを深く理解するための数学的ツールである「共変・反変テンソル」の概念について学びます。(中略) **直交性**: 逆格子ベクトル a_i^* は、自身と同じ添字の付いた実格子ベクトル a_i とは平行な成分を持たず、残りの2つの実格子ベクトルが張る平面に垂直です。例えば、a_1^* は a_2 と a_3 の両方に直交します。**長さの反比例関係**:...」

このように、AIは曖昧な表現を具体的な説明に置き換え、専門的な概念を補足します。

---

# スライド 54　AIが数式の誤りも修正！ (複雑な数式もバッチリ)

## テキスト

AIは、講義中の数式に関する誤りや不完全な記述も、専門知識に基づいて修正・補完してくれます。

**元の数式（誤りを含む例）とAIが修正した数式（例）:**

（スライドの図にある数式群を指して）
図１：散乱振幅の数式において、AIが正しく数式を修正している例です。

## 数式

$$ 𝑆(𝐤)= 𝜌(𝐫)exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ =\sum_{𝑛_{1},𝑛_{2},𝑛_{3}}^{}𝜌_{u.c.}(𝑛_{1}a_{1}+𝑛_{2}a_{2}+𝑛_{3}a_{𝟑})exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ 𝑆(𝐤)= 𝜌(𝐫)exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ =\sum_{𝑛_{1},𝑛_{2},𝑛_{3}}^{}𝜌_{u.c.}(𝒓-(𝑛_{1}a_{1}+𝑛_{2}a_{2}+𝑛_{3}a_{𝟑}))exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

$$ =\sum_{𝑛_{1},𝑛_{2},𝑛_{3}}^{}𝜌_{u.c.}(𝒓+𝑛_{1}a_{1}+𝑛_{2}a_{2}+𝑛_{3}a_{𝟑})exp(2𝜋𝑖𝐤\cdot𝐫)𝑑𝒓 $$

## 図

![スライド54の図1](images\slide54_image1.png)

AIは複雑な数式も正確に理解し、誤りを訂正してくれます。

---

# スライド 66　教科書だけじゃない！AIのその他の応用例

## テキスト

AIによるテキスト生成技術は、教科書作成にとどまらず、非常に幅広い分野に応用できます。

**「プロンプト次第」で、本当に様々な書類が生成可能です！**

---

# スライド 67　応用例1: 発表原稿・スライドをAIが生成 (日本語)

## テキスト

学会発表の準備にもAIが活躍します。

**AIへのプロンプト例:**
「あなたは材料科学を専門とする日本人の博士課程学生です。これから、応用物理学会で発表予定の『スライド』のテキストを提供します。次の要件に従って、日本語で発表原稿と発表スライド校正案のMarkdownファイルを作ってください。
**[全体要件]**
*   発表言語は日本語
*   発表時間は12分
*   聴講者はこの分野の専門家
*   話し言葉は学生らしく丁寧に
*   スライドでは説明が十分でない場合は補足する」

スライドのテキストを入力するだけで、専門家向けの発表原稿やスライドの校正案が自動で生成されます。英語での発表原稿も同様に作成可能です。

---

# スライド 71　応用例2: 発表原稿・スライドから成果報告書を作成

## テキスト

学会発表後の成果報告書の作成もAIが効率化します。

**AIへのプロンプト例:**
「あなたは半導体工学を専門とする日本の大学教授です。これから、応用物理学会で発表した『発表原稿』と『発表スライド』のテキストを提供します。次の要件に従って、この研究の成果報告書と成果報告会発表スライドのMarkdownを作ってください。
**[全体要件]**
*   言語は日本語
*   ですます調で丁寧に
*   発表スライドファイルの数式、図リンクをすべて成果報告書と成果報告会発表スライドに入れる
*   説明が十分でない場合は補足する」

発表原稿とスライドのテキストを基に、成果報告書とその発表スライドまで一括で生成できます。数式や図のリンクも引き継がれます。

---

# スライド 72　応用例3: この動画の「対談原稿」もAIが生成！

## テキスト

実は、私たちが今話している、このYouTube対談形式の原稿もAIが生成しました！

**AIへのプロンプト例 (まさに今回のプロンプトです！):**
「あなたは、対談形式の動画を配信しているYoutuberです。これから、応用物理学会で発表予定の『スライド』のテキストを提供します。次の要件に従って、日本語で対談形式の原稿とスライド校正案のMarkdownファイルを作ってください。
**[全体要件]**
*   言語は日本語
*   時間は12分
*   聴講者は科学技術に詳しくない一般人
*   話し言葉は気さくな感じで
*   スライドでは説明が十分でない場合は補足する」

このように、用途やターゲット層に合わせて、柔軟にテキストを生成できます。

---

# スライド 73　AIが作った原稿で、動画も作れる！(VOICEVOX)

## テキスト

AIが生成した対談原稿は、VOICEVOX（https://voicevox.hiroshiba.jp/）のような音声合成ソフトと組み合わせて、動画コンテンツを制作することも可能です。

**VOICEVOX向けスクリプト例:**
*   四国めたん（ノーマル）,皆さん、こんにちは。東京工業大学の神谷です。本日はよろしくお願いいたします。
*   ずんだもん（ノーマル）,神谷先生、ありがとうございます！早速ですが、先生の研究内容を、今日はお客様にバッチリ伝えたいと思います！それでは、最初のスライドからいきましょう！

AIが原稿作成から音声合成までをサポートすることで、動画制作の効率が大幅に向上します。

---

# スライド 75　今日のまとめ: AI活用術のポイント

## テキスト

今日のAI活用術のポイントをまとめます。

*   **生成AIの活用は、プロンプト次第！**
    AIへのお願いの仕方（プロンプト）が、成果物の質を左右します。

*   **Roleを与えることで、誤字だけでなく、論理・数式・専門用語も修正！**
    AIに「専門家」の役割を与えることで、高度な修正・補完が可能になります。ただし、修正結果が間違っていることもあるので注意が必要です。

*   **効果的に使うには、入力情報をテキストで準備する！**
    講義の録音やPowerPointも、まずはテキストデータに変換することが大切です。

*   **原則、出力もテキストに限定されるので、Markdownを活用！**
    シンプルで汎用性の高いMarkdown形式を使いこなしましょう。

*   **ほとんどの処理は、Webサービスと Pandoc だけで完結できる！**
    特別なソフトを入れなくても、便利なオンラインツールで多くの作業が行えます。
    （PowerPointをMarkdown化するには、専門のツール（pptx2md.py）の利用が推奨されます）

*   **プログラムを利用したほうが、より便利に高度な処理も可能！**
    専門家向けには、make_textbook5.py, pandoc.py, transcribe_simple.pyといったプログラムを活用することで、さらに効率的な作業が実現します。