# スライド 1　二段階成長法による 多結晶シリコン薄膜の作製

## テキスト

**二段階成長法による多結晶シリコン薄膜の作製**<br>
－表面反応制御による構造制御と物性－<br>
（東京工業大学 総合理工学研究科）<br>
○神谷利夫、中畑浩一、三井田淳、盧和敬、C.M.Fortmann、清水勇

**概要**<br>
　　・背景：なぜ新しい薄膜作製法が必要なのか？<br>
　　・2段階成長法：効率的に高品質な膜を作る新しいアプローチ<br>
　　・実験結果：<br>
　　　　└ 界面構造の改善（エリプソメータによるその場観察）<br>
　　　　└ 種結晶（タネの膜）が最終的な薄膜に与える影響<br>
　　・まとめ：研究成果のポイント

**【図の補足】**<br>
スライド右下の図は、今回開発した「二段階成長法」のイメージ図です。<br>
まず「Substrate（基板）」の上に、きれいに並んだ粒の「Seed crystal（種結晶）」を作り、その上に「poly-Si grain（多結晶シリコンの粒）」が連続的に成長していく様子を示しています。

---

# スライド 2　背景

## テキスト

**SiF4原料を用いたPE-CVD法による多結晶シリコン薄膜の作製**<br>
　・低温で高結晶性多結晶シリコンを実現<br>
　・~10Å/sの高速製膜（素早く膜が作れる）<br>
　・高い配向性（原子がきれいに並んでいる）	(022)

**【課題】ガラス基板上への製膜**<br>
　　製膜初期のアモルファス層（原子がバラバラに並んだ層）の低減が必要<br>
　　・Layer-By-Layer (LBL) 法：薄く作り、きれいに整える工程を繰り返す方法（手間がかかる）<br>
　　・**2段階成長法**：今回の研究で提案する新しいアプローチ

**【補足】**<br>
*   **SiF4原料**: 一般的なSiH4（シラン）ではなく、SiF4（テトラフルオロシラン）というガスを使うことで、低温でも高品質な膜を作れます。
*   **PE-CVD法**: プラズマの力を利用して膜を作る技術です。
*   **結晶性**: 膜の中で原子がきれいに並んでいる度合い。高いほど性能が良いです。
*   **アモルファス層**: 原子がランダムに並んでいる、ガラスのような状態の層です。これがあると、電気的な性能が落ちてしまいます。

---

# スライド 3　2段階成長法

## テキスト

**2段階成長法**：高品質な「タネ」を作り、その上に効率よく成長させる方法

**[成長プロセス]**<br>
　Substrate（基板）の上に、エピタキシャルライク成長（種結晶の並びを真似て成長）<br>
　低温製膜 (200~350℃)：熱に弱い基板でもOK<br>
　速い成膜速度：効率的に作製

**[種結晶プロセス]**<br>
　Substrate（基板）の上に、Seeds crystal（種結晶）を~100nm（非常に薄い層）作成<br>
　高配向性・高結晶性：原子がきれいに並んだ高品質なタネ<br>
　高温製膜 Ts (> 360℃)：Layer-By-Layer法を用いて丁寧に作製

**【ポイント】**<br>
「種結晶プロセス」で高品質な土台を丁寧に作り、「成長プロセス」でその土台を活かしつつ、効率的に膜全体を成長させることで、高品質かつ低コストな膜作製を目指します。<br>
ただし、この２つのプロセスの「境目（界面）」をどうスムーズに繋げるかが重要になります。

---

# スライド 4　過去の課題データ (宮本らの報告より)

## テキスト

**大気開放による成長プロセス開始時の界面劣化**<br>
このデータは、昨年宮本らが報告した研究結果です。

**【グラフの見方】**<br>
*   横軸：時間 (秒) - 膜を成長させている時間です。<br>
*   縦軸：<e2> (擬誘電関数) - この値が大きいほど、膜の結晶性が高く、表面が滑らかであることを示します。

**【注目ポイント】**<br>
*   種結晶を作製した後、一度「大気開放」して別のチャンバーに移すと、成長プロセス開始時に**<e2>が大きく「ディップ（ガクッと下がる）」**しているのが分かります。<br>
*   これは、大気に触れたことで膜の表面に不純物が付着したり、表面が荒れてしまったりしたためと考えられます。<br>
*   このような界面の劣化は、最終的な太陽電池の特性を大きく低下させてしまいます。<br>
*   よって、この**「界面をいかに改善するか」**が、高性能なデバイスを作る上で不可欠な課題でした。

## 図

![スライド4の図1](images\slide4_image1.png)

![スライド4の図2](images\slide4_image2.png)

![スライド4の図3](images\slide4_image3.png)

![スライド4の図4](images\slide4_image4.png)

![スライド4の図5](images\slide4_image5.png)

![スライド4の図6](images\slide4_image6.png)

![スライド4の図7](images\slide4_image7.png)

![スライド4の図8](images\slide4_image8.png)

![スライド4の図9](images\slide4_image9.png)

![スライド4の図10](images\slide4_image10.png)

![スライド4の図11](images\slide4_image11.png)

![スライド4の図12](images\slide4_image12.png)

![スライド4の図13](images\slide4_image13.png)

![スライド4の図14](images\slide4_image14.png)

![スライド4の図15](images\slide4_image15.x-wmf)

![スライド4の図16](images\slide4_image16.x-wmf)

---

# スライド 5　目 的

## テキスト

**目 的**

1.  **2段階成長法の種結晶と成長多結晶薄膜の「エピタキシャルライク界面」を実現する**<br>
    　→ 分光エリプソメトリー（光を使ったリアルタイム観察）を「その場観察（in-situ）」で用い、界面が滑らかにつながる条件を探る。
2.  **2段階成長法における種結晶の結晶性（タネの品質）が最終的な薄膜の構造にどのような影響を与えるか検討する**<br>
    　→ 良いタネと悪いタネで、育つ膜がどう変わるかを調べる。

**【イメージ】**<br>
まるで植物の栽培のように、「良いタネ」を使い、そのタネと「育つ環境（成長プロセス）」の「境目」をいかにスムーズに繋げて、最終的に高品質な作物を育てるか、を解明することを目指します。

---

# スライド 6　実験装置

## テキスト

**実験装置：マイクロ波プラズマエンハンスドCVD装置（その場観察機能付き）**

**【装置のしくみ】**<br>
*   **Ar/H2**: プラズマを起こしたり、原料ガスを薄めたりするガス。<br>
*   **SiF4**: シリコン薄膜の材料となる原料ガス。<br>
*   **Microwave (マイクロ波)**: ガスをプラズマ状態にするためのエネルギー。<br>
*   **Shutter (シャッター)**: SiF4ガスの導入を制御し、Layer-By-Layer法を実現します。<br>
*   **in-situ Spectroscopic Ellipsometer (分光エリプソメータ)**: 膜を成長させている最中に、リアルタイムで膜の厚さ、表面の粗さ、結晶性を測定します。

**【Layer-By-Layer 法の制御】**<br>
SiF4ガスを間欠的に導入することで、<br>
「Deposition（堆積）」→「Atomic Hydrogen Treatment（原子状水素処理）」<br>
という工程を繰り返し、高品質な膜を段階的に作ります。


---

# スライド 7　実験方法

## テキスト

**構造評価方法**<br>
*   **分光エリプソメータ (SE)**：膜の成長過程をリアルタイムで観察。4.15eVにおける<e2>（擬誘電関数）の変化を主要な指標とします。<br>
    　→ <e2>の値が大きいほど結晶性が高く、表面が滑らかです。
*   **粉末X線回折 (XRD)**：最終的な薄膜の結晶構造（原子の並び方）を評価します。

**典型的な製膜条件**<br>
*   マイクロ波出力：200W<br>
*   反応圧：400mTorr<br>
*   種結晶過程（LBL法）での堆積時間、水素処理時間：10秒<br>
*   **基板温度**：<br>
    　└ 種結晶プロセス：380℃（高品質なタネを作るため）<br>
    　└ 成長プロセス：220℃〜380℃（温度を変化させて実験）<br>
*   **主なパラメータ**：各過程での**SiF4/H2流量比**（原料ガスと水素ガスの割合）

**【ポイント】**<br>
特に、成長プロセスの「基板温度」と「SiF4/H2流量比」を細かく調整し、界面の改善を目指しました。

## 図

![スライド7の図1](images\slide7_image1.x-emf)

![スライド7の図2](images\slide7_image2.x-emf)

---

# スライド 8　成長プロセスにおける<e2>の製膜時間変化

## テキスト

**成長プロセスにおける<e2>の製膜時間変化**<br>
**(SiF4/H2流量比 : 種結晶プロセスと成長プロセスで同じ条件)**<br>
(Seed:SiF4流量50/H2流量5/その他ガス流量30, 380℃ - poly-Si:SiF4流量50/H2流量5/その他ガス流量30)

**【グラフの見方】**<br>
*   左側は種結晶の作製過程、点線から右側が成長プロセスの開始を示します。<br>
*   縦軸の<e2>の値が大きいほど、結晶性が良く、表面が滑らかです。

**【実験結果】**<br>
*   種結晶作製後、**大気開放せずに**成長プロセスを行ったため、過去のデータのような**大きなディップは観察されません**でした。これは界面のコンタミネーション（汚染）が抑制されたことを示します。
*   しかし、成長温度を380℃から**350℃に下げた途端**、**<e2>が急激に低下**しているのが分かります。<br>
*   これは、界面で急激な構造変化（結晶性の低下や表面の粗化）が起こっていることを意味します。

**【課題】**<br>
連続製膜であっても、成長プロセスで温度を下げると界面の劣化が起こってしまう。

## 図

![スライド8の図1](images\slide8_image1.x-emf)

---

# スライド 9　成長プロセスにおける<e2>の製膜時間変化

## テキスト

**成長プロセスにおける<e2>の製膜時間変化**<br>
**(SiF4/H2流量比 : 種結晶プロセスより成長プロセスでSiF4流量を少なくした場合)**<br>
(Seed:SiF4流量50/H2流量5/その他ガス流量60, 380℃ - poly-Si:SiF4流量50/H2流量5/その他ガス流量30)

**【実験条件】**<br>
*   種結晶プロセスに比べて、成長プロセスにおけるSiF4ガス（原料ガス）の流量を少なくし、SiF4/H2流量比を調整しました。

**【実験結果】**<br>
*   基板温度350℃においても、界面での<e2>の急激な低下が見られず、**連続的に変化**していることが分かります。<br>
*   これは、ガスの流量比を調整することで、界面構造が改善されたことを示しています。
*   ただし、さらに温度を下げて320℃にすると、まだ大きな<e2>の低下が起こってしまいました。

**【ポイント】**<br>
ガスの流量比を調整することが、低温での界面改善に有効であることが示唆されましたが、さらなる低温化にはまだ課題が残りました。

## 図

![スライド9の図1](images\slide9_image1.x-wmf)

---

# スライド 10　成長プロセスにおける<e2>の製膜時間変化

## テキスト

**成長プロセスにおける<e2>の製膜時間変化**<br>
**(SiF4/H2流量比 : さらに成長プロセスでH2流量を増大させた場合)**<br>
(Seed:SiF4流量60/H2流量5/その他ガス流量60, 380℃ - poly-Si:SiF4流量60/H2流量10/その他ガス流量30)

**【実験条件】**<br>
*   成長プロセスにおいて、H2（水素ガス）の流量をさらに増加させ、SiF4/H2流量比をより小さく調整しました。

**【実験結果】**<br>
*   基板温度を**280℃まで下げても**、界面の構造が滑らかにつながり、また、成長を続けても大きな<e2>の低下が起こらなくなりました。

**【結論】**<br>
まず、SiF4/H2流量比が比較的大きな条件で高品質な種結晶を作製し、その後、SiF4/H2流量比を小さく（水素ガスを多めに）して成長プロセスを行えば、**基板温度を下げても連続的で高品質な界面を保ったまま、2段階成長が可能**になることが分かりました。

## 図

![スライド10の図1](images\slide10_image1.x-wmf)

---

# スライド 11　2段階成長法で作製した薄膜の 構造に与える種結晶の影響

## テキスト

**2段階成長法で作製した薄膜の構造に与える種結晶の影響**

**【目的】**<br>
最初に形成する「種結晶（タネの膜）」の品質が、その上に成長させる最終的な薄膜の構造（結晶性）にどれほど影響を与えるかを検証しました。

**【実験方法】**<br>
*   「種結晶」の作製条件だけを変えて、異なる品質の種結晶を作りました。
*   その後の「成長プロセス」は、全く同じ条件で行いました。

---

# スライド 12　成長プロセスにおける<e2>変化の種結晶依存性

## テキスト

**成長プロセスにおける<e2>変化の種結晶依存性**

**【2種類の種結晶】**<br>
*   **Seed: 60/5/60 (左図)**：高品質な種結晶（結晶性が高く、アモルファス相が少ない）<br>
*   **Seed: 60/10/60 (右図)**：品質の低い種結晶（アモルファス相が多い）<br>
    *(poly-Si: 成長薄膜の条件は60/10/60で統一)*

**【実験結果】**<br>
*   **高温（350℃、380℃）**で成長させた場合：
    *   どちらの種結晶を使っても、<e2>に大きな差は見られません。
*   **低温（280℃以下）**で成長させた場合：
    *   品質の低い種結晶（右図）では、成長プロセス中の<e2>低下が大きくなっています。
    *   これは、品質の悪い種結晶だと、低温での成長において膜の劣化が起こりやすいことを示唆しています。

**【ポイント】**<br>
高温では種結晶の品質の影響は目立ちにくいですが、低温で高品質な膜を得るためには、種結晶の品質が非常に重要であることが分かります。

## 図

![スライド12の図1](images\slide12_image1.x-wmf)

![スライド12の図2](images\slide12_image2.x-wmf)

---

# スライド 13　2段階成長法で作製した薄膜の構造に 及ぼす種結晶の影響

## テキスト

**2段階成長法で作製した薄膜の構造に及ぼす種結晶の影響**

**【評価方法】**<br>
*   **<e2> (エリプソメータのデータ)**：左側のグラフ。膜全体の結晶性や表面の状態を示します。<br>
*   **Diffraction intensity / counts (XRDのデータ)**：右側のグラフ。膜の内部の結晶構造を詳細に示します。ピークが高いほど結晶性が良いです。<br>
    *(poly-Si: 成長薄膜の条件は60/10/60で統一)*

**【実験結果】**<br>
*   **Seed: 60/10/60（品質の悪い種結晶）**の場合：
    *   左側の<e2>グラフ：280℃以下で成長させた膜では、<e2>の値が非常に小さく、結晶性が大きく低下していることが分かります。
    *   右側のXRDグラフ：280℃以下で成長させた膜では、結晶によるピークがほとんどなくなり、アモルファス相（非晶質）が多い状態になっていることが確認されました。

**【結論】**<br>
種結晶がアモルファス相を多く含む（品質が悪い）場合、その上に成長させた膜の構造も、種結晶の構造を強く反映してアモルファス相が多くなってしまう、ということがはっきりと分かりました。つまり、**最初の「タネ」の品質が、最終的な「作物」の品質に直結する**ということです。

## 図

![スライド13の図1](images\slide13_image1.x-wmf)

![スライド13の図2](images\slide13_image2.x-wmf)

![スライド13の図3](images\slide13_image3.x-wmf)

![スライド13の図4](images\slide13_image4.x-wmf)

---

# スライド 14　まとめ

## テキスト

**まとめ**

*   **種結晶プロセスと成長プロセスにおいて、ガス流量（特にSiF4/H2流量比）を制御することにより、温度の異なる二つのプロセス間でも、連続的かつ滑らかな界面を実現できることが分かりました。**<br>
    　→ これにより、より低い温度でも高品質な薄膜を作製できる可能性が広がりました。

*   **種結晶の構造（最初の「タネ」の品質）が、最終的な薄膜の構造に非常に大きく影響していることが明らかになりました。**<br>
    　→ 高品質な薄膜を得るためには、種結晶の品質を高く保つことが不可欠です。

**【今後の展望】**<br>
今回の知見は、熱に弱い基板への製膜や、高性能な太陽電池、ディスプレイなどの開発に貢献できるものと期待されます。

---