# 結晶学と格子変換

## 1. 導入：結晶学の基礎と本講義の目的

本講義では、材料科学における結晶構造の理解を深めるために、基本的な結晶学と結晶化学の知識を前提として、さらに専門的な内容へと進んでいきます。特に、格子点の配列によって定義される「ブラベー格子」と、その最小単位である「基本格子」の概念を深く掘り下げます。

結晶は周期的な構造を持つ固体であり、その周期性は「格子」によって記述されます。格子を理解することは、材料の物理的・化学的性質を理解する上で不可欠です。本講義の主な学習目標は以下の通りです。

1.  **ブラベー格子と基本格子の概念の再確認**：結晶構造を表現するための最も基本的なツールであるこれらの格子の違いと、それぞれの意義を理解します。
2.  **単位格子の多様性と変換**：同じ結晶構造でも、単位格子の選び方には無限の自由度があります。異なる単位格子間でどのように変換を行うか、そのベクトル演算に基づく方法を学びます。
3.  **座標系の取り扱い**：デカルト座標系（直交座標系）と一般座標系（斜交座標系）におけるベクトルの表現と変換について習得します。これにより、格子ベクトルと内部座標を用いた単位格子の表現がより明確になります。
4.  **逆格子**：実格子と密接に関連する逆格子の概念を導入し、特に共変ベクトルと反変ベクトルの区別を理解します。これはX線回折などの解析において非常に重要な概念です。

本章ではまず、ブラベー格子と基本格子の基本的な考え方、結晶構造の表現方法、そして単位格子の選び方と晶系の分類について詳しく解説していきます。

## 2. 格子、格子点、単位格子、そして結晶構造

### 2.1. 格子と格子点

結晶は、原子、分子、あるいはイオンが三次元空間に周期的に配列した固体です。この周期性を数学的に表現する概念が「格子（lattice）」です。格子は、空間内の点の集合であり、各点（格子点）から見た周囲の環境がすべて同じであるという特徴を持ちます。つまり、格子点から格子点へは、常に同じ並進ベクトルで到達できます。この三次元的な並進対称性が結晶の本質をなします。

### 2.2. 単位格子

格子が無数の格子点から構成される一方で、その周期性を表す最小の基本単位を「単位格子（unit cell）」と呼びます。単位格子は、平行六面体で表現されることが一般的で、これを空間に並進させることで結晶全体を構築できます。ただし、単位格子の選び方は一通りではなく、無限に存在します。同じ格子点配列を持つ結晶でも、様々な形状や体積の単位格子を設定することが可能です。

### 2.3. 結晶構造

「結晶構造（crystal structure）」は、格子だけでは定義できません。格子点の上に何が乗っているか、すなわち原子、分子、あるいはイオンの集合体（原子団、またはモチーフ）を配置することで初めて結晶構造が完成します。重要な点は、原子団が必ずしも格子点の上に直接乗っている必要はないということです。
例えば、塩化ナトリウム（NaCl）結晶は、面心立方格子（ブラベー格子の一種）の各格子点にNaCl分子が配置されていると考えることができます。しかし、より正確には、NaイオンとClイオンがそれぞれ面心立方格子を構成し、互いにずれて配置されている構造と捉えられます。

## 3. 結晶構造の表現方法

結晶構造を定量的に表現するためには、単位格子の形状と、その内部に存在する原子の位置を記述する必要があります。

### 3.1. 単位格子の定義

単位格子は、以下の6つの格子定数によって一意に定義されます。

*   **軸長**：$a, b, c$（単位はオングストローム Å またはナノメートル nm）
*   **軸角**：$\alpha, \beta, \gamma$（単位は度）
    *   $\alpha$: $b$軸と$c$軸がなす角
    *   $\beta$: $c$軸と$a$軸がなす角
    *   $\gamma$: $a$軸と$b$軸がなす角

これらのパラメータは、単位格子を構成する平行六面体の辺の長さと、それらの辺がなす角度を規定します。

### 3.2. 格子ベクトル

$a, b, c$軸に対応する基本ベクトルを「格子ベクトル（lattice vector）」と呼び、$\mathbf{a}, \mathbf{b}, \mathbf{c}$ または $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$ と表します。これらは通常、単位格子の各辺に沿って設定されます。

### 3.3. 部分座標（内部座標）

単位格子内の原子の位置は、「部分座標（fractional coordinates）」または「内部座標（internal coordinates）」と呼ばれる方法で表されます。これは、単位格子の辺長を基準として0から1の間の数値で表現される座標系です。
例えば、格子ベクトル $\mathbf{a}, \mathbf{b}, \mathbf{c}$ で定義される単位格子において、原子の位置ベクトル $\mathbf{R}$ は、部分座標 $(x, y, z)$ を用いて次のように表されます。

$$
\mathbf{R} = x \mathbf{a} + y \mathbf{b} + z \mathbf{c}
$$

これは和の記号（$\Sigma$）を使って次のように書くこともできます。

$$
\mathbf{R} = \sum_{i=1}^3 x_i \mathbf{a}_i
$$

ここで、$x, y, z$（または $x_i$）は0以上1未満の実数で表現されることが一般的ですが、周期性を考慮すれば0未満や1以上の値を取ることも数学的には可能です。

### 3.4. 単位格子の体積

単位格子の体積 $V$ は、3つの格子ベクトル $\mathbf{a}, \mathbf{b}, \mathbf{c}$ のスカラー三重積（scalar triple product）として計算できます。

$$
V = \mathbf{a} \cdot (\mathbf{b} \times \mathbf{c})
$$

この式は、幾何学的には3つのベクトルが張る平行六面体の体積を表しています。

## 4. 単位格子の選び方：ブラベー格子と基本格子

前述の通り、格子点の配列が一意に与えられたとしても、単位格子の選び方は無限に存在します。しかし、結晶の対称性を最もよく反映し、かつ取り扱いやすい「標準的な」単位格子の概念があります。

### 4.1. 単位格子の多様性の例

たとえば、二次元の格子点配列を考えた場合、長方形の単位格子を選ぶこともできますし、菱形や一般的な平行四辺形の単位格子を選ぶこともできます。このとき、長方形の単位格子が最も対称性が高く、格子点配列の周期性を理解しやすいでしょう。

### 4.2. ブラベー格子 (Bravais Lattice)

**オーギュスト・ブラベーの功績**
ブラベー格子は、フランスの物理学者オーギュスト・ブラベー（Auguste Bravais, 1811-1863）が1848年に体系化した格子理論に基づいており、結晶学の根幹をなす概念の一つです。彼は、三次元空間において、全ての格子点から見た環境が同一であるような格子の種類が、数学的にわずか14種類に限られることを証明しました。

ブラベー格子は、結晶の「見かけの」対称性が高くなるように、場合によっては格子点や単位格子の体積が大きくなっても、対称性を優先して選んだ単位格子です。これにより、結晶の対称性を一目で理解しやすくなります。例えば、面心立方格子や体心立方格子は、それぞれの格子点配列が持つ高い対称性を反映したブラベー格子です。これらの格子では、単位格子の頂点以外にも、面心や体心に格子点が含まれることがあります。

### 4.3. 基本格子 (Primitive Lattice / Primitive Cell)

これに対し、「基本格子（primitive cell）」は、単位格子内にただ1つの格子点のみを含む最小の単位格子です。基本格子は、ブラベー格子よりも体積が小さく、格子定数も少ない場合があります。

**ブラベー格子と基本格子の使い分け**
*   **ブラベー格子**：結晶構造を視覚的に表現したり、結晶の対称性を議論したりする際に便利です。例えば、結晶構造図を描く際にはブラベー格子がよく用いられます。
*   **基本格子**：第一原理計算（DFT計算など）のような計算材料科学の分野で多用されます。計算時間は、単位格子中の原子数の二乗から三乗に比例して増加するため、可能な限り小さい単位格子（すなわち基本格子）を用いることで、計算コストを大幅に削減できます。計算材料科学の分野では、必ずしもブラベー格子が計算に適しているとは限らないため、広く「コンベンショナルセル（conventional cell）」という用語が、ブラベー格子のような扱いやすいが必ずしも最小ではない単位格子を指すのに使われることもあります。

### 4.4. 具体例：BaTiO3の逐次相転移と格子の関係

強誘電体であるチタン酸バリウム（BaTiO$_3$）は、温度によって結晶構造が変化する「逐次相転移」を示すことで知られています。

*   **120°C以上**：立方晶（常誘電相）
*   **120°C〜5°C**：正方晶（強誘電相）
*   **5°C〜-90°C**：直方晶（強誘電相）
*   **-90°C以下**：菱面体晶（強誘電相）

このうち、直方晶相のBaTiO$_3$の単位格子は、一見すると単斜晶のように見える小さな単位格子（基本格子）で表現できます。しかし、実際にはこの基本格子の約2倍の体積を持つ「面心直方格子」のブラベー格子を取ることができます。この面心直方格子は、直方晶というより高い対称性を明確に示します。

具体的には、直方晶のブラベー格子（Conventional cell）は、基本格子（Primitive cell）の格子ベクトルを$\mathbf{a}_m, \mathbf{b}_m, \mathbf{c}_m$ とすると、

$$
\mathbf{a}_o = \mathbf{a}_m
$$

$$
\mathbf{b}_o = \mathbf{b}_m - \mathbf{c}_m
$$

$$
\mathbf{c}_o = \mathbf{b}_m + \mathbf{c}_m
$$

のように変換して得られます。ここで下添え字の $o$ は直方晶 (orthorhombic)、$m$ は単斜晶 (monoclinic) を示します。この変換によって、ブラベー格子は直方晶としての対称性を明確に示し、かつ体積が基本格子の約2倍になります。このように、より大きな体積を持つ単位格子を設定することで、結晶が持つ真の対称性を浮き彫りにすることがしば学ぶ上で重要です。

## 5. 晶系の定義と分類

結晶の対称性は、その結晶が持つ対称要素（回転軸、鏡映面、反転中心など）によって分類されます。この対称要素に基づいて、結晶は7つの「晶系（crystal system）」に分類されます。単位格子の幾何学的数値（軸長や軸角）から直接晶系を判断することは数学的に困難ですが、対称要素から導かれる制限によって、その晶系に許される単位格子の形状が一意に定まります。

### 5.1. 対称要素と晶系の関係

*   **回転軸または鏡映面が存在する場合**：必ず90°の軸角を取ることができる法則があります。これにより、三斜晶（対称要素が最も少ない）以外の晶系では、少なくとも一つの軸角が90°となります。
*   **三斜晶に許される対称要素**：回転軸や鏡映面を持たないか、あっても1回軸（対称性なし）または1回回反軸（反転中心のみ）です。
*   **主軸に直交する回転軸または鏡映面が存在する場合**：より高い対称性を持つ晶系（直方晶以上）になります。これにより、複数の軸角が90°に制限されます。
*   **主軸の回転軸が6回軸**：六方晶
*   **主軸の回転軸が4回軸**：正方晶（さらに体対角方向に3回軸があれば立方晶）
*   **主軸の回転軸が3回軸**：三方晶（菱面体晶）
*   **単斜晶**：2回軸または鏡映面のみを持つ場合に特定されます。この場合、2回軸または鏡映面に垂直な軸角が90°となります。

### 5.2. 7つの晶系の概要

| 晶系 (Crystal System) | 対称要素の主な特徴                                   | 格子定数の標準的な関係                      | ブラベー格子 (Bravais Lattices) |
| :-------------------- | :--------------------------------------------------- | :------------------------------------------ | :------------------------------ |
| 三斜晶 (Triclinic)    | 1回軸（対称性なし）または1回回反軸（反転中心）のみ | $a \ne b \ne c$, $\alpha \ne \beta \ne \gamma \ne 90^\circ$ | P (単純)                        |
| 単斜晶 (Monoclinic)   | 1つの2回軸または1つの鏡映面                        | $a \ne b \ne c$, $\alpha = \gamma = 90^\circ$, $\beta \ne 90^\circ$ | P (単純), C (底心)              |
| 直方晶 (Orthorhombic) | 互いに直交する3つの2回軸                           | $a \ne b \ne c$, $\alpha = \beta = \gamma = 90^\circ$ | P (単純), C (底心), I (体心), F (面心) |
| 正方晶 (Tetragonal)   | 1つの4回軸                                           | $a = b \ne c$, $\alpha = \beta = \gamma = 90^\circ$ | P (単純), I (体心)              |
| 三方晶 (Trigonal)     | 1つの3回軸                                           | (詳細後述)                                  | R (菱面体), P (六方)            |
| 六方晶 (Hexagonal)    | 1つの6回軸                                           | $a = b \ne c$, $\alpha = \beta = 90^\circ$, $\gamma = 120^\circ$ | P (単純)                        |
| 立方晶 (Cubic)        | 体対角方向の4つの3回軸                             | $a = b = c$, $\alpha = \beta = \gamma = 90^\circ$ | P (単純), I (体心), F (面心) |

**IUCr (International Union of Crystallography) 標準の単位格子の取り方**
国際結晶学連合によって、単位格子の標準的な取り方が定められています。これは、結晶構造データを比較・共有する上で非常に重要です。

*   **ブラベー格子**：最も対称性がわかりやすい（高い）単位格子を選ぶ。
*   **主軸の配置**：単斜晶以外では、最も高い対称要素（回転軸や鏡映面）を $c$軸（主軸）に取る。
*   **原点の選択**：最も高い対称性を持つ位置を原点（0,0,0）に取る。通常、対称中心、鏡映面、回転軸の順に優先されます。ただし、らせん軸や映進面などの場合、その交点を原点とすることもあります。
*   **軸角**：90°以外の軸角は、90°以上に取る。
*   **単斜晶の例外**：主軸の2回軸を $b$軸に取るのが標準です。このとき、$\beta$角が90°でない軸角となります（$\beta > 90^\circ$）。$a$軸と$c$軸は$b$軸に垂直な面内で、できるだけ短くなるように取ります。
*   **軸長の順序**：一般的に、$c < a < b$ となるように軸長を配置します。

多くの結晶構造解析ソフトウェア（例：VESTA）では、これらの標準化ルールに従って単位格子を自動的に設定する機能（`Utilities` => `Standardization`）が提供されています。

### 5.3. 六方晶と三方晶の特殊な関係

六方晶と三方晶は、3回軸を持つという共通点から、しばしばその単位格子の取り方が混同されがちです。

#### 5.3.1. 六方晶の単位格子

六方晶では、画面に垂直な方向に6回軸（C6）がある場合を考えます。このとき、120°の角度をなす2つの格子ベクトル $\mathbf{a}$ と $\mathbf{b}$ を面内に取り、これらに垂直な格子ベクトル $\mathbf{c}$ を主軸として定義します。この結果、$a=b$, $\alpha=\beta=90^\circ$, $\gamma=120^\circ$ という格子定数を持つ六方格子が標準的なブラベー格子となります。

#### 5.3.2. 三方晶の単位格子：六方格子軸と菱面体格子軸

三方晶も3回軸（C3）を主軸としますが、その単位格子の取り方には二通りあります。

1.  **六方格子設定 (Hexagonal Setting)**: 六方晶と同じく、$a=b$, $\alpha=\beta=90^\circ$, $\gamma=120^\circ$ の格子定数を持つ単位格子を取ることができます。この場合、六方晶と同じ形状の単位格子ですが、回転対称性が3回軸である点で異なります。
2.  **菱面体格子設定 (Rhombohedral Setting)**: $a=b=c$, $\alpha=\beta=\gamma \ne 90^\circ$ の格子定数を持つ「菱面体（rhombohedral）単位格子」を取ることもできます。これは、3つの格子ベクトルが互いに等しい長さで、かつ互いに等しい角度をなすという特徴を持つ、斜めになった立方体のような形状です。

**三方晶と菱面体晶の区別**
*   **三方晶 (Trigonal)**：空間群の記号が P3 または P$\bar{3}$ で始まる結晶系で、基本格子が六方格子軸しか取れないものです。菱面体格子設定は取れません。
*   **菱面体晶 (Rhombohedral)**：基本格子として菱面体格子軸を設定できるものを指します。空間群の記号が R で始まるものです。この場合、菱面体格子設定が「基本格子」となりますが、六方格子設定（コンベンショナルセル）を取ることも可能です。ただし、六方格子設定を取ると、単位格子は元の菱面体単位格子の3倍の体積を持つことになります（菱面体単位格子中に1つの格子点がある場合、対応する六方単位格子中には3つの格子点が含まれると見なされる）。このため、空間群の記号の末尾に、設定された格子軸を示すために R (菱面体設定) または H (六方設定) が付けられることがあります。

## 6. ブラベー格子の種類

数学的に、三次元空間におけるブラベー格子は14種類に限定されます。これは、全ての格子点から見た環境が同一であるという条件を満たす格子のパターンを分類した結果です。

### 6.1. 底心正方格子や辺心正方格子が存在しない理由

ブラベー格子が14種類に限定される理由の一つに、「底心正方格子」や「辺心正方格子」のような、一見存在しそうな格子が存在しないことが挙げられます。

*   **底心正方格子（C-centered tetragonal lattice）**：正方晶系の単位格子の底面に格子点が追加されたものを想像してみましょう。しかし、この底心正方格子は、実際にはより小さな「単純正方格子」として表現できてしまいます。これは、新しい単位格子を斜めにとることで、底心にあった格子点も頂点に含まれるようにできるためです。したがって、底心正方格子はブラベー格子の条件（最小の単位格子で最大の対称性を示す）を満たしません。
*   **辺心格子（Edge-centered lattice）**：単位格子の辺の中央に格子点が置かれている格子を考えてみましょう。しかし、このような格子点は、頂点の格子点とは異なり、周囲の環境（隣接する格子点の数や距離）が異なります。ブラベー格子の定義は「全ての格子点から見た環境が同一である」ことなので、辺心格子は格子として成立しません。

このように、ブラベー格子は、格子の定義と対称性の要件を厳密に満たすものだけが選ばれた結果、14種類に限定されるのです。

## 7. ミラー指数：格子面の定義

結晶の特定の面や方向を記述するために「ミラー指数（Miller index）」が用いられます。これはX線回折などの結晶構造解析において、特定の回折ピークがどの格子面からのものであるかを特定するために不可欠です。

### 7.1. 格子面の定義（非直交座標系を含む）

ミラー指数は、格子面が単位格子の軸と交わる点の座標の逆数の最小整数比で表されます。

*   **2次元格子の場合**：
    単位格子軸 $\mathbf{a}, \mathbf{b}$ を考えます。ある格子面が $\mathbf{a}$軸を $1/h$ で、$\mathbf{b}$軸を $1/k$ で交わるとき、その面は $(h k)$ 面と表されます。たとえば、$1/2 \mathbf{a}$ と $1/1 \mathbf{b}$ で交わる面は $(2 1)$ 面です。
*   **3次元格子の場合**：
    単位格子軸 $\mathbf{a}, \mathbf{b}, \mathbf{c}$ を考えます。格子面がこれらの軸をそれぞれ $1/h, 1/k, 1/l$ の点で交わるとき、その面は $(h k l)$ 面と表されます。軸と平行な場合は、無限大で交わるため、その指数は0となります。例えば、$\mathbf{a}$軸を $1/1$ で、$\mathbf{b}$軸を $1/1$ で交わり、$c$軸に平行な面は $(1 1 0)$ 面です。

### 7.2. 指数の表記法

国際結晶学連合 (IUCr) によって、ミラー指数の表記方法が厳密に定められています。

*   **$[uvw]$**：実空間における「方位（方向）ベクトル」を表します。格子点から格子点へのベクトルを表し、角括弧 `[]` を用います。これは実空間での特定の方向を指します。
*   **$hkl$**：回折指数、または逆格子の座標を表します。通常、回折パターンで見られる各ピークに対応する指数で、特別な括弧は用いません。これは逆空間の点、すなわち逆格子ベクトルに対応します。
*   **$(hkl)$**：ミラー指数で定義される「格子面」を表します。丸括弧 `()` を用います。この $(hkl)$ 面の「法線ベクトル」は、逆格子空間の点 $hkl$ に対応する逆格子ベクトル $\mathbf{G}_{hkl}$ です。

**直交系と非直交系の違い**
*   **直交座標系（立方晶、正方晶、直方晶）**：`$[hkl]$` 方向は、`$(hkl)$` 面の法線方向と一致します。
*   **非直交座標系（三斜晶、単斜晶、三方晶、六方晶）**：`$[hkl]$` 方向は、`$(hkl)$` 面の法線方向とは一般に一致しません。この違いを明確に理解することは、特に異方的な材料の特性評価において重要です。

*   **`<uvw>`**：結晶学的に等価な全ての `$[uvw]$` 方向の集合（「型方向」）を表します。山括弧 `< >` を用います。
*   **`{hkl}`**：結晶学的に等価な全ての `$(hkl)$` 面の集合（「型面」）を表します。波括弧 `{ }` を用います。

*   **晶帯面（Zone Plane）と晶帯軸（Zone Axis）**：
    ある軸 $[uvw]$ に平行な面（晶帯面）の集合を考えることができます。これらの面は、その晶帯軸 $[uvw]$ を含む全ての面に適用される「晶帯の法則（Zone Law）」を満たします。晶帯の法則は次のように表されます。

    $$
    hu + kv + lw = 0
    $$

    ここで $(hkl)$ は晶帯面に属する面指数、$u, v, w$ は晶帯軸の方位指数です。この法則は、面と軸が垂直である必要はなく、単に平行であることを示しています。

### 7.3. 六方晶系のミラー・ブラベー指数 (hkil)

六方晶系や三方晶系（六方格子設定の場合）では、特別なミラー指数として「ミラー・ブラベー指数（Miller-Bravais index）」が用いられることがあります。これは、4つの指数 $(h k i l)$ で表記され、結晶の六方対称性をより明確に表現するのに役立ちます。

通常の3指数 $(h k l)$ では、例えば六方晶において $(1 0 \bar{1} 0)$, $(0 1 \bar{1} 0)$, $(\bar{1} 1 0 0)$ は物理的に等価な面ですが、指数だけを見てもそれが直感的に分かりにくい場合があります。そこで、4つ目の指数 $i$ を導入します。

$$
i = -(h+k)
$$

この関係を用いると、上述の等価な面はそれぞれ $(1 0 \bar{1} 0)$, $(0 1 \bar{1} 0)$, $(\bar{1} 1 0 0)$ となり、すべての指数が明示されることで、これらの面が六方対称によって関連付けられていることが直感的に理解しやすくなります。例えば、$(1 0 0)$ 面と書く代わりに $(1 0 \bar{1} 0)$ と書くことで、その面が六方晶系の対称要素によって関係付けられる他の面（$(0 1 \bar{1} 0)$ など）と等価であることが一目瞭然となります。

この $i$ 指数は冗長な情報ですが、対称性を強調する目的で非常に有用です。場合によっては、六方晶系の設定であることを明記する目的で、4番目の指数をドットで表すなどして省略表記（例: $(0 1 \cdot 0)$）することもあります。

### 7.4. 面指数と方位指数の区別の重要性：非直交系での注意点

前述の通り、非直交座標系では、面指数 `$(hkl)$` が表す面の法線方向と、方位指数 `$[hkl]$` が表す方向は一致しません。この区別は、特に結晶成長や物性異方性を議論する上で非常に重要です。

**具体例：六方晶 (ZnO) と単斜晶 ($\beta$-Ga$_2$O$_3$)**
*   **六方晶系 (例: ZnO)**：$\gamma = 120^\circ$ であるため、直交系ではありません。
    例えば、`$[1 0 0]$` 方位は$a$軸に平行な方向を指しますが、`$(1 0 0)$` 面は$a$軸と交わり$b, c$軸に平行な面です。この`$(1 0 0)$` 面の法線は、`$[1 0 0]$` 方向とは異なる方向を向いています。このことは、X線回折における回折ベクトルの方向（逆格子ベクトル、すなわち面の法線方向）と、結晶成長の方向（実空間の方位）を議論する際に混乱を招きやすい点です。
*   **単斜晶系 (例: $\beta$-Ga$_2$O$_3$)**：$\beta \ne 90^\circ$ であるため、典型的な非直交系です。
    特に、サファイア基板上へのエピタキシャル成長でよく用いられる$\beta$-Ga$_2$O$_3$（ベータガリウムオキシド）では、`$( \bar{2} 0 1)$` 面が重要な成長面として知られています。この`$( \bar{2} 0 1)$` 面に垂直な方向（すなわち法線方向）にエピタキシャル成長が進みます。しかし、もしこの成長方向を誤って`$[\bar{2} 0 1]$` 方位と記述してしまうと、これは結晶内で全く異なる斜めの方位を指すことになり、物理的な意味が大きく変わってしまいます。

このように、面指数は「特定の面に垂直な方向」を、方位指数は「特定の軸に沿った方向」を指すという違いを常に意識することが、材料科学の研究において不可欠です。

---

## 8. 単位格子の変換：格子ベクトルと座標変換

複数の単位格子設定が存在する場合、ある設定から別の設定へと変換を行う必要があります。この変換は、格子ベクトルの線形結合と、それに伴う原子の内部座標の変換によって行われます。

### 8.1. 格子ベクトルの変換

新しい単位格子を構成する格子ベクトル $\mathbf{a}', \mathbf{b}', \mathbf{c}'$ は、元の単位格子を構成する格子ベクトル $\mathbf{a}, \mathbf{b}, \mathbf{c}$ の線形結合として表すことができます。

$$
\begin{pmatrix} \mathbf{a}' \\ \mathbf{b}' \\ \mathbf{c}' \end{pmatrix} = \mathbf{M} \begin{pmatrix} \mathbf{a} \\ \mathbf{b} \\ \mathbf{c} \end{pmatrix}
$$

ここで、$\mathbf{M}$ は変換行列であり、通常は整数要素を持つ3x3行列です。

$$
\mathbf{M} = \begin{pmatrix} P_{11} & P_{12} & P_{13} \\ P_{21} & P_{22} & P_{23} \\ P_{31} & P_{32} & P_{33} \end{pmatrix}
$$

より具体的に各ベクトルを成分で書くと、

$$
\mathbf{a}' = P_{11}\mathbf{a} + P_{12}\mathbf{b} + P_{13}\mathbf{c} \\
\mathbf{b}' = P_{21}\mathbf{a} + P_{22}\mathbf{b} + P_{23}\mathbf{c} \\
\mathbf{c}' = P_{31}\mathbf{a} + P_{32}\mathbf{b} + P_{33}\mathbf{c}
$$

この変換行列 $\mathbf{M}$ は、元の単位格子をどのように新しい単位格子で「切り取る」かを決定します。例えば、体心立方格子（BCC）のブラベー格子から基本格子である菱面体格子への変換では、以下のような変換行列が使われます。

$$
\mathbf{M}_{BCC \to Primitive} = \begin{pmatrix} -1/2 & 1/2 & 1/2 \\ 1/2 & -1/2 & 1/2 \\ 1/2 & 1/2 & -1/2 \end{pmatrix}
$$

これは整数係数ではないですが、このように、より一般的には有理数係数を持つ変換行列を用いることもあります。

### 8.2. 原子座標（部分座標）の変換

単位格子が変換されると、その内部にある原子の部分座標もそれに合わせて変換する必要があります。
元の単位格子における原子の位置ベクトル $\mathbf{R}$ は、部分座標 $(x, y, z)$ と格子ベクトル $(\mathbf{a}, \mathbf{b}, \mathbf{c})$ を用いて次のように表されます。

$$
\mathbf{R} = x \mathbf{a} + y \mathbf{b} + z \mathbf{c} = \begin{pmatrix} x & y & z \end{pmatrix} \begin{pmatrix} \mathbf{a} \\ \mathbf{b} \\ \mathbf{c} \end{pmatrix}
$$

新しい単位格子における同じ原子の位置ベクトル $\mathbf{R}$ は、新しい部分座標 $(x', y', z')$ と新しい格子ベクトル $(\mathbf{a}', \mathbf{b}', \mathbf{c}')$ を用いて次のように表されます。

$$
\mathbf{R} = x' \mathbf{a}' + y' \mathbf{b}' + z' \mathbf{c}' = \begin{pmatrix} x' & y' & z' \end{pmatrix} \begin{pmatrix} \mathbf{a}' \\ \mathbf{b}' \\ \mathbf{c}' \end{pmatrix}
$$

これらの関係から、新しい部分座標 $(x', y', z')$ は、元の部分座標 $(x, y, z)$ と変換行列 $\mathbf{M}$ の逆行列 $\mathbf{M}^{-1}$ を使って計算できます。

$$
\begin{pmatrix} x' & y' & z' \end{pmatrix} = \begin{pmatrix} x & y & z \end{pmatrix} \mathbf{M}^{-1}
$$

または、列ベクトルで書くと、

$$
\begin{pmatrix} x' \\ y' \\ z' \end{pmatrix} = (\mathbf{M}^{-1})^T \begin{pmatrix} x \\ y \\ z \end{pmatrix}
$$

ここで $(\mathbf{M}^{-1})^T$ は $\mathbf{M}^{-1}$ の転置行列です。このようなベクトルの演算を理解することで、異なる単位格子設定間の変換を正確に行うことが可能になります。これは、異なる研究者が公開した結晶構造データを比較したり、計算科学のシミュレーション設定を行ったりする際に非常に重要なスキルとなります。

## 9. デカルト座標系と一般座標系

### 9.1. デカルト座標系（直交座標系）

デカルト座標系は、互いに直交する3つの軸（X, Y, Z）を持つ最も一般的な座標系です。軸のスケールは通常等しく、メートルやオングストロームなどの物理的な単位で表されます。結晶学においては、立方晶、正方晶、直方晶のように軸角がすべて90°である晶系では、このデカルト座標系と格子軸を一致させることができます。計算や幾何学的な直感に優れているため、特に等方的な性質を扱う際には便利です。

### 9.2. 一般座標系（斜交座標系）

一般座標系、または斜交座標系は、互いに直交しない軸を持つ座標系です。結晶学においては、非直交晶系（三斜晶、単斜晶、三方晶、六方晶）の単位格子ベクトルがこの座標系の基底ベクトルとなります。前述の部分座標 $(x, y, z)$ は、この一般座標系における座標値とみなすことができます。
この座標系では、基底ベクトル（格子ベクトル）の長さやなす角が異なるため、距離や角度の計算には注意が必要です。

### 9.3. デカルト座標系と一般座標系の相互変換

一般座標系で表現された格子ベクトル $\mathbf{a}, \mathbf{b}, \mathbf{c}$ を、デカルト座標系（$x, y, z$）の基底ベクトル $\mathbf{e}_x, \mathbf{e}_y, \mathbf{e}_z$ を用いて表現することができます。

$$
\mathbf{a} = a_x \mathbf{e}_x + a_y \mathbf{e}_y + a_z \mathbf{e}_z \\
\mathbf{b} = b_x \mathbf{e}_x + b_y \mathbf{e}_y + b_z \mathbf{e}_z \\
\mathbf{c} = c_x \mathbf{e}_x + c_y \mathbf{e}_y + c_z \mathbf{e}_z
$$

または、行列形式で書くと、

$$
\begin{pmatrix} \mathbf{a} \\ \mathbf{b} \\ \mathbf{c} \end{pmatrix} = \mathbf{A} \begin{pmatrix} \mathbf{e}_x \\ \mathbf{e}_y \\ \mathbf{e}_z \end{pmatrix}
$$

ここで $\mathbf{A}$ は、各行が格子ベクトルのデカルト座標成分である行列です。
原子の位置ベクトル $\mathbf{R}$ が一般座標系で $(x, y, z)$ と表される場合、そのデカルト座標系での成分 $(X, Y, Z)$ は次のように計算されます。

$$
\begin{pmatrix} X \\ Y \\ Z \end{pmatrix} = \mathbf{A}^T \begin{pmatrix} x \\ y \\ z \end{pmatrix} = \begin{pmatrix} a_x & b_x & c_x \\ a_y & b_y & c_y \\ a_z & b_z & c_z \end{pmatrix} \begin{pmatrix} x \\ y \\ z \end{pmatrix}
$$

この変換は、結晶構造の幾何学的解析、分子動力学シミュレーション、あるいは外部から力を加える際の方向の定義など、様々な場面で利用されます。

## 10. 実格子と逆格子：共変ベクトルと反変ベクトル

実格子（real lattice）は、原子が実際に存在する空間的な配列を記述します。これに対し、逆格子（reciprocal lattice）は、X線回折や電子回折といった波の回折現象を記述するために導入される概念です。逆格子ベクトルは、実格子の特定の面に対して垂直な方向を持ち、その長さは面間隔の逆数に比例します。

### 10.1. 逆格子ベクトルの定義と導出

実格子の基本ベクトルを $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$ とすると、逆格子の基本ベクトル $\mathbf{a}_1^*, \mathbf{a}_2^*, \mathbf{a}_3^*$ は以下のように定義されます。

$$
\mathbf{a}_1^* = \frac{\mathbf{a}_2 \times \mathbf{a}_3}{V}
$$

$$
\mathbf{a}_2^* = \frac{\mathbf{a}_3 \times \mathbf{a}_1}{V}
$$

$$
\mathbf{a}_3^* = \frac{\mathbf{a}_1 \times \mathbf{a}_2}{V}
$$

ここで $V = \mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)$ は実格子の単位格子の体積です。
これらの逆格子ベクトルは、以下の直交関係を満たします。

$$
\mathbf{a}_i^* \cdot \mathbf{a}_j = \delta_{ij}
$$

ここで $\delta_{ij}$ はクロネッカーのデルタであり、$i=j$ のときに1、$i \ne j$ のときに0となります。
任意の逆格子ベクトル $\mathbf{G}_{hkl}$ は、逆格子の基本ベクトルの整数倍の線形結合で表されます。

$$
\mathbf{G}_{hkl} = h \mathbf{a}_1^* + k \mathbf{a}_2^* + l \mathbf{a}_3^*
$$

ここで $h, k, l$ はミラー指数です。この逆格子ベクトル $\mathbf{G}_{hkl}$ は、実格子の $(hkl)$ 面に垂直な方向を指し、その大きさは面間隔 $d_{hkl}$ の逆数に $2\pi$ を掛けた値に等しくなります（物理学分野の定義では $2\pi/d_{hkl}$、結晶学分野の定義では $1/d_{hkl}$）。

### 10.2. 共変ベクトルと反変ベクトル

非直交座標系を扱う場合、特に逆格子との関連で「共変ベクトル（covariant vector）」と「反変ベクトル（contravariant vector）」という概念を区別することが重要です。

*   **反変ベクトル（Contravariant Vector）**：
    実格子の格子ベクトル $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$ を基底とするベクトルの成分 $(x, y, z)$ が反変成分です。原子の位置ベクトル $\mathbf{R} = x \mathbf{a}_1 + y \mathbf{a}_2 + z \mathbf{a}_3$ は反変ベクトルの例です。座標変換に対して、基底ベクトルが変換される方法とは逆の方法で成分が変換されることから「反変」と呼ばれます。すなわち、基底が大きくなれば成分は小さくなります。物理的には、実空間における「方向」や「位置」を表現する際に用いられます。

*   **共変ベクトル（Covariant Vector）**：
    逆格子の格子ベクトル $\mathbf{a}_1^*, \mathbf{a}_2^*, \mathbf{a}_3^*$ を基底とするベクトルの成分 $(h, k, l)$ が共変成分です。逆格子ベクトル $\mathbf{G}_{hkl} = h \mathbf{a}_1^* + k \mathbf{a}_2^* + l \mathbf{a}_3^*$ は共変ベクトルの例です。座標変換に対して、基底ベクトルが変換される方法と同じ方法で成分が変換されることから「共変」と呼ばれます。すなわち、基底が大きくなれば成分も大きくなります。物理的には、実空間における「面」の法線方向や「勾配」を表現する際に用いられます。ミラー指数 $(hkl)$ は、実空間の面に直交する逆格子ベクトル $\mathbf{G}_{hkl}$ の成分であるため、共変的な性質を持ちます。

直交座標系では、共変ベクトルと反変ベクトルの区別は本質的ではありませんが、非直交座標系（斜交座標系）では、その違いが明確に現れます。これは、デカルト座標系における単位ベクトルとは異なり、斜交座標系の基底ベクトルが互いに直交せず、長さも異なるためです。このため、非直交系では、実空間の方向を示す「方位指数 $[uvw]$」（反変的）と、格子面を示す「ミラー指数 $(hkl)$」（共変的）を厳密に区別することが非常に重要となります。この理解は、結晶の異方的な性質を正しく解釈し、X線回折データなどを正確に分析するために不可欠です。

---