# スライド 1　東京科学大学

## 東京科学大学総合研究院元素戦略MDX研究センターフロンティア材料研究所神谷利夫

### チュートリアル: 基本格子とブラベー格子

---

# スライド 2　前提と目標

## 前提

*   基本的な結晶学、結晶化学の知識があること

## 学習目標

*   **ブラベー格子と基本格子の復習**: 結晶構造を記述する二つの概念を理解する。
*   **単位格子は任意にとれる**: 異なる単位格子間の変換方法を学ぶ。
*   **デカルト座標系と一般座標系の取り扱い**: 基本ベクトルと座標の変換規則を習得する。
*   **単位格子の表現**: 格子ベクトルと内部座標（一般座標系）による表現。
*   **単位格子の変換**: 格子ベクトルの変換とそれに伴う内部座標の変換。
*   **逆格子**: 共変ベクトルと反変ベクトルの区別とその意義を理解する。

---

# スライド 3　単位格子: 基本格子とブラベー格子

---

# スライド 4　格子と格子点

## 格子

*   周期的に繰り返す構造
*   格子点だけで構成される
*   格子点の周囲の環境はすべて同じ

## 単位格子

*   格子の繰り返し単位
*   選び方は無限にある

![スライド4の図1](images\slide4_image1.png)
![スライド4の図2](images\slide4_image2.png)

---

# スライド 5　格子 + 原子修飾 = 結晶

## 結晶

*   格子に原子団を配置したもの
*   「格子点」に原子がある必要はない

---

# スライド 6　面心立方格子 + NaCl分子 = NaCl結晶

## 例: NaCl結晶

*   面心立方格子をベースに、Na$^+$とCl$^-$イオンが配置された構造

---

# スライド 7　結晶構造の表現

## 単位格子の定義

*   格子定数の組 ($a, b, c, \alpha, \beta, \gamma$) で定義される平行六面体。

## 原子座標

*   単位格子内の原子の座標は「部分座標（内部座標）」で表される。
    *   原点を (0, 0, 0)、$a, b, c$ 軸の端を 1.0 とする。
    *   一般に、0 から 1 の間の数値で座標を表現する。

## 格子ベクトル

*   $a, b, c$ 軸に対応するベクトル $\mathbf{a}, \mathbf{b}, \mathbf{c}$ を「格子ベクトル」と呼ぶ。
*   部分座標 $(x, y, z)$ にある原子の位置ベクトル $\mathbf{R}$:
    $$
    \mathbf{R} = x \mathbf{a} + y \mathbf{b} + z \mathbf{c} = \sum_i (x_i \mathbf{a}_i)
    $$
*   単位格子体積 $V$ はスカラー三重積で計算できる:
    $$
    V = \mathbf{a} \cdot (\mathbf{b} \times \mathbf{c})
    $$

![スライド7の図1](images\slide7_image1.png)

---

# スライド 8　単位格子の選び方は無限にある

## 同じ格子点配列でも、異なる単位格子を設定可能

*   対象性の高い長方形 (ab)
*   より小さな菱形 (a'b')
*   対称性の低い平行四辺形 (a''b'')

---

# スライド 9　格子の対称性と単位格子

## 見かけの形から対称性を判断するのは難しい

*   格子点の対称要素から判断・定義する。

## 例: 面心直方格子の基本格子

*   見た目は単斜晶のような格子定数 ($a=b, \gamma \ne 90^\circ$)
*   実際は、より大きな面心直方格子のブラベー格子をとれる

![スライド9の図1](images\slide9_image1.png)

---

# スライド 10　BaTiO$_3$の逐次相転移

## 強誘電体BaTiO$_3$の結晶構造変化

*   **立方晶** (常誘電相, 高温)
*   **正方晶** (強誘電相, 中温)
*   **直方晶** (強誘電相, 低温)
*   **菱面体晶** (強誘電相, 極低温)

![スライド10の図1](images\slide10_image1.x-emf)
![スライド10の図2](images\slide10_image2.x-emf)

---

# スライド 11　なぜ直方晶BaTiO$_3$は単位格子体積が2倍になるのか

## 直方晶BaTiO$_3$の単位格子

*   **ブラベー格子 (Conventional Cell, 直方格子)**: Amm2
    *   高い対称性を反映し、格子体積が基本格子の2倍になる。
*   **基本格子 (Primitive Cell, 単斜？格子)**:
    *   より小さな単位だが、対称性が分かりにくい。
*   変換関係の例:
    $$
    \mathbf{a}_o = \mathbf{a}_m \\
    \mathbf{b}_o = \mathbf{b}_m - \mathbf{c}_m \\
    \mathbf{c}_o = \mathbf{b}_m + \mathbf{c}_m
    $$
    *   ここで、$\mathbf{a}_o, \mathbf{b}_o, \mathbf{c}_o$ は直方晶の格子ベクトル、$\mathbf{a}_m, \mathbf{b}_m, \mathbf{c}_m$ は単斜晶の格子ベクトル。

![スライド11の図1](images\slide11_image1.png)
![スライド11の図2](images\slide11_image2.png)
![スライド11の図3](images\slide11_image3.png)
![スライド11の図4](images\slide11_image4.png)

---

# スライド 12　対称要素から高い対称性の単位格子をつくる

## 対称要素と晶系の関係

*   **回転軸または鏡映面がある**: 1つの軸角を90°にとることができる
    *   $\Rightarrow$ 三斜晶以外
    *   三斜晶に許される対称要素は中心対称（1回回反軸）だけ。
*   **主軸に直交する回転軸または鏡映面**: 直方晶以上（複数の軸角が90°）
*   **主軸の回転軸**:
    *   C6 $\Rightarrow$ 六方晶
    *   C4 $\Rightarrow$ 正方晶（体対角にC3軸があれば立方晶）
    *   C3 $\Rightarrow$ 三方晶
*   **単斜晶**: C2軸だけ、あるいは鏡映面だけでもよい。

---

# スライド 13　六方晶と三方晶の基本格子

## 三方晶も六方格子の単位格子をとれる

*   **六方晶**: 主軸C6軸
    *   $\mathbf{a}, \mathbf{b}$ が面内（$\gamma=120^\circ$）
*   **三方晶**: 主軸C3軸
    *   $\mathbf{a}, \mathbf{b}$ が面内にある場合: 六方格子設定
    *   $\mathbf{a}, \mathbf{b}$ が面直成分をもつ場合: 菱面体格子設定

---

# スライド 14　三方晶: 六方格子軸、菱面体格子軸の単位格子を取ることが可能

## 三方晶 vs 菱面体晶

*   **三方晶 (Trigonal)** (空間群 P3, P$\bar{3}$ など)
    *   基本格子が六方格子軸設定（菱面体格子設定は取れない）
*   **菱面体晶 (Rhombohedral)** (空間群 R で始まるもの)
    *   基本格子が菱面体格子軸設定
    *   六方格子設定を取ると単位格子が3倍になる（Conventional Cell）

![スライド14の図1](images\slide14_image1.png)

---

# スライド 15　7つの晶系の定義: 対称要素

| 晶系 (Crystal System) | 対称要素の主な特徴                                   | 格子定数の標準的な関係                      | ブラベー格子 (Bravais Lattices) |
| :-------------------- | :--------------------------------------------------- | :------------------------------------------ | :------------------------------ |
| 三斜晶 (Triclinic)    | 1回軸または1回回反軸（反転中心）のみ               | $a \ne b \ne c$, $\alpha \ne \beta \ne \gamma \ne 90^\circ$ | P (単純)                        |
| 単斜晶 (Monoclinic)   | 1つの2回軸または1つの鏡映面                        | $a \ne b \ne c$, $\alpha = \gamma = 90^\circ$, $\beta \ne 90^\circ$ | P (単純), C (底心)              |
| 直方晶 (Orthorhombic) | 互いに直交する3つの2回軸                           | $a \ne b \ne c$, $\alpha = \beta = \gamma = 90^\circ$ | P (単純), C (底心), I (体心), F (面心) |
| 正方晶 (Tetragonal)   | 1つの4回軸                                           | $a = b \ne c$, $\alpha = \beta = \gamma = 90^\circ$ | P (単純), I (体心)              |
| 六方晶 (Hexagonal)    | 1つの6回軸                                           | $a = b \ne c$, $\alpha = \beta = 90^\circ$, $\gamma = 120^\circ$ | P (単純)                        |
| 三方晶 (Trigonal)     | 1つの3回軸                                           | (六方格子設定) $a = b \ne c$, $\alpha = \beta = 90^\circ$, $\gamma = 120^\circ$ | P (単純)                        |
| 菱面体晶 (Rhombohedral) | 1つの3回軸                                           | (菱面体格子設定) $a = b = c$, $\alpha = \beta = \gamma \ne 90^\circ$ | R (菱面体)                      |
| 立方晶 (Cubic)        | 体対角方向の4つの3回軸                             | $a=b=c$, $\alpha=\beta=\gamma=90^\circ$ | P (単純), I (体心), F (面心) |

---

# スライド 16　基本格子 vs. ブラベー格子

## 基本格子 (Primitive cell)

*   格子点を1つだけ含む、最小の単位格子。
*   量子計算など、計算時間を削減したい場合に用いられる。

## ブラベー格子 (Bravais cell / Conventional cell)

*   格子点の数を増やし、見かけの対称性が高く見えるようにとった単位格子。
*   結晶の対称性を視覚的に理解しやすい。
*   例: 面心直方格子
*   計算時間がかかる場合がある。

---

# スライド 17　ブラベー格子と基本格子: 面心立方格子

## Siの構造 (室温)

*   空間群 Fd$\bar{3}$m, No. 227 (立方晶系, ダイヤモンド構造)

### ブラベー格子 (Conventional Cell)

*   面心立方格子
*   $a_C$ = 0.5431 nm
*   格子点数: 4個

### 基本格子 (Primitive Cell)

*   菱面体格子
*   $a_R$ = 0.3840 nm, $\alpha=60^\circ$
*   格子点数: 1個

![スライド17の図1](images\slide17_image1.png)
![スライド17の図2](images\slide17_image2.png)
![スライド17_図3](images\slide17_image3.png)
![スライド17_図4](images\slide17_image4.png)
![スライド17_図5](images\slide17_image5.png)
![スライド17_図6](images\slide17_image6.png)
![スライド17_図7](images\slide17_image7.png)
![スライド17_図8](images\slide17_image8.png)

---

# スライド 18　ブラベー格子と基本格子: 体心立方格子

## 体心立方格子

*   ブラベー格子中の格子点数: 2個
*   基本格子: 軸角が109.5°の菱面体格子

![スライド18の図1](images\slide18_image1.png)

---

# スライド 19　ブラベー格子と基本格子、格子変換

| ブラベー格子          | ブラベー格子内の格子点数 | 基本格子他にとれる単位格子                               |
| :-------------------- | :----------------------- | :------------------------------------------------------- |
| 体心立方格子          | 2                        | 軸角が109.5°の菱面体                                    |
| 面心立方格子          | 4                        | 軸角が60°の菱面体                                       |
| 六方晶                | 1                        | (ブラベー格子と一致)                                     |
| 直方格子 (底心/体心/面心) | 2, 2, 4                  | 菱面体やより小さな直方格子など                           |
| 菱面体晶              | 1                        | 菱面体格子。六方格子設定も可能だが体積は3倍              |
| 三方晶                | 1                        | 六方格子設定 (菱面体格子設定は不可)                      |

---

# スライド 20　底心正方格子、辺心正方格子はあるか？

## ブラベー格子として存在しないもの

*   **底心正方格子 (C-centered tetragonal lattice)**
    *   より小さい「単純正方格子」で表現できるため、ブラベー格子ではない。
*   **辺心格子 (Edge-centered lattice)**
    *   頂点と辺心の格子点の環境が異なるため、格子として成立しない。

---

# スライド 21　ブラベー格子は14種に限られる

## 三次元空間に存在するブラベー格子の種類

*   立方晶系: 単純、体心、面心
*   正方晶系: 単純、体心
*   直方晶系: 単純、体心、底心、面心
*   六方晶系: 単純
*   三方晶系: 菱面体（R設定）
*   単斜晶系: 単純、底心
*   三斜晶系: 単純

![スライド21の図1](images\slide21_image1.png)
![スライド21の図2](images\slide21_image2.png)
![スライド21の図3](images\slide21_image3.png)
![スライド21の図4](images\slide21_image4.png)
![スライド21の図5](images\slide21_image5.png)
![スライド21の図6](images\slide21_image6.png)
![スライド21の図7](images\slide21_image7.png)
![スライド21の図8](images\slide21_image8.png)
![スライド21の図9](images\slide21_image9.png)
![スライド21の図10](images\slide21_image10.png)
![スライド21の図11](images\slide21_image11.png)
![スライド21の図12](images\slide21_image12.png)
![スライド21の図13](images\slide21_image13.png)
![スライド21_図14](images\slide21_image14.png)

---

# スライド 22　単位格子の取り方 (国際結晶学連合 (IUCr) 標準)

## 一般的な選び方 (VESTA: Utilities => Standardization)

*   **ブラベー格子**をとること（対称性がわかりやすい単位格子で最小のもの）。
*   (単斜晶以外の場合) 最も高い対称要素を $c$ 軸（主軸）にとる。
*   最も高い対称性の位置を原点 (0 0 0) にとる。
    *   i) 対称中心、ii) 鏡映面、iii) 回転軸の順に優先。
    *   ただし、らせん軸や映進面などの交点を原点に取る場合もある。
*   軸角は90°以上に取る。

## 単斜晶の場合の例外

*   主軸のC2軸を $b$ 軸にとる ($\beta > 90^\circ$となる)。
*   $a, c$ 軸は、$b$ 軸に垂直な面内でなるべく短くなるようにとる。

---

# スライド 23　ミラー指数: 格子面の定義

---

# スライド 24　非直交座標系でいかに面を定義するか: 2次元格子

## ミラー指数 $(h k)$

*   格子面が軸と交わる点の逆数の最小整数比で表される。
*   例:
    *   $\mathbf{a}$軸を $1/2$ で、$\mathbf{b}$軸を $1/1$ で交わる面 $\Rightarrow (2 1)$ 面
    *   $\mathbf{a}$軸を $1/2$ で、$\mathbf{b}$軸を $1/3$ で交わる面 $\Rightarrow (2 3)$ 面

---

# スライド 25　非直交座標系でいかに面を定義するか: 3次元格子

## ミラー指数 $(h k l)$

*   例:
    *   $(0 1 0)$ 面: $\mathbf{b}$軸と $1/1$ で交わり、$a, c$軸に平行。
    *   $(1 1 0)$ 面: $\mathbf{a}$軸と $1/1$ で、$\mathbf{b}$軸と $1/1$ で交わり、$c$軸に平行。
    *   $(1 1 1)$ 面: $\mathbf{a}, \mathbf{b}, \mathbf{c}$軸とそれぞれ $1/1$ で交わる。

![スライド25の図1](images\slide25_image1.png)
![スライド25の図2](images\slide25_image2.png)
![スライド25の図3](images\slide25_image3.png)
![スライド25の図4](images\slide25_image4.png)
![スライド25の図5](images\slide25_image5.png)
![スライド25の図6](images\slide25_image6.png)

---

# スライド 26　指数の表記

## IUCr標準表記

*   `[uvw]` : 実空間における「方位（方向）ベクトル」。角括弧。
*   `hkl` : 回折指数（逆空間の座標、逆格子点）。括弧なし。
*   `(hkl)` : ミラー指数で定義される「格子面」。丸括弧。
    *   直交系では `[hkl]` は `(hkl)` の法線と同じ方向。
    *   非直交系では一般に一致しない。
*   `<uvw>` : 等価な`[uvw]`の全ての「実空間の方向」（型方向）。山括弧。
*   `{hkl}` : 等価な`(hkl)`の全ての「面」（型面）。波括弧。

## 晶帯面

*   ある軸 `[uvw]`（晶帯軸）に平行な面の集まり。
*   `$hu + kv + lw = 0$` を満たす面 `(hkl)` の集合。

![スライド26の図1](images\slide26_image1.png)

---

# スライド 27　六方晶、三方晶のミラー・ブラベー指数

## 4つ目の指数 $i$ の使用 (hkil)

*   六方晶系では、`$(1 0 0)$`, `$(0 1 0)$`, `$(1 \bar{1} 0)$` などが等価な面だが、3指数だけでは対称性が分かりにくい。
*   $i = -(h+k)$ を導入することで、六回対称性を明確に表現できる。
    *   例:
        $$
        (1 \ 0 \ \bar{1} \ 0) \quad \text{は} \quad (1 \ 0 \ 0) \quad \text{と表記}
        $$
        $$
        (0 \ 1 \ \bar{1} \ 0) \quad \text{は} \quad (0 \ 1 \ 0) \quad \text{と表記}
        $$
        $$
        (\bar{1} \ 1 \ 0 \ 0) \quad \text{は} \quad (\bar{1} \ 1 \ 0) \quad \text{と表記}
        $$
    *   これらの `$hki$` 指数はすべて組になっているため、等価な面だとわかる。
*   六方晶、三方晶であることを明記する意味で、`$(0 1 \cdot 0)$` のように省略表記することもある。

![スライド27の図1](images\slide27_image1.png)
![スライド27の図2](images\slide27_image2.x-wmf)
![スライド27の図3](images\slide27_image3.x-wmf)
![スライド27の図4](images\slide27_image4.x-wmf)
![スライド27の図5](images\slide27_image5.png)

---

# スライド 28　面指数と方位指数を区別する必要がある例

## 非直交軸角が絡む指数の場合は常に注意すること

*   **六方晶 (ZnO) など**
    *   `$[1 0 0]$` 方位と `$(1 0 0)$` 面の法線方向は異なる。
    *   エピタキシャル成長方向 (`$[\text{方位}]$`) と回折データ (`$(\text{面指数})$`) の解釈に重要。
*   **単斜晶 ($\beta$-Ga$_2$O$_3$) など**
    *   例えば、`$(\bar{2} 0 1)$` 面に垂直な方向に成長するが、この方向は `$[\bar{2} 0 1]$` 方位とは異なる。
    *   `$(\text{面指数})$` は面に垂直な方向を、`$[\text{方位指数}]$` は軸に平行な方向を示す。

![スライド28の図1](images\slide28_image1.x-wmf)
![スライド28の図2](images\slide28_image2.x-wmf)
![スライド28の図3](images\slide28_image3.x-wmf)
![スライド28_図4](images\slide28_image4.x-wmf)
![スライド28_図5](images\slide28_image5.x-wmf)
![スライド28_図6](images\slide28_image6.x-wmf)
![スライド28_図7](images\slide28_image7.x-wmf)

---