# Lecture 1: Reciprocal Lattice, Covariant and Contravariant Tensors

---

# 1. Review of the Reciprocal Lattice

## What is the Reciprocal Lattice?
*   A fundamental mathematical construct in materials science.
*   **Crucial for understanding:**
    *   X-ray/Electron Diffraction
    *   Electronic Band Structure (Solid-State Physics)
*   Provides a framework for analyzing wave-particle interactions in periodic crystal structures.

---

## Definition of Reciprocal Lattice Basis Vectors
*   **Real-space primitive basis vectors:** $ \mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3 $$
*   **Reciprocal-space primitive basis vectors:** $ \mathbf{a}^*_1, \mathbf{a}^*_2, \mathbf{a}^*_3 $$
*   **Defining Orthonormalization Condition:**
    $$ \mathbf{a}^*_i \cdot \mathbf{a}_j = 2\pi \delta_{ij} $$
    *   $ \delta_{ij} $$ is the Kronecker delta (1 if $ i=j $$, 0 if $ i \neq j $$).
    *   $ 2\pi $$ factor is common in physics (sometimes omitted in crystallography).
*   **Explicit Formulas:**
    $$ \mathbf{a}^*_1 = \frac{2\pi}{V} (\mathbf{a}_2 \times \mathbf{a}_3) $$
    (and cyclic permutations for $ \mathbf{a}^*_2, \mathbf{a}^*_3 $$)
    *   $ V = \mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3) $$ is the volume of the real-space primitive unit cell.

---

## Key Properties:
*   **Orthogonality:** Each $ \mathbf{a}^*_i $$ is perpendicular to the *other two* real-space basis vectors.
    *   Example: $ \mathbf{a}^*_1 \perp \mathbf{a}_2 $$ and $ \mathbf{a}^*_1 \perp \mathbf{a}_3 $$.
*   **Magnitude:** $ |\mathbf{a}^*_i| $$ is inversely proportional to the spacing of the real-space lattice planes to which it is normal.
*   **Angle (for orthogonal systems):** Angle between $ \mathbf{a}^*_1 $$ and $ \mathbf{a}^*_2 $$ is $ 180^\circ - \theta_{12} $$.
*   **Qualitative Visualization:** Helpful for intuition, but exact calculations require the mathematical definitions.

---

## Constructing Reciprocal Lattice Points & The Uniqueness Issue
*   Reciprocal lattice points: $ \mathbf{G}_{hkl} = h \mathbf{a}^*_1 + k \mathbf{a}^*_2 + l \mathbf{a}^*_3 $$ ($ h,k,l $$ are integers).
*   **Apparent Problem:** The choice of real-space primitive cell is not unique, leading to different *sets of primitive reciprocal basis vectors*.
*   **Resolution:** The reciprocal lattice is fundamentally determined by the *set of all real-space lattice points* and their underlying periodicity.
    *   This non-uniqueness is resolved by considering extinction rules.

---

# 2. Physical Significance

## The Reciprocal Lattice as a Fourier Transform
*   Reciprocal lattice points $ \mathbf{G} $$ are the wave vectors for which a plane wave $ e^{i \mathbf{G} \cdot \mathbf{r}} $$ has the crystal's periodicity.
*   **Scattering Theory:** The scattered wave amplitude $ S(\mathbf{K}) $$ is the Fourier transform of the electron density $ \rho(\mathbf{r}) $$.
    $$ S(\mathbf{K}) = \int \rho(\mathbf{r}) e^{-i \mathbf{K} \cdot \mathbf{r}} d^3r $$
*   **Bragg's Law / Laue Condition:** Constructive interference (diffraction peaks) occurs when the scattering vector $ \mathbf{K} $$ equals a reciprocal lattice vector $ \mathbf{G} $$.
    $$ \mathbf{K} = \mathbf{G} $$
    (Equivalent to $ 2d \sin\theta = n\lambda $$)
*   **Physical Meaning:** Only reciprocal lattice points corresponding to non-zero scattering amplitudes have physical significance.

---

## Extinction Rules (Selection Rules)
*   Arise from internal symmetries (e.g., centering atoms, screw axes, glide planes).
*   Lead to **destructive interference**, "extinguishing" certain diffraction peaks/reciprocal lattice points.
*   **Crucial for Reciprocal Lattice Uniqueness:**
    *   Applying extinction rules ensures a unique *physically relevant* reciprocal Bravais lattice.
    *   **Example:** A real-space Face-Centered Cubic (FCC) lattice has extinction rules ($ h,k,l $$ must be all even or all odd) that result in a Body-Centered Cubic (BCC) reciprocal lattice.

---

## Correspondence: Real vs. Reciprocal Bravais Lattices
| Real-Space Lattice    | Reciprocal Lattice   |
| :-------------------- | :------------------- |
| Simple Cubic (SC)     | Simple Cubic (SC)    |
| Body-Centered Cubic (BCC) | Face-Centered Cubic (FCC) |
| Face-Centered Cubic (FCC) | Body-Centered Cubic (BCC) |
| Simple Hexagonal (SH) | Simple Hexagonal (SH) |
*   **Key Duality:** BCC and FCC lattices are reciprocal duals of each other.
*   **Visualization:** Tools like `crystaldrawcell.py` help understand these transformations.

---

# 3. Covariant and Contravariant Tensors

## Lattice Transformation Rules Revisited
*   How do physical quantities transform when the coordinate system (basis vectors) changes?
*   **Real-space basis vectors:** $ \mathbf{a}'_i = \sum_j T_{ij} \mathbf{a}_j $$
*   **Real-space coordinates:** $ x'^i = \sum_j (T^{-1})_{ji} x^j $$
*   **Reciprocal-space basis vectors:** $ \mathbf{a}'^*_i = \sum_j (T^{-1})_{ji} \mathbf{a}^*_j $$
*   **Reciprocal-space coordinates (Miller indices):** $ h'^i = \sum_j T_{ij} h^j $$

---

## Defining Covariant and Contravariant Vectors
*   **Covariant Vectors (co-vary):** Components transform in the *same way* as the basis vectors ($ \mathbf{T} $$).
    *   Examples: Real-space basis vectors ($ \mathbf{a}_i $$), Reciprocal-space coordinates ($ h_i $$).
    *   Often denoted with **subscripts** ($ V_i $$).
*   **Contravariant Vectors (contra-vary):** Components transform in the *inverse transpose* way relative to basis vectors ($ \mathbf{T}^{-1}$ or $ (\mathbf{T}^{-1})^T $$).
    *   Examples: Real-space coordinates ($ x^i $$), Reciprocal-space basis vectors ($ \mathbf{a}^i $$ or $ \mathbf{a}^*_i $$).
    *   Often denoted with **superscripts** ($ V^i $$).
*   **Historical context:** Formalized by Albert Einstein for general relativity, ensuring physical laws are independent of coordinate choice.

---

## The Metric Tensor
*   A fundamental tensor that encodes the geometry of space (measures lengths, angles).
*   **Real-space metric tensor ($ g_{ij} $$):**
    $$ g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j $$
    *   Transforms with two factors of $ \mathbf{T} $$ $\implies$ **Second-rank covariant tensor**.
*   **Reciprocal-space metric tensor ($ g^{ij} $$):**
    $$ g^{ij} = \mathbf{a}^*_i \cdot \mathbf{a}^*_j $$
    *   Transforms with two factors of $ \mathbf{T}^{-1} $$ $\implies$ **Second-rank contravariant tensor**.
*   **Crucial Relationship:** The real-space and reciprocal-space metric tensors are matrix inverses of each other (up to a scalar factor).
    $$ \sum_k g_{ik} g^{kj} = \delta_i^j $$

---

## Relation Between Real-Space & Reciprocal-Space Transformations
*   The fundamental definition: $ \mathbf{a}^*_i \cdot \mathbf{a}_j = 2\pi \delta_{ij} $$
*   This implies that the matrix of reciprocal basis vectors is proportional to the inverse transpose of the matrix of real-space basis vectors:
    $$ \mathbf{A}^* = 2\pi (\mathbf{A}^{-1})^T $$
*   **Metric Tensors as Converters:** They bridge covariant and contravariant components.
    *   Lowering an index: $ X_i = g_{ij} X^j $$
    *   Raising an index: $ X^i = g^{ij} X_j $$

---

## Invariance of Scalar Products
*   The dot product of a covariant vector and a contravariant vector (with contracted indices) is always an **invariant scalar quantity**.
    $$ \mathbf{R} = x^i \mathbf{a}_i $$
    $$ |\mathbf{R}|^2 = g_{ij} x^i x^j $$
    *   The length (norm) of a vector does not change just because we change our coordinate system.
*   This is a cornerstone of physics: physical quantities and laws must be independent of the chosen coordinate system.

---

## Einstein Summation Convention
*   **Rules for Index Placement:**
    1.  **Covariant indices:** Subscripts ($ A_i $$).
    2.  **Contravariant indices:** Superscripts ($ A^i $$).
*   **Implied Summation (Contraction):** If an index appears exactly once as a subscript and once as a superscript in a single term, summation over that index is implied.
    $$ A^i B_i \equiv \sum_i A^i B_i $$
*   **Benefits:**
    *   **Conciseness:** Equations are much shorter.
    *   **Clarity on Invariance:** Contractions (summing over one upper and one lower index) always yield scalar invariants.
    *   **Consistency Check:** In a valid tensor equation, free indices (not summed over) must match in position and type on both sides.

---

## Covariance of Physical Equations
*   An equation is **covariant** if its form remains unchanged under coordinate transformations.
*   In tensor notation, this means the **index structure (number and position of upper/lower indices) must be identical on both sides of the equation.**
*   **Connection to Symmetry:** Physical laws are often required to satisfy fundamental symmetries (e.g., translational, rotational, Lorentz invariance). Expressing them as covariant tensor equations ensures these symmetries are respected.
*   **Examples:**
    *   Maxwell's equations (Lorentz covariant).
    *   Einstein's field equations (generally covariant under arbitrary coordinate transformations).

---

## Identifying Unknown Tensor Components
*   The index rules allow us to deduce the covariant or contravariant nature of unknown tensors.
*   **Example: Basis vector transformation:** $ \mathbf{a}'_i = T^j_i \mathbf{a}_j $$
    *   $ \mathbf{a}_i $$ (covariant), $ \mathbf{a}_j $$ (covariant). The sum is over $ j $$.
    *   Therefore, the transformation matrix $ T^j_i $$ must be a **mixed tensor of rank 2** (one contravariant index $ j $$, one covariant index $ i $$).
*   **Examples in Materials Science:**
    *   Dielectric permittivity tensor $ \epsilon_{ij} $$: Second-rank covariant.
    *   Strain tensor $ \epsilon_{ij} $$: Second-rank covariant.
    *   Elastic constant tensor $ C_{ijkl} $$: Fourth-rank covariant.

---

## Tensor Components in Cartesian vs. Crystallographic Coordinates
*   **Crystallographic Coordinates:** Based on the crystal's primitive lattice vectors; natural for anisotropic properties of single crystals.
*   **Cartesian Coordinates:** Mutually orthogonal axes; often used in computational materials science (e.g., VASP output).
    *   Simplifies tensor algebra ($ g_{ij} = \delta_{ij} $$).
    *   Provides a universal reference frame for comparison.
*   **VASP Example:** Defines Cartesian axes based on the lattice vectors in the `POSCAR` file. Outputted tensor components are in *this* Cartesian system.
    *   Requires coordinate transformation to interpret in crystallographic directions.

---

## Summary of Covariant and Contravariant Rules
1.  **Basis Vectors vs. Coordinates:**
    *   Covariant basis vectors $ \mathbf{a}_i $$ pair with contravariant coordinates $ x^i $$.
    *   Contravariant basis vectors $ \mathbf{a}^i $$ pair with covariant coordinates $ x_i $$.
    *   $ \mathbf{R} = x^i \mathbf{a}_i = x_i \mathbf{a}^i $$
2.  **Real Space vs. Reciprocal Space:**
    *   Real-space basis vectors $ \mathbf{a}_i $$ are covariant.
    *   Reciprocal-space basis vectors $ \mathbf{a}^i $$ are contravariant.
3.  **Differentiation:** Derivatives can change covariance/contravariance.
    *   $ \frac{\partial \phi}{\partial x^i} $$ (gradient wrt contravariant coord) is covariant.
4.  **Metric Tensor ($ g_{ij} $$, $ g^{ij} $$):** Used to "raise" and "lower" indices (convert between covariant and contravariant components).
    *   $ X_i = g_{ij} X^j $$ (lowers index)
    *   $ X^i = g^{ij} X_j $$ (raises index)

---

## Geometric Interpretation of Coordinates
*   **Contravariant Coordinates ($ x^i $$):**
    *   Represent components found by **parallel projection** onto the real-space basis vectors.
    *   They tell you "how much of each basis vector" is needed to construct the vector.
*   **Covariant Coordinates ($ x_i $$):**
    *   Represent components found by **orthogonal projection** onto the directions defined by the *reciprocal-space* basis vectors.
    *   They relate to the "projection onto the plane normal to the other real-space basis vectors."

Understanding this geometric duality is key to mastering tensor analysis in materials science.

Thank you!