# 材料科学特別講義：逆格子と共変・反変テンソル

## 序論

本講義では、材料科学において極めて重要な概念である「逆格子（Reciprocal Lattice）」と「共変（Covariant）・反変（Contravariant）テンソル」について学びます。これらの概念は、X線回折や電子バンド理論といった固体物理学の根幹をなす理論を理解する上で不可欠です。音声認識による文字起こしテキストとスライドの情報を統合し、誤りを修正しながら、物理理論として論理的かつ分かりやすく解説していきます。数学的な厳密性よりも、物理現象との関連性を重視し、直感的な理解を深めることを目指します。

## 1. 逆格子

### 1.1 逆格子の定義と物理的意義

逆格子とは、実空間に存在する結晶格子（実格子）に対応する、フーリエ空間（波数空間、あるいは逆空間）における仮想的な格子です。この概念は、主に以下のような現象の理解に役立ちます。

*   **回折現象:** X線、中性子線、電子線などの波が結晶に衝突した際に生じる回折現象は、逆格子点において強く起こります。これは、波の干渉条件が逆格子ベクトルと密接に関連しているためです。
*   **電子バンド理論:** 結晶中の電子のエネルギー状態を記述するバンド理論は、逆格子空間におけるブリルアンゾーン（Brillouin Zone）という概念を通じて展開されます。電子の運動もまた、結晶の周期的なポテンシャルによって回折される波として扱われます。

このように、波の干渉が重要な役割を果たす領域において、逆格子は非常に便利な道具となります。

**フーリエ変換と散乱理論**

散乱理論において、散乱波の振幅 $S(\mathbf{k})$ は、物質の電子密度分布 $\rho(\mathbf{r})$ のフーリエ変換として与えられます。

$$
S(\mathbf{k})= \int \rho(\mathbf{r}) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r}
$$

結晶のように周期的な構造を持つ場合、電子密度分布 $\rho(\mathbf{r})$ は単位胞内の電子密度分布 $\rho_{\text{u.c.}}(\mathbf{r})$ と格子ベクトルの和で表現できます。このとき、散乱振幅は以下のようになります。

$$
S(\mathbf{k}) = \sum_{n_1,n_2,n_3} \int_{\text{u.c.}} \rho_{\text{u.c.}}(\mathbf{r} - (n_1\mathbf{a}_1+n_2\mathbf{a}_2+n_3\mathbf{a}_3)) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r}
$$

この式から、散乱振幅 $S(\mathbf{k})$ が極大となるのは、波数ベクトル $\mathbf{k}$ が特定の条件を満たすときであることがわかります。この条件こそが「ブラッグ条件」であり、$\mathbf{k}$ が逆格子ベクトル $\mathbf{G}_{hkl}$ に等しい場合に $S(\mathbf{k})$ が極大となります。

$$
\mathbf{k}=\mathbf{G}_{hkl}
$$

このとき、$S(\mathbf{G}_{hkl}) \neq 0$ となる逆格子点のみが物理的な意味を持ちます。つまり、回折実験で観測される回折ピークは、逆格子点に対応しているのです。

### 1.2 逆格子の幾何学的理解

それでは、具体的に逆格子はどのように定義され、実格子とどのような関係にあるのでしょうか。

**逆格子の基本ベクトル**

実格子が基本ベクトル $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$ で張られるとき、対応する逆格子の基本ベクトル $\mathbf{a}^*_1, \mathbf{a}^*_2, \mathbf{a}^*_3$ は次のように定義されます。

$$
\mathbf{a}^{∗}_{1}=\frac{\mathbf{a}_{2} \times \mathbf{a}_{3}}{V}
$$

$$
\mathbf{a}^{∗}_{2}=\frac{\mathbf{a}_{3} \times \mathbf{a}_{1}}{V}
$$

$$
\mathbf{a}^{∗}_{3}=\frac{\mathbf{a}_{1} \times \mathbf{a}_{2}}{V}
$$

ここで $V$ は実格子の単位胞の体積であり、$V = \mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)$ で与えられます。この定義から、逆格子の基本ベクトルは以下の「規格直交条件」を満たします。

$$
\mathbf{a}^{∗}_{i} \cdot \mathbf{a}_{j}=\delta_{ij}
$$

ここで $\delta_{ij}$ はクロネッカーのデルタ（Kronecker delta）と呼ばれる記号で、$i=j$ のときに1、$i \neq j$ のときに0となります。これは、逆格子の基本ベクトル $\mathbf{a}^*_i$ が、実格子の基本ベクトル $\mathbf{a}_j$ ($j \neq i$) に直交し、自身に対応する実格子の基本ベクトル $\mathbf{a}_i$ との内積が1になることを意味します。

**幾何学的特性**

この定義から、逆格子の幾何学的特性を理解することができます。

1.  **直交性:** 逆格子ベクトル $\mathbf{a}^*_1$ は実格子ベクトル $\mathbf{a}_2$ と $\mathbf{a}_3$ に直交します。一般に、$\mathbf{a}^*_i$ は $\mathbf{a}_j$ ($j \neq i$) に直交します。
    *   スライド4の図1：`images\slide4_image1.png` を参照すると、$\mathbf{a}^*_1$ が $\mathbf{a}_2$ 軸に直交していることが視覚的に示されています。
2.  **長さの反比例関係:** 逆格子の基本ベクトルの長さは、おおよそ実格子の基本ベクトルの長さの逆数に比例します。例えば、$|\mathbf{a}^*_1| \approx 1/|\mathbf{a}_1|$ の関係があります。より正確には、

    $$
    |\mathbf{a}^{∗}_{1}| = \frac{|\mathbf{a}_{2} \times \mathbf{a}_{3}|}{V}
    $$
    
    が成り立ちます。もし $\mathbf{a}_1$ が $\mathbf{a}_2 \times \mathbf{a}_3$ と平行（直交座標系では3つのベクトルが互いに直交）であれば、$V = |\mathbf{a}_1| |\mathbf{a}_2 \times \mathbf{a}_3|$ となるため、$|\mathbf{a}^*_1| = 1/|\mathbf{a}_1|$ となります。非直交系ではこの単純な関係は成り立ちませんが、おおまかな目安として有用です。
    
    *補足: 定義式の前に $2\pi$ をつける流儀もあります。その場合、$\mathbf{a}^{∗}_{1}=2\pi\frac{\mathbf{a}_{2} \times \mathbf{a}_{3}}{\mathbf{a}_{1} \cdot (\mathbf{a}_{2} \times \mathbf{a}_{3})}$ となります。この講義では、$2\pi$ を含めない定義を採用しています。*
    
3.  **軸角の補角関係:** 実格子の軸角が $\alpha, \beta, \gamma$ であるとき、逆格子の軸角 $\alpha^*, \beta^*, \gamma^*$ は、非直交座標系の場合には単純な補角関係（例: $\alpha^* = 180^\circ - \alpha$）にはなりません。しかし、直交座標系では軸角はすべて90°であり、逆格子の軸角も90°であるため、この関係は成り立ちます。一般的には、両者の軸角は複雑な関係を持ちますが、大まかな傾向として理解しておくと良いでしょう。

**逆格子の作図**

実格子の基本ベクトルが与えられれば、逆格子の基本ベクトルを作図することができます。スライド4の図2：`images\slide4_image2.png` に示されているように、まず $\mathbf{a}^*_1$ は $\mathbf{a}_2$ と $\mathbf{a}_3$ に直交するように描かれ、その長さは実格子の長さと反比例の関係を持つように調整されます。

### 1.3 逆格子のBravais格子と消滅則

実格子から逆格子を作図する際に、単位格子をどのように選ぶかによって、見かけ上異なる逆格子が得られることがあります。しかし、この問題は「消滅則（Systematic Absences）」を考慮に入れることで解決され、逆格子のBravais格子は一意に決まります。

**単位格子の任意性**

スライド5に示される2次元面心直方格子の例を見てみましょう。
*   実格子の**Bravais格子**（面心格子）の基本ベクトルから逆格子を組むと、ある配列の逆格子点が得られます。
*   実格子の**Primitive格子**（単純格子）の基本ベクトルから逆格子を組むと、別の配列の逆格子点が得られるように見えます。

これは、実格子の単位格子の取り方が任意であることに起因します。しかし、これは逆格子が一意に決まらないという問題ではなく、物理的な意味を持つ逆格子点を選び出すルール、すなわち「消滅則」を考慮することで解消されます。

**消滅則の考慮**

先述の散乱理論の式 $S(\mathbf{G}_{hkl}) \neq 0$ の条件は、すべての逆格子点が回折ピークを与えるわけではないことを意味します。結晶構造が特定の対称性を持つ場合、特定のミラー指数 $(hkl)$ を持つ逆格子点では散乱振幅 $S(\mathbf{G}_{hkl})$ がゼロになり、回折ピークが観測されません。これが「消滅則」です。

例えば、実格子のブラべー格子が面心立方格子（FCC）の場合、散乱振幅は $h, k, l$ がすべて奇数か、すべて偶数の場合にのみゼロになりません（混合指数は消滅）。体心立方格子（BCC）の場合、$h+k+l$ が偶数の場合にのみゼロになりません（$h+k+l$ が奇数の場合は消滅）。

スライド7の2次元面心直方格子の例に戻ると、Primitive格子から得られた逆格子点のうち、消滅則（例: $h+k=$ 奇数）によって消える点を考慮すると、Bravais格子から得られた逆格子点と同じ配列になり、逆格子も面心格子になることが分かります。これにより、逆格子は一意に決定され、矛盾は解消されます。

### 1.4 実格子と逆格子のBravais格子関係

3次元のBravais格子について、実格子と逆格子のBravais格子の関係をまとめると以下のようになります。

| 実格子           | 消滅しないミラー指数条件                  | 逆格子           |
| :--------------- | :---------------------------------------- | :--------------- |
| **体心立方格子 (BCC)** | $h+k+l = \text{偶数}$                   | **面心立方格子 (FCC)** |
| **面心立方格子 (FCC)** | $h, k, l$ がすべて偶数、またはすべて奇数 | **体心立方格子 (BCC)** |
| **単純格子 (P)** | すべての $(hkl)$                          | **単純格子 (P)** |
| **底心格子 (A, B, C)** | 特定の消滅則による                      | **底心格子 (A, B, C)** |
| **六方格子 (H)** | 特定の消滅則による                      | **六方格子 (H)** |
| **菱面体格子 (R)** | 特定の消滅則による                      | **菱面体格子 (R)** |

**例：体心立方格子 (BCC)**
体心立方格子は、単位胞の頂点と体心に原子を持ちます。その格子点の座標は $(0,0,0)$ と $(1/2,1/2,1/2)$ です。このBCCの実格子に対する消滅則は、$h+k+l$ が偶数の場合にのみ回折が観測されるというものです。この条件を満たすミラー指数 $(hkl)$ の逆格子点をプロットすると、これは面心立方格子（FCC）の配置に対応します。したがって、体心立方格子の逆格子は面心立方格子となります。

**例：面心立方格子 (FCC)**
面心立方格子は、単位胞の頂点とすべての面の中心に原子を持ちます。その格子点の座標は $(0,0,0)$, $(0,1/2,1/2)$, $(1/2,0,1/2)$, $(1/2,1/2,0)$ です。このFCCの実格子に対する消滅則は、$h,k,l$ がすべて奇数であるか、またはすべて偶数である場合にのみ回折が観測されるというものです。この条件を満たすミラー指数 $(hkl)$ の逆格子点をプロットすると、これは体心立方格子（BCC）の配置に対応します。したがって、面心立方格子の逆格子は体心立方格子となります。

このように、実格子と逆格子のBravais格子タイプの間には、美しい双対関係が存在します。

*   スライド10の図1：`images\slide10_image1.png` には、菱面体晶の単位胞とそれに対応する逆格子の単位胞が赤線で示されています。`crystal_draw_cell.py` のようなプログラムを利用することで、これらの関係を可視化し、理解を深めることができます。

## 2. 共変ベクトルと反変ベクトル

### 2.1 ベクトルの変換則と共変・反変の定義

実格子と逆格子の関係をより深く理解するためには、共変（covariant）ベクトルと反変（contravariant）ベクトルという概念が非常に有用です。これらの概念は、一般座標変換の下でのベクトルの振る舞いを記述するもので、相対性理論をはじめとする物理学の広範な分野で使われています。

まず、一般座標系でのベクトルの変換則を復習しましょう。ここでは、ある基底 $\mathbf{a}_i$ から別の基底 $\mathbf{a}'_i$ への変換を考えます。

**実格子ベクトルの変換**
実格子の基本ベクトル $\mathbf{a}_i$ が変換行列 $T = (t_{ij})$ によって変換されるとします。
$$
\mathbf{a}'_i = \sum_j t_{ij} \mathbf{a}_j
$$
$$
\mathbf{a}_i = \sum_j (T^{-1})_{ij} \mathbf{a}'_j
$$
スライド12の図1：`images\slide12_image1.png`

**実格子座標の変換**
位置ベクトル $\mathbf{r}$ は $\mathbf{r} = \sum_i x^i \mathbf{a}_i = \sum_i x'^i \mathbf{a}'_i$ と書けます。ここで、$x^i$ は座標成分（反変成分）です。基底ベクトルの変換則から、座標成分の変換則は以下のようになります。
$$
x'^i = \sum_j (T^{-1})_{ji} x^j
$$
$$
x^i = \sum_j T_{ji} x'^j
$$
スライド12の図2：`images\slide12_image2.png`

**逆格子ベクトルの変換**
逆格子の基本ベクトル $\mathbf{a}^{*i}$ は、実格子の基本ベクトルとは異なる変換則に従います。
$$
\mathbf{a}^{'*i} = \sum_j (T^{-1})_{ji} \mathbf{a}^{*j}
$$
$$
\mathbf{a}^{*i} = \sum_j T_{ji} \mathbf{a}^{'*j}
$$

**指数（逆格子座標）の変換**
逆格子空間での座標成分、すなわちミラー指数 $h_i$ は、実格子の基本ベクトルと同じ変換則に従います。
$$
h'_i = \sum_j t_{ij} h_j
$$
$$
h_i = \sum_j (T^{-1})_{ij} h'_j
$$

これらの変換則をまとめると、ベクトルの種類によって変換行列が $T$ と $T^t{}^{-1}$ (転置の逆行列) の2種類に分類できることがわかります。

*   **共変ベクトル（Covariant Vector）**: 変換行列 $T$ を使って変換されるもの。実格子の基本ベクトル $\mathbf{a}_i$ や逆格子の座標（ミラー指数 $h_i$）がこれに該当します。
*   **反変ベクトル（Contravariant Vector）**: 変換行列 $T^t{}^{-1}$ を使って変換されるもの。実格子の座標 $x^i$ や逆格子の基本ベクトル $\mathbf{a}^{*i}$ がこれに該当します。

「共変」とは、基底と同じ方向に「共に変じる」という意味合い、「反変」とは基底とは「反対に変じる」という意味合いを持つと考えると理解しやすいかもしれません。

### 2.2 計量テンソル

結晶学では、基底ベクトルが互いに直交しない「斜交座標系」を扱うことが多いため、ベクトルの内積や長さの計算には「計量テンソル（Metric Tensor）」が必要となります。

**実格子の計量テンソル**
実格子の計量テンソル $g_{ij}$ は、実格子の基本ベクトル $\mathbf{a}_i$ と $\mathbf{a}_j$ の内積として定義されます。
$$
g_{ij}=\mathbf{a}_{i} \cdot \mathbf{a}_{j}
$$
この計量テンソルが座標変換の下でどのように振る舞うかを見てみましょう。$\mathbf{a}'_i = \sum_k t_{ik} \mathbf{a}_k$ を代入すると、
$$
g'_{ij}=\mathbf{a}'_{i} \cdot \mathbf{a}'_{j}=\left(\sum_{k}t_{ik}\mathbf{a}_{k}\right) \cdot \left(\sum_{l}t_{jl}\mathbf{a}_{l}\right)=\sum_{k,l}t_{ik}t_{jl}(\mathbf{a}_{k} \cdot \mathbf{a}_{l})=\sum_{k,l}t_{ik}t_{jl}g_{kl}
$$
この変換則は、計量テンソル $g_{ij}$ が共変ベクトルの変換則 $T$ を2回使って変換されることを示しています。したがって、$g_{ij}$ は「2階共変テンソル」であると言えます。

**逆格子の計量テンソル**
同様に、逆格子の計量テンソル $g^{ij}$ （しばしば $Rg_{ij}$ と表記されますが、添え字の位置で区別できるため $g^{ij}$ で統一します）は、逆格子の基本ベクトル $\mathbf{a}^{*i}$ と $\mathbf{a}^{*j}$ の内積として定義されます。
$$
g^{ij}=\mathbf{a}^{*i} \cdot \mathbf{a}^{*j}
$$
この計量テンソルが座標変換の下でどのように振る舞うかを見てみましょう。$\mathbf{a}^{'*i} = \sum_k (T^{-1})_{ki} \mathbf{a}^{*k}$ を代入すると、
$$
g'^{ij}=\mathbf{a}^{'*i} \cdot \mathbf{a}^{'*j}=\left(\sum_{k}(T^{-1})_{ki}\mathbf{a}^{*k}\right) \cdot \left(\sum_{l}(T^{-1})_{lj}\mathbf{a}^{*l}\right)=\sum_{k,l}(T^{-1})_{ki}(T^{-1})_{lj}(\mathbf{a}^{*k} \cdot \mathbf{a}^{*l})=\sum_{k,l}(T^{-1})_{ki}(T^{-1})_{lj}g^{kl}
$$
この変換則は、計量テンソル $g^{ij}$ が反変ベクトルの変換則 $T^t{}^{-1}$ を2回使って変換されることを示しています。したがって、$g^{ij}$ は「2階反変テンソル」であると言えます。

### 2.3 逆格子変換と計量テンソル

実格子から逆格子への変換は、この計量テンソルと密接に関連しています。

**一般座標系（実格子）から一般座標系（逆格子）への変換**

実格子の基本ベクトル $\mathbf{a}_i$ を逆格子の基本ベクトル $\mathbf{a}^{*j}$ に変換する行列はどのような形になるでしょうか。
逆格子の定義 $\mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta_{ij}$ を用いると、この変換行列の関係を導き出すことができます。

まず、実格子の基本ベクトルから逆格子の基本ベクトルへの変換を、ある変換行列 $M=(m_{ij})$ を用いて次のように仮定してみましょう。
$$
\mathbf{a}^{*i} = \sum_j m_{ij} \mathbf{a}_j
$$
この両辺に $\mathbf{a}_k$ を内積すると、
$$
\mathbf{a}^{*i} \cdot \mathbf{a}_k = \sum_j m_{ij} (\mathbf{a}_j \cdot \mathbf{a}_k)
$$
左辺は定義から $\delta_{ik}$ です。右辺の括弧内は実格子の計量テンソル $g_{jk}$ です。
$$
\delta_{ik} = \sum_j m_{ij} g_{jk}
$$
これを行列の形で書くと、
$$
I = M G
$$
ここで $I$ は単位行列、$G$ は実格子の計量テンソル行列です。したがって、変換行列 $M$ は実格子の計量テンソル行列の逆行列に等しいことがわかります。
$$
M = G^{-1}
$$
この $G^{-1}$ こそが、逆格子の計量テンソル $g^{ij}$ に他なりません。
$$
m_{ij} = g^{ij}
$$
この結果は非常に重要です。**実格子ベクトルを逆格子ベクトルに変換する際の変換行列は、逆格子の計量テンソルに等しい**ということです。

$$
\mathbf{a}^{*i} = \sum_j g^{ij} \mathbf{a}_j
$$

この関係は、共変成分と反変成分を変換する上で、計量テンソルが「添え字の上げ下げ」の役割を果たすことを示唆しています。

### 2.4 内積の不変性と添え字規則

共変ベクトルと反変ベクトルの概念を導入する最大の利点の一つは、その内積が座標変換に対して不変量（スカラー）となることです。

**ベクトルの内積の不変性**
位置ベクトル $\mathbf{r}$ を共変基底ベクトル $\mathbf{a}_i$ と反変座標 $x^i$ を用いて表すと、
$$
\mathbf{r} = \sum_i x^i \mathbf{a}_i
$$
と書けます。これを、変換された基底 $\mathbf{a}'_i$ と座標 $x'^i$ で表しても、同じベクトル $\mathbf{r}$ であるはずです。
$$
\mathbf{r} = \sum_i x'^i \mathbf{a}'_i
$$
ここで、$\mathbf{a}'_i = \sum_k t_{ik} \mathbf{a}_k$ と $x'^i = \sum_l (T^{-1})_{li} x^l$ の関係を使うと、
$$
\sum_i x'^i \mathbf{a}'_i = \sum_i \left( \sum_l (T^{-1})_{li} x^l \right) \left( \sum_k t_{ik} \mathbf{a}_k \right)
$$
$$
= \sum_{k,l} \mathbf{a}_k x^l \sum_i t_{ik} (T^{-1})_{li}
$$
ここで、$\sum_i t_{ik} (T^{-1})_{li}$ の部分は、変換行列 $T$ とその逆行列 $T^{-1}$ の積の成分 $(T T^{-1})_{kl}$ に相当します。これはクロネッカーのデルタ $\delta_{kl}$ に他なりません。
$$
\sum_i t_{ik} (T^{-1})_{li} = \delta_{kl}
$$
したがって、式は次のようになります。
$$
\sum_{k,l} \mathbf{a}_k x^l \delta_{kl} = \sum_k \mathbf{a}_k x^k = \mathbf{r}
$$
この結果は、位置ベクトル $\mathbf{r}$ が座標変換によっても変化しない不変量（スカラー）であることを再確認しています。これは、共変ベクトルと反変ベクトルの内積が不変量となることの一般則の一例です。

**アインシュタインの縮約記法と添え字規則**

このように、共変ベクトルと反変ベクトルの内積は常にスカラーとなるため、数学者アルベルト・アインシュタインは、相対性理論を展開する際に「アインシュタインの縮約記法（Einstein Summation Convention）」を提唱しました。

**規則:**
1.  **共変ベクトルの添え字は下付きに書く。** (例: $\mathbf{a}_i$)
2.  **反変ベクトルの添え字は上付きに書く。** (例: $x^i$)
3.  **同じ添え字記号が上と下にペアで現れる場合、その添え字についての総和（$\sum$）は省略して書く。**

例えば、$\sum_i x^i \mathbf{a}_i$ は $x^i \mathbf{a}_i$ と簡略化して書きます。この記法を用いると、同じ添え字が上と下にペアで現れる量がスカラー（不変量）であることが一目でわかります。

この添え字規則に従って、これまでに登場した量を書き直してみましょう。

*   **共変ベクトル（添え字は下付き）**:
    *   実格子の基本ベクトル: $\mathbf{a}_i$
    *   逆格子の座標（ミラー指数）: $h_i$
    *   実格子の計量テンソル: $g_{ij}$ （2階共変テンソル）
*   **反変ベクトル（添え字は上付き）**:
    *   実格子の座標: $x^i$
    *   逆格子の基本ベクトル: $\mathbf{a}^{*i}$
    *   逆格子の計量テンソル: $g^{ij}$ （2階反変テンソル）

このように表記すると、逆格子の計量テンソルをわざわざ $Rg_{ij}$ と書かなくても、添え字の位置で実格子の $g_{ij}$ と区別できるため、$g^{ij}$ とシンプルに書くことができます。

**ノルムと計量テンソル**
位置ベクトル $\mathbf{r}$ の長さの二乗（ノルムの二乗）は、内積 $\mathbf{r} \cdot \mathbf{r}$ で与えられます。アインシュタインの縮約記法を用いると、
$$
\mathbf{r} \cdot \mathbf{r} = (x^i \mathbf{a}_i) \cdot (x^j \mathbf{a}_j) = (\mathbf{a}_i \cdot \mathbf{a}_j) x^i x^j = g_{ij} x^i x^j
$$
この式では、添え字 $i$ と $j$ が上下にペアで現れているため、ノルムの二乗 $g_{ij} x^i x^j$ が座標変換に対して不変量（スカラー）であることが一目でわかります。

### 2.5 物性テンソルと共変性

物理法則や物性方程式を共変形式のテンソル方程式で表現することには、大きなメリットがあります。

**方程式の共変性**
もしある方程式の左辺と右辺が同じ型のテンソル（つまり、同じ添え字構造）であれば、両辺が同じ変換則に従うことが自明となります。このような方程式を「座標変換に対して共変（covariant）である」と言います。

私たちが学ぶ物理法則は、何らかの対称性を満たすことが要請されています。例えば、物理法則は座標系の選び方によらず同じ形式で記述されるべきです。このような場合に、ラグランジアンのようなスカラー量で表現するか、共変形式のテンソル方程式で表現することで、その方程式が要請されている対称性を満たしているかどうかを一目で確認できます。

*   **特殊相対性理論**や**マクスウェルの方程式**は、ローレンツ変換に対して共変です。
*   **一般相対性理論**は、さらに一般座標変換に対して共変な理論です。
*   **超弦理論**では、ローレンツ共変性や超対称性変換に対する不変性などが要請されます。
*   **ニュートンの運動方程式**は、ガリレイ変換に対して不変です。

このように、共変・反変の概念を用いて物理方程式を整理すると、非常に見通しが良くなります。

**未知のベクトル・テンソル成分の判別**

添え字規則を使うと、未知のベクトルやテンソル成分が共変か反変かを判別できます。例えば、実格子の基本ベクトル間の変換行列を考えてみましょう。
$$
\mathbf{a}'_i = \sum_j t_{ij} \mathbf{a}_j
$$
アインシュタインの縮約記法と添え字規則に従うと、これは以下のように書き直すことができます。
$$
\mathbf{a}'_i = t_i{}^j \mathbf{a}_j
$$
ここで、$t_i{}^j$ は変換行列の成分を示しますが、左辺の $\mathbf{a}'_i$ が共変ベクトル（下付き添え字）、右辺の $\mathbf{a}_j$ も共変ベクトル（下付き添え字）であることから、この変換行列は「添え字 $i$ が下付き、添え字 $j$ が上付き」となるような、$t_i{}^j$ の形式を持つ**2階混合テンソル**であることがわかります。

同様に、逆格子の基本ベクトル間の変換行列は、反変成分と共変成分を一つずつ持つ2階混合テンソルであることがわかります。添え字の位置が異なることで、同じ記号 $t$ を使っても、実格子間の変換行列と逆格子間の変換行列を明確に区別できます。

**計量テンソルによる添え字の上げ下げ**

計量テンソル $g_{ij}$ (共変テンソル) と $g^{ij}$ (反変テンソル) は、共変成分と反変成分を相互に変換する役割を持っています。
例えば、反変ベクトル $V^i$ から共変ベクトル $V_i$ へは、
$$
V_i = g_{ij} V^j
$$
共変ベクトル $V_i$ から反変ベクトル $V^i$ へは、
$$
V^i = g^{ij} V_j
$$
この関係は、前述の $\mathbf{a}^{*i} = g^{ij} \mathbf{a}_j$ と同じ形式です。ここで、$\mathbf{a}_j$ は共変ベクトル、$\mathbf{a}^{*i}$ は反変ベクトルであり、計量テンソル $g^{ij}$ が共変成分の添え字を反変成分の添え字に「上げている」ことがわかります。

**微分による共変・反変の変換**

スカラー関数 $F(x^i)$ を反変座標 $x^i$ で微分すると、共変ベクトルになります。
$$
\frac{\partial F}{\partial x^i}
$$
この量を座標変換すると、
$$
\frac{\partial F}{\partial x'^i} = \sum_j \frac{\partial x^j}{\partial x'^i} \frac{\partial F}{\partial x^j}
$$
ここで、$x^j$ は反変座標で、$x'^i$ は変換後の反変座標とします。$x^j = \sum_k (T^{-1})_{jk} x'^k$ となるため、
$$
\frac{\partial x^j}{\partial x'^i} = (T^{-1})_{ji}
$$
したがって、
$$
\frac{\partial F}{\partial x'^i} = \sum_j (T^{-1})_{ji} \frac{\partial F}{\partial x^j}
$$
これは共変ベクトルの変換則に従うため、スカラー関数を反変座標で微分すると共変ベクトルになる、ということがわかります。

**物性テンソルの例**
具体的な物性テンソルも、この規則に従って分類できます。
*   **電界ベクトル $\mathbf{E}$**: 反変ベクトル $E^i$ で表現されることが多いです。
    $$
    \mathbf{E} = E^i \mathbf{e}_i
    $$
    ここで $\mathbf{e}_i$ はデカルト座標系の基底ベクトルです。
*   **誘電率テンソル $\epsilon_{ij}$**: 自由エネルギー $G$ が電界ベクトルの2次形式で表されるとき、
    $$
    G = G_0 + \frac{1}{2} \epsilon_{ij} E^i E^j
    $$
    ここで $E^i$ は反変ベクトルです。$G$ はスカラーであるため、$\epsilon_{ij}$ は**2階共変テンソル**であるとわかります。
*   **ひずみテンソル $\epsilon^i_j$**: 空間の微小変位 $\Delta x^i$（反変ベクトル）を位置 $x^j$（反変ベクトル）で微分した量として定義されます。
    $$
    \epsilon^i_j = \frac{\partial (\Delta x^i)}{\partial x^j}
    $$
    これは、反変添え字 $i$ と共変添え字 $j$ を一つずつ持つ**2階混合テンソル**です。
*   **弾性テンソル $C^{ij}_{kl}$**: 自由エネルギーがひずみテンソルの2次形式で表されるとき、
    $$
    G = G_0 + \frac{1}{2} C^{ij}_{kl} \epsilon^i_j \epsilon^k_l
    $$
    これは、反変添え字2つ、共変添え字2つを持つ**4階混合テンソル**であるとわかります。

**材料物性計算における注意点**
非直交座標系でのベクトル解析は、理論解析において非常に強力なツールですが、実際の材料の物性テンソル成分と直接関係づけるのは必ずしも簡単ではありません。
*   **単結晶の場合**: 単位格子の軸方向が明確に定義されているため、テンソル成分を対応づけることができます。
*   **多結晶の場合**: 平均的な物性値を扱う場合、テンソルを対角化して主値（固有値）を求め、その平均値を取るなどの処理が必要になります。これは、基底ベクトルをテンソルの主軸に合わせる座標回転に対応します。
*   **理論計算ソフトウェア**: VASP（Vienna Ab initio Simulation Package）などの第一原理計算ソフトウェアは、通常、単位格子の基本ベクトルに対するデカルト座標系（直交座標系）で物性テンソル成分を出力します。POSCARファイル（VASPの入力ファイル）で格子ベクトルをデカルト座標で表現している場合、その方位に従って、誘電率テンソル、弾性定数テンソル、ボルン有効電荷テンソルなどの物性テンソルが出力されます。したがって、計算結果を扱う際には、どの座標系におけるテンソル成分であるかを常に意識する必要があります。

### 2.6 共変座標と反変座標

最後に、共変座標と反変座標が、同じ基底ベクトルを用いた場合でも、異なる座標の取り方に対応するという考え方について軽く触れておきましょう。

**斜交座標系（反変座標）**
一般的に、斜交座標系では、位置ベクトル $\mathbf{r}$ を2つの基底ベクトル $\mathbf{a}_1, \mathbf{a}_2$ を用いて $\mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2$ と表します。このとき、$x^1$ は $\mathbf{a}_2$ に平行な線に沿って $\mathbf{a}_1$ 軸に射影した値、というように読み取られます。これは「反変座標」に対応します（スライド26の「座標1 (基底座標系, 斜座標系)」の図）。

**直交射影座標系（共変座標）**
これに対し、位置ベクトル $\mathbf{r}$ を基底ベクトル $\mathbf{a}_1$ に垂直に射影して得られる座標値を考えることもできます。つまり、$\mathbf{r}$ から $\mathbf{a}_1$ に下ろした垂線の足が与える座標です。これは「共変座標」に対応します。

興味深いことに、この「直交射影座標系」は、実空間の基底ベクトル $\mathbf{a}_1, \mathbf{a}_2$ の逆格子ベクトル $\mathbf{a}^*_1, \mathbf{a}^*_2$ を用いた斜交座標系と同じであると考えることができます。スライド26の「座標2 (正射影座標系)」の図では、$\mathbf{r}$ を $\mathbf{a}_1$ に垂直に射影して得られる $x'_1$ が、逆格子ベクトル $\mathbf{a}^*_1$ を基底とした反変座標と一致することが示されています。

このことから、実空間における共変基底ベクトル $\mathbf{a}_i$ に対応する反変座標 $x^i$ と、逆空間における反変基底ベクトル $\mathbf{a}^{*i}$ に対応する共変座標 $h_i$ (ミラー指数) は、同じベクトルを異なる視点から記述しているに過ぎない、という深い理解に繋がります。

## まとめ

本講義では、まず材料科学における逆格子の重要性を、X線回折やバンド理論を例に挙げながら解説しました。逆格子の幾何学的定義、そして消滅則を考慮することで逆格子のBravais格子が一意に決まることを学びました。次に、一般座標変換の下でのベクトルの振る舞いを記述する「共変ベクトル」と「反変ベクトル」の概念を導入し、それぞれの変換則を明確にしました。計量テンソルの役割、共変・反変ベクトルの内積が不変量となること、そしてアインシュタインの縮約記法が物理法則の記述にいかに有用であるかを理解しました。最後に、物性テンソルへの応用例を通じて、このテンソル解析が理論解析に非常に役立つことを確認しました。これらの概念は、現代の材料科学を深く理解し、新たな材料設計を行う上で不可欠な基礎知識となります。

### 参考文献・関連プログラム

*   Ashcroft, N. W., & Mermin, N. D. (1976). *Solid State Physics*. Saunders College.
*   Kittel, C. (2005). *Introduction to Solid State Physics*. Wiley.
*   python [data-COE]\crystal\crystal_draw_cell.py: 結晶構造と逆格子単位胞の可視化

### 歴史的背景・エピソード

*   **ブラッグ父子のX線回折:** 逆格子の概念は、1912年のX線回折の発見とその理論的解明に深く関わっています。ウィリアム・ヘンリー・ブラッグとウィリアム・ローレンス・ブラッグの父子（通称ブラッグ父子）は、X線回折の法則（ブラッグの法則）を導き出し、結晶構造解析の基礎を築きました。彼らの研究は、物理学と結晶学の発展に多大な貢献をし、1915年にはノーベル物理学賞を受賞しました。逆格子空間における回折点は、まさにブラッグの法則が成り立つ場所を指し示しています。
*   **アインシュタインの縮約記法:** この記法は、アルベルト・アインシュタインが1916年に一般相対性理論を発表する際に導入されました。一般相対性理論は、時空の幾何学を記述するためにテンソル解析を駆使しており、複雑なテンソル方程式を簡潔に記述するためにこの記法が不可欠でした。添え字の上げ下げや縮約のルールは、一見すると難解ですが、慣れると方程式の構造や物理的意味を直感的に理解するのに役立ちます。