# スライド 1 東京科学大学

## 東京科学大学 総合研究院 元素戦略MDX研究センター フロンティア材料研究所 神谷利夫
チュートリアル: 逆格子と共変・反変テンソル

---

# スライド 2 前提と目標

## 前提と目標
*   **前提**: 基本的な結晶学、結晶化学の知識がある
*   **学習目標**:
    *   Bravais格子とPrimitive格子の復習
    *   単位格子は任意にとれる: 異なる単位格子間の変換を学ぶ
    *   デカルト座標系と一般座標系の取り扱い:
        *   基本ベクトルの変換と座標変換
    *   単位格子の表現: 格子ベクトルと内部座標 (一般座標系)
    *   単位格子の変換: 格子ベクトルの変換 (=> 内部座標の変換)
    *   逆格子: 共変ベクトルと反変ベクトル

---

# スライド 3 実格子と逆格子

## 実格子と逆格子

---

# スライド 4 逆格子の描き方

## 逆格子の描き方
*   **逆格子の基本ベクトル**:
    *   実格子の基本ベクトル $\mathbf{a}_i$ と逆格子の基本ベクトル $\mathbf{a}^*_j$ は規格直交条件を満たす: $\mathbf{a}^*_i \cdot \mathbf{a}_j = \delta_{ij}$
    *   $\mathbf{a}^*_1$ は $\mathbf{a}_2$ と $\mathbf{a}_3$ に直交する（循環置換で他のベクトルも同様）

$$
\mathbf{a}^{∗}_{1}=\frac{\mathbf{a}_{2} \times \mathbf{a}_{3}}{V}
$$

$$
\mathbf{a}^{∗}_{2}=\frac{\mathbf{a}_{3} \times \mathbf{a}_{1}}{V}
$$

$$
\mathbf{a}^{∗}_{3}=\frac{\mathbf{a}_{1} \times \mathbf{a}_{2}}{V}
$$

$$
\mathbf{a}^{∗}_{i} \cdot \mathbf{a}_{j}=\delta_{ij}
$$

*   **逆格子の長さ**: 実格子の長さとはおおよそ反比例に対応
    *   $|\mathbf{a}^*_1| \approx 1/|\mathbf{a}_1|$（ただし、$\mathbf{a}_1$が$\mathbf{a}_2 \times \mathbf{a}_3$に平行な場合）
$$
|\mathbf{a}^{∗}_{1}|=\frac{|\mathbf{a}_{2} \times \mathbf{a}_{3}|}{V}
$$

*   **逆格子の軸角**: 実格子の軸角の補角に対応（ただし直交系に限る）
    *   $\alpha^* = 180^\circ - \alpha$ などは限定的
    *   スライド4の図1: `images\slide4_image1.png`
    *   スライド4の図2: `images\slide4_image2.png`

---

# スライド 5 逆格子のBravais格子: 2D面心直方格子の例

## 逆格子のBravais格子: 2D面心直方格子の例
*   **実格子**: 面心直方格子
*   **Bravais格子からスタート**: ある配列の逆格子点
*   **Primitive格子からスタート**: 異なる配列の逆格子点に見える
*   **問題点**: 逆格子は一意に決まらないのか？
    *   スライド5の図1: `images\slide5_image1.png` (図のキャプションは無いが、`a1a2a*2` が図に示されているので、図1は2D格子の図として参照)

---

# スライド 6 逆格子は実格子のFourier変換

## 逆格子は実格子のFourier変換
*   **逆格子の導入**:
    *   **回折**: X線、中性子、電子 (波) の干渉現象を理解するために不可欠
    *   **バンド理論**: 電子の干渉現象（結晶中の電子状態）を記述する

*   **散乱理論**: 散乱振幅 $S(\mathbf{k})$ は電子密度分布 $\rho(\mathbf{r})$ のフーリエ変換
$$
S(\mathbf{k})= \int \rho(\mathbf{r}) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r}
$$

*   結晶の場合、散乱振幅は単位胞のフーリエ変換と格子和で表せる
$$
S(\mathbf{k}) =\sum_{n_{1},n_{2},n_{3}} \int_{\text{u.c.}} \rho_{\text{u.c.}}(\mathbf{r} - (n_1\mathbf{a}_1+n_2\mathbf{a}_2+n_3\mathbf{a}_3)) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r}
$$

*   $S(\mathbf{k})$ は $\rho_{\text{u.c.}}(\mathbf{r})$ のフーリエ変換
*   **ブラッグ条件**: $\mathbf{k}=\mathbf{G}_{hkl}$ （逆格子ベクトル）の時に $S(\mathbf{k})$ が極大になる
$$
\mathbf{k}=\mathbf{G}_{hkl}
$$
*   **物理的意味**: $S(\mathbf{G}_{hkl}) \neq 0$ の逆格子点のみ物理的に意味がある（回折ピークを与える）
    *   **消滅則を考慮する**必要がある
    *   スライド6の図1: `images\slide6_image1.png`

---

# スライド 7 逆格子のBravais格子: 消滅則を考慮すれば一意に決まる

## 逆格子のBravais格子: 消滅則を考慮すれば一意に決まる
*   **実格子**: 面心直方格子
*   **消滅則 (例: h + k = 奇数) で消える逆格子点を除去**
*   **結果**: Bravais格子からスタートした場合とPrimitive格子からスタートした場合の矛盾が解消される
    *   逆格子も面心格子になる
*   スライド7の図1: `images\slide7_image1.png` (図のキャプションは無いが、`a1a2a*2` が図に示されているので、図1は2D格子の図として参照)

---

# スライド 8 Bravais格子, 消滅則と逆格子

## Bravais格子, 消滅則と逆格子 (3次元の例)
*   **体心立方格子 (BCC)**:
    *   格子点の座標: $(0,0,0), (1/2,1/2,1/2)$
    *   消滅しない指数: $h+k+l = \text{偶数}$
    *   **逆格子は面心立方格子 (FCC)**
*   **面心立方格子 (FCC)**:
    *   格子点の座標: $(0,0,0), (0,1/2,1/2), (1/2,0,1/2), (1/2,1/2,0)$
    *   消滅しない指数: $h,k,l$ が非混合（すべて奇数／すべて偶数）
    *   **逆格子は体心立方格子 (BCC)**

---

# スライド 9 実格子と逆格子のBravais格子の関係

## 実格子と逆格子のBravais格子の関係
| 実格子              | 逆格子              |
| :------------------ | :------------------ |
| 単純格子 (P, H, R)  | 単純格子 (P, H, R)  |
| 面心格子 (FC)       | 体心格子 (BC)       |
| 体心格子 (BC)       | 面心格子 (FC)       |
| 底心格子 (A, B, C)  | 底心格子 (A, B, C)  |

---

# スライド 10 実格子と逆格子

## 実格子と逆格子
*   `python [data-COE]\crystal\crystal_draw_cell.py`
    *   菱面体晶の単位胞とその逆格子の単位胞を描画するプログラム
    *   スライド10の図1: `images\slide10_image1.png` (Rhombohedral cell and reciprocal unit cell)

---

# スライド 11 共変ベクトルと反変ベクトル

## 共変ベクトルと反変ベクトル

---

# スライド 12 格子変換のまとめ: 共変ベクトルと反変ベクトルの定義

## 格子変換のまとめ: 共変ベクトルと反変ベクトルの定義
*   **実格子ベクトルの変換**: $\mathbf{a}'_i = \sum_j t_{ij} \mathbf{a}_j$
    *   $\mathbf{a}_i = \sum_j (T^{-1})_{ij} \mathbf{a}'_j$
    *   スライド12の図1: `images\slide12_image1.png`

*   **実格子座標の変換**: $x'^i = \sum_j (T^{-1})_{ji} x^j$
    *   $x^i = \sum_j T_{ji} x'^j$
    *   スライド12の図2: `images\slide12_image2.png`

*   **逆格子ベクトルの変換**: $\mathbf{a}^{'*i} = \sum_j (T^{-1})_{ji} \mathbf{a}^{*j}$
    *   $\mathbf{a}^{*i} = \sum_j T_{ji} \mathbf{a}^{'*j}$

*   **指数（逆格子座標）の変換**: $h'_i = \sum_j t_{ij} h_j$
    *   $h_i = \sum_j (T^{-1})_{ij} h'_j$

*   **基底ベクトルと座標の変換則は2種類に分類できる**:
    *   **共変ベクトル**: 変換行列 $T$ で変換される
        *   実格子ベクトル、逆格子座標
    *   **反変ベクトル**: 変換行列 $T^t{}^{-1}$ で変換される
        *   実格子座標、逆格子ベクトル

---

# スライド 13 計量テンソル

## 計量テンソル
*   **実格子の計量テンソル $g_{ij}$**: $\mathbf{a}_i \cdot \mathbf{a}_j$ で定義
    *   座標変換すると:
$$
g'_{ij}=\mathbf{a}'_{i} \cdot \mathbf{a}'_{j}=\sum_{k,l}t_{ik}t_{jl}g_{kl}
$$
    *   $g_{ij}$ は共変ベクトルの変換則 $T$ によって2回変換される: **2階共変テンソル**
    *   スライド13の図1: `images\slide13_image1.png`

*   **逆格子の計量テンソル $g^{ij}$**: $\mathbf{a}^{*i} \cdot \mathbf{a}^{*j}$ で定義
    *   座標変換すると:
$$
g'^{ij}=\mathbf{a}^{'*i} \cdot \mathbf{a}^{'*j}=\sum_{k,l}(T^{-1})_{ki}(T^{-1})_{lj}g^{kl}
$$
    *   $g^{ij}$ は反変ベクトルの変換則 $T^t{}^{-1}$ によって2回変換される: **2階反変テンソル**

---

# スライド 14 一般座標系 (実格子) => 一般座標系 (逆格子) 変換

## 一般座標系 (実格子) => 一般座標系 (逆格子) 変換
*   **格子ベクトルの変換則**:
$$
\begin{pmatrix} \mathbf{a}'_1 \\ \mathbf{a}'_2 \\ \mathbf{a}'_3 \end{pmatrix} = \begin{pmatrix} t_{11} & t_{12} & t_{13} \\ t_{21} & t_{22} & t_{23} \\ t_{31} & t_{32} & t_{33} \end{pmatrix} \begin{pmatrix} \mathbf{a}_1 \\ \mathbf{a}_2 \\ \mathbf{a}_3 \end{pmatrix}
$$
*   ここで $T = (t_{ij})$ は格子ベクトル（基底ベクトル）の変換行列
    *   スライド14の図1: `images\slide14_image1.png`
    *   スライド14の図2: `images\slide14_image2.png`

*   **変換行列と計量テンソルの関係**:
    *   $\mathbf{a}'_i \cdot \mathbf{a}_j = \sum_k t_{ik} (\mathbf{a}_k \cdot \mathbf{a}_j) = \sum_k t_{ik} g_{kj}$
$$
\begin{pmatrix} \mathbf{a}'_1 \cdot \mathbf{a}_1 & \mathbf{a}'_1 \cdot \mathbf{a}_2 & \mathbf{a}'_1 \cdot \mathbf{a}_3 \\ \mathbf{a}'_2 \cdot \mathbf{a}_1 & \mathbf{a}'_2 \cdot \mathbf{a}_2 & \mathbf{a}'_2 \cdot \mathbf{a}_3 \\ \mathbf{a}'_3 \cdot \mathbf{a}_1 & \mathbf{a}'_3 \cdot \mathbf{a}_2 & \mathbf{a}'_3 \cdot \mathbf{a}_3 \end{pmatrix} = \begin{pmatrix} t_{11} & t_{12} & t_{13} \\ t_{21} & t_{22} & t_{23} \\ t_{31} & t_{32} & t_{33} \end{pmatrix} \begin{pmatrix} g_{11} & g_{12} & g_{13} \\ g_{21} & g_{22} & g_{23} \\ g_{31} & g_{32} & g_{33} \end{pmatrix}
$$
    *   スライド14の図3: `images\slide14_image3.png`

*   **$\mathbf{a}'_i$ が逆格子の基本ベクトル $\mathbf{a}^{*i}$ の場合**:
    *   $\mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta_{ij}$ (クロネッカーのデルタ)
    *   このとき、$(\mathbf{a}^{*i} \cdot \mathbf{a}_j)$ の行列は単位行列 $I$ となる。

---

# スライド 15 実格子 => 逆格子変換: 逆格子の計量テンソル

## 実格子 => 逆格子変換: 逆格子の計量テンソル
*   **実格子ベクトルを逆格子ベクトルに変換する変換行列 $M=(m_{ij})$ を仮定**:
$$
\mathbf{a}^{*i} = \sum_j m_{ij} \mathbf{a}_j
$$
*   両辺に $\mathbf{a}_k$ を内積すると:
$$
\mathbf{a}^{*i} \cdot \mathbf{a}_k = \sum_j m_{ij} (\mathbf{a}_j \cdot \mathbf{a}_k)
$$
*   左辺は $\delta_{ik}$、右辺は $g_{jk}$ で置き換え:
$$
\delta_{ik} = \sum_j m_{ij} g_{jk}
$$
*   行列で表現すると $I = M G$
    *   したがって、変換行列 $M$ は実格子の計量テンソル $G$ の逆行列に等しい
$$
(m_{ij})=(g_{ij})^{-1}
$$
*   この $G^{-1}$ が逆格子の計量テンソル $g^{ij}$ に他ならない
    *   実格子ベクトル => 逆格子ベクトルの変換行列は**逆格子の計量テンソル $g^{ij}$**
    *   スライド15の図1: `images\slide15_image1.png`

---

# スライド 16 共変ベクトルと反変ベクトルの内積は Scalar になる

## 共変ベクトルと反変ベクトルの内積は Scalar になる
*   **ベクトル $\mathbf{r}$ を座標変換**:
$$
\mathbf{r}=\sum_{i} x^{i}\mathbf{a}_{i}
$$
*   変換後も同じベクトル $\mathbf{r}$
$$
\sum_{i} x'^{i}\mathbf{a}'_{i}=\sum_{i} \left(\sum_{l} (T^{-1})_{li} x^{l}\right) \left(\sum_{k} t_{ik} \mathbf{a}_{k}\right)=\sum_{k,l} \mathbf{a}_{k} x^{l} \left(\sum_{i} t_{ik} (T^{-1})_{li}\right)
$$
$$
\left(\sum_{i} t_{ik} (T^{-1})_{li}\right) = (T T^{-1})_{kl} = \delta_{kl}
$$
*   つまり $\mathbf{r}=\sum_{k} x^{k}\mathbf{a}_{k} = \sum_{i} x'^{i}\mathbf{a}'_{i}$
    *   $\mathbf{r}$ は不変量 (スカラー) であることを再確認
    *   スライド16の図1: `images\slide16_image1.png`

*   **その他の共変ベクトル $V_i$ と反変ベクトル $W^j$ の内積の座標変換でも、同じ変換則**
$$
\sum_{i} V'_{i} W'^{i} = \sum_{i} V_{i} W^{i}
$$
*   **結論**: 共変ベクトルと反変ベクトルの内積は不変量 (Scalar) になる

---

# スライド 17 添え字の約束と縮約記法

## 添え字の約束と縮約記法
*   **規則**:
    *   共変ベクトルの添え字は**下付き**に書く
    *   反変ベクトルの添え字は**上付き**に書く

*   共変成分と反変成分の間で和を取ると、不変量 (scalar) になる
    *   => 同じ添え字記号の共変・反変成分がある場合は、**暗黙の約束として総和 ($\sum$) を取る**ことにする
        *   (**アインシュタインの縮約記法**: Einstein Summation Convention)

*   **例**: $x^i \mathbf{a}_i$ は $\sum_{i} x^{i}\mathbf{a}_{i}$ と簡略化して書く
    *   => 同じ添え字記号が上と下に現れれば、不変量であることが明確になる
    *   スライド17の図1: `images\slide17_image1.png`

---

# スライド 18 添え字規則に則って書き直す

## 添え字規則に則って書き直す
*   変換行列 $T$ によって変換される場合は共変ベクトル。添え字は**下付き**に書く。
*   変換行列 $T^t{}^{-1}$ によって変換される場合は反変ベクトル。添え字は**上付き**に書く。

*   **実格子の基本ベクトル**: $\mathbf{a}_i$ (共変ベクトル)
*   **実格子の座標**: $x^i$ (反変ベクトル)
*   **実格子の計量テンソル**: $g_{ij}$ (2階共変テンソル)
*   **逆格子の基本ベクトル**: $\mathbf{a}^{*i}$ (反変ベクトル)
*   **逆格子の座標**: $h_i$ (共変ベクトル)
*   **逆格子の計量テンソル**: $g^{ij}$ (2階反変テンソル)
    *   添え字の位置で区別できるので、$g^{ij}$ と書ける
    *   スライド18の図1: `images\slide18_image1.png`

---

# スライド 19 ノルムと計量テンソル

## ノルムと計量テンソル
*   **ベクトル $\mathbf{r}$ のノルムの二乗**: $\mathbf{r} \cdot \mathbf{r}$
$$
\mathbf{r} = x^{i}\mathbf{a}_{i}
$$
$$
||\mathbf{r}||^{2}=\mathbf{r} \cdot \mathbf{r}=(x^{i}\mathbf{a}_{i}) \cdot (x^{j}\mathbf{a}_{j})=(\mathbf{a}_{i} \cdot \mathbf{a}_{j})x^{i}x^{j}=g_{ij}x^{i}x^{j}
$$
*   添え字 $i, j$ が上と下でペアになっているので、ノルムは不変量 (スカラー) であることが確認できる
    *   スライド19の図1: `images\slide19_image1.png`

---

# スライド 20 方程式の共変性

## 方程式の共変性
*   方程式の左辺と右辺が同じ型（同じ添字構造）のテンソルであれば、両辺が同じ変換則に従うことが自明である
    *   これを「方程式は座標変換に対して共変 (共変形式である)」という

*   **物理法則は何らかの対称性を満たすことが要請される**:
    *   共変形式のテンソル方程式で表現できる

*   **例**:
    *   特殊相対性理論、Maxwellの方程式: Lorentz共変
    *   一般相対性理論: 一般共変
    *   超弦理論: Lorentz共変、超対称性不変など
    *   Newtonの運動方程式: Galilei不変

---

# スライド 21 未知のベクトル・テンソル成分の共変・反変の判断

## 未知のベクトル・テンソル成分の共変・反変の判断
*   共変な方程式に添え字規則を使うと、未知のベクトル・テンソル成分が共変か反変かわかる

*   **実格子ベクトルの変換行列**: $\mathbf{a}'_i = t_i{}^j \mathbf{a}_j$
    *   $\mathbf{a}'_i$ と $\mathbf{a}_j$ はどちらも共変ベクトル (添え字は下付き)
    *   共変形式になるためには $t_i{}^j$ の添え字 $i$ が下付き、 $j$ が上付きである必要がある
        *   よって $t_i{}^j$ は**共変成分と反変成分を1つずつ持つ2階混合テンソル**
    *   スライド21の図1: `images\slide21_image1.png`

*   **逆格子ベクトルの変換行列**: 同様に、反変成分と共変成分を1つずつ持つ2階混合テンソル

---

# スライド 22 計量テンソルは共変成分 <=> 反変成分を変換する

## 計量テンソルは共変成分 <=> 反変成分を変換する
*   **以前に証明した結果**: 実格子ベクトル => 逆格子ベクトルの変換行列は逆格子の計量テンソル
$$
\mathbf{a}^{*i} = g^{ij}\mathbf{a}_{j}
$$
    *   $\mathbf{a}^{*i}$ は反変ベクトル、$\mathbf{a}_j$ は共変ベクトル
    *   $g^{ij}$ が共変添え字を反変添え字に「上げる」役割を果たす

*   **逆格子ベクトルの性質**: $\mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta_{ij}$ より
$$
\mathbf{a}^{*i} \cdot \mathbf{a}_{j}=\sum_{k}g^{ik}\mathbf{a}_{k} \cdot \mathbf{a}_{j}=\sum_{k}g^{ik}g_{kj}
$$
*   したがって、
$$
\sum_{k}g^{ik}g_{kj}=\delta^{i}_{j}
$$
    *   これは $G^{-1}G=I$ という行列の関係を示している
    *   $g^{ik}$ (反変計量テンソル) は $g_{kj}$ (共変計量テンソル) の逆行列である
    *   スライド22の図1: `images\slide22_image1.png`

---

# スライド 23 共変成分と反変成分: 微分

## 共変成分と反変成分: 微分
*   共変成分か反変成分かは、座標変換して変換行列を確認する

*   **スカラー関数 $F(x^i)$ の座標微分**:
$$
\frac{\partial F}{\partial x'^i}=\sum_{j}\frac{\partial x^{j}}{\partial x'^i}\frac{\partial F}{\partial x^{j}}
$$
*   ここで、$x^j$ は反変座標 $x'^i$ の関数であり、$\frac{\partial x^{j}}{\partial x'^i}$ は変換行列 $T$ の逆行列の成分 $(T^{-1})_{ji}$ に相当する
    *   したがって、$\frac{\partial F}{\partial x'^i} = \sum_j (T^{-1})_{ji} \frac{\partial F}{\partial x^j}$

*   **結論**: スカラーを反変成分で微分すると共変ベクトルになる
    *   スライド23の図1: `images\slide23_image1.png`

---

# スライド 24 共変成分と反変成分: 物性テンソル

## 共変成分と反変成分: 物性テンソル
*   不変量 (スカラー) を既知の共変・反変成分で表すことで判別できる

*   **電界ベクトル**: $\mathbf{E} = E^i \mathbf{e}_i$
    *   電界ベクトル成分 $E^i$: 反変ベクトル

*   **誘電率テンソル $\epsilon_{ij}$**: 自由エネルギー $G$ は $G = G_0 + \frac{1}{2}\epsilon_{ij}E^{i}E^{j}$
    *   $G$ はスカラー、$E^i$ は反変ベクトルなので、$\epsilon_{ij}$ は**2階共変テンソル** (スカラーの反変ベクトルによる2階微分)
    *   スライド24の図1: `images\slide24_image1.png`

*   **ひずみテンソル $\epsilon^i_j$**: 微小変位 $\Delta x^i$（反変ベクトル）を位置 $x^j$（反変ベクトル）で微分
$$
\epsilon^{i}_{j}=\frac{\partial (\Delta x^{i})}{\partial x^{j}}
$$
    *   => 反変・共変添え字を持つ**2階混合テンソル**

*   **弾性テンソル $C^{ij}_{kl}$**: $G = G_0 + \frac{1}{2} C^{ij}_{kl} \epsilon^i_j \epsilon^k_l$
    *   => 反変・共変添え字を2つずつ持つ**4階混合テンソル**

*   非直交座標系のベクトル解析は、理論解析で重要だが、実際の材料のテンソル成分と関係づけるのは難しい
    *   単結晶ならテンソル成分と対応付けられる
    *   多結晶の場合、対角化して主値の平均で対応づけられる
    *   理論計算 (VASP など) では、POSCARファイルの格子ベクトル定義に基づく**デカルト座標系**に関するテンソルを出力している

---

# スライド 25 共変成分と反変成分: 一般的な規則

## 共変成分と反変成分: 一般的な規則
*   基本ベクトルと座標の共変・反変は入れ替わる
*   実空間と逆空間の共変・反変は入れ替わる
*   微分により共変と反変が入れ替わる
*   計量テンソル $g_{ij}$ (共変) と $g^{ij}$ (反変) により、共変成分と反変成分を入れ替えられる

|                 | 共変   | 反変   |
| :-------------- | :----- | :----- |
| 実格子ベクトル  | ✔️     |        |
| 実格子座標      |        | ✔️     |
| 実座標による微分 | ✔️     |        |
| 逆格子ベクトル  |        | ✔️     |
| 逆格子座標      | ✔️     |        |
| 逆格子座標による微分 |        | ✔️     |

*   スライド25の図1: `images\slide25_image1.png`

---

# スライド 26 共変座標と反変座標は同じ基底ベクトルで異なる座標の取り方に当たる

## 共変座標と反変座標は同じ基底ベクトルで異なる座標の取り方に当たる
*   **座標1 (斜交座標系)**:
    *   $\mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2$
    *   $x^1, x^2$ は反変座標
    *   実空間 (共変基底ベクトル $\mathbf{a}_i$) に対応
    *   スライド26の図1: `images\slide26_image1.png` (左上)

*   **座標2 (直交射影座標系)**:
    *   $\mathbf{r}$ を $\mathbf{a}_1$ に垂直に射影した座標 $x'_1$ など
    *   これは、(逆格子ベクトル $\mathbf{a}^*_i$) に対しては斜交座標系となる
    *   逆空間 (反変基底ベクトル $\mathbf{a}^{*i}$) に対応
    *   $x'_1, x'_2$ は共変座標
    *   スライド26の図1: `images\slide26_image1.png` (右上)

---