# 第1章 結晶学とテンソル解析の基礎

## 1.1 はじめに：材料科学における結晶学とテンソル解析の重要性

本講義では、材料科学、特に結晶材料の理解に不可欠な「逆格子」の概念と、座標変換を扱うための強力な数学的ツールである「共変・反変テンソル」について深く掘り下げていきます。皆さんはすでに基本的な結晶学や結晶化学の知識をお持ちのことと思いますが、ここではさらに進んで、結晶構造の記述や回折現象の解析、さらには物性理論の構築において、これらの概念がどのように活用されるかを体系的に学びます。

材料科学の研究では、原子レベルの構造がマクロな物性に直結することがしばしばあります。X線、中性子、電子などの波を用いた回折実験は、結晶の内部構造を探るための最も強力な手段の一つです。この回折現象を理解するためには、実空間の結晶構造に対応する「逆格子」の概念が不可欠です。また、結晶が持つ異方性や、外部からの刺激（電場、応力など）に対する応答を記述する際には、座標系の選び方によらず物理法則を普遍的に表現できる「テンソル」の概念、特に「共変・反変テンソル」が非常に重要になります。

この講義を通じて、皆さんがこれらの概念を深く理解し、今後の研究に役立てていただければ幸いです。

## 1.2 結晶の記述：ブラベー格子と基本格子、単位格子

### 1.2.1 ブラベー格子と基本格子の復習

まず、基本的な結晶学の概念を復習しましょう。**結晶**とは、原子や分子が三次元的に規則正しく配列した固体です。この規則正しい配列は、**格子**と呼ばれる仮想的な点の集合によって表現されます。

**ブラベー格子 (Bravais Lattice)** とは、空間中の各点が、ある点から見て、他のどの点からも同じ環境にあるような、無限に広がる点配列のことを指します。簡単に言えば、「どこから見ても同じ」という対称性を持つ点格子です。3次元空間には14種類のブラベー格子が存在し、それぞれが結晶の基本的な対称性を示します。

一方、**基本格子 (Primitive Lattice)** とは、単位胞（ユニットセル）が1つの格子点のみを含むブラベー格子のことを指します。基本格子の概念は、結晶学において最もシンプルで本質的な格子表現を与えます。

### 1.2.2 単位格子と格子ベクトルの変換

結晶構造を記述する際に、私たちは空間を繰り返し埋め尽くす最小単位である**単位格子 (Unit Cell)** を用います。単位格子は、その中に原子や分子がどのように配置されているか（**モチーフ**または**基礎**と呼ばれる）を含めて、結晶全体を表現します。

単位格子は、3つの独立な**格子ベクトル (Lattice Vectors)** $ \mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3 $ によって定義されます。これらのベクトルは単位格子の稜に沿って伸び、その長さ（$a, b, c$）とそれらの間の角度（$ \alpha, \beta, \gamma $）によって特徴づけられます。任意の位置ベクトル $ \mathbf{R} $ は、これらの格子ベクトルを用いて整数 $ n_1, n_2, n_3 $ の線形結合として表されます。

$$ \mathbf{R} = n_1 \mathbf{a}_1 + n_2 \mathbf{a}_2 + n_3 \mathbf{a}_3 $$

さて、ここで重要な点は、**単位格子は任意にとれる**ということです。同じ結晶構造を記述するのに、異なる格子ベクトルを持つ複数の単位格子を考えることができます。例えば、体心立方格子（BCC）は体心立方単位胞（2原子を含む）で記述することもできますし、菱面体単位胞（1原子を含む）で記述することも可能です。

異なる単位格子 $ (\mathbf{a}'_1, \mathbf{a}'_2, \mathbf{a}'_3) $ と $ (\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3) $ の間には、線形変換の関係が成り立ちます。

$$ \mathbf{a}'_i = \sum_{j=1}^3 t_{ij} \mathbf{a}_j $$

ここで $ t_{ij} $ は変換行列 $ \mathbf{T} $ の成分です。この変換行列 $ \mathbf{T} $ は整数成分を持ち、その行列式 $ \det(\mathbf{T}) $ は新しい単位胞の体積が元の単位胞の体積の何倍になるかを示します。特に、変換行列が可逆である場合、元の単位格子から新しい単位格子へ、あるいはその逆へと変換できます。

### 1.2.3 デカルト座標系と一般座標系

物理現象を記述する際には、しばしば直交座標系（デカルト座標系）が用いられます。しかし、結晶のような周期構造を扱う場合、結晶の対称性や格子ベクトルに沿った斜交座標系（一般座標系）の方が自然で簡潔な記述を可能にします。

デカルト座標系では、基底ベクトル $ \mathbf{e}_x, \mathbf{e}_y, \mathbf{e}_z $ は互いに直交し、長さが1に正規化されています。任意の位置ベクトル $ \mathbf{r} $ は、デカルト座標 $ (x, y, z) $ を用いて次のように表されます。

$$ \mathbf{r} = x \mathbf{e}_x + y \mathbf{e}_y + z \mathbf{e}_z $$

一方、一般座標系（斜交座標系）では、格子ベクトル $ \mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3 $ そのものを基底ベクトルとすることができます。この場合、任意の位置ベクトル $ \mathbf{r} $ は、**分数的座標 (Fractional Coordinates)** または**内部座標 (Internal Coordinates)** と呼ばれる $ (x^1, x^2, x^3) $ を用いて次のように表されます。

$$ \mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2 + x^3 \mathbf{a}_3 = \sum_{i=1}^3 x^i \mathbf{a}_i $$

この表記において、上付き添え字 $ i $ は、後のセクションで詳しく説明する「反変ベクトル成分」であることを示唆しています。分数的座標は、単位胞内の原子位置を $ (0 \le x^i < 1) $ の範囲で表現するため、結晶構造の記述に非常に便利です。

デカルト座標系と一般座標系の間での座標変換は、基底ベクトルの変換行列を用いて行われます。この変換は、ベクトルやテンソルの「共変」または「反変」な性質を理解する上で非常に重要になります。

## 1.3 実格子と逆格子

### 1.3.1 逆格子の導入：回折現象とフーリエ変換

結晶学における**逆格子 (Reciprocal Lattice)** は、実空間の結晶格子（**実格子**）に対応する仮想的な格子であり、主に回折現象の記述や電子バンド構造の解析に用いられます。逆格子は、X線、中性子、電子などの波の**干渉 (Interference)** 効果を理解するために不可欠な概念です。

**X線回折 (X-ray Diffraction)** は、結晶構造を決定する最も強力な実験手法の一つです。X線が結晶に入射すると、結晶中の原子によって散乱され、特定の方向に強め合う（干渉する）ことで回折ピークが生じます。この現象は、**ブラッグの法則 (Bragg's Law)** によって記述されます。

$$ n\lambda = 2d \sin\theta $$

ここで、$n$ は回折次数、$ \lambda $ はX線の波長、$ d $ は結晶面間隔、$ \theta $ は入射角です。ブラッグの法則は、実空間の結晶面間隔 $d$ と入射X線の波長、角度の関係を示しますが、この関係を逆格子空間で記述すると、より普遍的で直感的な理解が得られます。

逆格子は、実空間の周期的な構造を**フーリエ変換 (Fourier Transform)** したものと考えることができます。結晶中の電子密度分布 $ \rho(\mathbf{r}) $ は周期関数であるため、フーリエ級数展開が可能です。そのフーリエ係数が逆格子点に対応します。

物理学における慣習として、実空間の関数 $f(\mathbf{r})$ のフーリエ変換 $F(\mathbf{k})$ は一般的に次のように定義されます。

$$ F(\mathbf{k}) = \int_{\text{all space}} f(\mathbf{r}) \exp(-i \mathbf{k} \cdot \mathbf{r}) d^3\mathbf{r} $$

結晶学では、回折現象を記述する際に、散乱ベクトル $ \mathbf{k} $ （あるいは $ \mathbf{Q} $ と表記されることも多い）が逆格子ベクトル $ \mathbf{G}_{hkl} $ に一致したときに回折が起こるという条件（**ラウエ条件**または**ブラッグ条件**）が使われます。スライド6の数式は、電子密度分布 $ \rho(\mathbf{r}) $ のフーリエ変換が散乱振幅 $ S(\mathbf{k}) $ になることを示しています。

$$ S(\mathbf{k}) = \int \rho(\mathbf{r}) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r} $$

もし $ \rho(\mathbf{r}) $ が無限に広がる結晶の電子密度を表すとすると、それは単位胞内の電子密度 $ \rho_{\text{u.c.}}(\mathbf{r}) $ と、格子点 $ \mathbf{R} = n_1 \mathbf{a}_1 + n_2 \mathbf{a}_2 + n_3 \mathbf{a}_3 $ のデルタ関数列の畳み込みで表せます。このとき、散乱振幅は逆格子点 $ \mathbf{G}_{hkl} $ でのみ非ゼロの値を取ります。

$$ S(\mathbf{k}) = \sum_{n_1, n_2, n_3} \rho_{\text{u.c.}}(\mathbf{r} - (n_1 \mathbf{a}_1 + n_2 \mathbf{a}_2 + n_3 \mathbf{a}_3)) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r} $$

このフーリエ変換が非ゼロとなるのは、散乱ベクトル $ \mathbf{k} $ が実格子の基本ベクトルで張られる逆格子の格子ベクトル $ \mathbf{G}_{hkl} $ に一致する場合のみです。すなわち、

$$ \mathbf{k} = \mathbf{G}_{hkl} $$

このとき、散乱振幅 $ S(\mathbf{G}_{hkl}) $ は回折ピークの強度と位相の情報を含みます。回折実験で物理的に意味があるのは、この $ S(\mathbf{G}_{hkl}) \neq 0 $ となる逆格子点（**消滅則**を考慮したもの）だけです。

### 1.3.2 逆格子の基本ベクトルと性質

実格子ベクトル $ \mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3 $ に対し、**逆格子の基本ベクトル (Reciprocal Lattice Basis Vectors)** $ \mathbf{a}^{*1}, \mathbf{a}^{*2}, \mathbf{a}^{*3} $ は次のように定義されます。

$$ \mathbf{a}^{*1} = \frac{\mathbf{a}_2 \times \mathbf{a}_3}{V} $$
$$ \mathbf{a}^{*2} = \frac{\mathbf{a}_3 \times \mathbf{a}_1}{V} $$
$$ \mathbf{a}^{*3} = \frac{\mathbf{a}_1 \times \mathbf{a}_2}{V} $$

ここで $ V $ は実格子の単位胞の体積であり、

$$ V = \mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3) $$

によって計算されます。これらの逆格子ベクトルは、以下の重要な性質を持ちます。

1.  **直交条件**: 実格子の基本ベクトルと逆格子の基本ベクトルは、互いに直交します。特に、対応するインデックスのベクトルはスカラー積が1に、そうでない場合は0になります。

    $$ \mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j $$

    ここで $ \delta^i_j $ はクロネッカーのデルタであり、$ i=j $ のときに1、$ i \neq j $ のときに0となります。これは、逆格子ベクトル $ \mathbf{a}^{*1} $ が $ \mathbf{a}_2 $ と $ \mathbf{a}_3 $ が張る面に垂直であり、$ \mathbf{a}_1 $ に平行であることを示しています。

2.  **長さの反比例関係**: 逆格子の基本ベクトルの長さは、対応する実格子の基本ベクトルの長さとは「反比例」の関係にあります。例えば、$ |\mathbf{a}^{*1}| $ は $ |\mathbf{a}_1| $ に反比例します。

    $$ |\mathbf{a}^{*1}| = \frac{|\mathbf{a}_2 \times \mathbf{a}_3|}{V} = \frac{\text{Area}(\mathbf{a}_2, \mathbf{a}_3)}{\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)} $$

    より単純には、直交座標系で考えると、$ |\mathbf{a}^{*1}| = 1/|\mathbf{a}_1| $ のように簡潔になります。これは、短い実格子ベクトルは長い逆格子ベクトルに対応し、その逆もまた然り、という関係を意味します。
    なお、物理学では $ 2\pi $ を含めて定義することが多く、その場合は $ \mathbf{a}^{*1} = 2\pi \frac{\mathbf{a}_2 \times \mathbf{a}_3}{V} $ となります。スライド4の数式には $ 2\pi $ があるものとないものが混在していますが、結晶学では $ 2\pi $ を含まない定義が一般的です。本講義では $ 2\pi $ を含まない定義を主に使用します。

3.  **軸角の補角関係**: 逆格子の軸角は、実格子の軸角の補角に対応することがありますが、これは厳密には一般の斜方格子では成り立たず、特定の場合に限られます。例えば、立方晶系などでは $ \alpha^* = \alpha $ となります。一般的には、実格子の計量テンソルの逆行列が逆格子の計量テンソルに対応することから、より複雑な関係が導かれます。

逆格子点 $ \mathbf{G}_{hkl} $ は、逆格子の基本ベクトルを用いて整数 $ h, k, l $ の線形結合として表されます。

$$ \mathbf{G}_{hkl} = h \mathbf{a}^{*1} + k \mathbf{a}^{*2} + l \mathbf{a}^{*3} = \sum_{i=1}^3 h_i \mathbf{a}^{*i} $$

ここで $ h, k, l $ は**ミラー指数 (Miller Indices)** と呼ばれ、結晶学において特定の結晶面や回折ピークを指し示すために使われます。この表記において、下付き添え字 $ i $ は「共変ベクトル成分」であることを示唆しています。

### 1.3.3 逆格子のブラベー格子と消滅則

実格子の単位格子をどのように選ぶかによって、逆格子の基本ベクトルの組も異なります。例えば、実格子の面心直方格子を異なる基底で定義すると、一見すると異なる逆格子が導かれるように見えます（スライド5）。しかし、物理的に意味のある逆格子点は、**消滅則 (Extinction Rules)** を考慮することで一意に決定されます。

消滅則とは、結晶構造因子 $ F(\mathbf{G}_{hkl}) $ が特定のミラー指数 $ (hkl) $ においてゼロになる、すなわち回折ピークが観察されない条件のことです。これは、単位胞内に複数原子が存在する場合（モチーフが存在する場合）や、単位胞の選択による格子型（P, I, Fなど）に起因します。

例えば、**体心立方格子 (BCC)** の場合、格子点の座標は $ (0, 0, 0) $ と $ (1/2, 1/2, 1/2) $ です。このとき、回折ピークが消滅しない条件は $ h+k+l = \text{偶数} $ です。この条件を満たす $ (hkl) $ は、逆格子空間において**面心立方格子 (FCC)** の対称性を持ちます。

一方、**面心立方格子 (FCC)** の場合、格子点の座標は $ (0, 0, 0), (0, 1/2, 1/2), (1/2, 0, 1/2), (1/2, 1/2, 0) $ です。このとき、回折ピークが消滅しない条件は $ h, k, l $ がすべて偶数か、すべて奇数（**非混合**）の場合です。この条件を満たす $ (hkl) $ は、逆格子空間において**体心立方格子 (BCC)** の対称性を持ちます。

このように、消滅則を考慮することで、実格子のブラベー格子と逆格子のブラベー格子との間に明確な関係が導き出されます。

| 実格子ブラベー格子 | 逆格子ブラベー格子 |
| :----------------- | :----------------- |
| 単純格子 (P, H, R) | 単純格子 (P, H, R) |
| 面心格子 (FC)      | 体心格子 (BC)      |
| 体心格子 (BC)      | 面心格子 (FC)      |
| 底心格子 (A, B, C) | 底心格子 (A, B, C) |

この関係は、回折実験の結果から結晶構造を同定する際に非常に重要な指針となります。

### 1.3.4 歴史的背景：回折結晶学の発展

逆格子と回折現象の理解は、20世紀初頭の物理学と化学に革命をもたらしました。1912年、ドイツの物理学者マックス・フォン・ラウエは、X線が結晶によって回折されることを発見しました。これは、X線が波であること、そして結晶が周期的な原子配列を持つことの最初の証拠となりました。

その後、ウィリアム・ヘンリー・ブラッグとウィリアム・ローレンス・ブラッグの父子が、ブラッグの法則を定式化し、X線回折の原理を明確にしました。彼らはこの功績により1915年にノーベル物理学賞を受賞しました。逆格子の概念は、X線回折パターンの解釈を数学的に体系化し、複雑な結晶構造の解析を可能にしました。これにより、多くの材料の原子レベルでの構造が解明され、現代の材料科学の発展に不可欠な基盤が築かれたのです。

## 1.4 共変ベクトルと反変ベクトル

ここからは、より一般的な座標変換の観点から、ベクトルやテンソルの性質を議論するための「共変 (Covariant)」と「反変 (Contravariant)」の概念について学びます。これは、非直交座標系や曲がった空間（一般相対性理論など）を扱う際に特に重要となる数学的枠組みです。

### 1.4.1 格子変換とベクトルの変換則

前述の通り、異なる単位格子や座標系を考えることはしばしばあります。基底ベクトルの変換を例に、共変・反変の定義を導入しましょう。

新しい基底ベクトル $ \mathbf{a}'_i $ が古い基底ベクトル $ \mathbf{a}_j $ の線形結合で表されるとします。

$$ \mathbf{a}'_i = \sum_{j} t_{ij} \mathbf{a}_j $$

ここで $ \mathbf{T} = (t_{ij}) $ は基底変換行列です。
任意の位置ベクトル $ \mathbf{r} $ は、新しい座標系でも古い座標系でも同じ物理的実体を表します（不変量）。

$$ \mathbf{r} = \sum_{i} x^i \mathbf{a}_i = \sum_{i} x'^i \mathbf{a}'_i $$

この関係を用いて、座標成分 $ x^i $ と $ x'^i $ の間の変換則を導出します。

$$ \sum_{i} x'^i \left( \sum_{j} t_{ij} \mathbf{a}_j \right) = \sum_{j} x^j \mathbf{a}_j $$
$$ \sum_{j} \left( \sum_{i} x'^i t_{ij} \right) \mathbf{a}_j = \sum_{j} x^j \mathbf{a}_j $$

基底ベクトル $ \mathbf{a}_j $ が線形独立であるため、各係数は等しくなければなりません。

$$ x^j = \sum_{i} x'^i t_{ij} $$

これを $ x'^i $ について解くと、$ \mathbf{T}^{-1} $ を用いて次のように書けます。

$$ x'^i = \sum_{j} (T^{-1})_{ji} x^j $$

ここで $ (T^{-1})_{ji} $ は変換行列 $ \mathbf{T} $ の逆行列 $ \mathbf{T}^{-1} $ の $ j,i $ 成分を意味します。
まとめると、

*   **共変ベクトル (Covariant Vector)**: 基底ベクトルと同じ変換則 $ \mathbf{T} $ に従う成分を持つベクトル。添え字は下付きで表記されます（例: $ \mathbf{a}_i $, $ h_i $）。
    $$ \mathbf{a}'_i = \sum_{j} t_{ij} \mathbf{a}_j $$
    $$ h'_i = \sum_{j} t_{ij} h_j $$
*   **反変ベクトル (Contravariant Vector)**: 座標成分と同じ変換則 $ (\mathbf{T}^{-1})^t $ に従う成分を持つベクトル。添え字は上付きで表記されます（例: $ x^i $, $ \mathbf{a}^{*i} $）。
    $$ x'^i = \sum_{j} (T^{-1})_{ji} x^j $$
    $$ \mathbf{a}^{'*i} = \sum_{j} (T^{-1})_{ji} \mathbf{a}^{*j} $$

### 1.4.2 計量テンソル (Metric Tensor)

ベクトルの内積や長さ（ノルム）を計算する際に登場するのが**計量テンソル (Metric Tensor)** です。デカルト座標系では基底ベクトルが正規直交しているので、内積は単に各成分の積の和で計算できますが、一般座標系ではそうはいきません。

実格子の基底ベクトル $ \mathbf{a}_i $ を用いた計量テンソル $ g_{ij} $ は、基底ベクトルの内積として定義されます。

$$ g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j $$

この計量テンソルの成分が、座標変換に対してどのように変化するかを見てみましょう。新しい基底 $ \mathbf{a}'_i = \sum_k t_{ik} \mathbf{a}_k $ を用いると、新しい計量テンソル $ g'_{ij} $ は、

$$ g'_{ij} = \mathbf{a}'_i \cdot \mathbf{a}'_j = \left( \sum_k t_{ik} \mathbf{a}_k \right) \cdot \left( \sum_l t_{jl} \mathbf{a}_l \right) = \sum_{k,l} t_{ik} t_{jl} (\mathbf{a}_k \cdot \mathbf{a}_l) = \sum_{k,l} t_{ik} t_{jl} g_{kl} $$

となります。これは、計量テンソル $ g_{ij} $ が**2階共変テンソル (Covariant Tensor of Rank 2)** であることを示しています。つまり、その成分は共変ベクトルの成分と同じ変換行列 $ \mathbf{T} $ を2回作用させる形で変換されます。

同様に、逆格子の基底ベクトル $ \mathbf{a}^{*i} $ を用いた計量テンソル（**逆計量テンソル (Contravariant Metric Tensor)** とも呼ばれます） $ g^{ij} $ は、

$$ g^{ij} = \mathbf{a}^{*i} \cdot \mathbf{a}^{*j} $$

その変換則は、反変ベクトルの変換則に従います。

$$ g'^{ij} = \mathbf{a}^{'*i} \cdot \mathbf{a}^{'*j} = \left( \sum_k (T^{-1})_{ki} \mathbf{a}^{*k} \right) \cdot \left( \sum_l (T^{-1})_{lj} \mathbf{a}^{*l} \right) = \sum_{k,l} (T^{-1})_{ki} (T^{-1})_{lj} g^{kl} $$

これは、計量テンソル $ g^{ij} $ が**2階反変テンソル (Contravariant Tensor of Rank 2)** であることを示しています。

### 1.4.3 添え字の約束とアインシュタインの縮約記法

テンソル計算を簡潔にするため、**アインシュタインの縮約記法 (Einstein Summation Convention)** が広く用いられます。この記法には以下の規則があります。

1.  **共変成分の添え字は下付き ($ i $), 反変成分の添え字は上付き ($ i $) に書く。**
2.  **同じ添え字記号が上付きと下付きでペアになって現れた場合、その添え字について和を取る (Summation) ことを意味する。** この和の記号 $ \sum $ は省略される。

例: ベクトル $ \mathbf{r} = \sum_i x^i \mathbf{a}_i $ は、縮約記法では $ \mathbf{r} = x^i \mathbf{a}_i $ と書かれます。

この記法は、式の見通しを良くするだけでなく、テンソル成分の共変性・反変性を明確に示唆します。同じ添え字記号が上付きと下付きで現れるペアは「**縮約 (Contraction)**」と呼ばれ、その結果はスカラー（不変量）またはより低い階数のテンソルになります。

### 1.4.4 スカラー量の不変性：内積とノルム

物理法則は座標系の選び方によらず普遍的であるべきです。これは、物理量の中でも特に**スカラー (Scalar)** 量が座標変換に対して不変であることを意味します。

例えば、位置ベクトル $ \mathbf{r} $ の物理的な位置は、どの座標系を選んでも変わりません。

$$ \mathbf{r} = x^i \mathbf{a}_i = x'^i \mathbf{a}'_i $$

スライド16の数式が示すように、この関係を変換則を用いて展開すると、実際に恒等的に等しくなることが確認できます。

$$ x'^i \mathbf{a}'_i = \left( \sum_j (T^{-1})_{ji} x^j \right) \left( \sum_k t_{ik} \mathbf{a}_k \right) = \sum_{j,k} \left( \sum_i t_{ik} (T^{-1})_{ji} \right) x^j \mathbf{a}_k $$

ここで $ \sum_i t_{ik} (T^{-1})_{ji} $ は、行列 $ \mathbf{T} $ と $ \mathbf{T}^{-1} $ の積の $ k,j $ 成分であり、$ (\mathbf{T}\mathbf{T}^{-1})_{kj} = \delta_{kj} $ (クロネッカーのデルタ) となります。したがって、

$$ \sum_{j,k} \delta_{kj} x^j \mathbf{a}_k = \sum_j x^j \mathbf{a}_j $$

となり、元のベクトルに戻ることが分かります。これは、共変ベクトル成分と反変ベクトル成分の積が縮約されると、スカラー（不変量）になるというより一般的な法則の一部です。

同様に、ベクトルの長さの二乗（**ノルムの二乗**）もスカラー量です。位置ベクトル $ \mathbf{r} $ のノルムの二乗は、内積を用いて次のように定義されます。

$$ ||\mathbf{r}||^2 = \mathbf{r} \cdot \mathbf{r} = (x^i \mathbf{a}_i) \cdot (x^j \mathbf{a}_j) = x^i x^j (\mathbf{a}_i \cdot \mathbf{a}_j) = g_{ij} x^i x^j $$

縮約記法を用いると、上付きと下付きの添え字がペアになっているため、この結果がスカラー量であることが一目瞭然です。

### 1.4.5 計量テンソルによる共変・反変成分の相互変換

計量テンソル $ g_{ij} $ とその逆行列である反変計量テンソル $ g^{ij} $ は、共変成分と反変成分を相互に変換する役割を担います。

実格子ベクトル $ \mathbf{a}_j $ と逆格子ベクトル $ \mathbf{a}^{*i} $ の間の関係は、計量テンソルを用いて表現できます。

$$ \mathbf{a}^{*i} = g^{ij} \mathbf{a}_j $$
$$ \mathbf{a}_i = g_{ij} \mathbf{a}^{*j} $$

これは、計量テンソルが「添え字を上げ下げする演算子」として機能することを示します。
この関係式を逆格子ベクトルの定義 $ \mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j $ に代入すると、

$$ (g^{ik} \mathbf{a}_k) \cdot \mathbf{a}_j = g^{ik} (\mathbf{a}_k \cdot \mathbf{a}_j) = g^{ik} g_{kj} $$

そして、この値が $ \delta^i_j $ に等しいことから、

$$ g^{ik} g_{kj} = \delta^i_j $$

が導かれます。これは、行列 $ \mathbf{G} = (g_{ij}) $ と $ \mathbf{G}^{-1} = (g^{ij}) $ が互いに逆行列の関係にあることを意味します。したがって、**実格子ベクトルから逆格子ベクトルへの変換行列は、逆格子の計量テンソル（反変計量テンソル）$ g^{ij} $ と等しい**と言えます。スライド15の式はまさにこの関係を示しています。

### 1.4.6 微分操作における共変・反変性

微分操作もまた、共変性や反変性を変化させることがあります。
スカラー関数 $ F(x^i) $ を反変座標成分 $ x^i $ で偏微分することを考えます。新しい座標系での微分 $ \frac{\partial F}{\partial x'^i} $ は、連鎖律を用いて次のように変換されます。

$$ \frac{\partial F}{\partial x'^i} = \sum_j \frac{\partial x^j}{\partial x'^i} \frac{\partial F}{\partial x^j} $$

ここで、反変座標の変換則 $ x^j = \sum_k t^j_k x'^k $ (ここで $ t^j_k $ は $ (\mathbf{T}^{-1})^t $ の成分です) を用いると、
$ \frac{\partial x^j}{\partial x'^i} = t^j_i $ となります。したがって、

$$ \frac{\partial F}{\partial x'^i} = \sum_j t^j_i \frac{\partial F}{\partial x^j} $$

これは、偏微分 $ \frac{\partial F}{\partial x^j} $ が、共変ベクトルの変換則に従うことを示唆しています。
したがって、**スカラー関数を反変座標成分で微分すると、共変ベクトル成分が生成される**ことが分かります。一般的に、微分操作は添え字を下げ（共変成分を生成）、計量テンソルによる縮約は添え字を上げ下げする（共変成分を反変成分に変換する）と考えることができます。

### 1.4.7 物理法則の共変性

物理学において、方程式が「**共変形式 (Covariant Form)** である」とは、その方程式が座標変換によらず同じ形を保つことを意味します。これは、物理法則が特定の座標系の選択に依存しないという要請、すなわち「**対称性 (Symmetry)**」の表れです。

例えば、アインシュタインの**特殊相対性理論**における物理法則は、慣性系間の座標変換である**ローレンツ変換 (Lorentz Transformation)** に対して共変です。これにより、光速不変の原理が保証されます。さらに、**一般相対性理論**では、より一般的な座標変換（曲線座標系を含む）に対して共変な形式で物理法則が記述されます。これは、重力が時空の歪みとして現れるという、非常に革新的なアイデアに基づいています。

同様に、マックスウェルの方程式もローレンツ共変な形式で記述され、電磁気学の普遍性を示します。ニュートンの運動方程式は**ガリレイ変換 (Galilean Transformation)** に対して不変であり、これは**ガリレイ共変**と呼ばれます。

材料科学において、結晶の物性（弾性、誘電性、磁性など）はしばしばテンソルで記述されます。これらの物性テンソルも、結晶の対称性を考慮した上で、座標変換に対して共変な形式で表現される必要があります。これにより、材料の異方性などの特性が、測定方法や座標系の選び方によらず本質的に記述できるのです。

### 1.4.8 物性テンソルの共変・反変性

具体的な物性量を例に、そのテンソル成分が共変か反変か、あるいは混合テンソルかを判断する方法を見てみましょう。

1.  **電界ベクトル $ \mathbf{E} $**:
    電界ベクトル $ \mathbf{E} $ は、点電荷が受ける力の方向と大きさを表す物理量です。位置ベクトルと同様に、物理的な実体としては不変量です。もし基底ベクトルを $ \mathbf{e}_j $ とし、電界ベクトルを $ \mathbf{E} = E^j \mathbf{e}_j $ と表現する場合、その成分 $ E^j $ は通常**反変テンソル**成分として扱われます。

2.  **自由エネルギー $ G $ と誘電率テンソル $ \varepsilon_{ij} $**:
    結晶に電界を加えたときの自由エネルギー $ G $ はスカラー量です。外部電場によって誘起される分極を考慮すると、自由エネルギーは電界の2乗に比例する項を持つことがあります。

    $$ G = G_0 + \frac{1}{2} \sum_{i,j} \varepsilon_{ij} E^i E^j $$

    ここで $ G_0 $ は電界がないときの自由エネルギーです。この式が座標変換に対して不変であるためには、$ E^i $ が反変ベクトル成分である場合、$ \varepsilon_{ij} $ は**2階の共変テンソル**成分でなければなりません。なぜなら、反変成分と共変成分の縮約がスカラーを作るためです。つまり、$ \varepsilon_{ij} $ はスカラー量の反変テンソルによる2階微分によって得られるものと考えることができます。

3.  **歪テンソル $ \epsilon^i_j $**:
    結晶に外部応力が加わると、結晶は歪みます。歪みを記述する**歪テンソル (Strain Tensor)** は、変位勾配テンソルから導かれる物理量です。変位ベクトル $ \delta \mathbf{r} = \delta x^i \mathbf{a}_i $ を考えると、その座標微分は歪テンソルの成分に相当します。

    $$ \epsilon^i_j = \frac{\partial (\delta x^i)}{\partial x^j} $$

    この場合、$ \delta x^i $ は反変成分、$ x^j $ で微分すると共変成分が生成されるので、$ \epsilon^i_j $ は**混合テンソル (Mixed Tensor)**、具体的には1階反変・1階共変テンソルとして扱われます。

4.  **弾性テンソル $ C_{i}^{j}{_k}^{l} $**:
    応力 $ \sigma^{ij} $ と歪み $ \epsilon_{kl} $ の関係を記述する**弾性テンソル (Elastic Tensor)** は、材料の力学的性質を理解する上で非常に重要です。フックの法則の一般化として、自由エネルギーは歪みの2乗に比例する項を持ちます。

    $$ G = G_0 + \frac{1}{2} \sum_{i,j,k,l} C_{i}^{j}{_k}^{l} \epsilon^i_j \epsilon^k_l $$

    これはスカラー量であるため、各項の添え字の組み合わせは最終的に縮約されてスカラーになる必要があります。歪テンソルが混合テンソルであることを考慮すると、$ C_{i}^{j}{_k}^{l} $ は**4階の混合テンソル**として表現されます。
    実際には、応力テンソルは2階反変テンソル、歪テンソルは2階共変テンソルとして定義されることもあり、その場合、弾性テンソルは4階反変テンソル $ C^{ijkl} $ や4階共変テンソル $ C_{ijkl} $ となることもあります。定義に注意が必要です。

非直交座標系におけるベクトル解析、特に物性テンソルの取り扱いは、材料の異方性や複雑な応答を理論的に解析する上で非常に重要なツールとなります。
しかし、実際の材料におけるテンソル成分を実験的に決定したり、数値計算（VASPのような第一原理計算）で得られたデカルト座標系での結果と関連付けたりする際には、これらの座標変換とテンソル変換を正確に理解しておく必要があります。単結晶の場合、結晶軸に沿ったテンソル成分と対応付けられますが、多結晶材料の場合には、結晶方位の分布を考慮した平均化や、テンソルの対角化による主値解析が用いられます。

### 1.4.9 共変・反変成分の一般的な規則のまとめ

これまでの議論をまとめるために、共変・反変成分に関する一般的な規則を表に示します。

| 概念                     | 基底ベクトル | 座標成分 | 微分操作                         |
| :----------------------- | :----------- | :------- | :------------------------------- |
| **実空間**               | 共変 ($ \mathbf{a}_i $) | 反変 ($ x^i $) | スカラーを反変座標で微分すると共変 |
| **逆空間**               | 反変 ($ \mathbf{a}^{*i} $) | 共変 ($ h_i $) | スカラーを共変座標で微分すると反変 |

さらに、計量テンソル $ g_{ij} $ (共変) と $ g^{ij} $ (反変) は、共変成分と反変成分を相互に変換する役割を果たします。

### 1.4.10 共変座標と反変座標の幾何学的解釈

最後に、共変座標と反変座標の幾何学的な意味について補足します。
実格子の基本ベクトル $ \mathbf{a}_1, \mathbf{a}_2 $ を持つ2次元斜交座標系を考えましょう。任意の位置ベクトル $ \mathbf{r} $ は、反変座標 $ x^1, x^2 $ を用いて $ \mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2 $ と表されます。このとき、 $ x^1 $ や $ x^2 $ は、それぞれ $ \mathbf{a}_1 $ や $ \mathbf{a}_2 $ 方向に沿ってどれだけ進むかを示す成分です。これは「基底座標系」または「斜座標系」と呼ばれる描画に対応します。

一方、共変座標 $ x_1, x_2 $ を考えると、 $ \mathbf{r} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2} $ と書くことができます。しかし、実空間のベクトルを実格子の基底ベクトルで表す際には、反変座標が用いられるのが一般的です。共変座標は、ベクトルを反変基底ベクトル（逆格子ベクトル）の成分として表す場合、またはベクトルの成分をその基底ベクトルに正射影した値として捉える場合に現れます。

より直感的な解釈として、反変ベクトル成分 $ x^i $ は、基底ベクトル $ \mathbf{a}_i $ に平行な軸に沿って測定される「影」の長さ（スケール因子を含む）と考えることができます。一方、共変ベクトル成分 $ x_i $ は、基底ベクトル $ \mathbf{a}_i $ に直交する面への正射影の長さと考えることができます。

スライド26の図は、この概念を視覚的に示唆しています。
$ \mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2 $ は、基底ベクトルそのものに沿って測る斜座標系です。
$ \mathbf{r} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2} $ のように、逆格子ベクトルを基底とした座標系を考えると、これは実空間のベクトルを逆格子空間の基底で展開していることになります。
重要なのは、共変基底ベクトル $ \mathbf{a}_i $ と反変基底ベクトル $ \mathbf{a}^{*i} $ が、互いに異なるが補完的な方法で空間を記述するということです。そして、これらの基底ベクトルに対応する座標成分の変換則が、共変と反変の性質を決定するのです。