# 東京科学大学
## 総合研究院 元素戦略MDX研究センター フロンティア材料研究所
### 神谷利夫チュートリアル: 逆格子と共変・反変テンソル

---

# 前提と目標

## 前提
*   基本的な結晶学、結晶化学の知識

## 学習目標
*   ブラベー格子と基本格子の復習
*   単位格子は任意にとれる: 異なる単位格子間の変換を学ぶ
*   デカルト座標系と一般座標系の取り扱い: 基本ベクトルの変換と座標変換
*   単位格子の表現: 格子ベクトルと内部座標 (一般座標系)
*   単位格子の変換: 格子ベクトルの変換 (=> 内部座標の変換)
*   逆格子: 共変ベクトルと反変ベクトル

---

# 実格子と逆格子

---

# 逆格子の描き方

## 逆格子の基本ベクトル
*   実格子の基本ベクトルと逆格子の基本ベクトルは直交する:
    $$ \mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j $$
*   逆格子の長さは実格子の長さとは反比例に対応:
    $$ |\mathbf{a}^{*1}| \propto \frac{1}{|\mathbf{a}_1|} $$
*   逆格子の軸角は実格子の軸角の補角に対応 (限定的な場合)

## 逆格子の基本ベクトルの定義
$$ \mathbf{a}^{*1} = \frac{\mathbf{a}_2 \times \mathbf{a}_3}{V} $$
$$ \mathbf{a}^{*2} = \frac{\mathbf{a}_3 \times \mathbf{a}_1}{V} $$
$$ \mathbf{a}^{*3} = \frac{\mathbf{a}_1 \times \mathbf{a}_2}{V} $$
ここで $V = \mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)$ は実格子の単位胞体積。
（物理学では $2\pi$ を付けて定義する場合もある）

![スライド4の図1](images\slide4_image1.png)

![スライド4の図2](images\slide4_image2.png)

---

# 逆格子のBravais格子: 2D面心直方格子の例

*   実格子の取り方によって、導かれる逆格子が異なるように見える

    *   Bravais格子からスタート (図左上)
    *   Primitive格子からスタート (図右上)

*   「違う逆格子？？」という疑問

    *   **消滅則を考慮することで一意に決まる**


---

# 逆格子は実格子のFourier変換

## 逆格子の導入
*   **回折現象の記述**: X線、中性子、電子 (波) の干渉
*   **バンド理論**: 電子の干渉
*   **散乱理論**: 散乱振幅 $ S(\mathbf{k}) $ は電子密度 $ \rho(\mathbf{r}) $ のフーリエ変換
    $$ S(\mathbf{k}) = \int \rho(\mathbf{r}) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r} $$
*   単位胞内の原子配置 $ \rho_{\text{u.c.}}(\mathbf{r}) $ を考慮すると、
    $$ S(\mathbf{k}) = \sum_{n_1,n_2,n_3} \rho_{\text{u.c.}}(\mathbf{r} - (n_1\mathbf{a}_1+n_2\mathbf{a}_2+n_3\mathbf{a}_3)) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r} $$
*   **ブラッグ条件**: 散乱ベクトル $ \mathbf{k} $ が逆格子ベクトル $ \mathbf{G}_{hkl} $ に一致するとき、$ S(\mathbf{k}) $ が極大になる
    $$ \mathbf{k} = \mathbf{G}_{hkl} $$
*   物理的に意味があるのは $ S(\mathbf{G}_{hkl}) \neq 0 $ となる逆格子点のみ (消滅則を考慮)

![スライド6の図1](images\slide6_image1.png)

---

# 逆格子のBravais格子: 消滅則を考慮すれば一意に決まる

*   消滅則を考慮すると、逆格子のブラベー格子は一意に決まる
*   例えば2D面心直方格子 (実格子) の場合
    *   消滅則 (例: $h+k = \text{奇数}$ で消える逆格子点) を適用
    *   残る逆格子点は、元の実格子と同様に面心格子を形成する


---

# Bravais格子, 消滅則と逆格子

## 体心立方格子 (BCC)
*   格子点の座標: $ (0, 0, 0), (1/2, 1/2, 1/2) $
*   消滅しない指数: $ h + k + l = \text{偶数} $
*   この $ (h, k, l) $ は、逆格子空間において**面心立方格子 (FCC)** に対応

## 面心立方格子 (FCC)
*   格子点の座標: $ (0, 0, 0), (0, 1/2, 1/2), (1/2, 0, 1/2), (1/2, 1/2, 0) $
*   消滅しない指数: $ h, k, l $ が非混合 (すべて偶数 または すべて奇数)
*   この $ (h, k, l) $ は、逆格子空間において**体心立方格子 (BCC)** に対応

---

# 実格子と逆格子のBravais格子の関係

| 実格子           | 逆格子           |
| :--------------- | :--------------- |
| 単純格子 (P, H, R) | 単純格子 (P, H, R) |
| 面心格子 (FC)    | 体心格子 (BC)    |
| 体心格子 (BC)    | 面心格子 (FC)    |
| 底心格子 (A, B, C) | 底心格子 (A, B, C) |

---

# 実格子と逆格子

*   ロンボ面体晶の単位胞と逆格子単位胞の例

```python
python [data-COE]\crystal\crystal_draw_cell.py
```
Rhombohedral cell and reciprocal unit cell

![スライド10の図1](images\slide10_image1.png)

---

# 共変ベクトルと反変ベクトル

---

# 格子変換のまとめ: 共変ベクトルと反変ベクトルの定義

## 変換則の分類
*   **実格子ベクトルの変換 (共変ベクトル)**
    *   $ \mathbf{a}'_i = \sum_j t_{ij} \mathbf{a}_j $
    *   $ \mathbf{a}_i = \sum_j (T^{-1})_{ij} \mathbf{a}'_j $
*   **実格子座標の変換 (反変ベクトル)**
    *   $ x'^i = \sum_j (T^{-1})_{ji} x^j $
    *   $ x^i = \sum_j t_{ji} x'^j $
*   **逆格子ベクトルの変換 (反変ベクトル)**
    *   $ \mathbf{a}^{'*i} = \sum_j (T^{-1})_{ji} \mathbf{a}^{*j} $
    *   $ \mathbf{a}^{*i} = \sum_j t_{ji} \mathbf{a}^{'*j} $
*   **指数 (逆格子座標) の変換 (共変ベクトル)**
    *   $ h'_i = \sum_j t_{ij} h_j $
    *   $ h_i = \sum_j (T^{-1})_{ij} h'_j $

## 変換行列
*   変換行列は $ \mathbf{T} $: 実格子ベクトル、逆格子座標 (共変ベクトル)
*   変換行列は $ (\mathbf{T}^{-1})^t $: 実格子座標、逆格子ベクトル (反変ベクトル)

![スライド12の図1](images\slide12_image1.png)

![スライド12の図2](images\slide12_image2.png)

---

# 計量テンソル

*   計量テンソル $ g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j $ を座標変換:
    $$ g'_{ij} = \mathbf{a}'_i \cdot \mathbf{a}'_j = \sum_{k,l} t_{ik} t_{jl} g_{kl} $$
    *   $ g_{ij} $ は2階共変テンソル

*   逆計量テンソル $ g^{ij} = \mathbf{a}^{*i} \cdot \mathbf{a}^{*j} $ を座標変換:
    $$ g'^{ij} = \mathbf{a}^{'*i} \cdot \mathbf{a}^{'*j} = \sum_{k,l} (T^{-1})_{ki} (T^{-1})_{lj} g^{kl} $$
    *   $ g^{ij} $ は2階反変テンソル

![スライド13の図1](images\slide13_image1.png)

---

# 一般座標系 (実格子) => 一般座標系 (逆格子) 変換

## 格子ベクトルの変換則 (行列形式)
$$ \begin{pmatrix} \mathbf{a}'_1 \\ \mathbf{a}'_2 \\ \mathbf{a}'_3 \end{pmatrix} = \begin{pmatrix} t_{11} & t_{12} & t_{13} \\ t_{21} & t_{22} & t_{23} \\ t_{31} & t_{32} & t_{33} \end{pmatrix} \begin{pmatrix} \mathbf{a}_1 \\ \mathbf{a}_2 \\ \mathbf{a}_3 \end{pmatrix} $$
ここで $ \mathbf{T} = (t_{ij}) $ は格子ベクトル（基底ベクトル）の変換行列。

## 変換行列と計量テンソルの関係
$ \mathbf{a}'_i \cdot \mathbf{a}_j $ を考えると、
$$ (\mathbf{a}'_i \cdot \mathbf{a}_j) = \mathbf{T} \mathbf{G} $$
*   基底ベクトルを正規直交基底に変換する場合 $ \mathbf{a}'_i \cdot \mathbf{a}'_j = \delta_{ij} $
*   このとき、変換行列 $ \mathbf{T} $ と計量テンソル $ \mathbf{G} = (g_{ij}) $ の関係は $ \mathbf{T} \mathbf{G} \mathbf{T}^t = \mathbf{I} $ (単位行列)

![スライド14の図1](images\slide14_image1.png)

![スライド14の図2](images\slide14_image2.png)

![スライド14の図3](images\slide14_image3.png)

---

# 実格子 => 逆格子変換: 逆格子の計量テンソル

## 実格子ベクトルから逆格子ベクトルへの変換
*   実格子ベクトル $ \mathbf{a}_j $ を逆格子ベクトル $ \mathbf{a}^{*i} $ に変換する行列を $ (t_{ij}) $ とすると、
    $$ \mathbf{a}^{*i} = \sum_j t_{ij} \mathbf{a}_j $$
*   逆格子の定義 $ \mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j $ を利用すると、
    $$ \mathbf{a}^{*i} \cdot \mathbf{a}_j = \sum_k t_{ik} \mathbf{a}_k \cdot \mathbf{a}_j = \sum_k t_{ik} g_{kj} = \delta^i_j $$
*   この関係から、変換行列 $ (t_{ij}) $ は実格子の計量テンソル $ (g_{kj}) $ の逆行列であることがわかる:
    $$ (t_{ij}) = (g_{ij})^{-1} = (g^{ij}) $$
*   すなわち、**実格子ベクトルから逆格子ベクトルへの変換行列は、逆格子の計量テンソル (反変計量テンソル) $ g^{ij} $ である**。

![スライド15の図1](images\slide15_image1.png)

---

# 共変ベクトルと反変ベクトルの内積は Scalar になる

## 位置ベクトル $ \mathbf{r} $ の不変性
*   $ \mathbf{r} = x^i \mathbf{a}_i $ (反変座標 $ x^i $ と共変基底 $ \mathbf{a}_i $)
*   座標変換後も $ \mathbf{r} $ は同じ物理的実体を表すため、不変量 (Scalar) である。
    $$ \mathbf{r} = x^i \mathbf{a}_i = x'^i \mathbf{a}'_i $$
*   これは、反変成分と共変成分の積が縮約されるとスカラーになるという原則を示す。
    $$ x'^i \mathbf{a}'_i = \left( \sum_j (T^{-1})_{ji} x^j \right) \left( \sum_k t_{ik} \mathbf{a}_k \right) = \sum_{j,k} \left( \sum_i t_{ik} (T^{-1})_{ji} \right) x^j \mathbf{a}_k = \sum_{j,k} \delta_{kj} x^j \mathbf{a}_k = x^j \mathbf{a}_j $$

## 一般的な内積
*   共変ベクトル $ v_i $ と反変ベクトル $ w^j $ の内積 $ v_i w^i $ も不変量 (Scalar) になる。

![スライド16の図1](images\slide16_image1.png)

---

# 添え字の約束と縮約記法

## 規則
*   **共変成分の添え字は下付きに書く** (例: $ h_i $)
*   **反変成分の添え字は上付きに書く** (例: $ x^i $)
*   **アインシュタインの縮約記法**: 同じ添え字記号が上付きと下付きでペアになって現れた場合、その添え字について和を取る ( $ \sum $ を省略)

## 例
*   $ \sum_i x^i \mathbf{a}_i $ は $ x^i \mathbf{a}_i $ と簡略化して書く。
*   同じ添え字記号が上下に現れれば、その結果が不変量 (Scalar) であることが明確になる。

![スライド17の図1](images\slide17_image1.png)

---

# 添え字規則に則って書き直す

## 変換行列 $ \mathbf{T} $ に従って変換される場合: 共変ベクトル (添え字は下付)
## 変換行列 $ (\mathbf{T}^{-1})^t $ に従って変換される場合: 反変ベクトル (添え字は上付)

*   **実格子の基本ベクトル**: $ \mathbf{a}_i $ (共変ベクトル)
*   **実格子の座標**: $ x^i $ (反変ベクトル)
*   **実格子の計量テンソル**: $ g_{ij} $ (共変テンソル)
*   **逆格子の基本ベクトル**: $ \mathbf{a}^{*i} $ (反変ベクトル)
*   **逆格子の座標**: $ h_i $ (共変ベクトル)
*   **逆格子の計量テンソル**: $ g^{ij} $ (反変テンソル)

*   添え字の位置で区別できるので、実格子と逆格子の計量テンソルはそれぞれ $ g_{ij} $ と $ g^{ij} $ と書ける。

![スライド18の図1](images\slide18_image1.png)

---

# ノルムと計量テンソル

## ベクトル $ \mathbf{r} = x^j \mathbf{a}_j $ のノルムの二乗
$$ ||\mathbf{r}||^2 = \mathbf{r} \cdot \mathbf{r} = (x^i \mathbf{a}_i) \cdot (x^j \mathbf{a}_j) = (\mathbf{a}_i \cdot \mathbf{a}_j) x^i x^j = g_{ij} x^i x^j $$

*   添え字 $ i, j $ が縮約されて消えるため、ノルムの二乗は不変量 (Scalar) であることが確認できる。

![スライド19の図1](images\slide19_image1.png)

---

# 方程式の共変性

*   方程式の左辺と右辺が同じ型（同じ添字構造）のテンソルであれば、両辺が同じ変換則に従うことが自明。
    *   **「方程式は座標変換に対して共変 (共変形式である)」** という。
*   物理法則は何らかの対称性を満たすことが要請される:
    *   共変形式のテンソル方程式で表現できる
*   例:
    *   特殊相対性理論、Maxwellの方程式: Lorentz共変
    *   一般相対性理論: 一般共変
    *   超弦理論: Lorentz共変、超対称性不変など
    *   Newtonの運動方程式: Galilei不変

---

# 未知のベクトル・テンソル成分の共変・反変の判断

*   共変な方程式に添え字規則を使うと、未知のベクトル・テンソル成分が共変か反変か判断できる。

## 例1: 実格子ベクトルの変換行列 $ \mathbf{T} $
*   $ \mathbf{a}'_i = \sum_j t_{ij} \mathbf{a}_j $ (あるいは縮約記法で $ \mathbf{a}'_i = t_{i}^{j} \mathbf{a}_j $)
*   $ \mathbf{a}'_i $ も $ \mathbf{a}_j $ も共変ベクトル。
*   方程式が共変形式になるためには、変換行列の成分 $ t_{i}^{j} $ は1階共変・1階反変の**混合テンソル**として振る舞う。

## 例2: 逆格子ベクトルの変換行列
*   同様に、逆格子ベクトルを変換する行列の成分 $ t^{i}_{j} $ は反変・共変の混合テンソルとして振る舞う。

![スライド21の図1](images\slide21_image1.png)

---

# 計量テンソルは共変成分 $ \leftrightarrow $ 反変成分を変換する

## 以前に証明した結果
*   実格子ベクトルから逆格子ベクトルへの変換行列は、逆格子の計量テンソル $ g^{ij} $ である。
    *   $ \mathbf{a}^{*i} = g^{ij} \mathbf{a}_j $
    *   $ \mathbf{a}^{*i} $ は逆格子ベクトルであり、反変ベクトル。
    *   $ \mathbf{a}_j $ は実格子ベクトルであり、共変ベクトル。
*   計量テンソル $ g^{ij} $ をかけることで、共変ベクトル成分を反変ベクトル成分に変換できる。

## 計量テンソルと逆計量テンソルの関係
*   逆格子ベクトルの定義 $ \mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j $ (クロネッカーのデルタ)
*   これに $ \mathbf{a}^{*i} = g^{ik} \mathbf{a}_k $ を代入すると、
    $$ g^{ik} \mathbf{a}_k \cdot \mathbf{a}_j = g^{ik} g_{kj} = \delta^i_j $$
*   この関係は、$ g^{ik} $ が $ g_{kj} $ の逆行列であることを示している。
    *   計量テンソル $ g_{ij} $ と逆計量テンソル $ g^{ij} $ は互いに逆の関係にある。

![スライド22の図1](images\slide22_image1.png)

---

# 共変成分と反変成分: 微分

## スカラー関数 $ F(x^i) $ の座標微分
*   スカラー $ F(x^i) $ を反変座標 $ x^i $ で偏微分する $ \frac{\partial F}{\partial x^i} $
*   新しい座標系での微分 $ \frac{\partial F}{\partial x'^i} $ は連鎖律で変換:
    $$ \frac{\partial F}{\partial x'^i} = \sum_j \frac{\partial x^j}{\partial x'^i} \frac{\partial F}{\partial x^j} $$
*   座標変換 $ x^j = \sum_k t^j_k x'^k $ (ここで $ t^j_k $ は $ (\mathbf{T}^{-1})^t $ の成分) より、
    $$ \frac{\partial x^j}{\partial x'^i} = t^j_i $$
*   したがって、
    $$ \frac{\partial F}{\partial x'^i} = \sum_j t^j_i \frac{\partial F}{\partial x^j} $$
*   これは、$ \frac{\partial F}{\partial x^j} $ が共変ベクトルの変換則に従うことを示す。
    *   **スカラーを反変成分で微分すると共変ベクトルになる。**

![スライド23の図1](images\slide23_image1.png)

---

# 共変成分と反変成分: 物性テンソル

## 不変量 (Scalar) を既知の共変・反変成分で表すことで判別できる。
*   **電界ベクトル $ \mathbf{E} $**:
    *   $ \mathbf{E} = E^j \mathbf{e}_j $ と表現される場合、電界ベクトル成分 $ E^j $ は**反変テンソル**。
*   **自由エネルギー $ G $ と誘電率テンソル $ \varepsilon_{ij} $**:
    *   $ G = G_0 + \frac{1}{2} \varepsilon_{ij} E^i E^j $
    *   $ E^i $ が反変テンソルなので、$ \varepsilon_{ij} $ は**2階の共変テンソル**。
*   **歪テンソル $ \epsilon^i_j $**:
    *   変位の微分 $ \epsilon^i_j = \frac{\partial (\delta x^i)}{\partial x^j} $
    *   反変成分を共変成分で微分しているので、1階反変・1階共変の**混合テンソル**。
*   **弾性テンソル $ C_{i}^{j}{_k}^{l} $**:
    *   自由エネルギー $ G = G_0 + \frac{1}{2} C_{i}^{j}{_k}^{l} \epsilon^i_j \epsilon^k_l $
    *   歪テンソルが混合テンソルなので、$ C_{i}^{j}{_k}^{l} $ は**4階の混合テンソル**。

## 非直交座標系のベクトル解析は理論解析で重要
*   単結晶ならテンソル成分と対応付けられる
*   多結晶の場合、対角化して主値の平均で対応づけられる
*   理論計算 (VASP など) ではデカルト座標に関するテンソルを出力している

![スライド24の図1](images\slide24_image1.png)

---

# 共変成分と反変成分: 一般的な規則

## まとめ表
| カテゴリ   | 基底ベクトル | 座標成分 | 微分                       |
| :--------- | :----------- | :------- | :------------------------- |
| 実空間     | 共変 ($ \mathbf{a}_i $) | 反変 ($ x^i $) | スカラーを反変座標で微分 => 共変 |
| 逆空間     | 反変 ($ \mathbf{a}^{*i} $) | 共変 ($ h_i $) | スカラーを共変座標で微分 => 反変 |

*   計量テンソル $ g_{ij} $ と $ g^{ij} $ により、共変成分と反変成分を相互に変換できる。

![スライド25の図1](images\slide25_image1.png)

---

# 共変座標と反変座標は同じ基底ベクトルで異なる座標の取り方に当たる

*   **反変座標 ($ x^1, x^2 $) と共変基底 ($ \mathbf{a}_1, \mathbf{a}_2 $)**
    *   $ \mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2 $
    *   基底ベクトルに沿った「斜座標系」または「基底座標系」

*   **共変座標 ($ x_1, x_2 $) と反変基底 ($ \mathbf{a}^{*1}, \mathbf{a}^{*2} $)**
    *   $ \mathbf{r} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2} $ (実空間ベクトルを逆格子基底で展開)
    *   **正射影座標系**: 各軸への正射影として成分を捉える

*   実空間 (共変基底ベクトル) に対応するのは基底座標系。
*   逆空間 (反変基底ベクトル) に対応するのは正射影座標系。

![スライド26の図1](images\slide26_image1.png)