# 材料科学のための結晶学入門：逆格子とテンソル解析

## 序論

本講義では、材料科学において極めて重要な概念である「逆格子（reciprocal lattice）」と、それを理解するための数学的枠組みである「共変（covariant）」および「反変（contravariant）テンソル」について深く掘り下げていきます。これらの概念は、X線回折などの回折現象の解析、固体物理学におけるバンド理論、さらには一般的な物理法則の記述において不可欠です。

特に、音声認識による誤字・誤変換を修正し、「逆格子」「実格子」「計量テンソル」「クロネッカーデルタ」「三斜晶」「フーリエ変換」「アインシュタインの縮約記法」「誘電率テンソル」「弾性テンソル」といった専門用語を正確に用いて解説します。数式の導出も丁寧に追い、物理的な意味合いを深く理解できるよう努めます。

### 学習目標

*   ブラベー格子と単位格子の概念を復習し、異なる単位格子間の変換ルールを理解する。
*   デカルト座標系と一般座標系（斜交座標系）の取り扱いを習得し、基底ベクトルと座標の変換則を把握する。
*   逆格子の定義、作図法、そして実格子との関係性を物理的な観点から理解する。
*   共変ベクトル、反変ベクトル、計量テンソルの定義とその変換則を学び、アインシュタインの縮約記法を使いこなせるようになる。
*   物性テンソルの共変性・反変性を判別し、非直交座標系におけるテンソル解析の基礎を確立する。

## 1. 逆格子（Reciprocal Lattice）の基礎

### 1.1 逆格子の定義と性質

実空間における結晶格子（実格子）は、3つの基本ベクトル $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$ によって記述されます。これらの基本ベクトルによって張られる単位胞の体積 $V$ は、次のように定義されます。

$$ V = \mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3) $$

逆格子は、実格子の基本ベクトル $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$ から、次の関係式によって定義される3つの逆格子基本ベクトル $\mathbf{a}^*_1, \mathbf{a}^*_2, \mathbf{a}^*_3$ によって構成されます。

$$ \mathbf{a}^*_1 = \frac{\mathbf{a}_2 \times \mathbf{a}_3}{V} $$
$$ \mathbf{a}^*_2 = \frac{\mathbf{a}_3 \times \mathbf{a}_1}{V} $$
$$ \mathbf{a}^*_3 = \frac{\mathbf{a}_1 \times \mathbf{a}_2}{V} $$

これらの逆格子基本ベクトルは、実格子の基本ベクトルと以下の**クロネッカーのデルタ** $\delta_{ij}$ を用いた直交関係を満たします。

$$ \mathbf{a}^*_i \cdot \mathbf{a}_j = \delta_{ij} $$

ここで $\delta_{ij}$ は、$i=j$ のときに1、$i \neq j$ のときに0となる量です。これは、$\mathbf{a}^*_1$ は $\mathbf{a}_1$ に平行（または直交せず）に、$\mathbf{a}_2$ と $\mathbf{a}_3$ が張る平面に垂直であり、他のベクトルについても同様であることを意味します。

### 1.2 逆格子の作図法と幾何学的関係

逆格子の基本ベクトルは、実格子の基本ベクトルと以下の幾何学的関係を持ちます。

1.  **直交性**: $\mathbf{a}^*_1$ は $\mathbf{a}_2$ と $\mathbf{a}_3$ の両方に直交します。これは $\mathbf{a}_2 \times \mathbf{a}_3$ が $\mathbf{a}_2$ と $\mathbf{a}_3$ が張る平面に垂直であることから明らかです。同様に、$\mathbf{a}^*_2$ は $\mathbf{a}_3$ と $\mathbf{a}_1$ に、$\mathbf{a}^*_3$ は $\mathbf{a}_1$ と $\mathbf{a}_2$ に直交します。
2.  **長さ**: 逆格子ベクトルの長さは、実格子ベクトルの長さの逆数に比例します。例えば、
    $$ |\mathbf{a}^*_1| = \frac{|\mathbf{a}_2 \times \mathbf{a}_3|}{V} = \frac{\text{Area}(\mathbf{a}_2, \mathbf{a}_3)}{V} $$
    であり、これは $\mathbf{a}_1$ に垂直な面間隔 $d$ の逆数に相当します。すなわち、$|\mathbf{a}^*_1| \approx 1/|\mathbf{a}_1|$ のような反比例関係にあります。
3.  **軸角**: 逆格子の軸角は、実格子の軸角の補角に対応することが多いですが、三斜晶系のような非直交座標系ではより複雑な関係になります。例えば、実格子の軸角が $\alpha, \beta, \gamma$ であるとき、逆格子の軸角は $\alpha^*, \beta^*, \gamma^*$ となります。

**作図例**: 二次元のブラベー格子（面心直方格子）を例に取ると、実格子の基本ベクトル $\mathbf{a}_1, \mathbf{a}_2$ が与えられたとき、逆格子基本ベクトル $\mathbf{a}^*_1, \mathbf{a}^*_2$ を描くことができます。
*   $\mathbf{a}^*_1$ は $\mathbf{a}_2$ に直交する方向に描かれ、その長さは $|\mathbf{a}_2|$ に反比例します。
*   $\mathbf{a}^*_2$ は $\mathbf{a}_1$ に直交する方向に描かれ、その長さは $|\mathbf{a}_1|$ に反比例します。

![スライド4の図1](images\slide4_image1.png)
![スライド4の図2](images\slide4_image2.png)

### 1.3 逆格子の一意性とフーリエ変換

逆格子は、実格子の**フーリエ変換**として理解されます。この視点は、X線回折や電子回折といった回折現象、あるいは固体中の電子の運動を記述するバンド理論において極めて重要です。これらの現象は、X線や電子といった波が結晶中で干渉し、特定の方向にのみ強く散乱されることで観測されます。

#### 1.3.1 散乱理論とフーリエ変換

散乱理論において、散乱波の振幅 $S(\mathbf{k})$ は、結晶の電子密度分布 $\rho(\mathbf{r})$ のフーリエ変換として記述されます。

$$ S(\mathbf{k}) = \int \rho(\mathbf{r}) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r} $$

ここで $\mathbf{k}$ は散乱ベクトル（波数ベクトル）です。結晶のような周期構造を持つ物質の場合、電子密度 $\rho(\mathbf{r})$ も周期的です。このとき、散乱振幅 $S(\mathbf{k})$ が大きく（極大に）なるのは、散乱ベクトル $\mathbf{k}$ が実格子の逆格子ベクトル $\mathbf{G}_{hkl}$ に一致する場合のみです。

$$ \mathbf{k} = \mathbf{G}_{hkl} = h\mathbf{a}^*_1 + k\mathbf{a}^*_2 + l\mathbf{a}^*_3 $$

ここで、$h, k, l$ はミラー指数と呼ばれる整数です。この条件は**ブラッグの条件**（あるいはラウエの条件）に対応し、X線回折における「回折ピーク」の発生条件そのものです。

$$ 2d_{hkl} \sin\theta = n\lambda $$

ブラッグの法則は、波が結晶の面 $(hkl)$ で反射される現象と解釈できます。ここで $d_{hkl}$ は $(hkl)$ 面の面間隔です。逆格子の観点から見ると、逆格子点 $\mathbf{G}_{hkl}$ が $1/d_{hkl}$ の大きさを持つベクトルであるため、ブラッグ条件は散乱ベクトルが逆格子ベクトルに等しくなるという、より一般的な形で表現されます。

このようなことから、物理的に意味があるのは $S(\mathbf{G}_{hkl}) \neq 0$ となる逆格子点のみであることが分かります。

#### 1.3.2 消滅則と逆格子のブラベー格子

結晶構造によっては、特定のミラー指数 $(hkl)$ を持つ回折ピークが観測されないことがあります。これは**消滅則（extinction rule）**と呼ばれ、単位胞内の原子配置によって結晶構造因子 $S(\mathbf{G}_{hkl})$ がゼロになる場合に起こります。

例えば、**体心立方格子（BCC）**では、$h+k+l$ が奇数の逆格子点は消滅し、偶数の逆格子点のみが残ります。これにより、BCCの実格子に対する逆格子は**面心立方格子（FCC）**となります。

一方、**面心立方格子（FCC）**では、$h, k, l$ がすべて偶数か、すべて奇数（非混合）の場合のみ回折ピークが観測され、それ以外の混合指数の逆格子点は消滅します。これにより、FCCの実格子に対する逆格子は**体心立方格子（BCC）**となります。

**なぜこのような消滅則が重要なのでしょうか？**
文字起こしテキストにもあったように、実格子の基本ベクトルをどのように選ぶかによって、見かけ上の逆格子点の配列が異なるという問題が生じます。しかし、消滅則を考慮することで、物理的に意味のある逆格子点の配列は一意に決まります。例えば、ブラベー格子からスタートして逆格子を作図した場合と、単位胞の基本ベクトルからスタートした場合とで異なる逆格子点がプロットされるように見えても、消滅則を適用すれば、最終的に得られる逆格子点の集合は一致します。

![スライド6の図1](images\slide6_image1.png)

このように、逆格子は実格子のフーリエ変換であり、その物理的な意味は回折現象と深く結びついています。消滅則は、結晶の内部構造を反映した重要な情報であり、逆格子解析に不可欠です。

以下の表に、主要なブラベー格子とそれに対応する逆格子の関係を示します。

| 実格子ブラベー格子 | 逆格子ブラベー格子 |
| :----------------- | :----------------- |
| 単純格子 (P, H, R) | 単純格子 (P, H, R) |
| 面心格子 (FC)     | 体心格子 (BC)     |
| 体心格子 (BC)     | 面心格子 (FC)     |
| 底心格子 (A, B, C) | 底心格子 (A, B, C) |

この対応関係は、結晶学の分野で非常に重要です。例えば、python の `crystal_draw_cell.py` のようなプログラムは、この関係を視覚的に理解するのに役立ちます。

![スライド10の図1](images\slide10_image1.png)

## 2. 共変ベクトルと反変ベクトル

### 2.1 座標変換におけるベクトルのふるまい

結晶学では、必ずしも直交座標系ばかりを扱うわけではありません。一般の斜交座標系（一般座標系）を扱うことが多く、その際には座標変換の概念が不可欠です。基底ベクトルと座標の変換則を理解することが、共変ベクトルと反変ベクトルの理解の出発点となります。

前回の講義で、格子変換のルールについてまとめました。
実格子の基本ベクトル $\mathbf{a}_i$ が変換行列 $T = (t_{ij})$ によって新しい基本ベクトル $\mathbf{a}'_i$ に変換されるとき、
$$ \mathbf{a}'_i = \sum_j t_{ij} \mathbf{a}_j $$
と書けます。逆に、
$$ \mathbf{a}_j = \sum_i (T^{-1})_{ji} \mathbf{a}'_i $$
となります。

一方、実空間の座標 $x^i$ は、変換行列 $T$ の転置の逆行列 $(T^T)^{-1}$ を使って変換されます。
$$ x'^i = \sum_j ((T^T)^{-1})_{ij} x^j = \sum_j (T^{-1})_{ji} x^j $$
と書けます。ここで、$x^i$ は座標の成分を表します。

これらの変換則は、基底ベクトルと座標が互いに逆の振る舞いをすることを示唆しています。この違いを明確にするために導入されるのが、共変ベクトルと反変ベクトルという概念です。

#### 定義

*   **共変ベクトル (Covariant Vector)**: 基底ベクトルと同じ変換規則に従うベクトル。
    *   **例**: 実格子の基本ベクトル $\mathbf{a}_i$、逆格子の座標（ミラー指数）$h_i$
    *   これらは変換行列 $T$ によって変換されます。
*   **反変ベクトル (Contravariant Vector)**: 基底ベクトルとは逆の変換規則に従うベクトル（より正確には、座標と同じ変換規則に従う）。
    *   **例**: 実格子の座標 $x^i$、逆格子の基本ベクトル $\mathbf{a}^{*i}$
    *   これらは変換行列 $T$ の転置の逆行列 $(T^T)^{-1}$ によって変換されます。

![スライド12の図1](images\slide12_image1.png)
![スライド12の図2](images\slide12_image2.png)

### 2.2 計量テンソル (Metric Tensor)

計量テンソルは、ベクトルの長さや内積を計算するために用いられる重要なテンソルです。一般座標系において、その成分は基底ベクトルの内積によって定義されます。

#### 2.2.1 共変計量テンソル $g_{ij}$

実格子の計量テンソルは、実格子の基本ベクトル $\mathbf{a}_i$ と $\mathbf{a}_j$ の内積として定義されます。

$$ g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j $$

この計量テンソルが座標変換に対してどのように振る舞うかを見てみましょう。新しい座標系での計量テンソル $g'_{ij}$ は、変換された基本ベクトル $\mathbf{a}'_i, \mathbf{a}'_j$ の内積で定義されます。

$$ g'_{ij} = \mathbf{a}'_i \cdot \mathbf{a}'_j $$

ここで、$\mathbf{a}'_i = \sum_k t_{ik} \mathbf{a}_k$ と $\mathbf{a}'_j = \sum_l t_{jl} \mathbf{a}_l$ を代入すると、

$$ g'_{ij} = \left( \sum_k t_{ik} \mathbf{a}_k \right) \cdot \left( \sum_l t_{jl} \mathbf{a}_l \right) = \sum_{k,l} t_{ik} t_{jl} (\mathbf{a}_k \cdot \mathbf{a}_l) = \sum_{k,l} t_{ik} t_{jl} g_{kl} $$

この変換則は、共変ベクトルの変換行列 $T$ を2つ使って変換される形になっています。したがって、$g_{ij}$ は**2階の共変テンソル**であると言えます。

![スライド13の図1](images\slide13_image1.png)

#### 2.2.2 反変計量テンソル $g^{ij}$

逆格子の計量テンソルは、逆格子の基本ベクトル $\mathbf{a}^{*i}$ と $\mathbf{a}^{*j}$ の内積として定義されます。添え字の上付き/下付き規則は後述しますが、ここでは一般的な表記として $g^{ij}$ を用います。

$$ g^{ij} = \mathbf{a}^{*i} \cdot \mathbf{a}^{*j} $$

同様に、このテンソルの変換則を調べると、反変ベクトルの変換則に従うことになります。

$$ g'^{ij} = \mathbf{a}^{*'i} \cdot \mathbf{a}^{*'j} = \left( \sum_k ((T^T)^{-1})_{ik} \mathbf{a}^{*k} \right) \cdot \left( \sum_l ((T^T)^{-1})_{jl} \mathbf{a}^{*l} \right) = \sum_{k,l} ((T^{-1})_{ki}) ((T^{-1})_{lj}) g^{kl} $$

したがって、$g^{ij}$ は**2階の反変テンソル**であると言えます。

### 2.3 実格子から逆格子への変換行列

実格子の基本ベクトル $\mathbf{a}_i$ から逆格子の基本ベクトル $\mathbf{a}^{*i}$ への変換は、非常に重要な関係を持っています。
前のセクションで、逆格子基本ベクトルが実格子基本ベクトルと直交することを示しました。
$$ \mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j $$
ここで、$\mathbf{a}^{*i}$ を実格子基本ベクトル $\mathbf{a}_j$ を用いて表す変換行列 $T_{ij}$ を考えると、

$$ \mathbf{a}^{*i} = \sum_j T^{ij} \mathbf{a}_j $$

この式と、両辺に $\mathbf{a}_k$ を内積としてとった場合、
$$ \mathbf{a}^{*i} \cdot \mathbf{a}_k = \delta^i_k $$
$$ \left( \sum_j T^{ij} \mathbf{a}_j \right) \cdot \mathbf{a}_k = \sum_j T^{ij} (\mathbf{a}_j \cdot \mathbf{a}_k) = \sum_j T^{ij} g_{jk} $$
となります。したがって、
$$ \sum_j T^{ij} g_{jk} = \delta^i_k $$
これは、行列の形で書くと、$T \mathbf{G} = I$ となり、$T = \mathbf{G}^{-1}$ を意味します。
ここで $\mathbf{G}$ は計量テンソルの行列 $(g_{jk})$、 $I$ は単位行列です。

また、私たちは $g^{ik} = \sum_j \mathbf{a}^{*i} \cdot \mathbf{a}^{*j}$ から、
$$ \sum_k g^{ik} g_{kj} = \delta^i_j $$
という関係も知っています。これは、反変計量テンソル $(g^{ij})$ が共変計量テンソル $(g_{ij})$ の逆行列であることを示しています。

これらの関係から、**実格子ベクトルを逆格子ベクトルに変換する変換行列は、逆格子の計量テンソル、すなわち実格子の計量テンソルの逆行列に等しい**ことがわかります。

$$ (T^{ij}) = (g_{ij})^{-1} = (g^{ij}) $$

この関係は、非直交座標系におけるベクトルやテンソルの計算において非常に便利です。

### 2.4 共変ベクトルと反変ベクトルの内積は不変量（スカラー）になる

共変ベクトルと反変ベクトルの積は、常に不変量（スカラー）となります。この性質は、物理法則の記述において極めて重要です。

あるベクトル $\mathbf{r}$ を考えます。これを一般座標系で表現すると、反変座標 $x^i$ と共変基本ベクトル $\mathbf{a}_i$ を使って次のように書けます。
$$ \mathbf{r} = \sum_i x^i \mathbf{a}_i $$
このベクトル $\mathbf{r}$ が座標変換に対して不変量であることは自明です。新しい座標系で $\mathbf{r}$ を表現すると、$\mathbf{a}'_i$ と $x'^i$ を使って $\mathbf{r} = \sum_i x'^i \mathbf{a}'_i$ となります。これが元の表現と等しいことを確認しましょう。

$$ \sum_i x'^i \mathbf{a}'_i = \sum_i \left( \sum_l (T^{-1})_{li} x^l \right) \left( \sum_k t_{ik} \mathbf{a}_k \right) $$
$$ = \sum_{k,l} x^l \mathbf{a}_k \left( \sum_i (T^{-1})_{li} t_{ik} \right) $$

ここで、括弧内の項 $\sum_i (T^{-1})_{li} t_{ik}$ は、行列 $(T^{-1})_{li}$ の行 $l$ と行列 $(t_{ik})$ の列 $k$ の積に対応します。これは行列の積 $(T^{-1} T)_{lk}$ を意味し、単位行列の成分 $\delta_{lk}$ となります。
$$ \sum_i (T^{-1})_{li} t_{ik} = \delta_{lk} $$
したがって、
$$ \sum_i x'^i \mathbf{a}'_i = \sum_{k,l} x^l \mathbf{a}_k \delta_{lk} = \sum_k x^k \mathbf{a}_k $$
となり、ベクトル $\mathbf{r}$ が座標変換に対して不変量であることが再確認されます。

この性質は、他の任意の共変ベクトル $\mathbf{v}_i$ と反変ベクトル $w^j$ の内積にも当てはまります。その内積はスカラー不変量となります。

### 2.5 添え字の約束とアインシュタインの縮約記法

共変ベクトルと反変ベクトルの概念を導入することで、テンソル計算が非常に整理されます。この整理をさらに進めるために、**添え字（index）**に関する明確な約束を設けます。

#### 規則

1.  **共変ベクトルの添え字は下付きに書く**：例: $\mathbf{a}_i$, $g_{ij}$
2.  **反変ベクトルの添え字は上付きに書く**：例: $x^i$, $\mathbf{a}^{*i}$, $g^{ij}$
3.  **共変成分と反変成分の間で和を取ると、不変量（スカラー）になる**：
    例えば、$\sum_i x^i \mathbf{a}_i$ や $\sum_{i,j} g_{ij} x^i x^j$ のように、上付き添え字と下付き添え字がペアで現れる場合です。

#### アインシュタインの縮約記法 (Einstein Summation Convention)

この規則を利用して、アルバート・アインシュタインは相対性理論を展開する際に、特別な簡略化記法を提案しました。それが**アインシュタインの縮約記法**です。

*   **同じ添え字記号が上と下にペアで現れる場合、その添え字についての和を取ることを明示的な和記号 $\sum$ なしで表現する**。
    *   例: $\mathbf{r} = \sum_i x^i \mathbf{a}_i$ は、$x^i \mathbf{a}_i$ と簡略化して書くことができます。

この記法は、方程式を見ただけで、どの添え字について和が取られているか、そして結果がスカラー不変量になるか（全ての添え字がペアで消えた場合）、あるいはどの型のテンソルになるか（残った添え字の型と数で判断）が一目でわかるという利点があります。

#### 添え字規則に従った量の分類

これまでの議論を、この添え字規則に従って書き直してみましょう。

*   **変換行列 $T$ によって変換される量（共変）**: 添え字は下付き。
    *   実格子の基本ベクトル: $\mathbf{a}_i$
    *   実格子の計量テンソル: $g_{ij}$
    *   逆格子の座標（ミラー指数）: $h_i$

*   **変換行列 $T$ の転置の逆行列 $(T^T)^{-1}$ によって変換される量（反変）**: 添え字は上付き。
    *   実格子の座標: $x^i$
    *   逆格子の基本ベクトル: $\mathbf{a}^{*i}$
    *   逆格子の計量テンソル: $g^{ij}$

特に、逆格子の計量テンソルは $g^{ij}$ と書くことで、実格子の計量テンソル $g_{ij}$ とは異なる種類のテンソルであることを添え字の位置だけで明確に区別できます。

#### ノルムと計量テンソル

アインシュタインの縮約記法を用いると、ベクトルの長さ（ノルム）の二乗が不変量スカラーであることがすぐにわかります。
ベクトル $\mathbf{r}$ のノルムの二乗は、$\mathbf{r} \cdot \mathbf{r}$ で与えられます。

$$ ||\mathbf{r}||^2 = \mathbf{r} \cdot \mathbf{r} = (x^i \mathbf{a}_i) \cdot (x^j \mathbf{a}_j) = x^i x^j (\mathbf{a}_i \cdot \mathbf{a}_j) = g_{ij} x^i x^j $$

ここで、$g_{ij}$ は2階の共変テンソル（下付き添え字が2つ）であり、$x^i, x^j$ は反変ベクトル（上付き添え字が2つ）です。アインシュタインの縮約記法では、上付きの $i, j$ と下付きの $i, j$ がそれぞれペアになっているため、全ての添え字が消え、結果はスカラーになります。これは、ベクトルの長さが座標変換に依存しない不変量であるという物理的直感を数学的に明確に示しています。

![スライド19の図1](images\slide19_image1.png)

### 2.6 方程式の共変性

物理学において、ある方程式が「共変である」とは、その方程式が座標変換を行っても、その形式が変わらないことを意味します。この概念は、物理法則がどのような座標系で記述されても、その本質的な関係性が維持されるべきであるという要請から生まれています。

*   **定義**: 方程式の左辺と右辺が同じ型のテンソル（同じ添え字構造）であれば、両辺が同じ変換則に従うことが自明であり、その方程式は座標変換に対して共変であると言えます。

物理法則は、何らかの対称性（空間の並進対称性、回転対称性、ローレンツ変換対称性など）を満たすことが要請されます。共変形式のテンソル方程式で表現することで、この対称性を一目で確認できる利点があります。

**歴史と例**:
*   **特殊相対性理論**: アルバート・アインシュタインが1905年に発表した特殊相対性理論は、**ローレンツ変換**に対して共変な物理法則を記述します。これにより、光速度不変の原理が保証されます。マックスウェルの方程式もローレンツ共変です。
*   **一般相対性理論**: 1915年の一般相対性理論では、さらに進んで**任意の一般座標変換**に対して共変な理論として構築されました。これにより、重力を時空の曲がりとして記述することが可能になりました。
*   **超弦理論**: 素粒子の統一理論を目指す超弦理論では、ローレンツ共変性に加えて、**超対称性変換**に対して不変であることが要請されます。最終的な方程式は、出発点となるラグランジアンがこれらの対称性を満たすように設計されます。

このように、方程式の共変性は、物理法則が持つ対称性を表現する上で不可欠な概念です。

### 2.7 未知のベクトル・テンソル成分の共変・反変の判断

添え字規則とアインシュタインの縮約記法は、未知のベクトルやテンソル成分が共変であるか反変であるかを判断する強力なツールとなります。共変な方程式においては、左辺と右辺の添え字構造が一致しなければなりません。

例えば、実格子ベクトルの変換行列 $T_{i}^{j}$ を考えてみましょう。
$$ \mathbf{a}'_i = T_i^j \mathbf{a}_j $$
ここで、$\mathbf{a}'_i$ と $\mathbf{a}_j$ は両方とも共変ベクトル（下付き添え字）です。右辺の $j$ は上と下でペアになって和が取られているため、消滅します。残るのは下付きの $i$ です。したがって、$T_i^j$ は、**1階の共変添え字 $i$ と1階の反変添え字 $j$ を持つ2階の混合テンソル**であることが分かります。

同様に、逆格子ベクトルの変換行列を考えると、それは反変添え字と共変添え字を持つ混合テンソルとなります。同じ記号 $T$ を使っても、添え字の位置が異なることで、異なるテンソルを明確に区別できます。これは、計量テンソル $g_{ij}$ と $g^{ij}$ の区別と同様です。

### 2.8 計量テンソルによる共変成分と反変成分の変換

計量テンソル $g_{ij}$ と $g^{ij}$ は、共変成分と反変成分を相互に変換する役割を果たします。
以前に説明したように、実格子ベクトルを逆格子ベクトルに変換する行列は、逆格子の計量テンソル $g^{ij}$ と等しくなります。
$$ \mathbf{a}^{*i} = g^{ij} \mathbf{a}_j $$
この式は、下付き添え字の共変ベクトル $\mathbf{a}_j$ に上付き添え字の反変計量テンソル $g^{ij}$ を作用させることで、上付き添え字の反変ベクトル $\mathbf{a}^{*i}$ が得られることを示しています。このように、計量テンソルは「添え字の上げ下げ」を行う演算子として機能します。

### 2.9 微分による共変・反変の変換

微分操作もまた、ベクトルの共変性・反変性を変化させることがあります。
スカラー関数 $F(x^i)$ の座標 $x^i$ による微分を考えます。
$$ \frac{\partial F}{\partial x^i} $$
この量がどのように変換されるかを見てみましょう。新しい座標系 $x'^i$ における微分は、連鎖律によって次のように書けます。
$$ \frac{\partial F}{\partial x'^i} = \frac{\partial x^j}{\partial x'^i} \frac{\partial F}{\partial x^j} $$
ここで、反変座標 $x^j$ は $x'^i$ に対して $x^j = T^j_k x'^k$ のように変換されるため、
$$ \frac{\partial x^j}{\partial x'^i} = T^j_i $$
となります。したがって、
$$ \frac{\partial F}{\partial x'^i} = T^j_i \frac{\partial F}{\partial x^j} $$
この変換則は、共変ベクトルの変換則と一致します。つまり、**スカラーを反変成分（上付き添え字）で微分すると、共変ベクトル（下付き添え字）になる**ことがわかります。

### 2.10 物性テンソルへの応用

材料の様々な物理的性質（物性）は、テンソルとして記述されます。このとき、共変・反変の概念は、物性テンソルの型を正確に理解するのに役立ちます。

*   **電界ベクトル $\mathbf{E}$**: 電界ベクトル $\mathbf{E} = E^j \mathbf{e}_j$ は、通常、反変ベクトル成分 $E^j$ を持ちます（$\mathbf{e}_j$ は基底ベクトル）。
*   **誘電率テンソル $\epsilon_{ij}$**: 自由エネルギー $G$ はスカラー不変量です。もし $G$ が電界 $\mathbf{E}$ の二乗に比例する項を持つ場合、例えば、
    $$ G = G_0 + \frac{1}{2} \epsilon_{ij} E^i E^j $$
    と書けます。ここで、$E^i, E^j$ は反変ベクトルなので、それらがペアで上付き添え字を持つ場合、$\epsilon_{ij}$ は2階の**共変テンソル**であると判断できます。
*   **歪みテンソル $\epsilon^i_j$**: 歪みテンソルは、変位 $\delta x^i$ の座標 $x^j$ による微分として定義されることが多いです。
    $$ \epsilon^i_j = \frac{\partial (\delta x^i)}{\partial x^j} $$
    変位 $\delta x^i$ は反変ベクトル、微分 $\frac{\partial}{\partial x^j}$ は共変ベクトル成分を生み出すため、$\epsilon^i_j$ は**1階の反変添え字と1階の共変添え字を持つ2階の混合テンソル**となります。
*   **弾性テンソル $C_{kl}^{ij}$**: 弾性エネルギーもスカラー不変量であり、歪みテンソルの二乗に比例します。
    $$ G = G_0 + \frac{1}{2} C_{kl}^{ij} \epsilon^k_l \epsilon^i_j $$
    ここで、歪みテンソルが混合テンソルであることを考慮すると、$C_{kl}^{ij}$ は**4階の混合テンソル**（2つの反変添え字と2つの共変添え字を持つ）となります。

このように、非直交座標系におけるベクトル解析は、理論的な解析や展開を非常に簡潔かつ明瞭にする強力なツールです。

### 2.11 実践的な課題とデカルト座標系

しかしながら、実際の材料の物性テンソル成分と理論を関係づけることは、必ずしも容易ではありません。

*   **単結晶**: 単結晶の場合、単位格子の軸方向が明確に決まっているため、テンソル成分と結晶軸を対応させることができます。
*   **多結晶**: 多結晶材料の場合、結晶粒の方位がランダムであるため、平均的な物性を評価する必要があります。この場合、個々の結晶粒のテンソルを対角化して主値（固有値）を求め、それらを平均する、といった手法が用いられます。
*   **理論計算の出力**: VASP（Vienna Ab initio Simulation Package）のような第一原理計算ソフトウェアは、物性テンソルを出力しますが、多くの場合、計算に用いた単位格子の基本ベクトルに直接対応する一般座標系ではなく、**デカルト座標系**に対するテンソル成分を出力します。これは、POSTCARファイル（構造ファイル）で指定された格子ベクトルのデカルト座標表現に従って、物性テンソルが計算・出力されるためです。したがって、デカルト座標系と結晶の一般座標系との間の変換を理解しておくことが重要になります。

### 2.12 共変・反変成分の一般的な規則のまとめ

以下の表は、共変成分と反変成分の基本的な規則をまとめたものです。

|                 | 実格子ベクトル | 実格子座標 | 実座標による微分 | 逆格子ベクトル | 逆格子座標 | 逆格子座標による微分 |
| :-------------- | :------------- | :--------- | :--------------- | :------------- | :--------- | :------------------- |
| **共変成分**    | $\mathbf{a}_i$ |            | $\frac{\partial F}{\partial x^i}$ |              | $h_i$      |                      |
| **反変成分**    |                | $x^i$      |                  | $\mathbf{a}^{*i}$ |            | $\frac{\partial F}{\partial h_i}$ |

*   **基本ベクトルと座標の共変・反変は入れ替わります。**
*   **実空間と逆空間の共変・反変も入れ替わります。**
*   **微分によっても共変と反変が入れ替わります。**
*   **計量テンソル $g_{ij}$ と $g^{ij}$ を使うことで、共変成分と反変成分を相互に変換できます。**

これらのルールと添え字規則を厳密に守ることで、複雑なテンソル計算も間違いなく行うことができます。

### 2.13 共変座標と反変座標の幾何学的解釈

最後に、共変座標と反変座標が、同じ基底ベクトルを用いた異なる座標の取り方に相当することを幾何学的に見てみましょう。

二次元の斜交座標系を例にとります。基底ベクトルを $\mathbf{a}_1, \mathbf{a}_2$ とします。点 $P$ の位置ベクトルを $\mathbf{r}$ とします。

1.  **反変座標 ($x^1, x^2$)**:
    位置ベクトル $\mathbf{r}$ を $\mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2$ と表す場合、座標 $x^1, x^2$ は、$\mathbf{r}$ を $\mathbf{a}_1$ と $\mathbf{a}_2$ を辺とする平行四辺形に分解したときの各辺に沿った成分です。この方法で得られる座標が**反変座標**に対応します。これは「規定座標系」あるいは「斜座標系」と呼ばれることがあります。

2.  **共変座標 ($x_1, x_2$)**:
    一方、位置ベクトル $\mathbf{r}$ を $\mathbf{a}_1$ に垂直に射影して得られる長さを $x_1$、$\mathbf{a}_2$ に垂直に射影して得られる長さを $x_2$ と考えることもできます。この方法で得られる座標が**共変座標**に対応します。これは「正射影座標系」と呼ばれることがあります。
    しかし、この正射影座標系では、$\mathbf{r} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2}$ のように、基底ベクトルとして逆格子ベクトル $\mathbf{a}^{*1}, \mathbf{a}^{*2}$ を用いることで、より自然に表現されます。すなわち、逆格子ベクトル $\mathbf{a}^{*1}, \mathbf{a}^{*2}$ に対しては、直交射影によって得られる座標が反変座標（つまり、逆格子空間の規定座標）となります。このとき、実空間における共変基底ベクトル $\mathbf{a}_1, \mathbf{a}_2$ での表現が共変座標となるのです。

![スライド26の図1](images\slide26_image1.png)

このように、共変座標と反変座標は、同じ物理ベクトルを異なる幾何学的な視点から表現する方法であり、どちらを用いるかは問題設定や利便性によって決まります。しかし、これらの概念を正確に理解することで、非直交座標系における複雑な物理現象を統一的に、かつ美しく記述することが可能になります。

これで本講義を終了します。ありがとうございました。