# 東京科学大学

---

# 前提と目標

*   **前提**: 基本的な結晶学、結晶化学の知識がある
*   **学習目標**:
    *   ブラベー格子と単位格子の復習
    *   単位格子は任意にとれる: 異なる単位格子間の変換を学ぶ
    *   デカルト座標系と一般座標系の取り扱い: 基底ベクトルの変換と座標変換
    *   単位格子の表現: 格子ベクトルと内部座標 (一般座標系)
    *   単位格子の変換: 格子ベクトルの変換 (=> 内部座標の変換)
    *   逆格子: 共変ベクトルと反変ベクトル

---

# 実格子と逆格子

---

# 逆格子の描き方

*   **逆格子の基本ベクトル $\mathbf{a}^*_i$ の定義**
    $$ \mathbf{a}^*_1 = \frac{\mathbf{a}_2 \times \mathbf{a}_3}{V} $$
    $$ \mathbf{a}^*_2 = \frac{\mathbf{a}_3 \times \mathbf{a}_1}{V} $$
    $$ \mathbf{a}^*_3 = \frac{\mathbf{a}_1 \times \mathbf{a}_2}{V} $$
    (ただし $V = \mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)$)
*   **実格子の基本ベクトル $\mathbf{a}_j$ と逆格子の基本ベクトル $\mathbf{a}^*_i$ は直交する**
    $$ \mathbf{a}^*_i \cdot \mathbf{a}_j = \delta_{ij} $$
*   **逆格子の長さは実格子の長さの逆数に反比例**
    $$ |\mathbf{a}^*_1| \propto \frac{1}{|\mathbf{a}_1|} $$
*   **逆格子の軸角は実格子の軸角の補角に対応**: $\alpha^* = 180^\circ - \alpha$ (一部の場合)

![スライド4の図1](images\slide4_image1.png)
![スライド4の図2](images\slide4_image2.png)

---

# 逆格子のブラベー格子: 2D面心直方格子の例

*   **実格子**
    *   ブラベー格子からスタートした場合 (a, b)
    *   プリミティブ格子からスタートした場合 (ap, bp)
*   **逆格子**
    *   (1/a, 1/b) や (2/a, 2/b) と異なる配列になるように見える
*   **問題**: 逆格子の配列が一意に決まらない？

---

# 逆格子は実格子のフーリエ変換

*   **逆格子の導入背景**:
    *   **回折現象**: X線、中性子、電子（波）の干渉を理解するため
    *   **バンド理論**: 電子の干渉（波動関数）を理解するため
*   **散乱理論**:
    *   散乱振幅 $S(\mathbf{k})$ は電子密度 $\rho(\mathbf{r})$ のフーリエ変換
        $$ S(\mathbf{k}) = \int \rho(\mathbf{r}) \exp(2\pi i \mathbf{k} \cdot \mathbf{r}) d\mathbf{r} $$
    *   ブラッグ条件 ($\mathbf{k} = \mathbf{G}_{hkl}$) 時に $S(\mathbf{k})$ が極大になる
    *   物理的に意味があるのは $S(\mathbf{G}_{hkl}) \neq 0$ の逆格子点だけ: **消滅則**を考慮

![スライド6の図1](images\slide6_image1.png)

---

# 逆格子のブラベー格子: 消滅則を考慮すれば一意に決まる

*   **消滅則の適用**:
    *   実格子の基本ベクトルから描いた逆格子点から、消滅則を満たさない点を削除する
    *   例: 2D面心直方格子の場合、$(h+k=\text{奇数})$ の逆格子点が消滅
*   **結果**:
    *   ブラベー格子からスタートしても、プリミティブ格子からスタートしても、消滅則を考慮すれば同じ逆格子点の配列になる
    *   矛盾が解消され、逆格子も面心格子となる

---

# ブラベー格子、消滅則と逆格子

*   **体心立方格子 (BCC)**
    *   格子点の座標: $(0,0,0), (\frac{1}{2},\frac{1}{2},\frac{1}{2})$
    *   消滅しない指数: $h+k+l = \text{偶数}$
    *   これは**面心立方格子 (FCC)**の逆格子点に対応
*   **面心立方格子 (FCC)**
    *   格子点の座標: $(0,0,0), (0,\frac{1}{2},\frac{1}{2}), (\frac{1}{2},0,\frac{1}{2}), (\frac{1}{2},\frac{1}{2},0)$
    *   消滅しない指数: $h,k,l$ が非混合（すべて奇数またはすべて偶数）
    *   これは**体心立方格子 (BCC)**の逆格子点に対応

---

# 実格子と逆格子のブラベー格子の関係

| 実格子ブラベー格子 | 逆格子ブラベー格子 |
| :----------------- | :----------------- |
| 単純格子 (P, H, R) | 単純格子 (P, H, R) |
| 面心格子 (FC)     | 体心格子 (BC)     |
| 体心格子 (BC)     | 面心格子 (FC)     |
| 底心格子 (A, B, C) | 底心格子 (A, B, C) |

---

# 実格子と逆格子

*   `python [data-COE]\crystal\crystal_draw_cell.py`
*   Rhombohedral cell and reciprocal unit cell

![スライド10の図1](images\slide10_image1.png)

---

# 共変ベクトルと反変ベクトル

---

# 格子変換のまとめ: 共変ベクトルと反変ベクトルの定義

*   **実格子ベクトルの変換**: $\mathbf{a}'_i = \sum_j t_{ij} \mathbf{a}_j$
*   **実格子座標の変換**: $x'^i = \sum_j (T^{-1})_{ji} x^j$
*   **逆格子ベクトルの変換**: $\mathbf{a}^{*'i} = \sum_j (T^{-1})_{ji} \mathbf{a}^{*j}$
*   **指数 (逆格子座標) の変換**: $h'_i = \sum_j t_{ij} h_j$

*   **基底ベクトルと座標の変換則は2種類に分類できる**:
    *   変換行列 $T$: **実格子ベクトル $\mathbf{a}_i$、逆格子座標 $h_i$ (共変ベクトル)**
    *   変換行列 $(T^T)^{-1}$: **実格子座標 $x^i$、逆格子ベクトル $\mathbf{a}^{*i}$ (反変ベクトル)**

![スライド12の図1](images\slide12_image1.png)
![スライド12の図2](images\slide12_image2.png)

---

# 計量テンソル

*   **共変計量テンソル $g_{ij}$**:
    *   $g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j$
    *   座標変換: $g'_{ij} = \sum_{k,l} t_{ik} t_{jl} g_{kl}$
    *   $\mathbf{g}_{ij}$ は共変ベクトルの変換則 $T$ によって変換される: **2階共変テンソル**
*   **反変計量テンソル $g^{ij}$**:
    *   $g^{ij} = \mathbf{a}^{*i} \cdot \mathbf{a}^{*j}$
    *   座標変換: $g'^{ij} = \sum_{k,l} (T^{-1})_{ki} (T^{-1})_{lj} g^{kl}$
    *   $g^{ij}$ は反変ベクトルの変換則 $(T^T)^{-1}$ によって変換される: **2階反変テンソル**

![スライド13の図1](images\slide13_image1.png)

---

# 一般座標系 (実格子) => 一般座標系 (逆格子) 変換

*   **格子ベクトルの変換則**:
    *   $\mathbf{a}'_1 = t_{11}\mathbf{a}_1 + t_{12}\mathbf{a}_2 + t_{13}\mathbf{a}_3$
    *   $\mathbf{a}'_2 = t_{21}\mathbf{a}_1 + t_{22}\mathbf{a}_2 + t_{23}\mathbf{a}_3$
    *   $\mathbf{a}'_3 = t_{31}\mathbf{a}_1 + t_{32}\mathbf{a}_2 + t_{33}\mathbf{a}_3$
    *   行列形式: $(\mathbf{a}'_1 \quad \mathbf{a}'_2 \quad \mathbf{a}'_3)^T = T (\mathbf{a}_1 \quad \mathbf{a}_2 \quad \mathbf{a}_3)^T$
    *   $T = (t_{ij})$: 格子ベクトル (基底ベクトル) の変換行列
*   **変換行列と計量テンソルの関係**:
    *   $\mathbf{a}'_i \cdot \mathbf{a}_j = \sum_k t_{ik} g_{kj}$
    *   **実格子から逆格子への変換の場合** ($\mathbf{a}'_i = \mathbf{a}^{*i}$):
        *   $\mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j$
        *   したがって、$\sum_k T^{ik} g_{kj} = \delta^i_j$
        *   この関係から、変換行列 $(T^{ij})$ は計量テンソル $(g_{ij})$ の逆行列に等しい

![スライド14の図1](images\slide14_image1.png)
![スライド14の図2](images\slide14_image2.png)
![スライド14の図3](images\slide14_image3.png)

---

# 実格子 => 逆格子変換: 逆格子の計量テンソル

*   **実格子ベクトルを逆格子ベクトルに変換する行列は、逆格子の計量テンソルに等しい**
    *   $(\mathbf{a}^{*i})$ と $(\mathbf{a}_j)$ の関係: $\mathbf{a}^{*i} = g^{ij} \mathbf{a}_j$
    *   これは、変換行列 $(T^{ij})$ が実格子の計量テンソルの逆行列 $(g_{ij})^{-1}$ に等しいことを示す
        $$ (T^{ij}) = (g_{ij})^{-1} = (g^{ij}) $$

![スライド15の図1](images\slide15_image1.png)

---

# 共変ベクトルと反変ベクトルの内積はスカラーになる

*   **ベクトル $\mathbf{r}$ を座標変換**:
    *   $\mathbf{r} = x^i \mathbf{a}_i$
    *   座標変換後も $\mathbf{r} = x'^i \mathbf{a}'_i$
    *   $\sum_i x'^i \mathbf{a}'_i = \sum_i \left( \sum_l (T^{-1})_{li} x^l \right) \left( \sum_k t_{ik} \mathbf{a}_k \right) = \sum_k x^k \mathbf{a}_k$
    *   $\mathbf{r}$ は不変量であることを再確認
*   **その他の共変ベクトル $v_i$ と反変ベクトル $w^j$ の内積の座標変換にも、同じ変換則**
    *   $v'^i w'_j = v^i w_j$
    *   **共変ベクトルと反変ベクトルの内積は不変量 (スカラー) になる**

![スライド16の図1](images\slide16_image1.png)

---

# 添え字の約束と縮約記法

*   **規則**:
    *   共変ベクトルの添え字は下付きに書く ($\mathbf{a}_i$, $g_{ij}$)
    *   反変ベクトルの添え字は上付きに書く ($x^i$, $\mathbf{a}^{*i}$, $g^{ij}$)
*   **共変成分と反変成分の間で和を取ると、不変量 (スカラー) になる**
*   **アインシュタインの縮約記法 (Einstein Summation Convention)**:
    *   同じ添え字記号の共変・反変成分がペアで現れる場合は、暗黙の約束として和を取る ($\sum$ 記号を省略)
    *   例: $\sum_i x^i \mathbf{a}_i$ は $x^i \mathbf{a}_i$ と簡略化して書く
    *   同じ添え字記号が上と下に現れれば、不変量であることが明確になる

![スライド17の図1](images\slide17_image1.png)

---

# 添え字規則に則って書き直す

*   **変換行列 $T$ によって変換される場合は共変ベクトル**: 添え字は下付き
    *   実格子の基本ベクトル: $\mathbf{a}_i$
    *   実格子の計量テンソル: $g_{ij}$
    *   逆格子の座標: $h_i$
*   **変換行列 $(T^T)^{-1}$ によって変換される場合は反変ベクトル**: 添え字は上付き
    *   実格子の座標: $x^i$
    *   逆格子の基本ベクトル: $\mathbf{a}^{*i}$
    *   逆格子の計量テンソル: $g^{ij}$
        *   添え字の位置で区別できるので、 $g^{ij}$ と書ける

![スライド18の図1](images\slide18_image1.png)

---

# ノルムと計量テンソル

*   **ベクトル $\mathbf{r}$ のノルムの二乗**:
    $$ ||\mathbf{r}||^2 = \mathbf{r} \cdot \mathbf{r} = (x^i \mathbf{a}_i) \cdot (x^j \mathbf{a}_j) = (\mathbf{a}_i \cdot \mathbf{a}_j) x^i x^j = g_{ij} x^i x^j $$
*   添え字 $i, j$ が消えるので、ノルムは不変量 (スカラー) であることが確認できる

![スライド19の図1](images\slide19_image1.png)

---

# 方程式の共変性

*   方程式の左辺と右辺が同じ型（同じ添え字構造）のテンソルであれば、両辺が同じ変換則に従うことが自明である
    *   「方程式は座標変換に対して共変 (共変形式である)」という
*   物理法則は何らかの対称性を満たすことが要請される:
    *   共変形式のテンソル方程式で表現できる
    *   特殊相対性理論、マックスウェルの方程式: ローレンツ共変
    *   一般相対性理論: 一般共変
    *   超弦理論: ローレンツ共変、超対称性不変など
    *   ニュートンの運動方程式: ガリレイ不変

---

# 未知のベクトル・テンソル成分の共変・反変の判断

*   共変な方程式に添え字規則を使うと、未知のベクトル・テンソル成分が共変か反変かわかる
*   **実格子ベクトルの変換行列**: $\mathbf{a}'_i = T^j_i \mathbf{a}_j$
    *   $\mathbf{a}'_i$, $\mathbf{a}_j$ はどちらも共変ベクトル (下付き添え字)
    *   共変形式になるためには $T^j_i$
    *   $T^j_i$ は1階共変・1階反変の**混合テンソル**
*   **逆格子ベクトルの変換行列**: 同様に $T_j^i$ は反変・共変混合テンソル

![スライド21の図1](images\slide21_image1.png)

---

# 計量テンソルは共変成分 <=> 反変成分を変換する

*   以前に証明した結果: **実格子ベクトル => 逆格子ベクトルの変換行列は逆格子の計量テンソル**
    $$ (T^{ij}) = (g_{ij})^{-1} = (g^{ij}) $$
*   **逆格子ベクトルの性質**: $\mathbf{a}^{*i} = g^{ij} \mathbf{a}_j$
    *   $\mathbf{a}^{*i} \cdot \mathbf{a}_j = \delta^i_j$ (クロネッカーのデルタ)
    *   $ (g^{ik} \mathbf{a}_k) \cdot \mathbf{a}_j = \sum_k g^{ik} (\mathbf{a}_k \cdot \mathbf{a}_j) = \sum_k g^{ik} g_{kj} $
    *   したがって、$\sum_k g^{ik} g_{kj} = \delta^i_j$
    *   これは $g^{ik}$ が $g_{kj}$ の逆行列であることを示す

![スライド22の図1](images\slide22_image1.png)

---

# 共変成分と反変成分: 微分

*   共変成分か反変成分かは、座標変換して変換行列を確認する
*   **スカラー関数 $F(x^i)$ の座標微分**: $\frac{\partial F}{\partial x^i}$
    *   $\frac{\partial F}{\partial x'^i} = \frac{\partial x^j}{\partial x'^i} \frac{\partial F}{\partial x^j}$
    *   $x^j = T^j_k x'^k$ より、$\frac{\partial x^j}{\partial x'^i} = T^j_i$
    *   したがって、$\frac{\partial F}{\partial x'^i} = T^j_i \frac{\partial F}{\partial x^j}$
    *   **スカラーを反変成分で微分すると共変ベクトルになる**

![スライド23の図1](images\slide23_image1.png)

---

# 共変成分と反変成分: 物性テンソル

*   不変量 (スカラー) を既知の共変・反変成分で表すことで判別できる
*   **電界ベクトル**: $\mathbf{E} = E^j \mathbf{e}_j$
    *   電界ベクトル成分 $E^j$: **反変テンソル**
*   **誘電率テンソル $\epsilon_{ij}$**:
    *   自由エネルギー $G = G_0 + \frac{1}{2} \epsilon_{ij} E^i E^j$
    *   $G$ はスカラー、$E^i, E^j$ は反変テンソルなので、$\epsilon_{ij}$ は**2階の共変テンソル**
*   **歪みテンソル $\epsilon^i_j$**:
    *   $\epsilon^i_j = \frac{\partial (\delta x^i)}{\partial x^j}$
    *   $\delta x^i$ は反変、微分で共変になるため、$\epsilon^i_j$ は**1階反変・1階共変の混合テンソル**
*   **弾性テンソル $C^{ij}_{kl}$**:
    *   $G = G_0 + \frac{1}{2} C^{ij}_{kl} \epsilon^k_l \epsilon^i_j$
    *   $C^{ij}_{kl}$ は**4階の混合テンソル** (2階反変・2階共変)

*   非直交座標系のベクトル解析は、理論解析で重要
*   実際の材料のテンソル成分と関係づけるのは難しい:
    *   単結晶ならテンソル成分と対応付けられる
    *   多結晶の場合、対角化して主値の平均で対応づけられる
    *   理論計算 (VASP など) ではデカルト座標に関するテンソルを出力している

![スライド24の図1](images\slide24_image1.png)

---

# 共変成分と反変成分: 一般的な規則

*   基本ベクトルと座標の共変・反変は入れ替わる
*   実空間と逆空間の共変・反変は入れ替わる
*   微分により共変と反変が入れ替わる
*   計量テンソル $g_{ij}, g^{ij}$ により、共変成分と反変成分を入れ替えられる

|                 | 実格子ベクトル | 実格子座標 | 実座標による微分 | 逆格子ベクトル | 逆格子座標 | 逆格子座標による微分 |
| :-------------- | :------------- | :--------- | :--------------- | :------------- | :--------- | :------------------- |
| **共変成分**    | $\mathbf{a}_i$ |            | $\frac{\partial F}{\partial x^i}$ |              | $h_i$      |                      |
| **反変成分**    |                | $x^i$      |                  | $\mathbf{a}^{*i}$ |            | $\frac{\partial F}{\partial h_i}$ |

![スライド25の図1](images\slide25_image1.png)

---

# 共変座標と反変座標は同じ基底ベクトルで異なる座標の取り方に当たる

*   **座標1 (規定座標系, 斜座標系)**:
    *   $\mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2$
    *   $x^1, x^2$ は平行四辺形の成分（反変座標）
*   **座標2 (正射影座標系)**:
    *   $\mathbf{r} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2}$
    *   $x_1, x_2$ は逆格子ベクトルに対する平行四辺形の成分（共変座標）
    *   正射影座標系は、逆格子ベクトル $\mathbf{a}^{*i}$ に対しては規定座標系となる
*   $\mathbf{a}_1, \mathbf{a}_2$ を基準にした「反変座標」と $\mathbf{a}^*_1, \mathbf{a}^*_2$ を基準にした「反変座標」（実空間の共変座標）の幾何学的意味

![スライド26の図1](images\slide26_image1.png)