# 逆格子と共変・反変テンソル：結晶学と物性物理学における基礎概念

本講義では、材料科学、特に結晶学と固体物理学において非常に重要な概念である「逆格子 (Reciprocal Lattice)」について復習し、さらに「共変ベクトル (Covariant Vector)」と「反変ベクトル (Contravariant Vector)」という抽象的な概念を導入します。これらの概念が、結晶の幾何学、X線回折、そして物性テンソルの理解にどのように役立つかを体系的に解説していきます。

## 1. 逆格子の復習

まず、逆格子 (Reciprocal Lattice) の基本的な定義と性質について復習しましょう。逆格子は、実空間に存在する結晶格子（実行格子、Real Space Lattice）に対応する、仮想的な空間（逆空間、Reciprocal Space）における格子です。X線回折などの散乱実験を理解するために導入され、個体物理学におけるバンド理論などでも中心的な役割を果たします。

### 1.1 逆格子の定義

実行格子の基本ベクトルを $$ \mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3 $$ とすると、逆格子の基本ベクトル $$ \mathbf{a}^*_1, \mathbf{a}^*_2, \mathbf{a}^*_3 $$ は以下のように定義されます。

$$
\mathbf{a}^*_1 = \frac{2\pi}{V} (\mathbf{a}_2 \times \mathbf{a}_3)
$$

$$
\mathbf{a}^*_2 = \frac{2\pi}{V} (\mathbf{a}_3 \times \mathbf{a}_1)
$$

$$
\mathbf{a}^*_3 = \frac{2\pi}{V} (\mathbf{a}_1 \times \mathbf{a}_2)
$$

ここで、$$ V $$ は実行格子の単位胞の体積であり、$$ V = |\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)| $$ で与えられます。通常、$$ 2\pi $$ を含めずに定義されることもありますが、本講義では、フーリエ変換との整合性を考慮して $$ 2\pi $$ を含めた定義を使用します。

この定義から、逆格子の基本ベクトルは、以下の**規格直交化条件**を満たすことが導かれます。

$$
\mathbf{a}^*_i \cdot \mathbf{a}_j = 2\pi \delta_{ij}
$$

ここで、$$ \delta_{ij} $$ はクロネッカーのデルタであり、$$ i=j $$ のとき $$ 1 $$、$$ i \neq j $$ のとき $$ 0 $$ となります。この条件は、例えば $$ \mathbf{a}^*_1 $$ は $$ \mathbf{a}_2 $$ と $$ \mathbf{a}_3 $$ の両方に直交すること、そして $$ \mathbf{a}^*_1 $$ と $$ \mathbf{a}_1 $$ の内積が $$ 2\pi $$ となることを意味します。

**導出の考え方:**
逆格子ベクトルは、実空間の周期構造に対するフーリエ変換の「波数ベクトル」に対応します。周期的な関数 $$ f(\mathbf{r}) $$ はフーリエ級数で次のように展開できます。
$$
f(\mathbf{r}) = \sum_{\mathbf{G}} F_{\mathbf{G}} e^{i \mathbf{G} \cdot \mathbf{r}}
$$
ここで、$$ \mathbf{G} $$ が逆格子ベクトルです。この式が結晶の並進対称性を満たすためには、任意の格子点ベクトル $$ \mathbf{R} = n_1 \mathbf{a}_1 + n_2 \mathbf{a}_2 + n_3 \mathbf{a}_3 $$ に対して $$ f(\mathbf{r}+\mathbf{R}) = f(\mathbf{r}) $$ が成り立つ必要があります。これは、$$ e^{i \mathbf{G} \cdot \mathbf{R}} = 1 $$ を意味します。この条件を満たす $$ \mathbf{G} $$ が逆格子ベクトルであり、その基本ベクトルが上記の定義式を満たすことになります。特に、$$ \mathbf{G} \cdot \mathbf{R} $$ が $$ 2\pi $$ の整数倍になる必要があります。

### 1.2 逆格子の幾何学的解釈

規格直交化条件 $$ \mathbf{a}^*_i \cdot \mathbf{a}_j = 2\pi \delta_{ij} $$ から、逆格子の基本ベクトルと実行格子の基本ベクトルは、以下の幾何学的関係を持つことが分かります。

1.  **直交性**: $$ \mathbf{a}^*_1 $$ は $$ \mathbf{a}_2 $$ 軸と $$ \mathbf{a}_3 $$ 軸が張る平面に直交します。同様に、$$ \mathbf{a}^*_2 $$ は $$ \mathbf{a}_3 $$ と $$ \mathbf{a}_1 $$ に、$$ \mathbf{a}^*_3 $$ は $$ \mathbf{a}_1 $$ と $$ \mathbf{a}_2 $$ に直交します。これにより、実格子の基本ベクトルが斜交座標系を形成している場合でも、逆格子の基本ベクトルはそれらの平面に対して垂直な方向を指します。

2.  **長さ**: 逆格子の基本ベクトルの長さは、大まかに実行格子の対応する方向の長さの**逆数**に比例します。例えば、$$ |\mathbf{a}^*_1| \approx 2\pi / |\mathbf{a}_1| $$ となります。これは、短い実格子ベクトルに対応する逆格子ベクトルは長く、長い実格子ベクトルに対応する逆格子ベクトルは短くなることを意味します。

3.  **軸角**: 逆格子の軸角は、実行格子の軸角の補角（例えば、$$ \alpha^* = \pi - \alpha $$）に対応します。ただし、これは三斜晶系など、直交座標系でない格子では厳密には成り立たず、大まかな関係として捉えるべきです。

これらの関係を基に、実行格子の基本ベクトルが与えられれば、逆格子の基本ベクトルを大まかに作図することができます。

### 1.3 逆格子の作図と単位格子の曖昧性

実行格子のブラベー格子に対して逆格子を構成してみましょう。
例えば、実行格子の基本ベクトル $$ \mathbf{a}, \mathbf{b}, \mathbf{c} $$ を用いて逆格子の基本ベクトル $$ \mathbf{a}^*, \mathbf{b}^*, \mathbf{c}^* $$ を計算すると、逆格子点は特定の配列で並びます。

しかし、実行格子の単位胞の取り方は一意ではありません。例えば、単純格子の場合、その基本格子ベクトルから逆格子ベクトルを構成すれば、特定の配列の逆格子点が得られます。しかし、体心立方格子 (BCC) の実行格子を単純格子として捉え、その基本格子ベクトルから逆格子ベクトルを構成すると、別の配列の逆格子点が得られることがあります。

これは、実行格子点自体が与えられていても、それを表現する**単位胞 (Unit Cell)** は一意に決まらないという問題に起因します。単位胞の選び方によって、基本ベクトルが変わり、それによって計算される逆格子ベクトルも変わってしまうのです。

この問題の解決策は、逆格子を構成する際に、単に**単位胞**の基本ベクトルから出発するのではなく、**実行格子点そのもの**、あるいは**フーリエ変換の物理的意味**から出発することにあります。

### 1.4 フーリエ変換としての逆格子と回折現象

逆格子が導入された背景には、X線回折をはじめとする様々な散乱現象の理解があります。これらの現象では、入射波と散乱体の相互作用によって生じる散乱波の干渉が重要な役割を果たします。

**散乱理論の基本式:**
散乱体（電子密度分布や原子核スピン分布など）の物理量分布を $$ \rho(\mathbf{r}) $$ とすると、ある波数ベクトル $$ \mathbf{k}_0 $$ の入射波が散乱されて、波数ベクトル $$ \mathbf{k} $$ の散乱波になる場合、散乱振幅 $$ S(\mathbf{K}) $$ は通常、$$ \rho(\mathbf{r}) $$ のフーリエ変換として記述されます。ここで、$$ \mathbf{K} = \mathbf{k} - \mathbf{k}_0 $$ は散乱ベクトル（または運動量変化ベクトル）です。

$$
S(\mathbf{K}) = \int \rho(\mathbf{r}) e^{-i \mathbf{K} \cdot \mathbf{r}} d^3\mathbf{r}
$$

このとき、結晶のように周期的な構造を持つ散乱体の場合、$$ \rho(\mathbf{r}) $$ は周期関数であるため、そのフーリエ変換である $$ S(\mathbf{K}) $$ は、特定の波数ベクトル $$ \mathbf{K} $$ のときにのみ大きな値（極大）を取ります。この特定の波数ベクトルが、まさに**逆格子ベクトル $$ \mathbf{G} $$** に対応します。

つまり、$$ \mathbf{K} = \mathbf{G} $$ のとき、散乱振幅 $$ S(\mathbf{G}) $$ が極大となり、これがX線回折における**ブラッグ反射 (Bragg Reflection)** の条件に他なりません。
ブラッグの法則は $$ 2d \sin\theta = n\lambda $$ と表されますが、逆格子空間では散乱ベクトル $$ \mathbf{K} $$ が逆格子ベクトル $$ \mathbf{G} $$ に等しい（$$ \mathbf{K} = \mathbf{G} $$）という、より一般化された形で表現されます。

このような物理的な意味合いから、逆格子点において物理的に意味があるのは、**散乱振幅 $$ S(\mathbf{G}) $$ がゼロでない逆格子点だけ**である、ということが分かります。

### 1.5 回折における消滅則と逆格子の修正

前述の通り、逆格子点を構成する際には、物理的に意味のある点のみを考慮する必要があります。これは、結晶構造が持つ特定の対称性によって、一部の回折ピークが観測されない**消滅則 (Extinction Rule)** を考慮することに他なりません。

消滅則は、単位胞内に複数の原子が存在する場合や、格子が単純格子ではない（面心、体心など）ブラベー格子である場合に生じます。例えば、体心立方格子 (BCC) の場合、(hkl) 面からの回折ピークは、$$ h+k+l $$ が奇数の場合は消滅します。同様に、面心立方格子 (FCC) の場合、hklが全て奇数または全て偶数の場合にのみ回折ピークが観測され、それ以外の場合は消滅します。

この消滅則を考慮に入れることで、逆格子点の配列が修正され、先に述べた単位格子の選び方に起因する矛盾が解消されます。

**ブラベー格子における実行格子と逆格子の対応:**

| 実行格子           | 消滅則 (hkl)       | 逆格子           |
| :----------------- | :----------------- | :--------------- |
| 単純立方 (SC)      | なし               | 単純立方 (SC)    |
| 体心立方 (BCC)     | $$ h+k+l $$ が奇数 | 面心立方 (FCC)   |
| 面心立方 (FCC)     | 全て奇数または全て偶数 | 体心立方 (BCC)   |
| 単純正方 (ST)      | なし               | 単純正方 (ST)    |
| 体心正方 (BCT)     | $$ h+k+l $$ が奇数 | 面心正方 (FCT)   |
| 単純斜方 (SO)      | なし               | 単純斜方 (SO)    |
| 体心斜方 (BCO)     | $$ h+k+l $$ が奇数 | 面心斜方 (FCO)   |
| 面心斜方 (FCO)     | 全て奇数または全て偶数 | 体心斜方 (BCO)   |
| 底心斜方 (Base-O)  | $$ h+k $$ が奇数   | 底心斜方 (Base-O) |
| 三方晶 (Trigonal)  | なし               | 三方晶 (Trigonal) |
| 六方晶 (Hexagonal) | なし               | 六方晶 (Hexagonal) |
| 単斜晶 (Monoclinic) | なし               | 単斜晶 (Monoclinic) |
| 底心単斜晶 (Base-M) | $$ h+k $$ が奇数   | 底心単斜晶 (Base-M) |
| 三斜晶 (Triclinic) | なし               | 三斜晶 (Triclinic) |

このように、体心立方格子の実行格子は面心立方格子の逆格子に、面心立方格子の実行格子は体心立方格子の逆格子に対応するという興味深い関係があります。単純格子や底心格子、三方晶、六方晶、単斜晶、三斜晶の逆格子は、それぞれ同じブラベー格子のタイプになります。

実際に、`crystaldrawcell.py` のようなプログラムは、これらの関係を考慮して逆格子の単位胞（第一ブリルアンゾーンなど）を作図することができます。プログラムを読み解くことで、逆格子の計算と可視化の仕組みをより深く理解できるでしょう。

---

## 2. 共変ベクトルと反変ベクトル

逆格子と実行格子の関係をより深く、そして一般的に理解するためには、「共変ベクトル (Covariant Vector)」と「反変ベクトル (Contravariant Vector)」という概念が非常に役立ちます。これらの概念は、座標変換の下でのベクトルの振る舞いを分類するもので、テンソル解析の基礎となります。

### 2.1 座標変換とベクトルの分類

一般の線形座標変換を考えます。ある基底（基本ベクトル）$$ \{\mathbf{a}_i\} $$ から別の基底 $$ \{\mathbf{a}'_i\} $$ への変換が、変換行列 $$ \mathbf{T} $$ によって次のように与えられるとします。

$$
\mathbf{a}'_i = \sum_j T_{ij} \mathbf{a}_j
$$

このとき、同じ物理的なベクトル $$ \mathbf{v} $$ を異なる基底で表現すると、その成分はどのように変換されるでしょうか。
ベクトル $$ \mathbf{v} $$ を、基底 $$ \{\mathbf{a}_i\} $$ を用いて $$ \mathbf{v} = \sum_i v^i \mathbf{a}_i $$ と表し、基底 $$ \{\mathbf{a}'_i\} $$ を用いて $$ \mathbf{v} = \sum_i v'^i \mathbf{a}'_i $$ と表すと、両者が等しいことから、成分 $$ v^i $$ と $$ v'^i $$ の間には次のような関係が導かれます。

$$
v'^i = \sum_j (\mathbf{T}^{-1})_{ji} v^j
$$

ここで、$$ (\mathbf{T}^{-1})_{ji} $$ は変換行列 $$ \mathbf{T} $$ の逆行列 $$ \mathbf{T}^{-1} $$ の成分です。

このように、座標変換の下での振る舞いによって、ベクトル成分（または基底ベクトル）は2種類に分類されます。

1.  **共変ベクトル (Covariant Vector)**:
    基底ベクトルと同じ変換規則に従う成分を持つベクトル、あるいは変換行列 $$ \mathbf{T} $$ そのもので変換されるベクトル。
    例: **実行格子の基本ベクトル $$ \mathbf{a}_i $$**

2.  **反変ベクトル (Contravariant Vector)**:
    基底ベクトルとは逆の変換規則に従う成分を持つベクトル、あるいは変換行列 $$ \mathbf{T} $$ の逆行列 $$ \mathbf{T}^{-1} $$ で変換されるベクトル。
    例: **実行格子の座標成分 $$ x^i $$**

より厳密には、共変ベクトルは基底ベクトルの変換 $$ \mathbf{a}'_i = \sum_j T_{ij} \mathbf{a}_j $$ に対して、その成分は $$ v'_i = \sum_j (\mathbf{T}^{-1})_{ij} v_j $$ と変換される量です。一方、反変ベクトルは基底ベクトルが $$ \mathbf{a}'_i = \sum_j (\mathbf{T}^{-1})_{ij} \mathbf{a}_j $$ と変換される場合に、その成分は $$ v'^i = \sum_j T_{ij} v^j $$ と変換される量と考えることもできます。ここでは、講義の文脈に合わせて、「実行格子の基本ベクトル $$ \mathbf{a}_i $$ と同じ変換規則（$$ \mathbf{T} $$ で変換）に従うもの」を共変、その逆を反変と定義します。

具体的に、前回の講義でまとめた格子変換のルールを振り返ってみましょう。
-   実行格子の基本ベクトル $$ \mathbf{a}_i $$ は、変換行列 $$ \mathbf{T} $$ によって変換される。
    $$ \mathbf{a}'_i = \sum_j T_{ij} \mathbf{a}_j $$
-   実行格子の座標成分 $$ x^i $$ は、変換行列 $$ \mathbf{T} $$ の逆行列の転置 $$ (\mathbf{T}^{-1})^T $$ によって変換される。
    $$ x'^i = \sum_j ((\mathbf{T}^{-1})^T)_{ij} x^j $$
    （元のテキストでは「Tの転置の逆行列」という表現だが、座標の変換は基底の逆変換なので、$$ \mathbf{x}' = (\mathbf{T}^T)^{-1} \mathbf{x} $$ あるいは $$ \mathbf{x}' = (\mathbf{T}^{-1})^T \mathbf{x} $$ となる。これは基底の変換が $$ \mathbf{a}'_i = \sum_j T_{ij} \mathbf{a}_j $$ の場合、ベクトル成分は $$ v'^j = \sum_i (\mathbf{T}^{-1})_{ij} v^i $$ と変換されることを意味する。ここで、添え字の上下を導入するとより明確になる。）

-   逆格子の座標（ミラー指数 $$ h_i $$）は、変換行列 $$ \mathbf{T} $$ によって変換される。
    $$ h'_i = \sum_j T_{ij} h_j $$
-   逆格子の基本ベクトル $$ \mathbf{a}^*_i $$ は、変換行列 $$ \mathbf{T} $$ の逆行列の転置 $$ (\mathbf{T}^{-1})^T $$ によって変換される。
    $$ \mathbf{a}^{*'}_i = \sum_j ((\mathbf{T}^{-1})^T)_{ij} \mathbf{a}^*_j $$

これらの変換規則から、
-   **共変ベクトル**: 実行格子の基本ベクトル $$ \mathbf{a}_i $$、**逆格子の座標（ミラー指数）$$ h_i $$**
-   **反変ベクトル**: 実行格子の座標成分 $$ x^i $$、**逆格子の基本ベクトル $$ \mathbf{a}^*_i $$**

となります。共変ベクトルと反変ベクトルは、同じ「ベクトル」という物理量でありながら、座標変換の下での振る舞いが異なるため、区別して扱われます。

### 2.2 計量テンソル (Metric Tensor) の共変・反変性

計量テンソルは、空間の「距離」や「角度」といった幾何学的な情報を記述するテンソルです。実空間における計量テンソル $$ g_{ij} $$ は、実行格子の基本ベクトル $$ \mathbf{a}_i $$ と $$ \mathbf{a}_j $$ の内積として定義されます。

$$
g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j
$$

この $$ g_{ij} $$ が座標変換の下でどのように振る舞うかを見てみましょう。
新しい基底 $$ \mathbf{a}'_i = \sum_k T_{ik} \mathbf{a}_k $$ と $$ \mathbf{a}'_j = \sum_l T_{jl} \mathbf{a}_l $$ を用いると、新しい計量テンソル $$ g'_{ij} $$ は、

$$
g'_{ij} = \mathbf{a}'_i \cdot \mathbf{a}'_j = \left( \sum_k T_{ik} \mathbf{a}_k \right) \cdot \left( \sum_l T_{jl} \mathbf{a}_l \right) = \sum_k \sum_l T_{ik} T_{jl} (\mathbf{a}_k \cdot \mathbf{a}_l) = \sum_k \sum_l T_{ik} T_{jl} g_{kl}
$$

となります。この変換規則から、$$ g_{ij} $$ は2つの変換行列 $$ \mathbf{T} $$ を用いて変換されることが分かります。このようなテンソルを**2回共変テンソル (Twice Covariant Tensor)** と呼びます。

同様に、逆空間における計量テンソル $$ g^{ij} $$ は、逆格子の基本ベクトル $$ \mathbf{a}^*_i $$ と $$ \mathbf{a}^*_j $$ の内積として定義されます。

$$
g^{ij} = \mathbf{a}^*_i \cdot \mathbf{a}^*_j
$$

$$ \mathbf{a}^*_i $$ が反変ベクトルであることを考えると、$$ g^{ij} $$ は2つの逆行列の転置を用いて変換されることになります。したがって、$$ g^{ij} $$ は**2回反変テンソル (Twice Contravariant Tensor)** と呼ばれます。

**歴史的背景: リーマンとアインシュタイン**
共変・反変という概念は、19世紀の数学者ベルンハルト・リーマンによる幾何学の研究に端を発します。彼は曲がった空間（多様体）における幾何学を記述するために、基底に依存しない量を扱うテンソルの概念を導入しました。その後、アルベルト・アインシュタインが一般相対性理論を構築する際、重力を時空の歪みとして記述するために、この共変・反変テンソルの概念を駆使しました。アインシュタイン方程式は、座標変換に対して共変なテンソル方程式として表現されます。

### 2.3 実行格子から逆格子への変換行列

実行格子の基本ベクトル $$ \mathbf{a}_i $$ と逆格子の基本ベクトル $$ \mathbf{a}^*_j $$ の間には、規格直交化条件 $$ \mathbf{a}^*_i \cdot \mathbf{a}_j = 2\pi \delta_{ij} $$ がありました。

一般座標系における実行格子ベクトルを $$ \mathbf{r} = \sum_i x^i \mathbf{a}_i $$、逆格子ベクトルを $$ \mathbf{G} = \sum_i h_i \mathbf{a}^*_i $$ と書くことができます。
（ここではミラー指数 $$ h_i $$ を共変成分として表現しています。後述の添え字規則を参照ください。）

ここで、実行格子の基底 $$ \mathbf{a}_i $$ から逆格子の基底 $$ \mathbf{a}^*_i $$ へ、あるいはその逆への変換を考えます。
両者の関係は、計量テンソルを使って以下のように記述できます。

実行格子の基本ベクトル $$ \mathbf{a}_i $$ は、逆格子の基本ベクトル $$ \mathbf{a}^*_j $$ を用いて次のように表せます。

$$
\mathbf{a}_i = \sum_j g_{ij} \mathbf{a}^{*j} / (2\pi)
$$
（ただし、ここでは $$ \mathbf{a}^{*j} $$ は逆格子の反変基底である。通常の定義では $$ \mathbf{a}^*_j $$ と書かれるが、添え字規則を適用するとこのように書ける。）

より一般的な関係として、実行格子の基本ベクトル $$ \mathbf{a}_i $$ から逆格子の基本ベクトル $$ \mathbf{a}^*_i $$ への変換行列は、実空間の計量テンソル $$ g_{ij} $$ の逆行列 $$ g^{jk} $$ を用いて表されます。

$$
\mathbf{a}^*_i = \sum_j 2\pi (g^{-1})_{ij} \mathbf{a}_j
$$
または、$$ (\mathbf{a}^*_i)_k = \sum_j 2\pi (g^{-1})_{ij} (\mathbf{a}_j)_k $$

これは、**実空間の計量テンソルの逆行列が、逆空間の計量テンソルに一致する**ことを意味します。
すなわち、$$ g^{ij} = (g^{-1})^{ij} $$ となります。（正確には、$$ (g_{kl})^{-1} = g^{kl} $$）
これは、$$ \sum_k g_{ik} g^{kj} = \delta_i^j $$ （クロネッカーのデルタ）という関係で表現されます。
したがって、実行格子ベクトルと逆格子ベクトルの変換は、計量テンソルと密接に関連していることが分かります。

### 2.4 共変ベクトルと反変ベクトルの内積は不変量

共変ベクトルと反変ベクトルの内積は、座標変換に対して不変なスカラー量となります。これを具体的なベクトル $$ \mathbf{R} $$ で確認してみましょう。
ベクトル $$ \mathbf{R} $$ を、実行格子の基本ベクトルと反変座標成分で表すと、
$$
\mathbf{R} = \sum_i x^i \mathbf{a}_i
$$
また、同じベクトルを逆格子の基本ベクトルと共変座標成分で表すと、
$$
\mathbf{R} = \sum_i h_i \mathbf{a}^*_i
$$
と書くことができます。（これは先ほど定義したように、ミラー指数 $$ h_i $$ が共変成分に対応するためです。）

ここでは、任意の共変ベクトル $$ v_i $$ と反変ベクトル $$ w^i $$ の内積について考えます。
内積は $$ \sum_i v_i w^i $$ と書けます。
座標変換後をプライム記号で表すと、
$$
v'_i = \sum_j (\mathbf{T}^{-1})_{ij} v_j
$$
$$
w'^i = \sum_j T_{ij} w^j
$$
となります。これらの積の和を計算すると、
$$
\sum_i v'_i w'^i = \sum_i \left( \sum_j (\mathbf{T}^{-1})_{ij} v_j \right) \left( \sum_k T_{ik} w^k \right)
$$
ここで、和の順序を入れ替えて、$$ \sum_i (\mathbf{T}^{-1})_{ij} T_{ik} $$ の部分に着目すると、これは行列の積 $$ (\mathbf{T}^{-1} \mathbf{T})_{jk} $$ の $$ (j,k) $$ 成分であり、単位行列 $$ \delta_{jk} $$ に他なりません。

$$
\sum_i v'_i w'^i = \sum_j \sum_k v_j w^k \left( \sum_i (\mathbf{T}^{-1})_{ij} T_{ik} \right) = \sum_j \sum_k v_j w^k \delta_{jk} = \sum_j v_j w^j
$$
この結果は、座標変換後も内積の値が変化しないことを示しています。つまり、**共変ベクトルと反変ベクトルの内積は、常に座標変換に対して不変なスカラー量**となります。

### 2.5 アインシュタインの縮約記法 (Einstein Summation Convention)

上記の議論で見たように、共変成分と反変成分の内積（和）を頻繁に記述する必要があります。
アルベルト・アインシュタインは、相対性理論を展開する際に、この和の記号 $$ \sum $$ を省略する記法を提案しました。

**アインシュタインの縮約記法**:
同じ添え字記号が上付きと下付きでペアとして現れる場合、その添え字については自動的に和をとるものとします。

例:
$$ \sum_i x^i \mathbf{a}_i $$ を $$ x^i \mathbf{a}_i $$ と書く。
$$ \sum_i v_i w^i $$ を $$ v_i w^i $$ と書く。
$$ \sum_k \sum_l T_{ik} T_{jl} g_{kl} $$ を $$ T_{ik} T_{jl} g_{kl} $$ と書く。

この記法は、非常に簡潔で分かりやすいだけでなく、同じ添え字が上付きと下付きでペアになっている場合、それがスカラー量になることを一目で識別できるという大きな利点があります。

### 2.6 添え字規則とテンソル表記

アインシュタインの縮約記法と合わせて、共変成分と反変成分を区別するために、以下の**添え字規則**を導入します。

-   **共変ベクトル・テンソルの添え字は下付きに書く。** (例: $$ v_i, g_{ij} $$)
-   **反変ベクトル・テンソルの添え字は上付きに書く。** (例: $$ v^i, g^{ij} $$)

この規則を用いると、今まで出てきた量を以下のように書き直すことができます。

-   **実行格子の基本ベクトル**: $$ \mathbf{a}_i $$ (共変ベクトル)
-   **実行格子の座標**: $$ x^i $$ (反変ベクトル)
-   **逆格子の基本ベクトル**: $$ \mathbf{a}^{*i} $$ (反変ベクトル)
-   **逆格子の座標（ミラー指数）**: $$ h_i $$ (共変ベクトル)

これにより、例えば「逆格子の計量テンソル」を `rgij` と書かなくても、添え字の位置で実行格子の計量テンソル $$ g_{ij} $$ (2回共変) と逆格子の計量テンソル $$ g^{ij} $$ (2回反変) を明確に区別できるようになります。

この記法を使うと、ベクトルの距離の2乗（ノルムの2乗）も次のように簡潔に記述できます。

$$
|\mathbf{r}|^2 = \mathbf{r} \cdot \mathbf{r} = (x^i \mathbf{a}_i) \cdot (x^j \mathbf{a}_j) = x^i x^j (\mathbf{a}_i \cdot \mathbf{a}_j) = x^i x^j g_{ij}
$$

この式は、2回共変テンソル $$ g_{ij} $$ と2つの反変ベクトル成分 $$ x^i, x^j $$ の積和として表されます。添え字 $$ i, j $$ がそれぞれ上付きと下付きでペアになっているため、結果がスカラー量である（座標変換に対して不変である）ことが一目で分かります。

### 2.7 物理法則の共変性

共変・反変の概念と添え字規則は、物理法則を記述する上で極めて強力なツールとなります。
方程式の左辺と右辺が**同じ変換則に従う（同じ添え字構造になっている）** ことが確認できれば、その方程式は座標変換に対して不変である、すなわち**共変である (Covariant)** ことが一目で分かります。

現代物理学における多くの物理法則は、何らかの対称性（座標変換、ローレンツ変換など）を満たすことが要請されています。

-   **ラグランジアン (Lagrangian)**: 物理法則をスカラー量（座標変換に対して不変な量）として表現する場合によく用いられます。スカラーなので、自ずと共変です。
-   **特殊相対性理論**: ローレンツ変換に対して共変な理論です。ミンコフスキー空間における計量テンソル（ミンコフスキー計量）が中心的な役割を果たします。
-   **一般相対性理論**: さらに一般座標変換に対して共変な理論であり、時空が曲がっていることを計量テンソルが記述します。アインシュタイン方程式は典型的な共変テンソル方程式です。
-   **超弦理論**: ローレンツ共変性に加えて、超対称性変換に対しても不変であることが要請されます。出発点となるラグランジアンは、これらの対称性を満たすように設計されます。

このように、共変形式のテンソル方程式を用いることで、物理法則が満たすべき対称性を明確に表現し、検証することができます。

### 2.8 未知のテンソル成分の共変・反変性の特定

共変・反変の添え字規則は、未知のベクトルやテンソルが共変か反変かを判別する際にも役立ちます。

例えば、実行格子の変換行列 $$ T $$ を考えます。以前、$$ \mathbf{a}'_i = \sum_j T_{ij} \mathbf{a}_j $$ と書きましたが、添え字規則を用いると、より明確になります。

左辺の $$ \mathbf{a}'_i $$ は共変ベクトルなので、下付き添え字を持ちます。
右辺の $$ \sum_j T_{ij} \mathbf{a}_j $$ は、縮約記法を適用すると $$ T_{ij} \mathbf{a}_j $$ となります。ここで、$$ \mathbf{a}_j $$ は共変ベクトルなので下付き添え字です。
和をとる添え字 $$ j $$ は、上付きと下付きでペアになる必要があります。したがって、$$ T_{ij} $$ の $$ j $$ は上付き添え字であるべきです。
そして、残りの添え字 $$ i $$ は、左辺の $$ \mathbf{a}'_i $$ と同じ下付きであるべきです。

このことから、変換行列の成分は $$ T^i_j $$ と書かれるべきであり、これは**1回の反変成分と1回の共変成分を持つ2階テンソル**であることを示しています。
すなわち、$$ \mathbf{a}'_i = T^k_i \mathbf{a}_k $$ あるいは $$ \mathbf{a}'_i = T_{ik} \mathbf{a}_k $$ （変換行列が基底の変換を記述する際）の表記は、文脈によって解釈が異なりますが、添え字のルールに従えば、その性質が明確になります。

講義資料で述べられている「実行格子の変換行列 $$ T_{ij} $$ は、共変ベクトル $$ \mathbf{a}_j $$ を別の座標系の共変ベクトル $$ \mathbf{a}'_i $$ に変換する行列」という記述を添え字規則に照らして再検討します。
変換行列が $$ T_{ij} $$ で表現される場合、これは共変ベクトルを共変ベクトルに変換するテンソル成分と解釈できます。しかし、通常は基底ベクトル $$ \mathbf{a}'_i = \sum_j T_{ij} \mathbf{a}_j $$ のように、基底の線形結合として定義されます。この場合、$$ T_{ij} $$ そのものがテンソルとしてどのような性質を持つか、という問いに対しては、例えば、任意の反変ベクトル $$ V^j $$ を共変ベクトル $$ V_i $$ に変換する役割を持つような場合に $$ T_{ij} $$ が共変テンソルとなる、といった解釈になります。

より一般的な議論として、基底ベクトルを変換する行列と、それに対応するベクトル成分を変換する行列は異なる形を取ります。
例えば、基底ベクトルが $$ \mathbf{e}'_i = M^j_i \mathbf{e}_j $$ と変換されるとき、ベクトル成分は $$ v'^i = (M^{-1})^i_j v^j $$ と変換されます。この $$ M^j_i $$ が「混合テンソル」と呼ばれるものです。
講義資料の文脈では、変換行列自体をテンソルとして捉え、その添え字の上下で性質を判断するという意図が読み取れます。その場合、$$ T^i_j $$ のような表記が自然です。

同様に、逆格子の変換行列も、その添え字の位置から共変・反変の性質を判別できます。

### 2.9 物性テンソルの共変・反変性

材料の様々な物性（誘電性、弾性、熱伝導性など）は、テンソルとして記述されます。これらの物性テンソルも、共変・反変の概念を用いて理解することができます。

1.  **誘電率テンソル (Dielectric Permittivity Tensor)**:
    媒質中の電束密度 $$ \mathbf{D} $$ と電場 $$ \mathbf{E} $$ の関係を記述します。
    $$ D_i = \epsilon_{ij} E^j $$
    あるいは、より一般的に、自由エネルギー密度が電場によって $$ \Delta F = \frac{1}{2} \epsilon_{ij} E^i E^j $$ と書かれることがあります。
    ここで、電場 $$ E^i $$ は通常、反変ベクトル成分として扱われます（電位の勾配として定義されるため）。
    $$ E^i $$ が反変ベクトルであれば、自由エネルギー $$ \Delta F $$ がスカラー（不変量）であるためには、$$ \epsilon_{ij} $$ は**2回共変テンソル**である必要があります。

2.  **歪みテンソル (Strain Tensor)**:
    材料の変形（歪み）を記述するテンソルです。
    微小変位ベクトルを $$ \Delta x^i $$ とすると、歪みテンソル $$ \epsilon_{ij} $$ は、
    $$
    \epsilon_{ij} = \frac{1}{2} \left( \frac{\partial (\Delta x_i)}{\partial x^j} + \frac{\partial (\Delta x_j)}{\partial x^i} \right)
    $$
    （または、より一般的に $$ \epsilon_{ij} = \frac{1}{2} (g_{ik} \frac{\partial (\Delta x^k)}{\partial x^j} + g_{jk} \frac{\partial (\Delta x^k)}{\partial x^i}) $$）
    ここで、$$ \Delta x^i $$ は変位の反変成分、$$ \partial / \partial x^j $$ は微分演算子です。微分演算子は、通常、反変座標での微分 $$ \partial / \partial x^j $$ が共変成分に、共変座標での微分 $$ \partial / \partial x_j $$ が反変成分に対応します。
    したがって、$$ \partial (\Delta x^i) / \partial x^j $$ の形は、反変成分と共変成分を1つずつ持つ**混合テンソル (Mixed Tensor)** となります。歪みテンソルは、この対称化された形なので、**2回共変テンソル**として扱われることが多いです。

3.  **弾性テンソル (Elastic Tensor)**:
    応力テンソル $$ \sigma_{ij} $$ と歪みテンソル $$ \epsilon_{kl} $$ の関係を記述するテンソルです（フックの法則）。
    $$ \sigma_{ij} = C_{ijkl} \epsilon_{kl} $$
    応力テンソル $$ \sigma_{ij} $$ は2回共変テンソル、歪みテンソル $$ \epsilon_{kl} $$ も2回共変テンソルとして扱われることが多いです。
    このとき、$$ C_{ijkl} $$ は**4回共変テンソル**である必要があります。
    （ただし、応力と歪みを混合テンソルとして定義することも可能であり、その場合は弾性テンソルも混合テンソルとなります。）
    講義資料では「共変成分反変成分共変成分反変成分が交互に出てくる反変共変テンソル4回の反変共変テンソル」と記述されていますが、これは弾性定数テンソルが添え字の上下を適切に持つ、より一般的な$$ C_{kl}^{ij} $$のような混合テンソルとして定義される場合を指している可能性が高いです。

このように、共変・反変の添え字規則を適切に利用することで、テンソル方程式の構造を理解し、その物理的な性質（例えば座標変換に対する不変性）を直感的に把握することができます。

### 2.10 物性テンソルの実測と理論計算における課題

実際の材料の物性テンソル成分を決定する際には、いくつか課題があります。

-   **単結晶の場合**: 結晶の単位胞の軸方向が明確に定義されているため、テンソル成分を単位胞の軸に対応付けて表現することができます。実験的に測定された異方性（方向依存性）を持つ物性は、このテンソル成分として記述されます。
-   **多結晶の場合**: ランダムに配向した多数の結晶粒から構成されるため、個々の結晶粒の異方性を直接測定することは困難です。通常は、結晶粒全体の平均値として物性を評価します。この場合、個々の結晶粒のテンソル成分を、方位平均（球平均）によって集約する必要があります。これは、テンソルを対角化して主値（固有値）を求め、その平均をとるといった複雑な操作を伴います。
-   **理論計算との比較**: 密度汎関数理論 (DFT) に基づく第一原理計算コード（例: VASP）などの多くの理論計算ソフトウェアでは、物性テンソル成分を、結晶の格子ベクトルに沿った座標系ではなく、**デカルト座標系 (Cartesian Coordinate System)**（直交座標系）に対して出力するのが一般的です。
    計算の入力ファイル（例: POSCARファイル）で、格子ベクトルがデカルト座標で表現されているため、その出力もデカルト座標系でのテンソル成分として得られます。そのため、理論計算と実験結果を比較する際には、この座標系の違いを考慮してテンソル成分を変換する必要があります。

---

## 3. 共変・反変の基本的な規則のまとめ

これまでの議論で出てきた共変・反変に関する基本的な規則をまとめます。

1.  **基本ベクトルと座標の共変・反変は入れ替わる。**
    -   基本ベクトル（例: $$ \mathbf{a}_i $$）が共変なら、それを展開する座標成分（例: $$ x^i $$）は反変。
    -   基本ベクトル（例: $$ \mathbf{a}^{*i} $$）が反変なら、それを展開する座標成分（例: $$ h_i $$）は共変。

2.  **実空間と逆空間の共変・反変は入れ替わる。**
    -   実空間の基本ベクトル（$$ \mathbf{a}_i $$）が共変なら、逆空間の基本ベクトル（$$ \mathbf{a}^{*i} $$）は反変。
    -   実空間の座標（$$ x^i $$）が反変なら、逆空間の座標（ミラー指数 $$ h_i $$）は共変。

3.  **微分によって共変と反変が入れ替わる。**
    -   反変座標 $$ x^i $$ で微分する演算子 $$ \frac{\partial}{\partial x^i} $$ は共変成分を持つ。
    -   共変座標 $$ x_i $$ で微分する演算子 $$ \frac{\partial}{\partial x_i} $$ は反変成分を持つ。

4.  **計量テンソル $$ g_{ij} $$ やその逆 $$ g^{ij} $$ を用いることで、共変成分と反変成分を相互に変換できる。**
    -   $$ v_i = g_{ij} v^j $$ （反変成分を共変成分に変換）
    -   $$ v^i = g^{ij} v_j $$ （共変成分を反変成分に変換）
    これは、「添え字の上げ下げ (Raising and Lowering Indices)」と呼ばれます。

これらの規則と添え字ルールを厳密に守ることで、複雑なテンソル計算も間違いなく行うことができます。

|                 | 基本ベクトル | 座標成分 | 微分演算子 |
| :-------------- | :----------- | :------- | :--------- |
| **実空間**      | 共変 ($$ \mathbf{a}_i $$) | 反変 ($$ x^i $$) | 共変 ($$ \partial / \partial x^i $$) |
| **逆空間**      | 反変 ($$ \mathbf{a}^{*i} $$) | 共変 ($$ h_i $$) | 反変 ($$ \partial / \partial h_i $$) |

### 3.1 共変座標と反変座標の幾何学的解釈

最後に、共変座標と反変座標の取り方の違いを図を用いて視覚的に理解しましょう。

ある点 $$ P $$ の位置ベクトル $$ \mathbf{r} $$ を考えます。実空間の基本ベクトルを $$ \mathbf{a}_1, \mathbf{a}_2 $$ とします。

1.  **反変座標 ($$ x^1, x^2 $$)**:
    これは、私たちが通常、斜交座標系 (Oblique Coordinate System) で行う座標の取り方です。点 $$ P $$ から $$ \mathbf{a}_2 $$ 軸に平行に線を引いて $$ \mathbf{a}_1 $$ 軸に交わる点まで、その長さを $$ x^1 $$ とします。同様に、$$ \mathbf{a}_1 $$ 軸に平行に線を引いて $$ \mathbf{a}_2 $$ 軸に交わる点までの長さを $$ x^2 $$ とします。
    このとき、位置ベクトルは $$ \mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2 $$ と表現されます。この $$ x^1, x^2 $$ が反変座標成分です。

2.  **共変座標 ($$ x_1, x_2 $$)**:
    これは、点 $$ P $$ から $$ \mathbf{a}_1 $$ 軸に**垂直に**線を引いて $$ \mathbf{a}_1 $$ 軸に交わる点までの長さを $$ x_1 $$ とします。同様に、点 $$ P $$ から $$ \mathbf{a}_2 $$ 軸に**垂直に**線を引いて $$ \mathbf{a}_2 $$ 軸に交わる点までの長さを $$ x_2 $$ とします。このような座標の取り方を正斜交座標系 (Orthonormal Oblique Coordinate System) と呼ぶことがあります。
    この座標は、直感的ではありませんが、$$ \mathbf{r} \cdot \mathbf{a}_1 = x_1 $$、$$ \mathbf{r} \cdot \mathbf{a}_2 = x_2 $$ のように、位置ベクトルを基底ベクトルに投影した値として定義されます。

興味深いことに、この共変座標 $$ x_1, x_2 $$ は、実行格子の逆格子ベクトル $$ \mathbf{a}^{*1}, \mathbf{a}^{*2} $$ を用いたときの**反変座標**に対応します。
つまり、$$ \mathbf{r} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2} $$ （ただし、適切なスケーリング因子を除く）と書くこともできます。
このように、共変座標は、実は逆格子の基本ベクトルで張られる空間における座標成分と密接な関係があるのです。

本講義で学んだ逆格子、共変ベクトル、反変ベクトル、そして添え字規則の概念は、結晶学、固体物理学、相対性理論といった様々な分野で共通して現れる非常に強力な数学的ツールです。これらの概念を理解することで、複雑な物理現象や材料特性を記述するテンソル方程式を、より深く、かつ直感的に理解できるようになるでしょう。

---

以上で本講義を終了します。ありがとうございました。