# 逆格子と共変・反変テンソル：結晶学と物性物理学における基礎概念

---

## 1. 逆格子の復習

### 1.1 逆格子の定義
-   実行格子の基本ベクトル $$ \mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3 $$
-   逆格子の基本ベクトル $$ \mathbf{a}^*_1, \mathbf{a}^*_2, \mathbf{a}^*_3 $$ は以下で定義される:
    $$
    \mathbf{a}^*_1 = \frac{2\pi}{V} (\mathbf{a}_2 \times \mathbf{a}_3)
    $$
    $$
    \mathbf{a}^*_2 = \frac{2\pi}{V} (\mathbf{a}_3 \times \mathbf{a}_1)
    $$
    $$
    \mathbf{a}^*_3 = \frac{2\pi}{V} (\mathbf{a}_1 \times \mathbf{a}_2)
    $$
    （$$ V = |\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)| $$ は単位胞体積）
-   **規格直交化条件**: $$ \mathbf{a}^*_i \cdot \mathbf{a}_j = 2\pi \delta_{ij} $$
    -   $$ \mathbf{a}^*_1 $$ は $$ \mathbf{a}_2, \mathbf{a}_3 $$ に直交。
    -   $$ |\mathbf{a}^*_1| $$ は $$ |\mathbf{a}_1| $$ に反比例。

### 1.2 逆格子の幾何学的解釈
-   **直交性**: 逆格子ベクトルは、対応する実行格子ベクトルの張る平面に垂直。
-   **長さ**: 逆格子ベクトルの長さは、実格子ベクトルの長さの逆数に比例。
-   **軸角**: 実格子の軸角の補角に対応（おおよそ）。
-   **直交座標系以外では大まかな関係。**

---

### 1.3 逆格子の作図と単位格子の曖昧性
-   実行格子の基本ベクトルから逆格子を構成すると、逆格子点が配列する。
-   **問題**: 実行格子の単位胞の取り方によって、逆格子点の配列が異なるように見える。
    -   例: ブラベー格子を単純格子と見なして逆格子を組むと、矛盾が生じるように見える。
-   **解決策**: 逆格子は**実行格子点そのもの**、あるいは**フーリエ変換の物理的意味**から理解すべき。

### 1.4 フーリエ変換としての逆格子と回折現象
-   逆格子は、X線回折やバンド理論など、**波の干渉**が重要な領域で導入される。
-   **散乱振幅**: 電子密度分布 $$ \rho(\mathbf{r}) $$ のフーリエ変換 $$ S(\mathbf{K}) = \int \rho(\mathbf{r}) e^{-i \mathbf{K} \cdot \mathbf{r}} d^3\mathbf{r} $$
    -   $$ \mathbf{K} = \mathbf{k} - \mathbf{k}_0 $$ は散乱ベクトル。
-   **ブラッグ条件**: 散乱ベクトル $$ \mathbf{K} $$ が**逆格子ベクトル $$ \mathbf{G} $$** に等しいとき、散乱振幅は極大になる。
-   **物理的意味**: 散乱振幅がゼロでない逆格子点のみが物理的に意味を持つ。

---

### 1.5 回折における消滅則と逆格子の修正
-   結晶構造の対称性により、一部の回折ピークは観測されない (**消滅則**)。
-   消滅則を考慮することで、逆格子点の配列の曖昧性が解消される。
    -   例えば、体心立方格子 (BCC) の実行格子の逆格子は、面心立方格子 (FCC) になる。
    -   面心立方格子 (FCC) の実行格子の逆格子は、体心立方格子 (BCC) になる。

| 実行格子           | 逆格子           |
| :----------------- | :--------------- |
| 単純立方 (SC)      | 単純立方 (SC)    |
| 体心立方 (BCC)     | 面心立方 (FCC)   |
| 面心立方 (FCC)     | 体心立方 (BCC)   |
| （他のブラベー格子も同様の関係） | |
-   プログラム `crystaldrawcell.py` を読むと、逆格子の計算と可視化方法が理解できる。

---

## 2. 共変ベクトルと反変ベクトル

### 2.1 座標変換とベクトルの分類
-   **共変ベクトル (Covariant Vector)**:
    -   基底ベクトルと同じ変換規則に従う。
    -   例: **実行格子の基本ベクトル $$ \mathbf{a}_i $$**、**逆格子の座標（ミラー指数）$$ h_i $$**
-   **反変ベクトル (Contravariant Vector)**:
    -   基底ベクトルとは逆の変換規則に従う。
    -   例: **実行格子の座標成分 $$ x^i $$**、**逆格子の基本ベクトル $$ \mathbf{a}^{*i} $$**

### 2.2 計量テンソル (Metric Tensor) の共変・反変性
-   **実行格子の計量テンソル**: $$ g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j $$
    -   $$ \mathbf{a}_i $$ が共変ベクトルなので、$$ g_{ij} $$ は**2回共変テンソル**。
-   **逆格子の計量テンソル**: $$ g^{ij} = \mathbf{a}^{*i} \cdot \mathbf{a}^{*j} $$
    -   $$ \mathbf{a}^{*i} $$ が反変ベクトルなので、$$ g^{ij} $$ は**2回反変テンソル**。
-   **歴史**: リーマン、アインシュタインがテンソルと共変・反変の概念を確立。

---

### 2.3 実行格子から逆格子への変換行列
-   実行格子と逆格子の関係は、計量テンソルで結びつけられる。
-   **変換行列**: 実空間の計量テンソルの逆行列が、逆空間の計量テンソルに一致。
    $$ \mathbf{a}^*_i = \sum_j 2\pi (g^{-1})_{ij} \mathbf{a}_j $$
    （より厳密には、$$ (g_{kl})^{-1} = g^{kl} $$）

### 2.4 共変ベクトルと反変ベクトルの内積は不変量
-   共変ベクトル $$ v_i $$ と反変ベクトル $$ w^i $$ の内積 $$ \sum_i v_i w^i $$ は、座標変換に対して**不変なスカラー量**となる。
-   $$ \sum_i v'_i w'^i = \sum_i v_i w^i $$

### 2.5 アインシュタインの縮約記法 (Einstein Summation Convention)
-   同じ添え字記号が上付きと下付きでペアとして現れる場合、和の記号 $$ \sum $$ を省略する。
    -   例: $$ x^i \mathbf{a}_i $$ ($$ \sum_i x^i \mathbf{a}_i $$ を意味する)
-   **メリット**: 表記が簡潔になり、結果がスカラー量であることが一目でわかる。

---

### 2.6 添え字規則とテンソル表記
-   **共変成分**: 下付き添え字 ($$ v_i, g_{ij} $$)
-   **反変成分**: 上付き添え字 ($$ v^i, g^{ij} $$)
-   これにより、実行格子と逆格子の計量テンソルを $$ g_{ij} $$ と $$ g^{ij} $$ のように区別できる。
-   ベクトルの長さの2乗: $$ |\mathbf{r}|^2 = x^i x^j g_{ij} $$ (スカラー量であることが添え字で一目瞭然)

### 2.7 物理法則の共変性
-   方程式の左右が同じ添え字構造なら、その法則は座標変換に対して**共変**である。
-   物理法則は対称性を満たすことが要請される。
    -   **特殊相対性理論**: ローレンツ変換に対して共変。
    -   **一般相対性理論**: 一般座標変換に対して共変。
    -   **超弦理論**: ローレンツ共変性、超対称性変換に対して不変。
-   テンソル方程式を用いることで、対称性を明確に表現・検証できる。

---

### 2.8 未知のテンソル成分の共変・反変性の特定
-   添え字規則を利用して、未知のベクトルやテンソルが共変か反変かを判別できる。
    -   例: 変換行列 $$ T $$ の成分は $$ T^i_j $$ のように、1回の反変成分と1回の共変成分を持つ**混合テンソル**であると理解できる。
    -   添え字の位置で実行格子と逆格子の変換行列を区別。

### 2.9 物性テンソルの共変・反変性
-   **誘電率テンソル $$ \epsilon_{ij} $$**: 電場 $$ E^i $$ が反変なら、$$ \epsilon_{ij} $$ は**2回共変テンソル**。
    -   自由エネルギー $$ \Delta F = \frac{1}{2} \epsilon_{ij} E^i E^j $$ (スカラー)
-   **歪みテンソル $$ \epsilon_{ij} $$**: 変位 $$ \Delta x^i $$ と微分 $$ \partial / \partial x^j $$ を考慮すると、**2回共変テンソル**として扱われることが多い。
-   **弾性テンソル $$ C_{ijkl} $$**: 応力 $$ \sigma_{ij} $$ と歪み $$ \epsilon_{kl} $$ が2回共変なら、$$ C_{ijkl} $$ は**4回共変テンソル**。
    -   $$ \sigma_{ij} = C_{ijkl} \epsilon_{kl} $$
-   添え字規則により、テンソル方程式の構造と性質を直感的に理解できる。

---

### 2.10 物性テンソルの実測と理論計算における課題
-   **単結晶**: 単位胞の軸方向に対応付けてテンソル成分を表現。
-   **多結晶**: 平均値として評価するため、方位平均が必要。
-   **理論計算 (VASPなど)**: 一般にデカルト座標系でテンソル成分が出力される。
    -   入力ファイル (POSCAR) の格子ベクトル方位に依存。
-   実験と理論の比較には、座標変換が必要となる。

---

## 3. 共変・反変の基本的な規則のまとめ

-   **基本ベクトルと座標の共変・反変は入れ替わる。**
-   **実空間と逆空間の共変・反変は入れ替わる。**
-   **微分によって共変と反変が入れ替わる。**
-   **計量テンソルで共変成分と反変成分を相互変換できる (添え字の上げ下げ)。**

|                 | 基本ベクトル | 座標成分 | 微分演算子 |
| :-------------- | :----------- | :------- | :--------- |
| **実空間**      | 共変 ($$ \mathbf{a}_i $$) | 反変 ($$ x^i $$) | 共変 ($$ \partial / \partial x^i $$) |
| **逆空間**      | 反変 ($$ \mathbf{a}^{*i} $$) | 共変 ($$ h_i $$) | 反変 ($$ \partial / \partial h_i $$) |

### 3.1 共変座標と反変座標の幾何学的解釈
-   **反変座標 ($$ x^1, x^2 $$)**:
    -   斜交座標系における「平行な線による投影」。（通常イメージする座標）
    -   $$ \mathbf{r} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2 $$
-   **共変座標 ($$ x_1, x_2 $$)**:
    -   「垂直な線による投影」。
    -   $$ x_1 = \mathbf{r} \cdot \mathbf{a}_1 $$
-   共変座標は、逆格子の基本ベクトルで張られる空間における反変座標に対応。
    -   抽象的な概念も、幾何学的に解釈することで理解が深まる。

---

ご清聴ありがとうございました。