# 逆格子と共変・反変テンソル：結晶学における基礎概念

本講義では、結晶学と物性物理学において極めて重要な概念である「逆格子」について復習し、さらにそれを深く理解するための数学的ツールである「共変・反変テンソル」の概念について学びます。これらの概念は、X線回折などの回折現象の理解、固体中の電子の運動を記述するバンド理論、そして材料の異方的な物性を記述する上で不可欠です。

---

## 第1章 逆格子空間の基礎

### 1.1 逆格子の定義と性質

結晶は、原子が周期的に配列した「実格子」で記述されます。一方、「逆格子」は、この実格子の周期性をフーリエ変換によって波数空間で表現したものであり、結晶によるX線や電子線の回折現象を理解する上で非常に有用です。

#### 1.1.1 逆格子ベクトルの定義

実格子の基本ベクトルを $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$ とするとき、逆格子の基本ベクトル $\mathbf{a}_1^*, \mathbf{a}_2^*, \mathbf{a}_3^*$ は次のように定義されます。

$$
\mathbf{a}_i^* \cdot \mathbf{a}_j = 2\pi \delta_{ij}
$$

ここで、$\delta_{ij}$ はクロネッカーのデルタ（$i=j$ のとき 1、それ以外のとき 0）です。この定義から、逆格子ベクトルは実格子ベクトルによって具体的に以下のように表すことができます。

$$
\mathbf{a}_1^* = 2\pi \frac{\mathbf{a}_2 \times \mathbf{a}_3}{\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)}
$$

$$
\mathbf{a}_2^* = 2\pi \frac{\mathbf{a}_3 \times \mathbf{a}_1}{\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)}
$$

$$
\mathbf{a}_3^* = 2\pi \frac{\mathbf{a}_1 \times \mathbf{a}_2}{\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)}
$$

分母の $\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)$ は実格子の単位胞の体積 $V$ に等しく、これはスカラ三重積として知られています。

#### 1.1.2 実格子ベクトルと逆格子ベクトルの幾何学的関係

上記の定義から、実格子ベクトルと逆格子ベクトルには次のような幾何学的関係が成り立ちます。

1.  **直交性**: 逆格子ベクトル $\mathbf{a}_i^*$ は、自身と同じ添字の付いた実格子ベクトル $\mathbf{a}_i$ とは平行な成分を持たず、残りの2つの実格子ベクトルが張る平面に垂直です。例えば、$\mathbf{a}_1^*$ は $\mathbf{a}_2$ と $\mathbf{a}_3$ の両方に直交します。
2.  **長さの反比例関係**: 逆格子ベクトルの長さは、対応する実格子ベクトルの長さにおおよそ反比例します。厳密には、非直交座標系ではより複雑な関係になりますが、大まかな傾向として理解しておくと便利です。
3.  **軸角の補角**: 実格子の軸角と逆格子の軸角は、非直交座標系では互いに補角の関係にあることが多いです。ただし、これも一般的な直交座標系でない格子では厳密には成り立ちません。

これらの関係は、特に直交座標系（立方晶系など）では正確に成り立ちますが、単斜晶系や三斜晶系といった非直交座標系では、より複雑な変換が必要となることに注意が必要です。

#### 1.1.3 逆格子空間の描画と一意性の問題

実格子の基本ベクトルの取り方（primitive cellかconventional cellか）によって、逆格子の基本ベクトルも異なり、その結果として逆格子点の配列も異なって見えることがあります。

例えば、
- ブラベー格子（conventional cell）から逆格子を構成した場合と、
- 結晶の基本格子（primitive cell）から逆格子を構成した場合では、
逆格子点の配列が異なるように見えることがあります。これは、逆格子が単に実格子ベクトルの定義から機械的に導かれるだけでは、その物理的意味が完全に捉えられないことを示唆しています。

この問題は、実格子の定義自体も「格子点が一意に決まっていても、基本ベクトルの取り方には任意性がある」という点と共通しています。逆に言えば、逆格子を構築する際には、単に幾何学的なベクトル変換だけでなく、物理的な要請を考慮する必要があることを意味します。

### 1.2 逆格子の物理的意味

逆格子は、単なる数学的抽象概念ではなく、様々な物理現象を理解するための極めて重要なツールです。

#### 1.2.1 フーリエ変換としての逆格子

最も重要な物理的意味は、逆格子が**実格子のフーリエ変換**であるという点です。結晶中の電子密度分布や原子の散乱能分布は、実空間における周期関数として表現できます。このような周期関数をフーリエ変換すると、波数空間（逆格子空間）において離散的なピークとして現れます。これらのピークの位置が、まさに逆格子点に対応します。

この特性は、X線回折、電子回折、中性子回折といった**回折現象**の記述において不可欠です。また、固体中の電子のエネルギーバンド構造を記述する**バンド理論**においても、逆格子空間（ブリルアンゾーン）は電子の運動状態を理解するための基本的な舞台となります。

#### 1.2.2 X線回折とブラッグの法則

X線回折は、結晶によるX線の散乱現象を利用して結晶構造を決定する手法です。X線が結晶に照射されると、原子によって散乱され、特定の方向に強め合う干渉（回折）が起こります。この回折が起こる条件は、**ブラッグの法則**によって記述されます。

$$
2d \sin\theta = n\lambda
$$

ここで、$d$ は結晶の格子面間隔、$2\theta$ は回折角、$n$ は回折次数、$\lambda$ はX線の波長です。

ブラッグの法則は、波数空間では**ラウエの条件**または**回折条件**として次のように表現されます。

$$
\Delta \mathbf{k} = \mathbf{k}' - \mathbf{k} = \mathbf{G}
$$

ここで、$\mathbf{k}$ は入射X線の波数ベクトル、$\mathbf{k}'$ は回折X線の波数ベクトル、$\mathbf{G}$ は逆格子ベクトルです。つまり、入射波と散乱波の波数ベクトルの差が、**特定の逆格子ベクトル**に一致するときに回折が起こり、散乱強度が極大になることを意味します。このことから、逆格子点だけが物理的な意味を持つことがわかります。

#### 1.2.3 回折における消滅則と逆格子の一意性

結晶構造によっては、特定の逆格子点に対応する回折ピークが観測されないことがあります。これは「**消滅則 (Extinction Rule)**」と呼ばれ、結晶内の原子の配置が単位胞内で特定の対称性を持つことに起因します。

例えば、体心立方格子（BCC）や面心立方格子（FCC）のように、単位胞内に複数原子が存在するような結晶では、異なる原子からの散乱波が互いに打ち消し合うために、特定の回折ピークが消滅します。

**【具体的な消滅則の例】**

*   **体心立方格子 (BCC)**:
    回折指数 $(h k l)$ に対して、$h+k+l$ が奇数の場合、回折が消滅します。すなわち、$h+k+l$ が偶数の回折のみが観測されます。
    この消滅則を考慮すると、BCCの実格子に対する逆格子は、**面心立方格子 (FCC)** になります。

*   **面心立方格子 (FCC)**:
    回折指数 $(h k l)$ に対して、$h, k, l$ がすべて偶数、またはすべて奇数の場合のみ回折が観測されます。それ以外の場合は消滅します。
    この消滅則を考慮すると、FCCの実格子に対する逆格子は、**体心立方格子 (BCC)** になります。

前述の「逆格子の描画と一意性の問題」は、この消滅則を考慮に入れることで解決します。つまり、物理的に意味のある（散乱振幅がゼロでない）逆格子点のみをプロットすれば、逆格子点の配列は一意に定まり、実格子の基本格子から導かれる逆格子点の配列と一致するようになるのです。

**【代表的なブラベー格子と逆格子の対応】**

| 実格子           | 逆格子           |
| :--------------- | :--------------- |
| 単純立方 (SC)    | 単純立方 (SC)    |
| 体心立方 (BCC)   | 面心立方 (FCC)   |
| 面心立方 (FCC)   | 体心立方 (BCC)   |
| 単純正方 (ST)    | 単純正方 (ST)    |
| 体心正方 (BCT)   | 体心正方 (BCT)   |
| 単純斜方 (SO)    | 単純斜方 (SO)    |
| 底心斜方 (BCO)   | 底心斜方 (BCO)   |
| 体心斜方 (BCC)   | 面心斜方 (FCO)   |
| 面心斜方 (FCO)   | 体心斜方 (BCC)   |
| 単純六方 (SH)    | 単純六方 (SH)    |
| 単純三方 (SR)    | 単純三方 (SR)    |
| 単純単斜 (SM)    | 単純単斜 (SM)    |
| 底心単斜 (BCM)   | 底心単斜 (BCM)   |
| 単純三斜 (STR)   | 単純三斜 (STR)   |

#### 1.2.4 結晶構造解析ソフトウェアへの応用

実際には、結晶構造解析ソフトウェアやシミュレーションツール（例えば VASP などの第一原理計算ソフトウェア）が、これらの逆格子の計算を自動で行います。
例えば、`crystaldrawcell.py` のようなプログラムは、結晶構造情報から逆格子の単位胞を計算し、可視化することができます。このようなプログラムのコードを読むことは、逆格子の計算原理を深く理解する上で非常に役立つでしょう。

---

**コラム: 逆格子の発見とX線回折**

逆格子の概念は、1912年にマックス・フォン・ラウエがX線の結晶による回折現象を発見し、その翌年にウィリアム・ヘンリー・ブラッグとウィリアム・ローレンス・ブラッグ父子がブラッグの法則を提唱したことで、結晶構造解析が飛躍的に発展した時期に確立されました。特に、エヴァルト (Paul Peter Ewald) は、回折現象を幾何学的に記述するために、逆格子の概念を導入し、ラウエの条件を導き出しました。

逆格子空間は、結晶中の電子の波動関数を記述する**ブロッホの定理**においても本質的な役割を果たします。ブロッホの定理は、結晶の周期ポテンシャル中を運動する電子の波動関数が、平面波と結晶の周期性を持つ因子の積で表されることを示しています。この平面波の波数ベクトルは、逆格子空間のブリルアンゾーン内で定義され、電子のエネルギーバンド構造を決定します。このように、逆格子は、結晶の構造だけでなく、その電子物性をも理解するための基礎を提供しています。

---

## 第2章 共変・反変テンソルと結晶物理

結晶の構造や物性は、一般に直交座標系ではない斜交座標系で記述されることが多いため、座標変換を伴う物理量の取り扱いには注意が必要です。「共変・反変テンソル」の概念は、このような座標変換のもとで物理量を正しく記述し、物理法則の普遍性（座標変換に対する不変性）を保証するための強力な数学的枠組みを提供します。

### 2.1 座標変換とベクトル・テンソルの種類

まず、前回の講義でまとめた座標変換のルールを復習し、そこから共変ベクトルと反変ベクトルの概念を導入します。

#### 2.1.1 結晶学における座標変換のルール

ある結晶格子を記述する実格子の基本ベクトル系 $\{\mathbf{a}_i\}$ から、別の基本ベクトル系 $\{\mathbf{a}_j'\}$ への変換を考えます。この変換は、変換行列 $T$ を用いて次のように表されます。

$$
\mathbf{a}_i' = T_{ij} \mathbf{a}_j
$$

このとき、

1.  **実格子ベクトル**: $\mathbf{a}_i$ と同じ変換規則に従います。
    `$$\mathbf{a}_i' = T_{ij} \mathbf{a}_j$$`
2.  **実格子座標**: ある点 $\mathbf{R}$ の実格子座標 $x^i$ は、変換行列 $T$ の転置の逆行列 $(T^t)^{-1}$ を用いて変換されます。
    `$$x'^i = ((T^t)^{-1})_{ij} x^j$$`
3.  **逆格子基本ベクトル**: $\mathbf{a}_i^*$ は、実格子座標 $x^i$ と同じ変換規則に従います。
    `$$\mathbf{a}_i^{*'} = ((T^t)^{-1})_{ij} \mathbf{a}_j^*$$`
4.  **逆格子座標（ミラー指数）**: $h_i$ は、実格子ベクトル $\mathbf{a}_i$ と同じ変換規則に従います。
    `$$h'_i = T_{ij} h_j$$`

#### 2.1.2 共変ベクトルと反変ベクトルの定義

上記の変換規則をまとめると、物理量はその変換の仕方によって大きく2つのグループに分類できます。

*   **共変ベクトル (Covariant Vector)**:
    変換行列 $T$ によって変換される物理量。
    例：**実格子ベクトル $\mathbf{a}_i$**、**逆格子座標（ミラー指数） $h_i$**。
    （添字は**下付き**で表記するのが一般的です：$A_i, B_i$ など）

*   **反変ベクトル (Contravariant Vector)**:
    変換行列 $T$ の転置の逆行列 $((T^t)^{-1})$ によって変換される物理量。
    例：**実格子座標 $x^i$**、**逆格子基本ベクトル $\mathbf{a}^{*i}$**。
    （添字は**上付き**で表記するのが一般的です：$A^i, B^i$ など）

この呼び方は、「共変 (covariant)」が「共に変わる」、「反変 (contravariant)」が「反対に変わる」といった意味合いを持つことから来ています。

### 2.2 計量テンソル

「計量テンソル (Metric Tensor)」は、非直交座標系におけるベクトルの長さや内積を定義するために不可欠なテンソルです。また、共変成分と反変成分を相互に変換する役割も担います。

#### 2.2.1 実空間の計量テンソル

実格子の計量テンソル $g_{ij}$ は、実格子の基本ベクトル $\mathbf{a}_i$ と $\mathbf{a}_j$ の内積として定義されます。

$$
g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j
$$

この計量テンソルが座標変換に対してどのように変換されるかを調べると、

$$
g'_{ij} = \mathbf{a}_i' \cdot \mathbf{a}_j' = (T_{ik} \mathbf{a}_k) \cdot (T_{jl} \mathbf{a}_l) = T_{ik} T_{jl} (\mathbf{a}_k \cdot \mathbf{a}_l) = T_{ik} T_{jl} g_{kl}
$$

となります。これは、変換行列 $T$ を2回用いて変換される形式であり、**2階共変テンソル**であることを示しています。

#### 2.2.2 逆空間の計量テンソル

逆格子の計量テンソル $g^{ij}$ は、逆格子の基本ベクトル $\mathbf{a}^{*i}$ と $\mathbf{a}^{*j}$ の内積として定義されます。

$$
g^{ij} = \mathbf{a}^{*i} \cdot \mathbf{a}^{*j}
$$

同様に、逆格子の計量テンソルが座標変換に対してどのように変換されるかを調べると、

$$
g'^{ij} = \mathbf{a}^{*'i} \cdot \mathbf{a}^{*'j} = (((T^t)^{-1})_{ik} \mathbf{a}^{*k}) \cdot (((T^t)^{-1})_{jl} \mathbf{a}^{*l}) = ((T^t)^{-1})_{ik} ((T^t)^{-1})_{jl} g^{kl}
$$

となります。これは、変換行列 $T$ の転置の逆行列 $((T^t)^{-1})$ を2回用いて変換される形式であり、**2階反変テンソル**であることを示しています。

#### 2.2.3 計量テンソルの関係性

実空間の計量テンソルと逆空間の計量テンソルは、互いに逆行列の関係にあります。

$$
g^{ik} g_{kj} = \delta_j^i
$$

ここで $\delta_j^i$ はクロネッカーのデルタです。この関係は、次の手順で導出できます。
逆格子の定義 $\mathbf{a}^{*i} \cdot \mathbf{a}_j = 2\pi \delta_j^i$ を思い出します。
実格子の基本ベクトルを逆格子ベクトルで展開すると $\mathbf{a}_j = g_{jk} \mathbf{a}^{*k}$ のようになります（ただし $g_{jk}$ は適切な係数）。
同様に、$\mathbf{a}^{*i}$ を実格子ベクトルで展開すると $\mathbf{a}^{*i} = g^{ik} \mathbf{a}_k$ のようになります。
これらを用いて計算すると、$g^{ik} g_{kj} = \delta_j^i$ が導出されます。
この性質は、計量テンソルが共変成分と反変成分を相互に変換する役割を果たすことを意味します。例えば、共変ベクトル $A_i$ と計量テンソル $g^{ij}$ を使って反変ベクトル $A^j$ を得ることができます。

$$
A^j = g^{jk} A_k
$$

また、反変ベクトル $A^i$ と計量テンソル $g_{ij}$ を使って共変ベクトル $A_j$ を得ることができます。

$$
A_j = g_{jk} A^k
$$

このように、計量テンソルは**添字の昇降 (raising and lowering indices)** の役割を担っています。

### 2.3 内積の不変性とアインシュタインの縮約記法

物理法則は、座標系の選び方によらず普遍的であるべきです。この普遍性は「不変性」として表現されます。共変・反変テンソルは、この不変性を数学的に保証する上で非常に有用です。

#### 2.3.1 スカラー量の不変性

あるベクトル $\mathbf{R}$ を考えます。このベクトルは、実格子の基本ベクトルと座標を用いて $\mathbf{R} = x^i \mathbf{a}_i$ と表すことができます。座標変換後の系では $\mathbf{R} = x'^j \mathbf{a}_j'$ となります。この物理量としてのベクトル $\mathbf{R}$ 自体は、座標系の選び方によらず同じものであるべきです。

実際、$\mathbf{R}$ は共変ベクトル $\mathbf{a}_i$ と反変座標 $x^i$ の内積として表現されており、この内積は座標変換に対して不変な**スカラー量**となります。

$$
x^i \mathbf{a}_i = x'^j \mathbf{a}_j'
$$

この関係は、共変成分と反変成分のペアの内積が常にスカラー量（不変量）となることを示しています。

#### 2.3.2 アインシュタインの縮約記法とその利点

アルバート・アインシュタインは、一般相対性理論を展開する際に、共変・反変テンソルを扱う上で非常に便利な表記法を提案しました。それが「**アインシュタインの縮約記法 (Einstein Summation Convention)**」です。

この記法では、式中に同じ添字が上付きと下付きでペアになって現れた場合、その添字について自動的に和をとる（$\sum$ 記号を省略する）というルールを定めます。

例えば、ベクトルの表現は、

$$
\mathbf{R} = \sum_{i} x^i \mathbf{a}_i \quad \rightarrow \quad \mathbf{R} = x^i \mathbf{a}_i
$$

と簡潔に書けるようになります。

この記法の便利な点は次の通りです。

*   **式の簡潔化**: 和記号を省略できるため、複雑なテンソル式が非常に見やすくなります。
*   **スカラー量の識別**: 同じ添字が上と下でペアになっている項は、その添字が「縮約」されて消えるため、結果としてスカラー量（不変量）になることが一目でわかります。
*   **テンソルの階数**: 縮約されていない添字の数と位置によって、テンソルの階数と共変/反変の性質が直感的に理解できます。

---

**コラム: アインシュタインの縮約記法と一般相対性理論**

アインシュタインの縮約記法は、特殊相対性理論から一般相対性理論へと発展する過程で、非常に複雑なテンソル方程式を簡潔に記述するために考案されました。一般相対性理論は、重力を時空の幾何学的な性質として記述する理論であり、時空の曲がりを表現するために計量テンソルとリーマンテンソルなどの高階テンソルが不可欠です。これらのテンソルを扱う上で、縮約記法は方程式の構造を明瞭にし、座標変換不変性を一目で確認できる強力なツールとなりました。アインシュタインはこの記法を大変気に入り、「私の人生で最も素晴らしい発見」の一つと評したと言われています。

---

### 2.4 添字規則とテンソル表現

アインシュタインの縮約記法と共変・反変の概念を組み合わせることで、物理量をより体系的に記述できるようになります。

#### 2.4.1 共変・反変添字の表記法

私たちがこれから用いる添字規則を再確認します。

*   **共変成分**: 添字は**下付き**で書きます（例：$A_i, B_{ij}, g_{ij}$）。これらは変換行列 $T$ によって変換されます。
*   **反変成分**: 添字は**上付き**で書きます（例：$A^i, B^{ij}, g^{ij}$）。これらは変換行列 $T$ の転置の逆行列 $((T^t)^{-1})$ によって変換されます。

このルールに従うと、わざわざ「実空間の計量テンソル $g_{ij}$」や「逆空間の計量テンソル $g^{ij}$」と区別して書かなくても、添字の位置によってそれが実空間のものか逆空間のものか、あるいは共変成分か反変成分かが一目でわかるようになります。

**【例】**
ベクトルの長さの2乗（ノルムの2乗）は、次のように計量テンソルと座標を用いて表現されます。

$$
|\mathbf{R}|^2 = g_{ij} x^i x^j
$$

この式では、$g_{ij}$ は2階共変テンソル、$x^i, x^j$ は反変座標です。添字 $i$ と $j$ がそれぞれ上付きと下付きでペアになっているため、アインシュタインの縮約記法により和がとられ、結果としてスカラー量（不変量）になることがわかります。つまり、ベクトルの長さの2乗は座標系の選び方によらず常に同じ値を取る物理量であることを示しています。

#### 2.4.2 方程式の共変性と物理法則

物理法則を記述する方程式は、「**共変である (covariant)**」ことがしばしば要請されます。これは、方程式の左辺と右辺が、どのような座標変換に対しても同じ変換規則に従うことを意味します。つまり、両辺の添字構造が同じである（同じ数の上付き添字と下付き添字を持つ）ことを確認できれば、その方程式が座標変換に対して不変である（物理的に普遍的である）と判断できるのです。

私たちが大学以上で学ぶ物理法則は、何らかの対称性（時空の対称性、ゲージ対称性など）を満たすことが要請されます。このような場合、物理法則をラグランジアンのようなスカラー量として表現したり、共変形式のテンソル方程式として表現し、両辺の添字構造を比較することで、その方程式が要請されている対称性を満たすかを一目で確認できます。

**【例】**
*   **特殊相対性理論**: マクスウェルの方程式は、ローレンツ変換（時空の回転やブースト）に対して共変です。
*   **一般相対性理論**: さらに一般的な任意の座標変換（一般相対性原理）に対して共変な理論です。
*   **超弦理論**: ローレンツ共変性などに加えて、超対称性変換に対しても不変であることが要請されています。出発点となるラグランジアンは、これらの要請を満たすように設計されます。

このように、共変・反変テンソルの概念と添字規則を理解することは、物理法則の根底にある対称性や普遍性を捉える上で非常に強力な武器となります。

---

### 2.5 微分と共変・反変テンソル

微分操作を行うと、共変成分と反変成分の性質が入れ替わることがあります。

#### 2.5.1 スカラー関数の微分

スカラー関数 $f(\mathbf{R})$ を反変座標 $x^i$ で微分した $\frac{\partial f}{\partial x^i}$ がどのような性質を持つか見てみましょう。
合成関数の微分法則（連鎖律）を用いて、座標変換後の $x'^j$ による微分を考えます。

$$
\frac{\partial f}{\partial x'^j} = \frac{\partial x^k}{\partial x'^j} \frac{\partial f}{\partial x^k}
$$

ここで、座標の変換則 $x^k = T^k_l x'^l$ を思い出します。ただし、ここでの $T^k_l$ は、厳密には変換行列 $T$ の逆行列の転置 $(T^{-1})^t$ の成分にあたります。具体的に言うと、`$x'^j = ((T^t)^{-1})_{jk} x^k$` であったので、`$\frac{\partial x^k}{\partial x'^j}$` は変換行列の逆行列の転置成分 `$(T^{-1})^t_{kj}$` となります。これを $T^k_j$ と書くと、

$$
\frac{\partial f}{\partial x'^j} = T^k_j \frac{\partial f}{\partial x^k}
$$

この形式は、変換行列 $T$ と同じ変換規則に従っているように見えます。したがって、スカラー関数を**反変座標**で微分すると、結果は**共変ベクトル**になることがわかります。

#### 2.5.2 物性テンソルへの応用例

この微分と共変・反変の入れ替わりの規則は、様々な材料の物性を記述するテンソルがどのような共変・反変成分を持つかを理解する上で役立ちます。

**(1) 電場ベクトル** $\mathbf{E}$
電位 $\phi$ はスカラー量です。電場 $\mathbf{E}$ は、電位の勾配として定義されます。

$$
\mathbf{E} = -\nabla \phi
$$

成分表示では $E_i = -\frac{\partial \phi}{\partial x^i}$ となります。
電位 $\phi$ はスカラー量であり、反変座標 $x^i$ で微分されているため、$E_i$ は**共変ベクトル**であることがわかります。

**(2) 誘電率テンソル** $\epsilon_{ij}$
電束密度 $\mathbf{D}$ と電場 $\mathbf{E}$ の関係は、誘電率テンソル $\epsilon_{ij}$ を用いて次のように表されます。

$$
D_i = \epsilon_{ij} E^j
$$

電束密度 $\mathbf{D}$ の成分 $D_i$ は共変ベクトル、電場 $\mathbf{E}$ の成分 $E^j$ は反変ベクトル（通常は $\mathbf{E} = E^j \mathbf{a}_j$ と表現されるため）であるとすると、誘電率テンソル $\epsilon_{ij}$ は**2階共変テンソル**であると推測できます（$i$ と $j$ の添字が両方とも下付きであるため）。

**(3) ひずみテンソル** $\epsilon_{ij}$
ひずみテンソルは、変位ベクトル $\mathbf{u}$ の勾配として定義されます。例えば、線形ひずみテンソルの共変成分は、変位の共変ベクトル $u_i$ を反変座標 $x^j$ で微分したものの対称成分として定義されます。

$$
\epsilon_{ij} = \frac{1}{2} \left( \frac{\partial u_i}{\partial x^j} + \frac{\partial u_j}{\partial x^i} \right)
$$

ここでは、変位の共変成分 $u_i$ を反変座標 $x^j$ で微分しているので、結果として $\epsilon_{ij}$ は**2階共変テンソル**となります。

**(4) 弾性テンソル** $C_{ijkl}$
応力 $\sigma^{ij}$ とひずみ $\epsilon_{kl}$ の関係は、弾性テンソル $C^{ijkl}$ を用いて次のように表されます。

$$
\sigma^{ij} = C^{ijkl} \epsilon_{kl}
$$

応力テンソル $\sigma^{ij}$ は2階反変テンソル、ひずみテンソル $\epsilon_{kl}$ は2階共変テンソルです。したがって、弾性テンソル $C^{ijkl}$ は、添字の構造から**2階反変2階共変テンソル（4階テンソル）** であるとわかります。

このように、共変・反変テンソルの規則を適用することで、物理量の性質を体系的に理解し、適切な数学的表現を選択することができます。

### 2.6 物性テンソルの実用的な取り扱い

#### 2.6.1 非直交系でのベクトル解析の利点

非直交座標系（斜交座標系）を扱う場合、通常のデカルト座標系でのベクトル解析は非常に複雑になることがあります。共変・反変テンソルを用いた解析は、このような系での理論展開を非常に簡潔かつ見通しよくしてくれます。特に、結晶学において一般の結晶系を扱う際には、このアプローチが不可欠です。

#### 2.6.2 計算科学とデカルト座標

しかしながら、実際に第一原理計算（DFT）ソフトウェア（VASPなど）の出力では、物性テンソル成分は多くの場合**デカルト座標系**で出力されます。
例えば、VASPの入力ファイルである POSCAR ファイルでは、格子ベクトルはデカルト座標で表現されます。そして、出力される弾性定数、誘電率、Born有効電荷テンソルなども、このデカルト座標系に準拠して与えられます。

これは、計算の便宜上、デカルト座標系を用いる方が実装が容易であるためです。したがって、理論解析で共変・反変テンソルを用いて導出した結果を、実際の計算結果と比較する際には、適切な座標変換を行う必要があります。この変換には、計量テンソルや変換行列の知識が重要となります。

### 2.7 共変・反変ベクトルのまとめ

本講義で学んだ共変・反変ベクトルの基本的な変換規則をまとめます。

1.  **基本ベクトルと座標**: 基本ベクトルと座標の共変・反変性は入れ替わります。
2.  **実空間と逆空間**: 実空間の物理量と逆空間の物理量の共変・反変性も入れ替わります。
3.  **微分**: スカラー関数を反変座標で微分すると共変ベクトルに、共変座標で微分すると反変ベクトルになります。
4.  **計量テンソル**: 計量テンソル $g_{ij}$ および $g^{ij}$ を用いることで、共変成分と反変成分を相互に変換できます（添字の昇降）。

以下の表に、主要な物理量の共変・反変の性質をまとめます。

| 分類            | 共変成分 (下付き添字)                                                                      | 反変成分 (上付き添字)                                                                          |
| :-------------- | :----------------------------------------------------------------------------------------- | :--------------------------------------------------------------------------------------------- |
| **実空間**      | 実格子基本ベクトル ($\mathbf{a}_i$)                                                          | 実格子座標 ($x^i$)                                                                             |
|                 | 実空間の計量テンソル ($g_{ij}$)                                                            | 実空間の計量テンソルの逆行列 ($g^{ij}$)                                                      |
|                 | 電場ベクトル ($E_i = -\partial \phi / \partial x^i$)                                     | 電位 $\phi$ を共変座標で微分した場合 ($\partial \phi / \partial x_i$)                        |
| **逆空間**      | 逆格子座標（ミラー指数）($h_i$)                                                          | 逆格子基本ベクトル ($\mathbf{a}^{*i}$)                                                         |
|                 | 逆空間の計量テンソル ($g_{ij}^*$)                                                          | 逆空間の計量テンソルの逆行列 ($g^{*ij}$)                                                     |
|                 | ($\partial f / \partial h^i$) (スカラー関数 $f$ を反変逆格子座標で微分)                  | ($\partial f / \partial h_i$) (スカラー関数 $f$ を共変逆格子座標で微分)                      |
| **微分操作**    | スカラー関数 $f$ を反変座標 $x^i$ で微分した結果 ($\partial f / \partial x^i$)          | スカラー関数 $f$ を共変座標 $x_i$ で微分した結果 ($\partial f / \partial x_i$)              |
| **変換行列**    | 共変ベクトルを変換する行列 ($T_{ij}$ の形式)                                             | 反変ベクトルを変換する行列 ($((T^t)^{-1})_{ij}$ の形式)                                       |

これらのルールと添字規則を厳密に適用することで、共変・反変テンソルを用いた計算において間違いを防ぎ、物理法則の普遍性を正しく表現できるようになります。

### 2.8 共変座標と反変座標

最後に、共変座標と反変座標の幾何学的な意味について軽く触れて終わりにしましょう。

これまでの議論で、私たちはある点 $\mathbf{P}$ の位置ベクトル $\mathbf{R}$ を、実格子の基本ベクトル $\mathbf{a}_1, \mathbf{a}_2$ と座標 $x^1, x^2$ を用いて $\mathbf{R} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2$ と表してきました。この座標 $x^i$ は**反変座標**に対応します。これは、点 $\mathbf{P}$ から $\mathbf{a}_1$ 軸に平行に $\mathbf{a}_2$ 軸まで、また $\mathbf{a}_2$ 軸に平行に $\mathbf{a}_1$ 軸まで射影して得られる座標です。このような座標の取り方を「**規定座標系 (oblique coordinate system)**」と呼びます。

これに対して、点 $\mathbf{P}$ の位置ベクトル $\mathbf{R}$ を、基本ベクトル $\mathbf{a}_1, \mathbf{a}_2$ に対して**垂直に射影**して得られる座標 $x_1, x_2$ を考えることもできます。この場合、$\mathbf{R} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2}$ のように、逆格子の基本ベクトル $\mathbf{a}^{*i}$ を用いて表現される座標に対応します。このような座標の取り方を「**正座標系 (normal coordinate system)**」と呼びます。この座標 $x_i$ は、**共変座標**に対応します。

[図1: 規定座標系と正座標系の概念図 (A1, A2, A*1, A*2 ベクトルと点Pの座標軸への射影を模式的に示す図)]

共変座標 $x_i$ は $\mathbf{R} \cdot \mathbf{a}_i^* / (2\pi)$、反変座標 $x^i$ は $\mathbf{R} \cdot \mathbf{a}^i / (2\pi)$ に対応し、計量テンソルによって互いに変換可能です。
このように、共変座標と反変座標は、同じ物理的な位置を異なる幾何学的な射影方法で表現したものとして理解できます。どちらの表現を用いるかは、解決したい問題や座標系の性質によって使い分けられます。

本講義では、逆格子と共変・反変テンソルの基礎を学びました。これらの概念は、材料科学における様々な高度な理論やシミュレーションを理解するための強力な基盤となります。