# 逆格子と共変・反変テンソル：結晶学における基礎概念

材料科学特論

---

## 本講義の目的

*   **逆格子の復習**:
    *   定義、幾何学的関係、物理的意味を再確認する
    *   X線回折、バンド理論における重要性を理解する
*   **共変・反変テンソルの基礎**:
    *   座標変換ルールとベクトルの種類を学ぶ
    *   計量テンソル、添字規則、アインシュタインの縮約記法を理解する
*   **結晶物理への応用**:
    *   物性テンソルの共変・反変性を判別できるようになる

---

## 1. 逆格子の定義と性質

### 逆格子ベクトルの定義

*   実格子基本ベクトル $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}_3$
*   逆格子基本ベクトル $\mathbf{a}_1^*, \mathbf{a}_2^*, \mathbf{a}_3^*$ は以下を満たす：
    `$$\mathbf{a}_i^* \cdot \mathbf{a}_j = 2\pi \delta_{ij}$$`
    (`$\delta_{ij}$` はクロネッカーのデルタ)
*   具体的には：
    `$$\mathbf{a}_1^* = 2\pi \frac{\mathbf{a}_2 \times \mathbf{a}_3}{\mathbf{a}_1 \cdot (\mathbf{a}_2 \times \mathbf{a}_3)}$$`
    (分母は単位胞体積 $V$)

---

### 実格子と逆格子の幾何学的関係

*   **直交性**:
    *   $\mathbf{a}_1^*$ は $\mathbf{a}_2, \mathbf{a}_3$ が張る平面に垂直。
    *   $\mathbf{a}_i^*$ は $\mathbf{a}_j$ (`$i \neq j$`) に直交。
*   **長さの反比例**:
    *   逆格子ベクトルの長さは、対応する実格子ベクトルの長さにおおよそ反比例。
    *   ($|\mathbf{a}_1^*| \propto 1/|\mathbf{a}_1|$)
*   **軸角の補角**:
    *   実格子の軸角と逆格子の軸角は互いに補角に対応 (非直交系では注意が必要)。

---

### 逆格子空間の描画と一意性の問題

*   実格子の基本ベクトルの取り方（ブラベー格子 vs 基本格子）によって、描かれる逆格子点が異なるように見えることがある。
*   これは、単なる幾何学的変換だけでは逆格子の物理的意味を完全に捉えきれないことを示唆。

---

## 2. 逆格子の物理的意味

### フーリエ変換としての逆格子

*   **逆格子は実格子のフーリエ変換である。**
    *   結晶の周期性を波数空間（逆格子空間）で表現。
*   **応用分野**:
    *   **回折現象**: X線回折、電子回折、中性子回折など
    *   **固体物理学**: 電子バンド理論（ブリルアンゾーン）

---

### X線回折とブラッグの法則

*   **ブラッグの法則**: `$2d \sin\theta = n\lambda$`
    *   結晶によるX線の回折条件。
*   **波数空間での表現（ラウエの条件）**:
    `$$\Delta \mathbf{k} = \mathbf{k}' - \mathbf{k} = \mathbf{G}$$`
    *   入射波 ($\mathbf{k}$) と回折波 ($\mathbf{k}'$) の波数ベクトル差が**逆格子ベクトル ($\mathbf{G}$)** に一致するとき、回折が起こる。
    *   物理的に意味があるのは逆格子点のみ。

---

### 回折における消滅則と逆格子の一意性

*   **消滅則**: 特定の逆格子点に対応する回折ピークが観測されない現象。
    *   結晶内の原子配置の対称性に起因。
*   **例**:
    *   **体心立方格子 (BCC)**: `$h+k+l$` が奇数の回折は消滅。
        *   逆格子は**面心立方格子 (FCC)** になる。
    *   **面心立方格子 (FCC)**: `$h, k, l$` がすべて偶数、またはすべて奇数の回折のみ観測。
        *   逆格子は**体心立方格子 (BCC)** になる。
*   消滅則を考慮することで、逆格子点の配列は一意に定まる。
*   `crystaldrawcell.py` のようなプログラムで可視化・学習可能。

---

### ブラベー格子と逆格子の対応

| 実格子           | 逆格子           |
| :--------------- | :--------------- |
| 単純立方 (SC)    | 単純立方 (SC)    |
| 体心立方 (BCC)   | 面心立方 (FCC)   |
| 面心立方 (FCC)   | 体心立方 (BCC)   |
| ... (他の格子系も同様の対応関係) | ...              |

---

## 3. 共変・反変テンソル：導入

### 結晶学における座標変換のルール

*   基本ベクトル系 $\{\mathbf{a}_i\}$ から $\{\mathbf{a}_j'\}$ への変換は変換行列 $T$ で記述。
    *   `$$\mathbf{a}_i' = T_{ij} \mathbf{a}_j$$`
*   **変換規則の分類**:
    1.  **実格子ベクトル $\mathbf{a}_i$**: `$T_{ij}$` で変換される。
    2.  **実格子座標 $x^i$**: `$(T^t)^{-1}$` で変換される。
    3.  **逆格子基本ベクトル $\mathbf{a}^{*i}$**: `$(T^t)^{-1}$` で変換される。
    4.  **逆格子座標（ミラー指数） $h_i$**: `$T_{ij}$` で変換される。

---

### 共変ベクトルと反変ベクトル

*   **共変ベクトル (Covariant Vector)**:
    *   変換行列 $T$ と同じ規則で変換される。
    *   **例**: 実格子ベクトル $\mathbf{a}_i$、逆格子座標 $h_i$。
    *   **表記**: 添字は**下付き** ($A_i, B_i$)
*   **反変ベクトル (Contravariant Vector)**:
    *   変換行列 $T$ の転置の逆行列 `$(T^t)^{-1}$` で変換される。
    *   **例**: 実格子座標 $x^i$、逆格子基本ベクトル $\mathbf{a}^{*i}$。
    *   **表記**: 添字は**上付き** ($A^i, B^i$)

---

### 計量テンソル (Metric Tensor)

*   非直交座標系におけるベクトルの長さや内積を定義。
*   共変成分と反変成分の相互変換（添字の昇降）に用いる。

#### 実空間の計量テンソル $g_{ij}$

*   実格子ベクトルの内積:
    `$$g_{ij} = \mathbf{a}_i \cdot \mathbf{a}_j$$`
*   **性質**: 2階**共変**テンソル

#### 逆空間の計量テンソル $g^{ij}$

*   逆格子ベクトルの内積:
    `$$g^{ij} = \mathbf{a}^{*i} \cdot \mathbf{a}^{*j}$$`
*   **性質**: 2階**反変**テンソル

---

### 計量テンソルの関係性

*   実空間の計量テンソルと逆空間の計量テンソルは互いに逆行列の関係。
    `$$g^{ik} g_{kj} = \delta_j^i$$`
*   **添字の昇降**:
    *   共変ベクトルから反変ベクトルへ: `$A^j = g^{jk} A_k$`
    *   反変ベクトルから共変ベクトルへ: `$A_j = g_{jk} A^k$`

---

### 内積の不変性

*   共変ベクトルと反変ベクトルの内積は、座標変換に対して不変な**スカラー量**となる。
    *   例: ベクトル $\mathbf{R} = x^i \mathbf{a}_i$（反変座標と共変ベクトルの内積）
    *   `$$x^i \mathbf{a}_i = x'^j \mathbf{a}_j'$$`
    *   物理法則の普遍性を数学的に保証。

---

### アインシュタインの縮約記法

*   同じ添字が上付きと下付きでペアになって現れた場合、その添字について自動的に和をとる（$\sum$ を省略）。
    *   例: `$x^i \mathbf{a}_i$` は `$\sum_i x^i \mathbf{a}_i$` を意味する。
*   **利点**:
    *   式の簡潔化、見通しが良くなる。
    *   スカラー量の識別が容易（縮約された添字が消える）。
    *   テンソルの階数と性質が直感的にわかる。

---

### 物理法則の共変性

*   **共変である**：方程式の左辺と右辺が、どのような座標変換に対しても同じ変換規則に従うこと。
*   **添字構造の一致**: 両辺の添字構造が同じ（同じ数の上付き・下付き添字を持つ）ことを確認できれば、方程式は座標変換に対して不変であると判断できる。
*   **対称性**: 物理法則が持つ対称性を表現するための強力なツール。
    *   例: 特殊相対性理論 (ローレンツ共変)、一般相対性理論 (一般共変)

---

## 4. 微分と共変・反変テンソル

### スカラー関数の微分

*   スカラー関数 $f$ を**反変座標 $x^i$ で微分**した結果 ($\partial f / \partial x^i$) は、**共変ベクトル**になる。
    *   `$$\frac{\partial f}{\partial x'^j} = \frac{\partial x^k}{\partial x'^j} \frac{\partial f}{\partial x^k} = T^k_j \frac{\partial f}{\partial x^k}$$`

---

### 物性テンソルへの応用例

*   **電場ベクトル $E_i$**: 電位 $\phi$ (スカラー) を反変座標で微分 → **共変ベクトル**
    *   `$$E_i = -\frac{\partial \phi}{\partial x^i}$$`
*   **誘電率テンソル $\epsilon_{ij}$**: 電束密度 $D_i$ と電場 $E^j$ の関係 `$D_i = \epsilon_{ij} E^j$`
    *   $\epsilon_{ij}$ は**2階共変テンソル**
*   **ひずみテンソル $\epsilon_{ij}$**: 変位 $u_i$ を反変座標 $x^j$ で微分
    *   `$$\epsilon_{ij} = \frac{1}{2} \left( \frac{\partial u_i}{\partial x^j} + \frac{\partial u_j}{\partial x^i} \right)$$`
    *   $\epsilon_{ij}$ は**2階共変テンソル**
*   **弾性テンソル $C^{ijkl}$**: 応力 $\sigma^{ij}$ とひずみ $\epsilon_{kl}$ の関係 `$\sigma^{ij} = C^{ijkl} \epsilon_{kl}$`
    *   $C^{ijkl}$ は**2階反変2階共変テンソル (4階テンソル)**

---

## 5. 共変・反変の総括

### 変換ルールまとめ

*   **基本ベクトル $\leftrightarrow$ 座標**: 共変・反変が入れ替わる。
*   **実空間 $\leftrightarrow$ 逆空間**: 共変・反変が入れ替わる。
*   **微分操作**: 反変座標で微分すると共変に、共変座標で微分すると反変に。
*   **計量テンソル**: 添字の昇降によって共変・反変を相互変換できる。

---

### 共変座標と反変座標の幾何学的解釈

*   **反変座標 ($x^i$)**: 基底ベクトルに**平行**に軸に射影して得られる座標。
    *   「規定座標系 (oblique coordinate system)」
    *   例: $\mathbf{R} = x^1 \mathbf{a}_1 + x^2 \mathbf{a}_2$
*   **共変座標 ($x_i$)**: 基底ベクトルに**垂直**に軸に射影して得られる座標。
    *   「正座標系 (normal coordinate system)」
    *   例: $\mathbf{R} = x_1 \mathbf{a}^{*1} + x_2 \mathbf{a}^{*2}$
*   同じ物理的な位置を、異なる幾何学的射影方法で表現したもの。

[図1: 規定座標系と正座標系の概念図 (ベクトル $\mathbf{a}_1, \mathbf{a}_2, \mathbf{a}^{*1}, \mathbf{a}^{*2}$ と点Pの座標軸への射影を模式的に示す図)]

---

## 本日のまとめ

*   **逆格子**:
    *   実格子のフーリエ変換であり、回折現象や電子バンド理論に不可欠。
    *   消滅則を考慮することで一意に定まる。
*   **共変・反変テンソル**:
    *   座標変換のもとでの物理量の振る舞いを記述。
    *   計量テンソル、アインシュタインの縮約記法が重要。
    *   物性テンソルの性質理解や物理法則の普遍性確認に役立つ。

ご清聴ありがとうございました。