# 統計力学概論：第3回 古典統計力学の基礎

### イントロダクション

みなさん、こんにちは。統計力学概論、第3回目の講義を始めます。

前回は、空間の対称性という、数学的に洗練されたアプローチで自由理想気体の速度分布、いわゆる**マクスウェル分布**を導出しました。しかし、今日は視点を変えて、もっと直感的な**確率論**に基づき、任意のポテンシャル中に存在する粒子系の分布関数を導出します。今日の講義は、これまでの熱力学やニュートン力学では見えてこなかった、**ミクロな世界**と**マクロな世界**をつなぐ統計力学の核心に迫る内容です。

---

### 講義内容の復習と質問への回答

講義を始める前に、前回の課題と皆さんから寄せられた質問に答えましょう。

#### 1. 課題：統計分布関数がエネルギーに関して指数関数となる理由

この問いに明確な答えを出すのは難しいですが、最もシンプルに説明すると、その理由は**空間がXYZ方向に独立で対称**であるという前提にあります。この独立性から、3つの方向の速度成分に関する関数の積の形で分布関数が表現され、この積の形が指数関数という解を導くのです。

#### 2. 運動エネルギーはなぜ $\frac{1}{2}mv^2$ で表されるのか？

これは非常に良い質問です。私たちは日頃、当たり前のようにこの式を使っていますが、その起源を考えることは重要です。この式は、ニュートンの運動方程式 $F=ma$ から導出された**仕事**の概念から定義されています。

$$ \text{仕事 } W = \int F \,dx = \int ma \,dx $$

この積分を計算すると、仕事は $\frac{1}{2}mv^2$ に比例することがわかります。この運動に起因するエネルギーを**運動エネルギー**と呼ぶと決めたわけです。つまり、運動エネルギーは**定義**として導入された概念です。物理学の定理や概念が、**定義**なのか、**仮説**なのか、それとも**導出された法則**なのかを常に意識することが、深く学ぶ上で非常に大切です。

---

### 1. 統計力学の基本的な概念

今日の講義の中心となる概念をいくつか導入します。

#### 1.1. 位相空間 (Phase Space)

N個の粒子からなる系を考えましょう。この系の物理的状態を完全に記述するためには、各粒子の座標と運動量（あるいは速度）を指定する必要があります。

* **1粒子**: 座標 $(x, y, z)$ と運動量 $(p_x, p_y, p_z)$ で記述される6次元空間。
* **N粒子**: 6N次元空間。

この仮想的な空間を**位相空間**と呼びます。位相空間中の1点1点が、その時点におけるN粒子系の全状態を完全に表します。

#### 1.2. エルゴード仮説と等確率の原理

統計力学では、**時間平均**と**アンサンブル平均**が一致すると仮定します。

* **時間平均**: 1つの系を長時間にわたって観測し、その平均をとること。
* **アンサンブル平均**: 多数の同じ系（同じ条件で準備された統計集団）をある瞬間に観測し、その平均をとること。

この両者が一致するというのが**エルゴード仮説**です。この仮説が成立するなら、私たちは個々の粒子の運動を追跡する代わりに、膨大な数の粒子が集まった状態の平均的な振る舞いを調べればよいことになります。

この仮説をより実践的にしたのが、**等確率の原理**です。これは「**位相空間中の、同じエネルギー幅に含まれるすべての微小状態は、等しい確率で出現する**」というものです。この原理が、これからの議論の土台となります。

---

### 2. ボルツマン分布の導出

いよいよ、**ボルツマン分布**を導出します。

#### 2.1. 最大配置数

等確率の原理に従うと、私たちが観測する系は、最も**出現確率が高い**状態、すなわち、**最も多くの組み合わせで実現される状態**であると考えられます。

いま、N個の粒子を、エネルギーの異なるいくつかの「細胞」に分配することを考えます。
第1の細胞に $N_1$ 個、第2の細胞に $N_2$ 個、...と分配するとき、その**配置の数** $W$ は、高校で学んだ組み合わせの計算と同じです。

$$ W = \frac{N!}{N_1! N_2! N_3! \cdots} = N! \prod_i \frac{1}{N_i!} $$

私たちは、この $W$ が最大となるような $N_i$ の分布を求めます。

#### 2.2. ラグランジュの未定乗数法

$W$ を最大化するには、微分して0となる点を見つければ良いのですが、ここでは2つの**制約条件**があります。

1.  **全粒子数一定**: $\sum_i N_i = N$
2.  **全エネルギー一定**: $\sum_i E_i N_i = E$

これらの制約条件のもとで $W$ を最大化する数学的手法が、**ラグランジュの未定乗数法**です。これは、複数の制約がある中で関数の極値を求めるのに非常に強力なツールです。

この手法を用いると、最も確率の高い粒子の分布 $N_i$ が、エネルギー $E_i$ に対して次のような式で表されることがわかります。

$$ N_i \propto \exp(-\beta E_i) $$

これが**ボルツマン分布**です。エネルギーが高い状態ほど、その状態にある粒子の数は少なくなる、という直感的な結果が得られました。

#### 2.3. 分配関数と熱力学量

ボルツマン分布の比例定数、すなわち**ボルツマン因子** $\exp(-\beta E_i)$ の和を**分配関数** $Z$ と呼びます。

$$ Z = \sum_i \exp(-\beta E_i) $$

この分配関数を計算しておけば、系の**内部エネルギー**や**ヘルムホルツエネルギー**、**圧力**といった様々な熱力学量を簡単な微分で求めることができます。

$$ U = -\frac{\partial \log Z}{\partial \beta}, \quad F = -kT \log Z $$

分配関数は、ミクロな世界の情報をマクロな世界の量へと橋渡しする、まさに統計力学の心臓部といえるでしょう。

---

### 3. ギブスのパラドックスとエントロピー

ボルツマン分布からエントロピーを計算すると、$S = k \log W$ という非常に美しい関係式が得られます。これは**ボルツマンの原理**と呼ばれ、**エントロピーが微視的な状態の数の対数に比例する**ことを示しています。つまり、エントロピーは系の**乱雑さ**の尺度なのです。

しかし、この式には**ギブスのパラドックス**という問題が潜んでいます。

#### 3.1. ギブスのパラドックスとは？

この問題は、ボルツマン分布を用いて計算したエントロピーが、系のサイズに比例しない（**示量性**を持たない）という不合理な結果でした。

この原因は、私たちが$W$を計算する際に、**同じ種類の粒子を区別できる**と考えてしまったことにあります。アルゴン原子1とアルゴン原子2を区別して数えた結果、余分な組み合わせを考慮してしまい、正しいエントロピーが得られなかったのです。

#### 3.2. 粒子の不可弁別性

このパラドックスを解決するためには、**同じ種類の粒子は互いに区別できない**という**量子力学的な考え方**を導入する必要があります。古典的な粒子であっても、統計的に扱う際には区別しないというルールを適用します。

この修正を行うと、配置数 $W$ は、同じ粒子の入れ替えの数である $N!$ で割る必要があります。

$$ W_{\text{修正}} = \frac{W}{N!} = \frac{1}{N!} \prod_i \frac{1}{N_i!} $$

この修正によって、エントロピーは示量性を取り戻し、物理的に正しい記述が可能になります。

この事実は、私たちが直感的に信じていた**「同じ種類の粒子は区別できる」という考えが、統計学的な議論においては間違っている**ことを示唆しており、統計力学の最も深い結論の一つと言えるでしょう。

---

### 4. 講義のまとめ

本日の講義の重要なポイントをまとめます。

* **位相空間**: 系の状態を記述する6N次元の仮想空間。
* **ボルツマン分布**: 粒子がエネルギー $E_i$ を持つ確率は、$\exp(-\beta E_i)$ に比例します。これは、**確率論的アプローチ**から導出されました。
* **ボルツマンの原理**: エントロピーは微視的な配置数 $W$ の対数で表される。
* **分配関数**: 分配関数 $Z = \sum \exp(-\beta E_i)$ は、マクロな熱力学量を計算するための鍵です。
* **ギブスのパラドックス**: 同じ種類の粒子を区別して数えると、不合理な結論（エントロピーの非示量性）に陥ります。これを解決するには、**粒子の不可弁別性**を仮定する必要があります。

### 最後に

これで今回の講義は終わりです。

次回の課題ですが、今日の講義でも用いた**ラグランジュの未定乗数法**について、なぜそれが制約条件のある極値問題を解くことができるのか、その数学的な背景を調べてみてください。教科書には詳しく書かれていない部分ですが、非常に重要な手法です。

では、質問があればどうぞ。お疲れ様でした。