[トップページに戻る](/D2MatE/D2MatE_programs.html)

### **注：  **

  * **VBA (マクロ) が入ったファイルは、拡張子 .xlsm で保存する必要があります。**
  * **アドインは .xlam で保存します。**

* * *

# ExcelでVBAを使う準備

### 「開発」タブを表示する

  1. Excelを開き、任意のブックを新規作成するか、既存のブックを開く。
  2. リボンの「ファイル」タブ => 「オプション」メニューを選択します。
  3. 「Excelの基本オプション」ダイアログボックスが表示されたら、「リボンのユーザー設定」をクリック。 
  4. 右側の「リボンのユーザー設定」欄で、「開発」チェックボックスをオンにする。 
  5. 「OK」ボタンをクリックしてダイアログボックスを閉じる。  
「開発」タブがリボンに表示されていることを確認。

### VBAエディターでコードを作成する

  1. 「開発」タブ => 「Visual Basic」ボタンをクリック。
  2. VBAエディターが開くので、「挿入」メニューから「モジュール」を選択。
  3. 新しく作成したモジュールに以下のコードを入力。  
  `  
Sub HelloWorld()  
  MsgBox "Hello, World!"  
End Sub  
  `

  4. VBAエディターを閉じ、Excelに戻る。
  5. 「開発」タブ => 「マクロ」をクリック (あるいはAlt + F8) し、「マクロ」ダイアログボックスを開く。  
「HelloWorld」を選択して「実行」ボタンをクリックして実行

* * *

# Excelにボタンを追加してVBAを実行する

### 注: 設定でマクロを有効にする必要があります。セキュリティリスクがありますので、注意してください

  1. 「ファイル」 => 「オプション」 を開く
  2. 「セキュリティセンター」 => 「セキュリティセンターの設定」 をクリック 
  3. 「マクロの設定」   
「すべてのマクロを有効にする」 に変更  
「VBAプロジェクト オブジェクト モデルへのアクセスを信頼する」にチェック

  4.  Excelを再起動

### フォームコントロールのボタンを追加

  1. 「開発」タブ =>  「デザインモード」 を押して、デザインモードに入る 
  2. 「挿入」ボタン をクリック 
  3. 「フォームコントロール」 => 「ボタン」を選択し、  
シート上でドラッグしてボタンを配置

  4. 「マクロの登録」ダイアログが表示されるので、 新規作成 (あるいは既存マクロを選択) 

### VBAコードを入力

  1. VBAエディタが開くので、以下のコードを入力  
  
Sub RunMacro()  
MsgBox "ボタンがクリックされました！"  
End Sub  


  2. 保存ボタンあるいはCtrl+Sで保存
  3. VBAエディタを閉じる
  4. OKボタンを押してダイアログを閉じる 
  5. デザインモードボタンを押し、デザインモードを抜ける 

### 実行

  1. ボタンをクリック

### 登録マクロの変更

  1. ボタン上でマウスの右ボタンをクリック
  2. 「マクロの登録」を選択

* * *

# 外部ファイルのVBAを使う方法

### 以下のような方法で実現できます。

### (i) 外部ファイルをインポート

_注: 「信頼できる VBA プロジェクト オブジェクト モデルへのアクセスを許可する」 を有効にすること_

  1. Sub ImportModule()  
  Dim vbProj As Object  
  Set vbProj = ThisWorkbook.VBProject  
  vbProj.VBComponents.Import "\path\to\module.bas"  
End Sub

### (ii) 外部ファイルのVBAを実行

  1. Sub RunMacroFromAnotherWorkbook()  
  Dim wb As Workbook  
  Set wb = Workbooks.Open("\path\to\otherWorkbook.xlsm")

  Application.Run "otherWorkbook.xlsm!MacroName"

  wb.Close False ' 保存せずに閉じる  
End Sub

### (iii) アドインを使う

  1. 他のファイルを アドイン（.xlam） にして保存する
  2. Excelで アドインを有効化 する
  3. Application.Run "AddInName.xlam!MacroName" でマクロを実行

### (iv) ライブラリ化 (参照設定)

  1. VBAエディタ（VBE） で 「ツール」 → 「参照設定」 を開く
  2. 他のExcelファイルを ライブラリとして追加 する。  
含まれているVBA関数を直接呼び出せる。

  3. Sub RunVBAFromLibrary()  
  Dim obj As New MyLibrary.Module1  
  Call obj.MySub  
End Sub

### (v) 外部スクリプト (VBS) を実行する (2024年に廃止されたので非推奨)

  1. 以下を、test.vbsに保存する  
  
Dim objExcel, objWorkbook  
Set objExcel = CreateObject("Excel.Application")  
Set objWorkbook = objExcel.Workbooks.Open("C:\path\to\otherWorkbook.xlsm")

objExcel.Application.Run "otherWorkbook.xlsm!MacroName"  
objWorkbook.Close False  
objExcel.Quit  


  2. 実行する  
> cscript test.vbs

### (vi) PowerShellで実行する

  1. 以下をtest.ps1として保存  
  
$excel = New-Object -ComObject Excel.Application  
$excel.Visible = $false # Excelを非表示  
$workbook = $excel.Workbooks.Open("C:\Users\YourName\Documents\test.xlsm")  
$excel.Run("MyMacro") # 実行するマクロ名  
$workbook.Close($false) # 保存せずに閉じる  
$excel.Quit()  
[System.Runtime.Interopservices.Marshal]::ReleaseComObject($excel)  


  2. 実行  
> powershell -ExecutionPolicy Bypass -File "test.ps1"  

