[TITLE]  
Charge-transport model for conducting polymers

[AUTHORS]  
Stephen Dongmin Kang and G. Jeffrey Snyder

[AFFILIATIONS]  
1. Department of Applied Physics and Materials Science, California Institute of Technology, California 91125, USA  
2. Department of Materials Science and Engineering, Northwestern University, Illinois 60208, USA

[JOURNAL]  
Nature Materials

[DOI]  
10.1038/NMAT4784

---

The growing technological importance of conducting polymers makes the fundamental understanding of their charge transport extremely important for materials and process design. Various hopping and mobility edge transport mechanisms have been proposed, but their experimental verification is limited to poor conductors. Now that advanced organic and polymer semiconductors have shown high conductivity approaching that of metals, the transport mechanism should be discernible by modeling the transport like a semiconductor with a transport edge and a transport parameter \( s \). Here we analyze the electrical conductivity and Seebeck coefficient together and determine that most polymers (except possibly PEDOT:tosylate) have \( s \approx 3 \) and thermally activated conductivity, whereas \( s \approx 1 \) and itinerant conductivity is typically found in crystalline semiconductors and metals. The different transport in polymers may result from the percolation of charge carriers from conducting ordered regions through poorly conducting disordered regions, consistent with what has been expected from structural studies.

Organic semiconductors provide a unique processing advantage over inorganic materials, putting them in a strong position for innovative electronic applications. Organic light-emitting diodes are already part of the mainstream technology in displays, and the advances in organic field-effect transistors (FETs) are further driving the technology towards flexible displays. Flexible photovoltaics enabled by the use of conducting polymer layers have now reached competitive efficiencies. Some polymers have promising properties for thermoelectric applications, increasing interest in thermopower measurements.

Progress in semiconducting polymers has led to carrier mobilities exceeding that of amorphous silicon, with a focus on controlling and understanding the structural aspects. Nevertheless, one of the foremost and persistent challenges in the burgeoning field of polymer electronics and thermoelectrics is the fact that there is no robust transport model to guide further development in these complex systems.

In crystalline semiconductors and metals, the free-electron approximation for the band structure enables the effective use of a mobility \( \mu \) and free-carrier concentration \( n \) to describe the electrical conductivity \( \sigma = |e|n\mu \). In disordered polymers, there are many localized charge carriers by which charge transport is often described by hopping from site to site. It then may become a challenge to clearly define a free-carrier concentration and mobility. Here we will avoid this complication and analyze the conductivity in a much generalized form applicable to all mechanisms of electronic conduction: from metals to hopping insulators.

Generalized charge-transport model: Most charge-transport theories can be described by generalized Boltzmann transport equations (see Methods and Supplementary Information) where electrical conductivity \( \sigma \) can be characterized by the transport function \( \Sigma(E) \):

\[
\sigma = \int \Sigma(E) \left(-\frac{\partial f}{\partial E}\right) dE
\]

\( \Sigma(E) \) has units of conductivity but is the measured conductivity only when all mobile carriers have the same energy (for example, at the electron chemical potential \( E_F \) in a metal at low \( T \)). In general, the measured conductivity \( \sigma \) will sample the transport function \( \Sigma(E) \) in an energy width of approximately \( 4k_BT \) around \( E_F \). This is because electrons are fermions that must also have an unoccupied state accessible to transport, leading to the function \(-\frac{\partial f}{\partial E} = f(1-f)/k_BT\) (where \( f \) is the Fermi-Dirac distribution function) in equation (1) to select only the mobile electrons from \( \Sigma(E) \).

The form of \( \Sigma(E, T) \) to get the true conductivity \( \sigma \):

\[
\Sigma(E, T) = \Sigma_0(T) \left(\frac{E - E_t}{k_BT}\right)^s \quad (E > E_t)
\]

\[
= 0 \quad (E < E_t)
\]

where \( E/k_BT \) is the reduced energy of the charge carriers (electrons or holes) and \( \Sigma_0(T) \) is a temperature-dependent but energy-independent parameter, which we call the transport coefficient. The existence of a transport edge is essential for describing the nearly insulating polymers with \( E_F \ll E_t \), while semiconductors with \( E_F \) near \( E_t \) are further characterized by the energy dependence above the edge using the transport parameter \( s \) as an exponent.

Like a band edge, the transport edge is the transport energy \( E_t \) of charge carriers below which no electrons or holes exist or have no contribution to conductivity even at finite temperature. In a crystalline semiconductor or insulator, there are no charge carriers with energy \( E < E_t \), so the transport edge is the band edge. Carriers with energy below the transport edge must be thermally excited to an energy above the transport edge to conduct electricity (this is accounted for in the distribution function \( f \) in equation (1)).

Here we define the transport edge to be when \( \Sigma(E) \) becomes nonzero at finite temperature. More often, the term mobility edge is used, originally to describe homogeneously disordered systems, where the mobility edge is defined when \( \Sigma(E) \) and mobility become nonzero at \( T = 0 \) K, which happens when the electronic states are fully delocalized across the sample as is considered for a true metal. Charge carriers with energy above the mobility edge are itinerant and freely conduct electricity like a metal. The transport edge we find here from measurements in doping studies is fundamentally different from a mobility edge because the conductivity is thermally activated.