ARTICLES

PUBLISHED ONLINE: 14 NOVEMBER 2016 | DOI: 10.1038/NMAT4784

Charge-transport model for conducting polymers
Stephen Dongmin Kang1,2 and G. Jeffrey Snyder1,2*

The growing technological importance of conducting polymers makes the fundamental understanding of their charge transport
extremely important for materials and process design. Various hopping and mobility edge transport mechanisms have
been proposed, but their experimental veriﬁcation is limited to poor conductors. Now that advanced organic and polymer
semiconductors have shown high conductivity approaching that of metals, the transport mechanism should be discernible by
modelling the transport like a semiconductor with a transport edge and a transport parameter s. Here we analyse the electrical
conductivity and Seebeck coefficient together and determine that most polymers (except possibly PEDOT:tosylate) have s
3
and thermally activated conductivity, whereas s
1 and itinerant conductivity is typically found in crystalline semiconductors
and metals. The different transport in polymers may result from the percolation of charge carriers from conducting ordered
regions through poorly conducting disordered regions, consistent with what has been expected from structural studies.

D

D

O rganic semiconductors provide a unique processing advan-

tage1,2 over inorganic materials, putting them in a strong
position for innovative electronic applications. Organic
light-emitting diodes are already part of the mainstream technology
in displays and the advances in organic field-e(cid:27)ect transistors
(FETs) are further driving the technology towards flexible displays3.
Flexible photovoltaics enabled by the use of conducting polymer
layers have now reached competitive e(cid:30)ciencies4(cid:21)6. Some polymers
thermoelectric applications7,8,
have promising properties
for
increasing interest in thermopower measurements.

Progress in semiconducting polymers has led to carrier mobilities
exceeding that of amorphous silicon9(cid:21)11, with a focus on controlling
and understanding the structural aspects12,13. Nevertheless, one of
the foremost and persistent challenges in the burgeoning field of
polymer electronics and thermoelectrics is the fact that there is no
robust transport model12,14 to guide further development in these
complex systems.

In crystalline semiconductors and metals the free-electron
approximation for the band structure enables the e(cid:27)ective use
of a mobility (cid:22) and free-carrier concentration n to describe the
electrical conductivity (cid:27) D jejn(cid:22). In disordered polymers there
are many localized charge carriers by which charge transport is
often described by hopping from site to site. It then may become a
challenge to clearly define a free-carrier concentration and mobility.
Here we will avoid this complication and analyse the conductivity in
a much generalized form applicable to all mechanisms of electronic
conduction: from metals to hopping insulators.

Generalized charge-transport model
Most charge-transport theories can be described by generalized
Boltzmann transport equations (see Methods and Supplementary
Information) where electrical conductivity (cid:27) can be characterized
by the transport function (cid:27)

.E/:

E

(cid:27) D

Z

(cid:18)

(cid:0)

(cid:27)
E

(cid:19)

@f
@E

dE

(1)

.E/ has units of conductivity but is the measured conductivity
(cid:27)
E
only when all mobile carriers
have the same energy (for
example, at the electron chemical potential (EF) in a metal at
low T ). In general, the measured conductivity (cid:27) will sample the

E

.E/ in an energy width of (cid:25)4kBT around EF.
transport function (cid:27)
This is because electrons are fermions that must also have an
unoccupied state accessible to transport, leading to the function
(cid:0)@f =@E D f .1 (cid:0) f /=kBT (where f is the Fermi(cid:21)Dirac distribution
function) in equation (1) to select only the mobile electrons from
(cid:27)
E

.E/ that we find fits the transport data for a wide
range of semiconducting polymers over the entire measurable range
of conductivity has two essential features that will help identify the
transport mechanism: a transport edge Et and transport parameter s.

.E/ to get the true conductivity (cid:27) .
The form of (cid:27)

E

(cid:27)
E

.E, T / D (cid:27)

E0

.T / (cid:2)

(cid:19)s

(cid:18) E (cid:0) Et
kBT

.E > Et

/

(2)

D 0

.E < Et

/

E0

where E=kBT is the reduced energy of the charge carriers (electrons
or holes) and (cid:27)
.T / is a temperature-dependent but energy-
independent parameter, which we call the transport coe(cid:30)cient. The
existence of a transport edge is essential for describing the nearly
insulating polymers with EF (cid:28) Et, while semiconductors with EF
near Et are further characterized by the energy dependence above
the edge using the transport parameter s as an exponent.

Like a band edge, the transport edge is the transport energy Et of
charge carriers below which no electrons or holes exist or have no
contribution to conductivity even at finite temperature (Fig. 1a). In
a crystalline semiconductor or insulator there are no charge carriers
with energy E < Et, so the transport edge is the band edge. Carriers
with energy below the transport edge must be thermally excited to
an energy above the transport edge to conduct electricity (this is
accounted for in the distribution function f in equation (1)).

Here we define the transport edge to be when (cid:27)

.E/ becomes
nonzero at finite temperature. More often the term mobility edge
is used, originally to describe homogeneously disordered systems,
.E/ and mobility become
where the mobility edge is defined when (cid:27)
nonzero at T D 0 K, which happens when the electronic states are
fully delocalized across the sample as is considered for a true metal15.
Charge carriers with energy above the mobility edge are itinerant
and freely conduct electricity like a metal. The transport edge we
find here from measurements in doping studies is fundamentally
di(cid:27)erent from a mobility edge because the conductivity is thermally

E

E

1Department of Applied Physics and Materials Science, California Institute of Technology, California 91125, USA. 2Department of Materials Science and
Engineering, Northwestern University, Illinois 60208, USA. *e-mail: jeff.snyder@northwestern.edu

252

NATURE MATERIALS | VOL 16 | FEBRUARY 2017 | www.nature.com/naturematerials

© 2017 Macmillan Publishers Limited, part of Springer Nature. All rights reserved.