import os
from docx import Document

# 入力ファイル名
infile = "input.md"

# 出力ファイル名を設定（.txt を .docx に置き換え）
outfile = os.path.splitext(infile)[0] + ".docx"

# Markdownファイルを読み込み
with open(infile, "r", encoding="utf-8") as f:
    markdown_content = f.readlines()

# MS-Wordファイルを作成
doc = Document()

# Markdown形式をWordに変換（簡易な実装）
for line in markdown_content:
    if line.startswith("# "):  # 見出し (H1)
        doc.add_heading(line[2:].strip(), level=1)
    elif line.startswith("## "):  # 見出し (H2)
        doc.add_heading(line[3:].strip(), level=2)
    elif line.startswith("### "):  # 見出し (H3)
        doc.add_heading(line[4:].strip(), level=3)
    elif line.startswith("- "):  # 箇条書き
        doc.add_paragraph(line[2:].strip(), style="List Bullet")
    else:  # 通常の段落
        doc.add_paragraph(line.strip())

# Wordファイルに保存
doc.save(outfile)

print(f"MarkdownファイルをMS-Wordファイルに変換しました: {outfile}")
