import numpy as np
import matplotlib.pyplot as plt

# 指数分布のパラメータ
lam = 1.0

# x範囲
x = np.linspace(0, 5, 500)
f_x = lam * np.exp(-lam * x)  # 密度関数
F_x = 1 - np.exp(-lam * x)    # 累積分布関数
F_inv = lambda u: -np.log(1 - u) / lam  # 逆関数

# 一様乱数を使った例
np.random.seed(0)
U = np.linspace(0.01, 0.99, 10)
X = F_inv(U)

# プロット
plt.figure(figsize=(12, 5))
plt.rcParams['font.family'] = 'MS Gothic'

# 左：密度関数 f(x)
plt.subplot(1, 2, 1)
plt.plot(x, f_x, label='f(x) = λ e^{-λx}')
plt.vlines(X, 0, lam * np.exp(-lam * X), linestyles='dashed', colors='gray')
plt.title('目的の確率密度関数 f(x)')
plt.xlabel('x')
plt.ylabel('f(x)')
plt.grid(True)
plt.legend()

# 右：累積分布関数 F(x) と逆変換
plt.subplot(1, 2, 2)
plt.plot(x, F_x, label='F(x)')
plt.plot(X, U, 'ro', label='(X, U)')
plt.hlines(U, 0, X, linestyles='dashed', colors='gray')
plt.vlines(X, 0, U, linestyles='dashed', colors='gray')
plt.title('累積分布関数 F(x) と逆変換')
plt.xlabel('x')
plt.ylabel('F(x)')
plt.grid(True)
plt.legend()

plt.tight_layout()
plt.show()
