import sys
import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import multivariate_normal

w0 = 1.0
w1 = 1.0
sigma = 5.0
nsamples = 300

argv = sys.argv
nargs = len(argv)
if nargs > 1:
    w0 = float(argv[1])
if nargs > 2:
    w1 = float(argv[2]) 
if nargs > 3:
    sigma = float(argv[3])
if nargs > 4:
    nsamples = int(argv[4])


def plot_gaussian_and_points(w0=1, w1=1, sigma=5.0, nsamples=1000):
    # ガウス分布の中心
    mean = [w0, w1]
    # 共分散行列
    cov = [[sigma**2, 0], [0, sigma**2]]
    
    # ガウス分布からサンプルを生成
    samples = np.random.multivariate_normal(mean, cov, nsamples)
    w0_samples, w1_samples = samples.T
    
    # x, y の範囲を定義
    x = np.linspace(-10, 10, 100)
    y = np.linspace(-10, 10, 100)
    X, Y = np.meshgrid(x, y)
    pos = np.dstack((X, Y))
    
    # ガウス分布の確率密度
    rv = multivariate_normal(mean, cov)
    Z = rv.pdf(pos)
    Z_log = np.log(Z)

    # グラフを作成
    fig, axes = plt.subplots(1, 2, figsize=(12, 6))
    
    # 左側: ガウス分布の等高線とサンプル点
    axes[0].scatter(w0_samples, w1_samples, s=8.0, c='red',alpha=0.5, label='Samples')
    contour = axes[0].contourf(X, Y, Z_log, levels=20, cmap='Blues', alpha=0.7)  # 等高線の間隔数を20に設定
    axes[0].set_xlim([-10, 10])
    axes[0].set_ylim([-10, 10])
    axes[0].set_xlabel('a0')
    axes[0].set_ylabel('a1')
    
    # 右側: 乱数で生成した点の散布図（小さなマーカーを使用）
    x_line = np.linspace(-3, 3, 100)
    for w0s, w1s in zip(w0_samples, w1_samples):
        y_line = w0s + w1s * x_line
        axes[1].scatter(x_line, y_line, alpha=0.5, marker='.', s=5)  # マーカーサイズを小さく設定
    axes[1].set_xlim([-3, 3])
    axes[1].set_xlabel('x')
    axes[1].set_ylabel('y')
    
    # グラフを表示
    plt.tight_layout()
    plt.show()

# 関数を呼び出し
plot_gaussian_and_points(w0=w0, w1=w1, sigma=sigma, nsamples=nsamples)
