import numpy as np
import matplotlib.pyplot as plt
from scipy.stats import norm

def inverse_transform_sampling_normal(n_samples, mean=0, std=1, eps=1e-10):
    """逆関数法で正規分布乱数を生成（クリップ付き）"""
    u = np.random.uniform(0, 1, n_samples)
    u = np.clip(u, eps, 1 - eps)  # 0と1を避けるためにクリップ
    samples = norm.ppf(u)  # 標準正規分布の逆累積分布関数
    samples = mean + std * samples  # 平均と標準偏差を適用
    return samples

# パラメータ
n_samples = 10000
mean = 2  # 任意の平均
std = 3   # 任意の標準偏差

# サンプリング
samples = inverse_transform_sampling_normal(n_samples, mean, std)

# 可視化
x = np.linspace(mean - 4 * std, mean + 4 * std, 1000)
fx = norm.pdf(x, mean, std)  # 理論的な正規分布の確率密度

plt.hist(samples, bins=50, density=True, alpha=0.6, label="Sampled")
plt.plot(x, fx, 'r-', label="Theoretical PDF", linewidth=2)
plt.xlabel('x')
plt.ylabel('Density')
plt.legend()
plt.title('Inverse Transform Sampling for Normal Distribution (Clipped)')
plt.grid(True)
plt.show()
