import numpy as np
import matplotlib.pyplot as plt

def inverse_cdf(u, lam):
    """指数分布の逆関数 F^{-1}(u) を計算"""
    return -np.log(1 - u) / lam

def generate_random_samples(n_samples, lam=1.0):
    """逆関数法でランダムサンプルを生成"""
    u = np.random.uniform(0, 1, n_samples)  # 一様乱数
    samples = inverse_cdf(u, lam)
    return samples

# パラメータ設定
lam = 2.0  # 指数分布のλ
n_samples = 10000

# サンプリング
samples = generate_random_samples(n_samples, lam)

# 結果を可視化
x = np.linspace(0, 3, 1000)
fx = lam * np.exp(-lam * x)

plt.hist(samples, bins=50, density=True, alpha=0.6, label="Sampled")
plt.plot(x, fx, label="Theoretical PDF", linewidth=2)
plt.xlabel('x')
plt.ylabel('Density')
plt.legend()
plt.title('Inverse Transform Sampling for Exponential Distribution')
plt.grid(True)
plt.show()
