import math
import matplotlib.pyplot as plt

def c4(n):
    """
    不偏標準偏差の補正係数 c4(n) を計算する。
    c4(n) = sqrt(2/(n-1)) * [Gamma(n/2) / Gamma((n-1)/2)]
    を、オーバーフローを避けるために lgamma() を用いて実装。
    """
    # c4(n) = sqrt(2/(n-1)) * exp( lgamma(n/2) - lgamma((n-1)/2) )
    return math.sqrt(2.0/(n-1)) * math.exp(
        math.lgamma(n/2.0) - math.lgamma((n-1)/2.0)
    )

# 計算する n のリスト
n_values = [5, 10, 20, 40, 80, 100, 200, 500, 1000]

# c4(n) を計算
c4_values = [c4(n) for n in n_values]

# プロット
plt.plot(n_values, c4_values, marker='o')
plt.xscale('log')
plt.xlabel('n')
plt.ylabel('c4(n)')
plt.title('Unbiased Std Dev Correction Factor c4(n)')
plt.grid(True)
plt.show()
