import numpy as np

# モデル関数
def model(x, ai):
    return ai[0] + ai[1]*x

# 真のパラメータ
beta_true = np.array([2.0, 1.5])
N = 100  # サンプル数
x1 = np.linspace(0, 10, N)
X = np.vstack([np.ones(N), x1]).T  # デザイン行列

noise_sigma = 0.2
noise = noise_sigma * np.random.normal(size=N)
y = model(x1, beta_true) + noise
residuals = y - X @ beta_true
residual_variance = np.var(residuals, ddof=2)
print("ノイズsigma:", noise_sigma)
print("データの誤差分散:", residual_variance)

# 事前分布の設定
mu_prior = np.zeros(2)
Sigma_prior = np.eye(2) * 10  # 適度な分散

# データ分散を誤差分散とした場合
Sigma_post_inv_data_var = np.linalg.inv(Sigma_prior) + (X.T @ X) / residual_variance
Sigma_post_data_var = np.linalg.inv(Sigma_post_inv_data_var)
std_beta_data_var = np.sqrt(np.diag(Sigma_post_data_var))
print(f"  ベイズ回帰: データの分散を誤差分散として使用 - a0標準偏差: {std_beta_data_var[0]:.3f}, a1標準偏差: {std_beta_data_var[1]:.3f}")
print(f"  推定残差分散: {residual_variance:.3f}")

# 誤差分散の設定（異なる範囲で変化）
noise_sigmas = [0.1, 0.2, 0.3, 0.4, 0.5, 0.8, 1.0]
results = {}
for noise_sigma in noise_sigmas:
    # ベイズ線形回帰の計算（解析的解法）
    Sigma_post_inv = np.linalg.inv(Sigma_prior) + (X.T @ X) / noise_sigma**2
    Sigma_post = np.linalg.inv(Sigma_post_inv)
    beta_post = Sigma_post @ (np.linalg.inv(Sigma_prior) @ mu_prior + (X.T @ y) / noise_sigma**2)
    
    # 標準偏差の計算
    std_beta = np.sqrt(np.diag(Sigma_post))  # 事後分布の分散の平方根

    results[noise_sigma] = std_beta

# 結果の表示
print("誤差分散と標準偏差の比較:")
for sigma, std_beta in results.items():
    print(f"\n誤差分散: {sigma:.2f}")
    print(f"  ベイズ線形回帰 - a0標準偏差: {std_beta[0]:.3f}, a1標準偏差: {std_beta[1]:.3f}")
