以下は `tkcrystalbase.py` ライブラリの解析結果です。

---

## `tkcrystalbase.py` 解析

### 1) このライブラリの主な機能や目的

このライブラリは、結晶学における基礎的な計算と可視化の準備を目的としたユーティリティ群を提供します。具体的には以下の機能を含みます。

*   **物理定数**: 様々な物理学で用いられる基本的な定数（π、プランク定数、光速、素電荷など）を定義しています。
*   **結晶構造の定義**: 格子定数（`lattice_parameters`）と原子サイト情報（`sites`）を保持するための変数を定義しています。これにより、特定の結晶構造（例: NaCl型立方晶）のデータ管理が可能です。
*   **実空間および逆空間の計算**: 格子定数から実空間の格子ベクトル、計量テンソル、単位胞の体積を計算する機能を提供します。また、実空間の情報から逆空間の格子ベクトル、格子定数、計量テンソル、逆単位胞の体積を計算する機能も備えています。
*   **原子サイトの幾何学的計算**: 分数座標と直交座標の相互変換、格子内の2点間の距離、3点間の角度を計算する機能を提供します。
*   **可視化ヘルパー**: Matplotlibなどのグラフ描画ライブラリと連携し、3Dプロットの軸設定や、単位胞の境界線、原子サイトの描画を行うためのヘルパー関数を提供します。ファイル名に `tk` が含まれていますが、`tkinter` の直接的な使用はなく、`matplotlib.pyplot` の `Axes3D` オブジェクトを操作する関数が含まれます。

総じて、本ライブラリは結晶構造のデータを扱い、その幾何学的特性を計算し、さらに外部の描画ツールと組み合わせて可視化するための基盤となる機能を提供することを目的としています。

### 2) このライブラリを他のプログラムからimportする方法

`tkcrystalbase.py` がPythonのパス上にある、または同じディレクトリにある場合、標準的なPythonのimport文で利用できます。

```python
# ライブラリ全体をインポートする場合
import tkcrystalbase

# 特定の変数や関数をインポートする場合
from tkcrystalbase import pi, cal_lattice_vectors, sites

# すべての公開変数と関数をインポートする場合（推奨されないこともあります）
from tkcrystalbase import *
```

### 3) 必要な非標準ライブラリとインストールコマンドとインストール方法

このライブラリが依存する非標準ライブラリは `numpy` です。

*   **ライブラリ名**: `numpy`
*   **インストールコマンド**:
    ```bash
    pip install numpy
    ```
*   **インストール方法**:
    上記コマンドをターミナルまたはコマンドプロンプトで実行します。Pythonのパッケージ管理ツールである `pip` を使用して、`numpy` ライブラリをPython環境にインストールします。

### 4) importできる変数と関数

#### 変数

*   `pi` (float): 円周率 (3.14159265358979323846)。
*   `pi2` (float): `pi` の2倍の値。
*   `torad` (float): 度からラジアンへの変換係数 (0.01745329251944 rad/deg)。
*   `todeg` (float): ラジアンから度への変換係数 (57.29577951472 deg/rad)。
*   `basee` (float): 自然対数の底 (2.71828183)。
*   `h` (float): プランク定数 (6.6260755e-34 Js)。
*   `h_bar` (float): 換算プランク定数 (1.05459e-34 Js)。
*   `hbar` (float): `h_bar` と同じ、換算プランク定数。
*   `c` (float): 光速 (2.99792458e8 m/s)。
*   `e` (float): 素電荷 (1.60218e-19 C)。
*   `me` (float): 電子の質量 (9.1093897e-31 kg)。
*   `mp` (float): 陽子の質量 (1.6726231e-27 kg)。
*   `mn` (float): 中性子の質量 (1.67495e-27 kg)。
*   `u0` (float): 磁気定数 (透磁率) (4.0 * 3.14 * 1e-7 Ns^2C^-2)。
*   `e0` (float): 電気定数 (真空の誘電率) (8.854418782e-12 C^2N^-1m^-2)。
*   `e2_4pie0` (float): `e^2 / (4 * pi * e0)` の値 (2.30711e-28 Nm^2)。
*   `a0` (float): ボーア半径 (5.29177e-11 m)。
*   `kB` (float): ボルツマン定数 (1.380658e-23 JK^-1)。
*   `NA` (float): アボガドロ定数 (6.0221367e23 mol^-1)。
*   `R` (float): 理想気体定数 (8.31451 J/K/mol)。
*   `F` (float): ファラデー定数 (96485.3 C/mol)。
*   `g` (float): 標準重力加速度 (9.81 m/s^2)。
*   `lattice_parameters` (list): 結晶の格子定数 `[a, b, c, alpha, beta, gamma]`。長さはオングストローム、角度は度。初期値は `[5.62, 5.62, 5.62, 90.0, 90.0, 90.0]` (立方晶)。
*   `sites` (list of lists): 結晶格子内の原子サイト情報。各要素は `[原子名, サイトラベル, 原子番号, 原子質量, 電荷, 半径, 色, 基準座標(numpy.array)]` の形式。基準座標は分数座標。

#### 関数

*   `reduce01(x)`
    *   **動作**: 与えられた数値 `x` の小数部分を返します。例えば、`3.7` なら `0.7` を返します。
    *   **引数**:
        *   `x` (float): 数値。
    *   **戻り値**: (float) `x` の小数部分 (`x - int(x)`)。
*   `round01(x)`
    *   **動作**: 数値 `x` を0または1に丸める、または0-1の範囲に正規化しようと試みます。`x` が1.0に近い場合は1.0、0.0に近い場合は0.0を返します。それ以外の場合は小数部分を返したり、`x < 1.0` の場合は `x - int(x) + 1.0` を返したりする、やや複雑な振る舞いをします。
    *   **引数**:
        *   `x` (float): 数値。
    *   **戻り値**: (float) 丸められた、または正規化された数値。
*   `round_parameter(x, tol)`
    *   **動作**: 数値 `x` を指定された許容誤差 `tol` の倍数に丸めます。`tol` の0.1倍のオフセットを加えた上で丸め計算が行われます。
    *   **引数**:
        *   `x` (float): 丸める数値。
        *   `tol` (float): 丸めの粒度（許容誤差）。
    *   **戻り値**: (float) `tol` の倍数に丸められた数値。
*   `cal_lattice_vectors(latt)`
    *   **動作**: 格子定数 `latt` から実空間の格子ベクトル行列 `aij` を計算します。`aij[0]` がベクトル `a`、`aij[1]` がベクトル `b`、`aij[2]` がベクトル `c` となります。
    *   **引数**:
        *   `latt` (list): `[a, b, c, alpha, beta, gamma]` の形式の格子定数リスト（長さはオングストローム、角度は度）。
    *   **戻り値**: (`numpy.ndarray`) 各行が格子ベクトルを表す `[3, 3]` 行列。
*   `cal_metrics(latt)`
    *   **動作**: 格子定数 `latt` から実空間の格子ベクトル行列 `aij` と計量テンソル `gij` を計算し、辞書として返します。計量テンソル `gij` は格子ベクトルの内積で構成されます。
    *   **引数**:
        *   `latt` (list): `[a, b, c, alpha, beta, gamma]` の形式の格子定数リスト。
    *   **戻り値**: (dict) `{'aij': aij, 'gij': gij}` の形式の辞書。
*   `cal_volume(aij)`
    *   **動作**: 実空間の格子ベクトル行列 `aij` から単位胞の体積を計算します。体積は3つの格子ベクトルのスカラー三重積として計算されます。
    *   **引数**:
        *   `aij` (`numpy.ndarray`): 格子ベクトル行列。
    *   **戻り値**: (float) 単位胞の体積。
*   `cal_reciprocal_lattice_vectors(aij)`
    *   **動作**: 実空間の格子ベクトル行列 `aij` から逆空間の格子ベクトル `Ra, Rb, Rc` を計算します。
    *   **引数**:
        *   `aij` (`numpy.ndarray`): 実空間の格子ベクトル行列。
    *   **戻り値**: (list of `numpy.ndarray`) 逆格子ベクトル `[Ra, Rb, Rc]` のリスト。
*   `cal_reciprocal_lattice_parameters(Raij)`
    *   **動作**: 逆空間の格子ベクトル `Raij` から逆空間の格子定数（長さと角度）を計算します。
    *   **引数**:
        *   `Raij` (list of `numpy.ndarray`): 逆空間の格子ベクトルのリスト。
    *   **戻り値**: (list) `[Ra, Rb, Rc, Ralpha, Rbeta, Rgamma]` の形式の逆格子定数リスト。
*   `fractional_to_cartesian(pos, aij)`
    *   **動作**: 分数座標 `pos` を、与えられた格子ベクトル `aij` を用いて直交座標 `(x, y, z)` に変換します。
    *   **引数**:
        *   `pos` (list or `numpy.ndarray`): 分数座標 `[x_frac, y_frac, z_frac]`。
        *   `aij` (`numpy.ndarray`): 格子ベクトル行列。
    *   **戻り値**: (tuple) 直交座標 `(x, y, z)`。
*   `distance2(pos0, pos1, gij)`
    *   **動作**: 2つの分数座標 `pos0` と `pos1` の間の距離の2乗を、計量テンソル `gij` を用いて計算します。
    *   **引数**:
        *   `pos0` (list or `numpy.ndarray`): 最初の分数座標。
        *   `pos1` (list or `numpy.ndarray`): 2番目の分数座標。
        *   `gij` (`numpy.ndarray`): 計量テンソル。
    *   **戻り値**: (float) 距離の2乗。
*   `distance(pos0, pos1, gij)`
    *   **動作**: 2つの分数座標 `pos0` と `pos1` の間の距離を、計量テンソル `gij` を用いて計算します。
    *   **引数**:
        *   `pos0` (list or `numpy.ndarray`): 最初の分数座標。
        *   `pos1` (list or `numpy.ndarray`): 2番目の分数座標。
        *   `gij` (`numpy.ndarray`): 計量テンソル。
    *   **戻り値**: (float) 距離。
*   `angle(pos0, pos1, pos2, gij)`
    *   **動作**: 3つの分数座標 `pos0`, `pos1`, `pos2` が形成する `pos1 - pos0 - pos2` の角度を計算します。`pos0` が角度の頂点です。計量テンソル `gij` を使用します。
    *   **引数**:
        *   `pos0` (list or `numpy.ndarray`): 角度の頂点となる分数座標。
        *   `pos1` (list or `numpy.ndarray`): 最初のベクトル (頂点から) の終点分数座標。
        *   `pos2` (list or `numpy.ndarray`): 2番目のベクトル (頂点から) の終点分数座標。
        *   `gij` (`numpy.ndarray`): 計量テンソル。
    *   **戻り値**: (float) 角度 (度単位)。
*   `configure_axis_structure(ax, xrange, yrange, zrange, fontsize=12, legend_fontsize=12)`
    *   **動作**: Matplotlibの3Dプロット軸 `ax` の表示設定を結晶構造の描画に適した形に調整します。軸ラベル、目盛り、軸線、グリッドなどを非表示にし、指定された範囲を設定します。
    *   **引数**:
        *   `ax`: Matplotlibの `Axes3D` オブジェクト。
        *   `xrange` (list): x軸の表示範囲 `[xmin, xmax]`。
        *   `yrange` (list): y軸の表示範囲 `[ymin, ymax]`。
        *   `zrange` (list): z軸の表示範囲 `[zmin, zmax]`。
        *   `fontsize` (int, optional): 軸ラベルなどのフォントサイズ。デフォルトは12。
        *   `legend_fontsize` (int, optional): 凡例のフォントサイズ。デフォルトは12 (この関数内では未使用)。
    *   **戻り値**: なし。`ax` オブジェクトを直接変更します。
*   `draw_box(ax, aij, nrange, color='black')`
    *   **動作**: Matplotlibの3Dプロット軸 `ax` 上に、格子ベクトル `aij` で定義される単位胞の境界線を描画します。`nrange` 引数は定義されていますが、この関数内では実際には使用されていません。
    *   **引数**:
        *   `ax`: Matplotlibの `Axes3D` オブジェクト。
        *   `aij` (`numpy.ndarray`): 格子ベクトル行列。
        *   `nrange`: 描画範囲を指定しますが、この関数内では未使用。
        *   `color` (str, optional): ボックスの線の色。デフォルトは 'black'。
    *   **戻り値**: なし。`ax` オブジェクトを直接変更します。
*   `draw_unitcell(ax, sites, aij, nrange, color='black', facecolor='black', edgecolor='white', alpha=0.7, kr=1.0)`
    *   **動作**: Matplotlibの3Dプロット軸 `ax` 上に、単位胞の境界線と原子サイトを描画します。`draw_box` を呼び出して境界線を描き、`sites` 情報と `nrange` で指定された範囲に基づいて原子を球としてプロットします。
    *   **引数**:
        *   `ax`: Matplotlibの `Axes3D` オブジェクト。
        *   `sites` (list of lists): 原子サイト情報のリスト。
        *   `aij` (`numpy.ndarray`): 格子ベクトル行列。
        *   `nrange` (list of lists): 描画する単位胞の範囲を示す `[[xmin, xmax], [ymin, ymax], [zmin, zmax]]` (分数座標系)。
        *   `color` (str, optional): 単位胞の線の色。デフォルトは 'black'。
        *   `facecolor` (str, optional): 原子球の面の色。デフォルトは 'black'。
        *   `edgecolor` (str, optional): 原子球の縁の色。デフォルトは 'white'。
        *   `alpha` (float, optional): 原子球の透明度。デフォルトは0.7。
        *   `kr` (float, optional): 原子半径のスケールファクター。デフォルトは1.0。
    *   **戻り値**: なし。`ax` オブジェクトを直接変更します。

### 5) main scriptとして実行したときの動作

`tkcrystalbase.py` が直接Pythonインタープリタによって実行された場合 (`python tkcrystalbase.py`)、`main()` 関数が実行されます。

`main()` 関数は、このライブラリが提供する主な計算機能のテストとデモンストレーションを行います。具体的には以下の処理が行われます。

1.  **初期格子情報の出力**: グローバル変数 `lattice_parameters` の内容を出力します。
2.  **実空間計算の実行と出力**:
    *   `cal_lattice_vectors` を用いて格子ベクトル `aij` を計算し、その成分を出力します。
    *   `cal_metrics` を用いて計量テンソル `gij` を計算し、その成分を出力します。
    *   `cal_volume` を用いて単位胞の体積を計算し、出力します。
3.  **逆空間計算の実行と出力**:
    *   `cal_reciprocal_lattice_vectors` を用いて逆格子ベクトル `Raij` を計算し、その成分を出力します。
    *   `cal_reciprocal_lattice_parameters` を用いて逆格子定数 `Rlatt` を計算し、出力します。
    *   `cal_metrics` を用いて逆格子計量テンソル `Rgij` を計算し、その成分を出力します。
    *   `cal_volume` を用いて逆単位胞の体積を計算し、出力します。
4.  **距離と角度の計算と出力**:
    *   分数座標 `[0,0,0]` と `[1,1,1]` 間の距離を `distance` 関数で計算し、出力します。
    *   分数座標 `[0,0,0]` を頂点とする `[1,1,1]` と `[1,0,0]` 間の角度を `angle` 関数で計算し、出力します。
    *   分数座標 `[0,0,0]` を頂点とする `[1,0,0]` と `[0,1,0]` 間の角度を `angle` 関数で計算し、出力します。
5.  **プログラムの終了**: `exit()` を呼び出してプログラムを強制終了します。

つまり、このスクリプトはNaCl型立方晶（設定されている `lattice_parameters` はa=b=c=5.62Å, α=β=γ=90°）を仮定し、その幾何学的特性を計算した結果をコンソールに表示するテストスクリプトとして機能します。描画関連の関数 (`configure_axis_structure`, `draw_box`, `draw_unitcell`) は `main` 関数内では呼び出されません。