以下にPythonプログラム `lattice_plane.py` の解析結果をMarkdown形式で記述します。

---

## `lattice_plane.py` プログラム解析

### 1. プログラムの動作

このプログラムは、結晶学における単位格子内に特定のミラー指数 (hkl) で定義される結晶面（格子面）を描画するツールです。

1.  **初期設定**:
    *   格子定数 (`a`, `b`, `c`) と軸角 (`alpha`, `beta`, `gamma`) がコード内で定義されています。これにより、単位格子の形状が決定されます。デフォルトでは、斜方晶系に近い、軸角が90度ではない三斜晶系の設定です。
    *   描画する格子面のミラー指数 (`h`, `k`, `l`) のデフォルト値も設定されています。
2.  **コマンドライン引数の解析**:
    *   プログラムはコマンドライン引数を受け取ることができます。引数が指定された場合、最初の1～3個の引数をミラー指数 `h`, `k`, `l` として使用します。引数が不足している場合は、デフォルト値が使用されます。
3.  **座標変換行列の計算**:
    *   定義された格子定数と軸角に基づき、分数座標系からデカルト（実）座標系への変換を行うための行列 `M` を計算します。これにより、斜方晶や三斜晶などの非直交座標系も扱うことができます。
4.  **単位格子の定義**:
    *   分数座標系における単位格子の8つの頂点と12の辺が定義されます。
5.  **格子面のポリゴン計算**:
    *   ミラー指数 `(hkl)` によって定義される平面 `hx + ky + lz = 1` が単位格子と交差する点を計算します。これらの交点は、格子面が単位格子内で形成する多角形（ポリゴン）の頂点となります。
    *   計算された頂点は、平面の法線ベクトルを基準に角度でソートされ、正しい順序のポリゴンが形成されます。
6.  **実座標系への変換**:
    *   計算された格子面のポリゴン頂点と単位格子の頂点を、分数座標系からデカルト（実）座標系へ変換します。
7.  **3Dプロットの生成**:
    *   `matplotlib` を使用して3Dプロットを作成します。
    *   実座標系に変換された単位格子は、黒い線で描画されます。
    *   計算された格子面は、半透明のシアン色で塗りつぶされ、青い縁で描画されます。
    *   格子軸 (`a`, `b`, `c`) のラベルと、ミラー指数に対応する軸上のインターセプト（1/h, 1/k, 1/l）の注記がプロットに追加されます。
    *   プロットの視点、背景色、軸の非表示など、視覚的な設定が行われます。フォントは'MS Gothic'に設定されます。
8.  **出力**:
    *   生成された3Dプロットは、PNG画像ファイルとして保存されます。ファイル名は指定されたミラー指数に基づいて動的に生成されます（例: `lattice_plane123.png`）。
    *   プロットは画面にも表示されます。

### 2. 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムは以下の非標準ライブラリを使用しています。

*   **`numpy`**: 高性能な数値計算を行うためのライブラリです。
*   **`matplotlib`**: グラフ描画を行うためのライブラリです。`mpl_toolkits.mplot3d` は `matplotlib` に含まれる3Dプロット用ツールキットです。

**インストールコマンド**:

Pythonのパッケージ管理システム `pip` を使用してインストールします。コマンドプロンプトやターミナルで以下のコマンドを実行してください。

```bash
pip install numpy matplotlib
```

### 3. 必要な入力ファイル

このプログラムの実行に**特別な入力ファイルは必要ありません**。
ミラー指数 `h, k, l` は、プログラム内のデフォルト値を使用するか、コマンドライン引数として直接与えることができます。

### 4. 実行後に生成される出力ファイル

プログラムは実行後、以下のPNG画像ファイルを生成します。

*   **ファイル名**: `lattice_plane{h}{k}{l}.png`
    *   `{h}{k}{l}` の部分は、プログラム実行時に使用されたミラー指数の値に置き換わります。
    *   **例**: ミラー指数が `h=1, k=2, l=3` の場合、`lattice_plane123.png` というファイルが生成されます。
    *   **例**: ミラー指数が `h=2, k=0, l=0` の場合、`lattice_plane200.png` というファイルが生成されます。
*   **形式**: PNG画像
*   **特徴**: 300dpiの高解像度、余白を最小化した（`bbox_inches='tight'`）、背景が透過（`transparent=True`）の画像ファイルです。

### 5. コマンドラインでの使用例 (Usage)

プログラムはPythonインタープリタで実行します。ミラー指数はオプションでコマンドライン引数として渡すことができます。

1.  **デフォルトのミラー指数 (1 2 3) を使用して実行する例**:
    ```bash
    python lattice_plane.py
    ```
    *   出力ファイル: `lattice_plane123.png`

2.  **特定のミラー指数 (1 1 0) を指定して実行する例**:
    ```bash
    python lattice_plane.py 1 1 0
    ```
    *   出力ファイル: `lattice_plane110.png`

3.  **特定のミラー指数 (2 0 0) を指定して実行する例**:
    ```bash
    python lattice_plane.py 2 0 0
    ```
    *   出力ファイル: `lattice_plane200.png`

4.  **特定のミラー指数 (0 0 1) を指定して実行する例**:
    ```bash
    python lattice_plane.py 0 0 1
    ```
    *   出力ファイル: `lattice_plane001.png`

5.  **h のみ指定し、k, l はデフォルト値 (2 3) を使用する例 (h=1, k=2, l=3)**:
    ```bash
    python lattice_plane.py 1
    ```
    *   出力ファイル: `lattice_plane123.png`

6.  **h, k のみ指定し、l はデフォルト値 (3) を使用する例 (h=1, k=1, l=3)**:
    ```bash
    python lattice_plane.py 1 1
    ```
    *   出力ファイル: `lattice_plane113.png`