このPythonスクリプト `crystal_draw_FCC.py` は、面心立方格子 (FCC) の結晶構造を3Dで描画し、その基本的な物理量を計算して表示します。

---

### 1) プログラムの動作

このプログラムは、以下の機能を提供します。

*   **格子パラメータの定義**: FCC構造の格子パラメータ（現状は立方晶、a=b=c=5.62 Å, α=β=γ=90°）を定義します。
*   **原子サイトの定義**: FCCの単位格子内（Na原子4つ）と原始単位格子内（Na原子1つ）の原子サイト（相対座標、原子半径、色など）を定義します。
*   **結晶学的計算**:
    *   実空間の格子ベクトル、メトリックテンソル、単位格子の体積を計算し、標準出力に表示します。
    *   逆空間の格子ベクトル、メトリックテンソル、逆単位格子の体積を計算し、標準出力に表示します。
*   **3D結晶構造の描画**:
    *   `matplotlib` の `mpl_toolkits.mplot3d` を使用して、実空間のFCC単位格子と、その原始単位格子の両方を3D空間に描画します。
    *   原子は球体として描画され、単位格子や原始単位格子の境界線も表示されます。
    *   描画された図はインタラクティブなMatplotlibウィンドウとして表示されます。

要するに、結晶の基本的な性質を計算し、その構造を視覚的に理解するためのツールです。

### 2) 必要な非標準ライブラリとインストールコマンドとインストール方法

このプログラムは、以下の非標準ライブラリに依存しています。

1.  **NumPy**: 数値計算を効率的に行うためのライブラリ。
    *   **インストールコマンド**:
        ```bash
        pip install numpy
        ```
    *   **インストール方法**: 上記コマンドをターミナルまたはコマンドプロンプトで実行します。

2.  **Matplotlib**: グラフ描画のためのライブラリ。特に `mpl_toolkits.mplot3d` を使用して3Dプロットを行います。
    *   **インストールコマンド**:
        ```bash
        pip install matplotlib
        ```
    *   **インストール方法**: 上記コマンドをターミナルまたはコマンドプロンプトで実行します。

3.  **tkcrystalbase**: このプログラムのコードに直接は含まれていませんが、`tkcrystalbase` モジュールから `cal_lattice_vectors`, `draw_unitcell` などの関数をインポートしています。これは標準ライブラリではないため、ユーザーが別途用意する必要があります。
    *   **インストールコマンド**: `pip` による直接のインストールコマンドは提供されていません。
    *   **インストール方法**:
        *   通常、`tkcrystalbase.py` ファイル（またはそのモジュールを含むパッケージディレクトリ）が、`crystal_draw_FCC.py` と同じディレクトリ、またはPythonのモジュール検索パス（`PYTHONPATH` 環境変数で指定されたディレクトリやPythonの `site-packages` ディレクトリなど）に存在している必要があります。
        *   もしこのモジュールのソースコードが別に提供されている場合は、それを適切な場所に配置してください。

### 3) 必要な入力ファイル

このプログラムは、すべてのデータ（格子パラメータ、原子サイト情報など）がスクリプト内にハードコードされています。
したがって、**外部からの入力ファイルは必要ありません**。

### 4) 実行後に生成される出力ファイル

*   **コンソール出力**:
    *   実空間の格子パラメータ、格子ベクトル、メトリックテンソル、単位格子の体積。
    *   逆空間の格子パラメータ、逆格子ベクトル、逆格子メトリックテンソル、逆単位格子の体積。
    これらの計算結果が標準出力（ターミナル/コマンドプロンプト）に表示されます。

*   **グラフィック出力**:
    *   Matplotlibによって生成された3D結晶構造の図が、**インタラクティブなウィンドウ**として表示されます。
    *   `plt.savefig()` などは呼ばれていないため、画像ファイル（例: `.png`, `.jpg`）は**直接は生成されません**。ユーザーは表示されたウィンドウから手動で画像を保存することは可能です。

### 5) コマンドラインでの使用例 (Usage)

このプログラムはコマンドライン引数を受け取らないため、Pythonインタプリタで直接実行します。

```bash
python crystal_draw_FCC.py
```